/*
 * Decompiled with CFR 0.152.
 */
package com.zhy.spider.core;

import com.zhy.spider.bean.LinkTypeData;
import com.zhy.spider.rule.Rule;
import com.zhy.spider.rule.RuleException;
import com.zhy.spider.util.TextUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractService {
    public static List<LinkTypeData> extract(Rule rule) {
        ExtractService.validateRule(rule);
        ArrayList<LinkTypeData> arrayList = new ArrayList<LinkTypeData>();
        LinkTypeData linkTypeData = null;
        try {
            String string = rule.getUrl();
            String[] stringArray = rule.getParams();
            String[] stringArray2 = rule.getValues();
            String string2 = rule.getResultTagName();
            int n = rule.getType();
            int n2 = rule.getRequestMoethod();
            Connection connection = Jsoup.connect(string);
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    connection.data(stringArray[i], stringArray2[i]);
                }
            }
            Document document = null;
            switch (n2) {
                case 0: {
                    document = connection.timeout(500000).get();
                    break;
                }
                case 1: {
                    document = connection.timeout(500000).post();
                }
            }
            Elements elements = new Elements();
            switch (n) {
                case 0: {
                    elements = document.getElementsByClass(string2);
                    break;
                }
                case 1: {
                    Element element = document.getElementById(string2);
                    elements.add(element);
                    break;
                }
                case 2: {
                    elements = document.select(string2);
                    break;
                }
                default: {
                    if (!TextUtil.isEmpty(string2)) break;
                    elements = document.getElementsByTag("body");
                }
            }
            for (Element element : elements) {
                Elements elements2 = element.getElementsByTag("a");
                for (Element element2 : elements2) {
                    String string3 = element2.attr("href");
                    String string4 = element2.attr("title");
                    if (string4 == null || string4.length() <= 0) continue;
                    linkTypeData = new LinkTypeData();
                    linkTypeData.setLinkHref(string3);
                    linkTypeData.setLinkText(string4);
                    arrayList.add(linkTypeData);
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return arrayList;
    }

    private static void validateRule(Rule rule) {
        String string = rule.getUrl();
        if (TextUtil.isEmpty(string)) {
            throw new RuleException("url\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!string.startsWith("http://")) {
            throw new RuleException("url\u7684\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
        }
        if (rule.getParams() != null && rule.getValues() != null && rule.getParams().length != rule.getValues().length) {
            throw new RuleException("\u53c2\u6570\u7684\u952e\u503c\u5bf9\u4e2a\u6570\u4e0d\u5339\u914d\uff01");
        }
    }
}

