/*
 * Decompiled with CFR 0.152.
 */
package com.bairuitech.server;

import com.bairuitech.anychat.AnyChatServerEvent;
import com.bairuitech.anychat.AnyChatServerSDK;
import com.bairuitech.anychat.AnyChatVerifyUserOutParam;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SampleServer
implements AnyChatServerEvent {
    public static AnyChatServerSDK anychat;
    public static int iUserIdSeed;
    public static boolean bShowActionLog;
    public static final int QUEUE_ABILITY_TYPE_PERSONAL = 1;
    public static final int QUEUE_ABILITY_TYPE_COMPANY = 2;

    static {
        iUserIdSeed = 1;
        bShowActionLog = true;
    }

    public static void main(String[] args) throws InterruptedException, IOException {
        char c;
        anychat = new AnyChatServerSDK();
        anychat.SetServerEvent(new SampleServer());
        anychat.InitSDK(0);
        anychat.RegisterVerifyUserClass(new AnyChatVerifyUserOutParam());
        SampleServer.InitBusinessQueue();
        System.out.print(String.valueOf(SampleServer.getCurrentTime()) + "Welcome use AnyChat! (" + anychat.GetSDKVersion() + ")\r\n");
        InputStreamReader reader = new InputStreamReader(System.in);
        int ch = 0;
        do {
            if (ch == 100) {
                bShowActionLog = !bShowActionLog;
            } else if (ch != 13) {
                int[] onlineusers = AnyChatServerSDK.GetOnlineUsers(-1);
                System.out.print(String.valueOf(SampleServer.getCurrentTime()) + "Business server(Java) still running, press 'q' to exit...(Online users: " + onlineusers.length + ")\r\n");
            }
            Thread.sleep(100L);
            c = (char)((Reader)reader).read();
            ch = c;
        } while (c != 'q');
        anychat.Release();
        System.out.print(String.valueOf(SampleServer.getCurrentTime()) + "Business server(Java) already exited...\r\n");
    }

    private static void InitBusinessQueue() {
        int dwAreaId = 10001;
        AnyChatServerSDK.ObjectControl(4, dwAreaId, 2, 0, 0, 0, 0, "");
        AnyChatServerSDK.ObjectSetStringValue(4, dwAreaId, 8, "\u79d1\u97f5\u8def\u8425\u4e1a\u5385");
        AnyChatServerSDK.ObjectSetStringValue(4, dwAreaId, 11, "\u4f4d\u4e8e\u5e7f\u5dde\u5e02\u79d1\u97f5\u8def\uff0c\u670d\u52a1\u8d85\u7ea7\u68d2\uff01");
        int dwQueueId = 101;
        AnyChatServerSDK.ObjectControl(5, dwQueueId, 2, dwAreaId, 0, 0, 0, "");
        AnyChatServerSDK.ObjectSetStringValue(5, dwQueueId, 8, "\u4e2a\u4eba\u4e1a\u52a1\u961f\u5217");
        AnyChatServerSDK.ObjectSetStringValue(5, dwQueueId, 11, "\u5f00\u6237\u3001\u6302\u5931\u3001\u8f6c\u5e10");
        int dwPriority = 0;
        AnyChatServerSDK.ObjectSetIntValue(5, dwQueueId, 9, dwPriority);
        int dwQueueAbility = 1;
        AnyChatServerSDK.ObjectSetIntValue(5, dwQueueId, 10, dwQueueAbility);
        int dwQueueIntTag = 2;
        AnyChatServerSDK.ObjectSetIntValue(5, dwQueueId, 12, dwQueueIntTag);
        dwQueueId = 102;
        AnyChatServerSDK.ObjectControl(5, dwQueueId, 2, dwAreaId, 0, 0, 0, "");
        AnyChatServerSDK.ObjectSetStringValue(5, dwQueueId, 8, "\u4e2a\u4eba\u4e1a\u52a1\u961f\u5217(VIP)");
        AnyChatServerSDK.ObjectSetStringValue(5, dwQueueId, 11, "\u5f00\u6237\u3001\u6302\u5931\u3001\u8f6c\u5e10");
        dwPriority = 10;
        AnyChatServerSDK.ObjectSetIntValue(5, dwQueueId, 9, dwPriority);
        dwQueueAbility = 1;
        AnyChatServerSDK.ObjectSetIntValue(5, dwQueueId, 10, dwQueueAbility);
        dwQueueIntTag = 2;
        AnyChatServerSDK.ObjectSetIntValue(5, dwQueueId, 12, dwQueueIntTag);
        dwQueueId = 103;
        AnyChatServerSDK.ObjectControl(5, dwQueueId, 2, dwAreaId, 0, 0, 0, "");
        AnyChatServerSDK.ObjectSetStringValue(5, dwQueueId, 8, "\u5bf9\u516c\u4e1a\u52a1\u961f\u5217");
        AnyChatServerSDK.ObjectSetStringValue(5, dwQueueId, 11, "\u652f\u7968\u3001\u56de\u5355\u3001\u57fa\u672c\u6237");
        dwPriority = 0;
        AnyChatServerSDK.ObjectSetIntValue(5, dwQueueId, 9, dwPriority);
        dwQueueAbility = 2;
        AnyChatServerSDK.ObjectSetIntValue(5, dwQueueId, 10, dwQueueAbility);
        dwQueueIntTag = 3;
        AnyChatServerSDK.ObjectSetIntValue(5, dwQueueId, 12, dwQueueIntTag);
        dwAreaId = 10002;
        AnyChatServerSDK.ObjectControl(4, dwAreaId, 2, 0, 0, 0, 0, "");
        AnyChatServerSDK.ObjectSetStringValue(4, dwAreaId, 8, "\u5929\u6cb3\u8def\u8425\u4e1a\u5385");
        AnyChatServerSDK.ObjectSetStringValue(4, dwAreaId, 11, "\u4e03\u661f\u7ea7\u65d7\u8230\u5e97\uff0c\u9ad8\u7aef\u5ba2\u6237\u9996\u9009\uff01");
        dwQueueId = 201;
        AnyChatServerSDK.ObjectControl(5, dwQueueId, 2, dwAreaId, 0, 0, 0, "");
        AnyChatServerSDK.ObjectSetStringValue(5, dwQueueId, 8, "\u6295\u8d44\u7406\u8d22\u4e1a\u52a1\u961f\u5217");
        AnyChatServerSDK.ObjectSetStringValue(5, dwQueueId, 11, "\u57fa\u91d1\u3001\u7406\u8d22\u4ea7\u54c1\u3001\u8d35\u91d1\u5c5e");
        dwPriority = 0;
        AnyChatServerSDK.ObjectSetIntValue(5, dwQueueId, 9, dwPriority);
        dwQueueAbility = 1;
        AnyChatServerSDK.ObjectSetIntValue(5, dwQueueId, 10, dwQueueAbility);
        dwQueueIntTag = 2;
        AnyChatServerSDK.ObjectSetIntValue(5, dwQueueId, 12, dwQueueIntTag);
        dwQueueId = 202;
        AnyChatServerSDK.ObjectControl(5, dwQueueId, 2, dwAreaId, 0, 0, 0, "");
        AnyChatServerSDK.ObjectSetStringValue(5, dwQueueId, 8, "\u5546\u4e1a\u8d37\u6b3e\u4e1a\u52a1\u961f\u5217");
        AnyChatServerSDK.ObjectSetStringValue(5, dwQueueId, 11, "\u623f\u8d37\u3001\u8f66\u8d37\u3001\u516c\u79ef\u91d1");
        dwPriority = 10;
        AnyChatServerSDK.ObjectSetIntValue(5, dwQueueId, 9, dwPriority);
        dwQueueAbility = 2;
        AnyChatServerSDK.ObjectSetIntValue(5, dwQueueId, 10, dwQueueAbility);
        dwQueueIntTag = 3;
        AnyChatServerSDK.ObjectSetIntValue(5, dwQueueId, 12, dwQueueIntTag);
    }

    public static String getCurrentTime() {
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat tm = new SimpleDateFormat("MM-dd HH:mm:ss:SSS");
        String strTime = "";
        try {
            strTime = String.valueOf(tm.format(date)) + "\t";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strTime;
    }

    @Override
    public void OnAnyChatServerAppMessageExCallBack(int dwNotifyMessage, int wParam, int lParam) {
        if (dwNotifyMessage == 10) {
            if (wParam == 0) {
                System.out.print(String.valueOf(SampleServer.getCurrentTime()) + "Success connected with anychatcoreserver...\r\n");
            } else {
                System.out.print(String.valueOf(SampleServer.getCurrentTime()) + "ERROR: Disconnected from the anychatcoreserver, errorcode:" + wParam + "\r\n");
            }
        } else if (dwNotifyMessage == 11) {
            if (wParam == 0) {
                System.out.print(String.valueOf(SampleServer.getCurrentTime()) + "Success connected with anychatrecordserver(id:" + lParam + ") ...\r\n");
            } else {
                System.out.print(String.valueOf(SampleServer.getCurrentTime()) + "ERROR: Disconnected from the anychatrecordserver, errorcode:" + wParam + "\r\n");
            }
        } else {
            System.out.print(String.valueOf(SampleServer.getCurrentTime()) + "OnServerAppMessageExCallBack, dwNotifyMessage:" + dwNotifyMessage + " wParam:" + wParam + " lParam:" + lParam + "\r\n");
        }
    }

    @Override
    public int OnAnyChatVerifyUserCallBack(String szUserName, String szPassword, AnyChatVerifyUserOutParam outParam) {
        outParam.SetUserId(iUserIdSeed);
        outParam.SetUserLevel(0);
        outParam.SetNickName(szUserName);
        if (bShowActionLog) {
            System.out.print(String.valueOf(SampleServer.getCurrentTime()) + "OnVerifyUserCallBack: userid:" + iUserIdSeed + " username: " + szUserName + "\r\n");
        }
        ++iUserIdSeed;
        return 0;
    }

    @Override
    public void OnAnyChatUserLoginActionCallBack(int dwUserId, String szUserName, int dwLevel, String szIpAddr) {
        if (bShowActionLog) {
            System.out.print(String.valueOf(SampleServer.getCurrentTime()) + "OnUserLoginActionCallBack: userid:" + dwUserId + " username: " + szUserName + " ip: " + szIpAddr + "\r\n");
        }
    }

    @Override
    public void OnAnyChatUserLogoutActionExCallBack(int dwUserId, int dwErrorCode) {
        if (bShowActionLog) {
            System.out.print(String.valueOf(SampleServer.getCurrentTime()) + "OnUserLogoutActionExCallBack: userid:" + dwUserId + " errorcode:" + dwErrorCode + "\r\n");
        }
    }

    @Override
    public int OnAnyChatPrepareEnterRoomCallBack(int dwUserId, int dwRoomId, String szRoomName, String szPassword) {
        if (bShowActionLog) {
            System.out.print(String.valueOf(SampleServer.getCurrentTime()) + "OnPrepareEnterRoomCallBack: userid:" + dwUserId + " roomid: " + dwRoomId + "\r\n");
        }
        return 0;
    }

    @Override
    public void OnAnyChatUserEnterRoomActionCallBack(int dwUserId, int dwRoomId) {
        if (bShowActionLog) {
            System.out.print(String.valueOf(SampleServer.getCurrentTime()) + "OnUserEnterRoomActionCallBack: userid:" + dwUserId + " roomid: " + dwRoomId + "\r\n");
        }
    }

    @Override
    public void OnAnyChatUserLeaveRoomActionCallBack(int dwUserId, int dwRoomId) {
        if (bShowActionLog) {
            System.out.print(String.valueOf(SampleServer.getCurrentTime()) + "OnUserLeaveRoomActionCallBack: userid:" + dwUserId + " roomid: " + dwRoomId + "\r\n");
        }
    }

    @Override
    public void OnAnyChatTransFile(int dwUserId, String szFileName, String szTempFilePath, int dwFileLength, int wParam, int lParam, int dwTaskId) {
    }

    @Override
    public void OnAnyChatTransBuffer(int dwUserId, byte[] lpBuf, int dwLen) {
        if (bShowActionLog) {
            System.out.print(String.valueOf(SampleServer.getCurrentTime()) + "OnAnyChatTransBuffer: userid:" + dwUserId + "len: " + dwLen + " timestamp: " + AnyChatServerSDK.SetSDKOptionInt(1, dwUserId) + "\r\n");
        }
    }

    @Override
    public void OnAnyChatTransBufferEx(int dwUserId, byte[] lpBuf, int dwLen, int wParam, int lParam, int dwTaskId) {
    }

    @Override
    public void OnAnyChatSDKFilterData(int dwUserId, byte[] lpBuf, int dwLen) {
        System.out.print(String.valueOf(SampleServer.getCurrentTime()) + "OnAnyChatSDKFilterData\r\n");
    }

    @Override
    public void OnAnyChatTimerEventCallBack() {
        System.out.print(String.valueOf(SampleServer.getCurrentTime()) + "OnTimerEventCallBack\r\n");
    }

    @Override
    public void OnAnyChatRecvUserTextMsgCallBack(int dwRoomId, int dwSrcUserId, int dwTarUserId, int bSecret, String szTextMessage, int dwLen) {
        if (bShowActionLog) {
            System.out.print(String.valueOf(SampleServer.getCurrentTime()) + "OnAnyChatRecvUserTextMsgCallBack: " + dwSrcUserId + " to " + dwTarUserId + " " + szTextMessage + "\r\n");
        }
    }

    @Override
    public void OnAnyChatServerRecordExCallBack(int dwUserId, String szRecordFileName, int dwElapse, int dwFlags, int dwParam, String lpUserStr, int dwRecordServerId) {
        boolean bSnapShotEvent = (dwFlags & 0x400) != 0;
        String eventStr = bSnapShotEvent ? " ,SnapShot Event" : " ,Record Event";
        String str = "OnAnyChatServerRecordExCallBack: dwUserId" + dwUserId + eventStr + " ,szRecordFileName:" + szRecordFileName + " lpUserStr:" + lpUserStr;
        if (bShowActionLog) {
            System.out.print(String.valueOf(SampleServer.getCurrentTime()) + str + "\r\n");
        }
    }

    @Override
    public int OnAnyChatVideoCallEventCallBack(int dwEventType, int dwSrcUserId, int dwTarUserId, int dwErrorCode, int dwFlags, int dwParam, String lpUserStr) {
        String str = "OnAnyChatVideoCallEventCallBack: dwEventType:" + dwEventType + " dwSrcUserId:" + dwSrcUserId + " dwTarUserId:" + dwTarUserId + " dwErrorCode:" + dwErrorCode + " dwFlags:" + dwFlags + " dwParam:" + dwParam + " lpUserStr:" + lpUserStr;
        if (bShowActionLog) {
            System.out.print(String.valueOf(SampleServer.getCurrentTime()) + str + "\r\n");
        }
        return 0;
    }

    @Override
    public int OnAnyChatUserInfoCtrlCallBack(int dwSendUserId, int dwUserId, int dwCtrlCode, int wParam, int lParam, String lpStrValue) {
        String str = "OnAnyChatUserInfoCtrlCallBack: dwSendUserId:" + dwSendUserId + " dwUserId:" + dwUserId + " dwCtrlCode:" + dwCtrlCode + " wParam:" + wParam + " lParam:" + lParam + " lpStrValue:" + lpStrValue;
        if (bShowActionLog) {
            System.out.print(String.valueOf(SampleServer.getCurrentTime()) + str + "\r\n");
        }
        return 0;
    }

    @Override
    public int OnAnyChatObjectEventCallBack(int dwObjectType, int dwObjectId, int dwEventType, int dwParam1, int dwParam2, int dwParam3, int dwParam4, String lpStrParam) {
        return 0;
    }
}

