/*
 * Decompiled with CFR 0.152.
 */
package com.bairuitech.demo;

import com.bairuitech.anychat.AnyChatBaseEvent;
import com.bairuitech.anychat.AnyChatCoreSDK;
import com.bairuitech.anychat.AnyChatStateChgEvent;
import com.bairuitech.anychat.AnyChatTextMsgEvent;
import com.bairuitech.demo.AnyChatDemo;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class VideoJFrame
extends JFrame
implements AnyChatBaseEvent,
AnyChatTextMsgEvent,
AnyChatStateChgEvent,
ActionListener {
    private AnyChatCoreSDK anychat;
    private int dwSelfUserId;
    private JPanel mPanlVideoSelf;
    private JPanel mPanlVideoRemote;
    private JPanel mPanlEditChat;
    private JList mJListOnline;
    private int[] dwOnlines;
    private DefaultListModel mListModel;
    private JScrollPane mJScrollList;
    private JTextArea mTxtChatMsg;
    private JEditorPane mEditChatMsg;
    private JButton mBtnSend;
    private JLabel jlabelSelf;
    private JLabel jlabelRemote;
    private JLabel jRemoteLabel;
    private JLabel jlabelOnlineNum;
    private JProgressBar mProgressRemote;
    private JProgressBar mProgressLocal;
    private Hashtable<String, Integer> hashtable;
    private int dwRemoteUserid = 0;
    private JFrame jRoomListFrame;
    private AnyChatDemo mMainInstance;
    private static Timer mTimer;
    private static TimerTask mTimerTask;

    public VideoJFrame(AnyChatCoreSDK anychat, int userId, JFrame roomlistFrame) {
        this.anychat = anychat;
        this.dwSelfUserId = userId;
        this.jRoomListFrame = roomlistFrame;
        this.hashtable = new Hashtable();
        this.initSDK();
        this.mProgressRemote = new JProgressBar();
        this.mProgressLocal = new JProgressBar();
        this.mPanlVideoRemote = new JPanel();
        this.mPanlEditChat = new JPanel();
        this.mJListOnline = new JList();
        this.mTxtChatMsg = new JTextArea();
        this.mTxtChatMsg.setEditable(false);
        this.mEditChatMsg = new JEditorPane();
        this.mBtnSend = new JButton("\u53d1\u9001");
        this.mJScrollList = new JScrollPane(this.mJListOnline);
        this.mPanlVideoSelf = new JPanel();
        this.jRemoteLabel = new JLabel();
        this.jRemoteLabel.setHorizontalAlignment(0);
        this.jRemoteLabel.setText("\u8fdc\u7a0b\u89c6\u9891");
        String strSelfName = anychat.GetUserName(this.dwSelfUserId);
        this.dwOnlines = anychat.GetOnlineUser();
        this.mListModel = new DefaultListModel();
        this.mListModel.addElement(strSelfName);
        this.hashtable.put(strSelfName, this.dwSelfUserId);
        this.initVideoJFrame();
        this.InitUserList();
    }

    public void initSDK() {
        this.anychat.SetBaseEvent(this);
        this.anychat.SetTextMessageEvent(this);
        this.anychat.SetStateChgEvent(this);
    }

    public int getRemoteId() {
        return this.dwRemoteUserid;
    }

    public JLabel getRemoteView() {
        return this.jlabelRemote;
    }

    public void initTimeTask() {
        if (mTimer == null) {
            mTimer = new Timer();
        } else {
            mTimer.cancel();
            mTimer = null;
        }
        if (mTimerTask == null) {
            mTimerTask = new TimerTask(){

                @Override
                public void run() {
                    VideoJFrame.this.mProgressLocal.setValue(VideoJFrame.this.anychat.GetUserSpeakVolume(VideoJFrame.this.dwSelfUserId));
                    if (VideoJFrame.this.dwRemoteUserid != 0) {
                        VideoJFrame.this.mProgressRemote.setValue(VideoJFrame.this.anychat.GetUserSpeakVolume(VideoJFrame.this.dwRemoteUserid));
                    }
                }
            };
            mTimer.schedule(mTimerTask, 100L, 100L);
        } else {
            mTimerTask = null;
        }
    }

    public void initVideoJFrame() {
        this.setDefaultCloseOperation(2);
        this.setSize(840, 700);
        this.setResizable(false);
        this.mPanlVideoSelf.setLayout(null);
        this.setTitle("AnyChat\u623f\u95f4");
        this.setForeground(Color.lightGray);
        this.jlabelOnlineNum = new JLabel();
        int dwNum = this.dwOnlines.length + 1;
        this.jlabelOnlineNum.setText("\u5728\u7ebf\u5217\u8868:(" + dwNum + "\u4eba" + ")");
        this.jlabelOnlineNum.setForeground(Color.blue);
        this.jlabelOnlineNum.setBounds(10, 10, 250, 15);
        this.mJScrollList.setBounds(10, 30, 250, 400);
        this.mJListOnline.setBackground(Color.white);
        this.jlabelSelf = new JLabel("\u672c\u5730\u89c6\u9891:");
        this.jlabelSelf.setBackground(Color.green);
        this.jlabelSelf.setBounds(10, 440, 250, 200);
        this.mProgressLocal.setMaximum(100);
        this.mProgressLocal.setBounds(10, 650, 250, 10);
        this.mProgressLocal.setForeground(Color.blue);
        this.jRemoteLabel.setBounds(395, 5, 300, 12);
        this.jlabelRemote = new JLabel();
        this.jlabelRemote.setBackground(Color.green);
        this.jlabelRemote.setBounds(270, 20, 550, 400);
        this.mProgressRemote.setMaximum(100);
        this.mProgressRemote.setBounds(270, 430, 550, 10);
        this.mProgressRemote.setForeground(Color.blue);
        JScrollPane jPanTxtMsg = new JScrollPane(this.mTxtChatMsg);
        jPanTxtMsg.setBounds(270, 455, 550, 170);
        this.mPanlEditChat.setLayout(new BoxLayout(this.mPanlEditChat, 0));
        this.mPanlEditChat.setBounds(270, 635, 550, 30);
        this.mPanlEditChat.add(new JLabel("\u6587\u5b57\u804a\u5929\uff1a"));
        this.mPanlEditChat.add(this.mEditChatMsg);
        this.mBtnSend.addActionListener(this);
        this.mPanlEditChat.add(this.mBtnSend);
        this.mPanlEditChat.add(this.mBtnSend);
        this.mPanlVideoSelf.add(this.jlabelOnlineNum);
        this.mPanlVideoSelf.add(this.mJScrollList);
        this.mPanlVideoSelf.add(this.jRemoteLabel);
        this.mPanlVideoSelf.add(this.jlabelRemote);
        this.mPanlVideoSelf.add(this.mProgressLocal);
        this.mPanlVideoSelf.add(this.mProgressRemote);
        this.mPanlVideoSelf.add(jPanTxtMsg);
        this.mPanlVideoSelf.add(this.mPanlEditChat);
        this.add(this.mPanlVideoSelf);
        this.setVisible(true);
    }

    @Override
    protected void processWindowEvent(WindowEvent arg0) {
        if (arg0.getID() == 201) {
            int tag = JOptionPane.showConfirmDialog(null, "\u786e\u5b9a\u5173\u95ed\u5417\uff1f", "\u6e29\u99a8\u63d0\u793a", 0);
            if (tag == 0) {
                this.anychat.UserCameraControl(-1, 0);
                this.anychat.UserSpeakControl(-1, 0);
                if (this.dwRemoteUserid != 0) {
                    this.anychat.UserCameraControl(this.dwRemoteUserid, 0);
                    this.anychat.UserSpeakControl(this.dwRemoteUserid, 0);
                    this.dwRemoteUserid = 0;
                }
                this.anychat.LeaveRoom(-1);
                this.jRoomListFrame.setVisible(true);
                AnyChatDemo.initSdk();
                this.dispose();
            } else {
                return;
            }
        }
    }

    public void InitUserList() {
        int i = 0;
        while (i < this.dwOnlines.length) {
            int dwuserid = this.dwOnlines[i];
            String strUserName = this.anychat.GetUserName(dwuserid);
            this.mListModel.addElement(strUserName);
            this.hashtable.put(strUserName, dwuserid);
            ++i;
        }
        this.mJListOnline.setModel(this.mListModel);
        this.mJListOnline.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Object target = VideoJFrame.this.mJListOnline.getSelectedValue();
                    int dwTargetId = (Integer)VideoJFrame.this.hashtable.get(target);
                    System.out.println(String.valueOf(dwTargetId));
                    if (dwTargetId != VideoJFrame.this.dwRemoteUserid && dwTargetId != VideoJFrame.this.dwSelfUserId) {
                        if (VideoJFrame.this.dwRemoteUserid != 0) {
                            VideoJFrame.this.anychat.UserCameraControl(VideoJFrame.this.dwRemoteUserid, 0);
                            VideoJFrame.this.anychat.UserSpeakControl(VideoJFrame.this.dwRemoteUserid, 0);
                            VideoJFrame.this.dwRemoteUserid = 0;
                        }
                        VideoJFrame.this.refreshRemoteVideo(dwTargetId);
                    }
                }
                super.mouseClicked(e);
            }
        });
        this.refreshRemoteVideo(-1);
    }

    @Override
    public void OnAnyChatConnectMessage(boolean bSuccess) {
    }

    @Override
    public void OnAnyChatLoginMessage(int dwUserId, int dwErrorCode) {
    }

    @Override
    public void OnAnyChatEnterRoomMessage(int dwRoomId, int dwErrorCode) {
    }

    @Override
    public void OnAnyChatOnlineUserMessage(int dwUserNum, int dwRoomId) {
    }

    @Override
    public void OnAnyChatUserAtRoomMessage(int dwUserId, boolean bEnter) {
        String strName = this.anychat.GetUserName(dwUserId);
        this.dwOnlines = this.anychat.GetOnlineUser();
        if (bEnter) {
            this.mListModel.addElement(strName);
            this.hashtable.put(strName, dwUserId);
        } else {
            this.mListModel.removeElement(strName);
            this.hashtable.remove(strName);
            if (dwUserId == this.dwRemoteUserid) {
                this.anychat.UserCameraControl(this.dwRemoteUserid, 0);
                this.anychat.UserSpeakControl(this.dwRemoteUserid, 0);
                this.dwRemoteUserid = 0;
                this.refreshRemoteVideo(-1);
            }
        }
        int dwNum = this.dwOnlines.length + 1;
        this.jlabelOnlineNum.setText("\u5728\u7ebf\u5217\u8868:(" + dwNum + "\u4eba" + ")");
    }

    @Override
    public void OnAnyChatLinkCloseMessage(int dwErrorCode) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.mBtnSend) {
            int dwTargetId;
            String strContent = this.mEditChatMsg.getText();
            Object target = this.mJListOnline.getSelectedValue();
            try {
                dwTargetId = this.hashtable.get(target);
            }
            catch (Exception k) {
                dwTargetId = -1;
            }
            if (strContent.length() != 0) {
                this.anychat.SendTextMessage(dwTargetId, 0, strContent);
                String strTarget = this.formatChatMsg(this.dwSelfUserId, dwTargetId, strContent);
                this.mTxtChatMsg.append(String.valueOf(strTarget) + "\n");
            }
        }
    }

    @Override
    public void OnAnyChatTextMessage(int dwFromUserid, int dwToUserid, boolean bSecret, String message) {
        String strTarget = this.formatChatMsg(dwFromUserid, dwToUserid, message);
        this.mTxtChatMsg.append(String.valueOf(strTarget) + "\n");
    }

    public String formatChatMsg(int dwFromUserid, int dwToUserid, String message) {
        StringBuffer strChat = new StringBuffer();
        String strFrom = dwFromUserid == this.dwSelfUserId ? "\u6211" : this.anychat.GetUserName(dwFromUserid);
        String strTarget = dwToUserid == this.dwSelfUserId ? "\u6211" : (dwToUserid == -1 ? "\u6240\u6709\u4eba" : this.anychat.GetUserName(dwFromUserid));
        strChat.append(String.valueOf(strFrom) + " \u5bf9 " + strTarget + " \u8bf4: " + message + " " + this.getCurrentTime());
        return strChat.toString();
    }

    public String getCurrentTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        Date date = new Date(System.currentTimeMillis());
        String strTime = "";
        try {
            strTime = sdf.format(date);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strTime;
    }

    public void refreshRemoteVideo(int dwUserid) {
        if (this.dwRemoteUserid != 0) {
            return;
        }
        this.jRemoteLabel.setText("\u8fdc\u7a0b\u89c6\u9891");
        if (dwUserid == -1) {
            int i = 0;
            while (i < this.dwOnlines.length) {
                int dwuserid = this.dwOnlines[i];
                int dwCameraStatus = this.anychat.GetCameraState(dwuserid);
                if (dwCameraStatus == 2) {
                    this.dwRemoteUserid = dwuserid;
                    break;
                }
                ++i;
            }
        } else {
            this.dwRemoteUserid = dwUserid;
        }
        if (this.dwRemoteUserid != 0) {
            String strRname = this.anychat.GetUserName(this.dwRemoteUserid);
            this.jRemoteLabel.setText("\u8fdc\u7a0b\u89c6\u9891:  \u7528\u6237\u540d:" + strRname + "  \u7528\u6237ID:" + this.dwRemoteUserid);
            this.anychat.UserCameraControl(this.dwRemoteUserid, 1);
            this.anychat.UserSpeakControl(this.dwRemoteUserid, 1);
            this.anychat.SetVideoPos(this.dwRemoteUserid, this, 290, 30, 790, 390);
            int position = 1;
            int i = 0;
            while (i < this.dwOnlines.length) {
                if (this.dwOnlines[i] == this.dwRemoteUserid) break;
                ++position;
                ++i;
            }
            this.mJListOnline.setSelectedIndex(position);
            System.out.println("position" + position);
        }
    }

    @Override
    public void OnAnyChatMicStateChgMessage(int dwUserId, boolean bOpenMic) {
    }

    @Override
    public void OnAnyChatCameraStateChgMessage(int dwUserId, int dwState) {
        if (dwState == 2) {
            this.refreshRemoteVideo(-1);
        }
    }

    @Override
    public void OnAnyChatChatModeChgMessage(int dwUserId, boolean bPublicChat) {
    }

    @Override
    public void OnAnyChatActiveStateChgMessage(int dwUserId, int dwState) {
    }

    @Override
    public void OnAnyChatP2PConnectStateMessage(int dwUserId, int dwState) {
    }
}

