/*
 * Decompiled with CFR 0.152.
 */
package com.bairuitech.anychat;

import com.bairuitech.anychat.AnyChatBaseEvent;
import com.bairuitech.anychat.AnyChatCoreSDKEvent;
import com.bairuitech.anychat.AnyChatDataEncDecEvent;
import com.bairuitech.anychat.AnyChatObjectEvent;
import com.bairuitech.anychat.AnyChatOutParam;
import com.bairuitech.anychat.AnyChatPrivateChatEvent;
import com.bairuitech.anychat.AnyChatRecordEvent;
import com.bairuitech.anychat.AnyChatStateChgEvent;
import com.bairuitech.anychat.AnyChatStreamCallBack;
import com.bairuitech.anychat.AnyChatTextMsgEvent;
import com.bairuitech.anychat.AnyChatTransDataEvent;
import com.bairuitech.anychat.AnyChatUserInfoEvent;
import com.bairuitech.anychat.AnyChatVideoCallEvent;
import java.awt.Component;

public class AnyChatCoreSDK {
    AnyChatBaseEvent baseEvent;
    AnyChatStateChgEvent stateChgEvent;
    AnyChatPrivateChatEvent privateChatEvent;
    AnyChatTextMsgEvent textMsgEvent;
    AnyChatTransDataEvent transDataEvent;
    AnyChatVideoCallEvent videoCallEvent;
    AnyChatUserInfoEvent userInfoEvent;
    AnyChatDataEncDecEvent encdecEvent;
    AnyChatRecordEvent recordEvent;
    AnyChatObjectEvent objectEvent;
    AnyChatCoreSDKEvent coresdkEvent;
    AnyChatStreamCallBack streamcbEvent;
    private static AnyChatCoreSDK mAnyChat = null;

    static {
        System.loadLibrary("anychatcore4java");
    }

    public static synchronized AnyChatCoreSDK getInstance() {
        if (mAnyChat == null) {
            mAnyChat = new AnyChatCoreSDK();
        }
        return mAnyChat;
    }

    private AnyChatCoreSDK() {
    }

    public void SetBaseEvent(AnyChatBaseEvent e) {
        this.RegisterNotify();
        this.baseEvent = e;
    }

    public void SetStateChgEvent(AnyChatStateChgEvent e) {
        this.RegisterNotify();
        this.stateChgEvent = e;
    }

    public void SetPrivateChatEvent(AnyChatPrivateChatEvent e) {
        this.RegisterNotify();
        this.privateChatEvent = e;
    }

    public void SetTextMessageEvent(AnyChatTextMsgEvent e) {
        this.RegisterNotify();
        this.textMsgEvent = e;
    }

    public void SetTransDataEvent(AnyChatTransDataEvent e) {
        this.RegisterNotify();
        this.transDataEvent = e;
    }

    public void SetVideoCallEvent(AnyChatVideoCallEvent e) {
        this.RegisterNotify();
        this.videoCallEvent = e;
    }

    public void SetUserInfoEvent(AnyChatUserInfoEvent e) {
        this.RegisterNotify();
        this.userInfoEvent = e;
    }

    public void SetDataEncDecEvent(AnyChatDataEncDecEvent e) {
        this.RegisterNotify();
        this.encdecEvent = e;
    }

    public void SetRecordSnapShotEvent(AnyChatRecordEvent e) {
        this.RegisterNotify();
        this.recordEvent = e;
    }

    public void SetObjectEvent(AnyChatObjectEvent e) {
        this.RegisterNotify();
        this.objectEvent = e;
    }

    public void SetCoreSDKEvent(AnyChatCoreSDKEvent e) {
        this.RegisterNotify();
        this.coresdkEvent = e;
    }

    public void SetMediaCallBackEvent(AnyChatStreamCallBack e) {
        this.RegisterNotify();
        this.streamcbEvent = e;
    }

    public void removeEvent(Object e) {
        if (this.baseEvent == e) {
            this.baseEvent = null;
        }
        if (this.stateChgEvent == e) {
            this.stateChgEvent = null;
        }
        if (this.privateChatEvent == e) {
            this.privateChatEvent = null;
        }
        if (this.textMsgEvent == e) {
            this.textMsgEvent = null;
        }
        if (this.transDataEvent == e) {
            this.transDataEvent = null;
        }
        if (this.videoCallEvent == e) {
            this.videoCallEvent = null;
        }
        if (this.userInfoEvent == e) {
            this.userInfoEvent = null;
        }
        if (this.encdecEvent == e) {
            this.encdecEvent = null;
        }
        if (this.recordEvent == e) {
            this.recordEvent = null;
        }
        if (this.objectEvent == e) {
            this.objectEvent = null;
        }
        if (this.coresdkEvent == e) {
            this.coresdkEvent = null;
        }
        if (this.streamcbEvent == e) {
            this.streamcbEvent = null;
        }
    }

    public int GetSDKMainVersion() {
        return this.GetSDKOptionInt(22);
    }

    public int GetSDKSubVersion() {
        return this.GetSDKOptionInt(23);
    }

    public String GetSDKBuildTime() {
        return this.GetSDKOptionString(24);
    }

    public native int RegisterNotify();

    public native int InitSDK(int var1, int var2);

    public native int Connect(String var1, int var2);

    public native int Login(String var1, String var2);

    public native int LoginEx(String var1, int var2, String var3, String var4, int var5, String var6, String var7);

    public native int EnterRoom(int var1, String var2);

    public native int EnterRoomEx(String var1, String var2);

    public native int LeaveRoom(int var1);

    public native int Logout();

    public native int Release();

    public native int[] GetOnlineUser();

    public native int[] GetRoomOnlineUsers(int var1);

    public native int SetVideoPos(int var1, Component var2, int var3, int var4, int var5, int var6);

    public native int SetVideoPosEx(int var1, Component var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public native int UserCameraControl(int var1, int var2);

    public native int UserCameraControlEx(int var1, int var2, int var3, int var4, String var5);

    public native int UserSpeakControl(int var1, int var2);

    public native int UserSpeakControlEx(int var1, int var2, int var3, int var4, String var5);

    public native int SetUserStreamInfoInt(int var1, int var2, int var3, int var4);

    public native int SetUserStreamInfoString(int var1, int var2, int var3, String var4);

    public native int GetUserStreamInfoInt(int var1, int var2, int var3);

    public native String GetUserStreamInfoString(int var1, int var2, int var3);

    public native int StreamRecordCtrl(int var1, int var2, int var3, int var4);

    public native int StreamRecordCtrlEx(int var1, int var2, int var3, int var4, String var5);

    public native int SnapShot(int var1, int var2, int var3);

    public native int AudioGetVolume(int var1);

    public native int AudioSetVolume(int var1, int var2);

    public native String QueryUserStateString(int var1, int var2);

    public native int QueryUserStateInt(int var1, int var2);

    public native int GetUserSpeakVolume(int var1);

    public native int GetCameraState(int var1);

    public native int GetSpeakState(int var1);

    public native int GetUserVideoWidth(int var1);

    public native int GetUserVideoHeight(int var1);

    public native String QueryRoomStateString(int var1, int var2);

    public native int QueryRoomStateInt(int var1, int var2);

    public native int SetServerAuthPass(String var1);

    public native int SetSDKOptionInt(int var1, int var2);

    public native int SetSDKOptionString(int var1, String var2);

    public native int GetSDKOptionInt(int var1);

    public native String GetSDKOptionString(int var1);

    public native int SendTextMessage(int var1, int var2, String var3);

    public native int TransFile(int var1, String var2, int var3, int var4, int var5, AnyChatOutParam var6);

    public native int TransFileEx(String var1, int var2, String var3, int var4, String var5);

    public native int TransBuffer(int var1, byte[] var2, int var3);

    public native int TransBufferEx(int var1, byte[] var2, int var3, int var4, int var5, int var6, AnyChatOutParam var7);

    public native int CancelTransTask(int var1, int var2);

    public native int CancelTransTaskEx(String var1, int var2, int var3);

    public native int QueryTransTaskInfo(int var1, int var2, int var3, AnyChatOutParam var4);

    public native int QueryTransTaskInfoEx(String var1, int var2, AnyChatOutParam var3);

    public native int SendSDKFilterData(byte[] var1, int var2);

    public static native byte[] FetchAudioPlayBuffer(int var0);

    public void CameraAutoFocus() {
        this.SetSDKOptionInt(90, 1);
    }

    public String GetUserName(int userid) {
        return this.QueryUserStateString(userid, 6);
    }

    public String GetUserIPAddr(int userid) {
        return this.QueryUserStateString(userid, 8);
    }

    public native String[] EnumVideoCapture();

    public native int SelectVideoCapture(String var1);

    public native String GetCurVideoCapture();

    public native String[] EnumAudioCapture();

    public native int SelectAudioCapture(String var1);

    public native String GetCurAudioCapture();

    public native String[] EnumAudioPlayback();

    public native int SelectAudioPlayback(String var1);

    public native String GetCurAudioPlayback();

    public native int ChangeChatMode(int var1);

    public native int GetUserChatMode(int var1);

    public native int PrivateChatRequest(int var1);

    public native int PrivateChatEcho(int var1, int var2, int var3);

    public native int PrivateChatEchoEx(int var1, int var2, int var3);

    public native int PrivateChatExit(int var1);

    public static native int SetInputVideoFormat(int var0, int var1, int var2, int var3, int var4);

    public static native int SetInputVideoFormatEx(int var0, int var1, int var2, int var3, int var4, int var5, int var6);

    public static native int InputVideoData(byte[] var0, int var1, int var2);

    public static native int InputVideoDataEx(int var0, byte[] var1, int var2, int var3, int var4);

    public static native int SetInputAudioFormat(int var0, int var1, int var2, int var3);

    public static native int SetInputAudioFormatEx(int var0, int var1, int var2, int var3, int var4, int var5);

    public static native int InputAudioData(byte[] var0, int var1, int var2);

    public static native int InputAudioDataEx(int var0, byte[] var1, int var2, int var3, int var4);

    public native int VideoCallControl(int var1, int var2, int var3, int var4, int var5, String var6);

    public native int[] GetUserFriends();

    public native int GetFriendStatus(int var1);

    public native int[] GetUserGroups();

    public native int[] GetGroupFriends(int var1);

    public native String GetUserInfo(int var1, int var2);

    public native String GetGroupName(int var1);

    public native int UserInfoControl(int var1, int var2, int var3, int var4, String var5);

    public native int MultiCastControl(String var1, int var2, String var3, int var4, int var5);

    public native String QueryInfoFromServer(int var1, String var2, int var3);

    public native String SDKControl(int var1, String var2);

    public static native int[] ObjectGetIdList(int var0);

    public static native int ObjectGetIntValue(int var0, int var1, int var2);

    public static native String ObjectGetStringValue(int var0, int var1, int var2);

    public static native int ObjectSetIntValue(int var0, int var1, int var2, int var3);

    public static native int ObjectSetStringValue(int var0, int var1, int var2, String var3);

    public static native int ObjectControl(int var0, int var1, int var2, int var3, int var4, int var5, int var6, String var7);

    public native int StreamPlayInit(String var1, String var2, int var3, String var4);

    public native int StreamPlayControl(String var1, int var2, int var3, int var4, String var5);

    public native int StreamPlaySetVideoPos(String var1, Component var2, int var3, int var4, int var5, int var6);

    public native String StreamPlayGetInfo(String var1, int var2);

    public native int StreamPlayDestroy(String var1, int var2);

    public void OnNotifyMsg(int dwNotifyMsg, int wParam, int lParam) {
        switch (dwNotifyMsg) {
            case 1225: {
                if (this.baseEvent == null) break;
                this.baseEvent.OnAnyChatConnectMessage(wParam >= 1);
                break;
            }
            case 1226: {
                if (this.baseEvent == null) break;
                this.baseEvent.OnAnyChatLoginMessage(wParam, lParam);
                break;
            }
            case 1227: {
                if (this.baseEvent == null) break;
                this.baseEvent.OnAnyChatEnterRoomMessage(wParam, lParam);
                break;
            }
            case 1229: {
                if (this.baseEvent == null) break;
                this.baseEvent.OnAnyChatUserAtRoomMessage(wParam, lParam >= 1);
                break;
            }
            case 1230: {
                if (this.baseEvent == null) break;
                this.baseEvent.OnAnyChatLinkCloseMessage(lParam);
                break;
            }
            case 1231: {
                if (this.baseEvent == null) break;
                this.baseEvent.OnAnyChatOnlineUserMessage(wParam, lParam);
                break;
            }
            case 1228: {
                if (this.stateChgEvent == null) break;
                this.stateChgEvent.OnAnyChatMicStateChgMessage(wParam, lParam != 0);
                break;
            }
            case 1235: {
                if (this.stateChgEvent == null) break;
                this.stateChgEvent.OnAnyChatCameraStateChgMessage(wParam, lParam);
                break;
            }
            case 1236: {
                if (this.stateChgEvent == null) break;
                this.stateChgEvent.OnAnyChatChatModeChgMessage(wParam, lParam == 0);
                break;
            }
            case 1237: {
                if (this.stateChgEvent == null) break;
                this.stateChgEvent.OnAnyChatActiveStateChgMessage(wParam, lParam);
                break;
            }
            case 1238: {
                if (this.stateChgEvent == null) break;
                this.stateChgEvent.OnAnyChatP2PConnectStateMessage(wParam, lParam);
                break;
            }
            case 1239: {
                break;
            }
            case 1245: {
                if (this.privateChatEvent == null) break;
                this.privateChatEvent.OnAnyChatPrivateRequestMessage(wParam, lParam);
                break;
            }
            case 1246: {
                if (this.privateChatEvent == null) break;
                this.privateChatEvent.OnAnyChatPrivateEchoMessage(wParam, lParam);
                break;
            }
            case 1247: {
                if (this.privateChatEvent == null) break;
                this.privateChatEvent.OnAnyChatPrivateExitMessage(wParam, lParam);
                break;
            }
        }
    }

    private void OnAnyChatNotifyMsg(int dwNotifyMsg, int wParam, int lParam) {
        this.OnNotifyMsg(dwNotifyMsg, wParam, lParam);
    }

    private void OnTextMessageCallBack(int dwFromUserid, int dwToUserid, int bSecret, String message) {
        if (this.textMsgEvent != null) {
            this.textMsgEvent.OnAnyChatTextMessage(dwFromUserid, dwToUserid, bSecret != 0, message);
        }
    }

    private void OnTransFileCallBack(int userid, String filename, String tempfilepath, int filelength, int wparam, int lparam, int taskid) {
        if (this.transDataEvent != null) {
            this.transDataEvent.OnAnyChatTransFile(userid, filename, tempfilepath, filelength, wparam, lparam, taskid);
        }
    }

    private void OnTransBufferCallBack(int userid, byte[] buf, int len) {
        if (this.transDataEvent != null) {
            this.transDataEvent.OnAnyChatTransBuffer(userid, buf, len);
        }
    }

    private void OnTransBufferExCallBack(int userid, byte[] buf, int len, int wparam, int lparam, int taskid) {
        if (this.transDataEvent != null) {
            this.transDataEvent.OnAnyChatTransBufferEx(userid, buf, len, wparam, lparam, taskid);
        }
    }

    private void OnSDKFilterDataCallBack(byte[] buf, int len) {
        if (this.transDataEvent != null) {
            this.transDataEvent.OnAnyChatSDKFilterData(buf, len);
        }
    }

    private void OnVideoDataCallBack(int userid, byte[] buf, int len, int width, int height) {
        if (this.streamcbEvent != null) {
            this.streamcbEvent.OnAnyChatVideoDataCallBack(userid, 0, buf, len, width, height);
        }
    }

    private void OnVideoDataCallBackEx(int userid, int streamindex, byte[] buf, int len, int width, int height) {
        if (this.streamcbEvent != null) {
            this.streamcbEvent.OnAnyChatVideoDataCallBack(userid, streamindex, buf, len, width, height);
        }
    }

    private void OnAudioDataCallBack(int userid, int streamindex, byte[] buf, int len, int timestamp, int channels, int samplespersecond, int bitspersample) {
        if (this.streamcbEvent != null) {
            this.streamcbEvent.OnAnyChatAudioDataCallBack(userid, streamindex, buf, len, timestamp, channels, samplespersecond, bitspersample);
        }
    }

    private void OnVideoCallEventCallBack(int eventtype, int userid, int errorcode, int flags, int param, String userStr) {
        if (this.videoCallEvent != null) {
            this.videoCallEvent.OnAnyChatVideoCallEvent(eventtype, userid, errorcode, flags, param, userStr);
        }
    }

    private void OnRecordSnapShotExCallBack(int dwUserId, int dwErrorCode, String lpFileName, int dwElapse, int dwFlags, int dwParam, String lpUserStr) {
        if (this.recordEvent != null) {
            if ((dwFlags & 0x400) == 0) {
                this.recordEvent.OnAnyChatRecordEvent(dwUserId, dwErrorCode, lpFileName, dwElapse, dwFlags, dwParam, lpUserStr);
            } else {
                this.recordEvent.OnAnyChatSnapShotEvent(dwUserId, dwErrorCode, lpFileName, dwFlags, dwParam, lpUserStr);
            }
        }
    }

    private int OnDataEncDecCallBack(int userid, int flags, byte[] buf, int len, AnyChatOutParam outParam) {
        if (this.encdecEvent != null) {
            return this.encdecEvent.OnAnyChatDataEncDec(userid, flags, buf, len, outParam);
        }
        return -1;
    }

    private void OnObjectEventNotifyCallBack(int dwObjectType, int dwObjectId, int dwEventType, int dwParam1, int dwParam2, int dwParam3, int dwParam4, String lpStrParam) {
        if (this.objectEvent != null) {
            this.objectEvent.OnAnyChatObjectEvent(dwObjectType, dwObjectId, dwEventType, dwParam1, dwParam2, dwParam3, dwParam4, lpStrParam);
        }
    }

    private void OnAnyChatCoreSDKEventCallBack(int dwEventType, String lpJsonStr) {
        if (this.coresdkEvent != null) {
            this.coresdkEvent.OnAnyChatCoreSDKEvent(dwEventType, lpJsonStr);
        }
    }
}

