/*
 * Decompiled with CFR 0.152.
 */
package com.bairuitech.server;

import com.bairuitech.anychat.AnyChatServerEvent;
import com.bairuitech.anychat.AnyChatServerSDK;
import com.bairuitech.anychat.AnyChatVerifyUserOutParam;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class BusinessServer
extends JFrame
implements AnyChatServerEvent {
    private static final long serialVersionUID = 1L;
    public AnyChatServerSDK anychat;
    public StringBuilder message = new StringBuilder();
    public JTextArea showMessage;
    public JScrollPane jPanlMsg;
    public JScrollPane jPanlUser;
    public JPanel jContent;
    public JTable jTableUser;
    public JLabel jServerStatus;
    public GridBagLayout gridBagLayout;
    public GridBagConstraints gridConstraints;
    public Vector<String> tableTitles = new Vector();
    public DefaultTableModel model;
    public static int iUserIdSeed = 1;
    public static final int COLUM_COUNT = 5;
    public static final int ROOM_INDEX = 3;
    public static final int QUEUE_ABILITY_TYPE_PERSONAL = 1;
    public static final int QUEUE_ABILITY_TYPE_COMPANY = 2;

    public BusinessServer() {
        this.initView();
    }

    private void initUserTable() {
        this.tableTitles.addElement("\u7528\u6237ID");
        this.tableTitles.addElement("\u7528\u6237\u59d3\u540d");
        this.tableTitles.addElement("\u7528\u6237IP");
        this.tableTitles.addElement("\u623f\u95f4ID");
        this.tableTitles.addElement("\u767b\u5f55\u65f6\u95f4");
        this.model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.jTableUser = new JTable(this.model);
        this.jTableUser.setForeground(Color.white);
        this.jTableUser.setRowHeight(20);
        this.jTableUser.setPreferredScrollableViewportSize(new Dimension(200, 200));
        this.jTableUser.doLayout();
        this.jTableUser.setGridColor(Color.gray);
        int i = 0;
        while (i < 5) {
            this.model.addColumn(this.tableTitles.get(i));
            ++i;
        }
        DefaultTableCellRenderer render = new DefaultTableCellRenderer(){

            @Override
            public void setValue(Object value) {
                this.setForeground(Color.blue);
                super.setValue(value);
            }
        };
        render.setHorizontalAlignment(0);
        render.setVerticalAlignment(0);
        this.jTableUser.setDefaultRenderer(Object.class, render);
        DefaultTableCellRenderer hendRender = (DefaultTableCellRenderer)this.jTableUser.getTableHeader().getDefaultRenderer();
        Dimension d = render.getSize();
        d.height = 20;
        hendRender.setPreferredSize(d);
    }

    private void updateUserData(int userId, String name, String ip, String time) {
        if (userId != 0) {
            Vector<Object> verctor = new Vector<Object>();
            verctor.addElement(userId);
            verctor.addElement(name);
            verctor.addElement(ip);
            verctor.addElement("");
            verctor.addElement(time);
            this.model.addRow(verctor);
        }
    }

    private void updateUserData(int userId) {
        int index = -1;
        index = this.findUserDataById(userId);
        if (index != -1) {
            this.model.removeRow(index);
        }
    }

    private void updateUserData(int userId, int roomId) {
        int index = -1;
        index = this.findUserDataById(userId);
        if (index != -1) {
            if (roomId != -1) {
                this.model.setValueAt(roomId, index, 3);
            } else {
                this.model.setValueAt("", index, 3);
            }
            this.jTableUser.updateUI();
        }
    }

    private int findUserDataById(int userId) {
        int index = -1;
        Vector<Vector> userDatas = this.model.getDataVector();
        int size = userDatas.size();
        System.out.print(size);
        int i = 0;
        while (i < size) {
            index = i;
            Vector vector = userDatas.get(i);
            if (vector != null && vector.indexOf(userId) != -1) {
                return index;
            }
            ++i;
        }
        return -1;
    }

    private String getCurrentTime() {
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat sdf = new SimpleDateFormat("MM-dd HH:mm:ss:SS");
        String strTime = "";
        try {
            strTime = sdf.format(date);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strTime;
    }

    public void initView() {
        this.setLayout(null);
        this.showMessage = new JTextArea();
        this.showMessage.setEditable(false);
        this.jContent = new JPanel();
        this.jContent.setLayout(new GridLayout(2, 1));
        this.jPanlMsg = new JScrollPane(this.showMessage);
        this.jPanlMsg.setVerticalScrollBarPolicy(20);
        this.jPanlMsg.setHorizontalScrollBarPolicy(30);
        this.initUserTable();
        this.jPanlUser = new JScrollPane(this.jTableUser);
        this.jPanlUser.setVerticalScrollBarPolicy(20);
        this.jPanlUser.setHorizontalScrollBarPolicy(30);
        this.jPanlUser.getViewport().setBackground(Color.white);
        this.jServerStatus = new JLabel();
        this.jContent.add(this.jPanlUser);
        this.jContent.add(this.jPanlMsg);
        this.jContent.setBounds(0, 0, 850, 540);
        this.jServerStatus.setBounds(620, 540, 200, 30);
        this.add(this.jContent);
        this.add(this.jServerStatus);
        this.setSize(850, 600);
        this.setLocation(400, 150);
        this.setResizable(false);
        this.setTitle("AnyChat Server SDK for Java \u793a\u4f8b");
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.createImage("bairuitech.png");
        this.setIconImage(image);
        this.setDefaultCloseOperation(3);
        this.addWindowListener(new WindowsEvent());
        this.setVisible(true);
    }

    private void initSdk() {
        this.anychat = new AnyChatServerSDK();
        this.anychat.SetServerEvent(this);
        this.anychat.InitSDK(0);
        this.anychat.RegisterVerifyUserClass(new AnyChatVerifyUserOutParam());
        String sdkVersion = this.anychat.GetSDKVersion();
        this.message.append(String.valueOf(sdkVersion) + "\r\n");
        this.showMessage.setText(this.message.toString());
    }

    private void generateLog(String str) {
        this.message.append(String.valueOf(this.getCurrentTime()) + "  ");
        this.message.append(str);
        this.message.append("\n");
        this.showMessage.setText(this.message.toString());
    }

    public static void main(String[] args) {
        BusinessServer server = new BusinessServer();
        server.initSdk();
        BusinessServer.InitBusinessQueue();
    }

    private static void InitBusinessQueue() {
        int dwAreaId = 10001;
        AnyChatServerSDK.ObjectControl(4, dwAreaId, 2, 0, 0, 0, 0, "");
        AnyChatServerSDK.ObjectSetStringValue(4, dwAreaId, 8, "\u79d1\u97f5\u8def\u8425\u4e1a\u5385");
        AnyChatServerSDK.ObjectSetStringValue(4, dwAreaId, 11, "\u4f4d\u4e8e\u5e7f\u5dde\u5e02\u79d1\u97f5\u8def\uff0c\u670d\u52a1\u8d85\u7ea7\u68d2\uff01");
        int dwQueueId = 101;
        AnyChatServerSDK.ObjectControl(5, dwQueueId, 2, dwAreaId, 0, 0, 0, "");
        AnyChatServerSDK.ObjectSetStringValue(5, dwQueueId, 8, "\u4e2a\u4eba\u4e1a\u52a1\u961f\u5217");
        AnyChatServerSDK.ObjectSetStringValue(5, dwQueueId, 11, "\u5f00\u6237\u3001\u6302\u5931\u3001\u8f6c\u5e10");
        int dwPriority = 0;
        AnyChatServerSDK.ObjectSetIntValue(5, dwQueueId, 9, dwPriority);
        int dwQueueAbility = 1;
        AnyChatServerSDK.ObjectSetIntValue(5, dwQueueId, 10, dwQueueAbility);
        int dwQueueIntTag = 2;
        AnyChatServerSDK.ObjectSetIntValue(5, dwQueueId, 12, dwQueueIntTag);
        dwQueueId = 102;
        AnyChatServerSDK.ObjectControl(5, dwQueueId, 2, dwAreaId, 0, 0, 0, "");
        AnyChatServerSDK.ObjectSetStringValue(5, dwQueueId, 8, "\u4e2a\u4eba\u4e1a\u52a1\u961f\u5217(VIP)");
        AnyChatServerSDK.ObjectSetStringValue(5, dwQueueId, 11, "\u5f00\u6237\u3001\u6302\u5931\u3001\u8f6c\u5e10");
        dwPriority = 10;
        AnyChatServerSDK.ObjectSetIntValue(5, dwQueueId, 9, dwPriority);
        dwQueueAbility = 1;
        AnyChatServerSDK.ObjectSetIntValue(5, dwQueueId, 10, dwQueueAbility);
        dwQueueIntTag = 2;
        AnyChatServerSDK.ObjectSetIntValue(5, dwQueueId, 12, dwQueueIntTag);
        dwQueueId = 103;
        AnyChatServerSDK.ObjectControl(5, dwQueueId, 2, dwAreaId, 0, 0, 0, "");
        AnyChatServerSDK.ObjectSetStringValue(5, dwQueueId, 8, "\u5bf9\u516c\u4e1a\u52a1\u961f\u5217");
        AnyChatServerSDK.ObjectSetStringValue(5, dwQueueId, 11, "\u652f\u7968\u3001\u56de\u5355\u3001\u57fa\u672c\u6237");
        dwPriority = 0;
        AnyChatServerSDK.ObjectSetIntValue(5, dwQueueId, 9, dwPriority);
        dwQueueAbility = 2;
        AnyChatServerSDK.ObjectSetIntValue(5, dwQueueId, 10, dwQueueAbility);
        dwQueueIntTag = 3;
        AnyChatServerSDK.ObjectSetIntValue(5, dwQueueId, 12, dwQueueIntTag);
        dwAreaId = 10002;
        AnyChatServerSDK.ObjectControl(4, dwAreaId, 2, 0, 0, 0, 0, "");
        AnyChatServerSDK.ObjectSetStringValue(4, dwAreaId, 8, "\u5929\u6cb3\u8def\u8425\u4e1a\u5385");
        AnyChatServerSDK.ObjectSetStringValue(4, dwAreaId, 11, "\u4e03\u661f\u7ea7\u65d7\u8230\u5e97\uff0c\u9ad8\u7aef\u5ba2\u6237\u9996\u9009\uff01");
        dwQueueId = 201;
        AnyChatServerSDK.ObjectControl(5, dwQueueId, 2, dwAreaId, 0, 0, 0, "");
        AnyChatServerSDK.ObjectSetStringValue(5, dwQueueId, 8, "\u6295\u8d44\u7406\u8d22\u4e1a\u52a1\u961f\u5217");
        AnyChatServerSDK.ObjectSetStringValue(5, dwQueueId, 11, "\u57fa\u91d1\u3001\u7406\u8d22\u4ea7\u54c1\u3001\u8d35\u91d1\u5c5e");
        dwPriority = 0;
        AnyChatServerSDK.ObjectSetIntValue(5, dwQueueId, 9, dwPriority);
        dwQueueAbility = 1;
        AnyChatServerSDK.ObjectSetIntValue(5, dwQueueId, 10, dwQueueAbility);
        dwQueueIntTag = 2;
        AnyChatServerSDK.ObjectSetIntValue(5, dwQueueId, 12, dwQueueIntTag);
        dwQueueId = 202;
        AnyChatServerSDK.ObjectControl(5, dwQueueId, 2, dwAreaId, 0, 0, 0, "");
        AnyChatServerSDK.ObjectSetStringValue(5, dwQueueId, 8, "\u5546\u4e1a\u8d37\u6b3e\u4e1a\u52a1\u961f\u5217");
        AnyChatServerSDK.ObjectSetStringValue(5, dwQueueId, 11, "\u623f\u8d37\u3001\u8f66\u8d37\u3001\u516c\u79ef\u91d1");
        dwPriority = 10;
        AnyChatServerSDK.ObjectSetIntValue(5, dwQueueId, 9, dwPriority);
        dwQueueAbility = 2;
        AnyChatServerSDK.ObjectSetIntValue(5, dwQueueId, 10, dwQueueAbility);
        dwQueueIntTag = 3;
        AnyChatServerSDK.ObjectSetIntValue(5, dwQueueId, 12, dwQueueIntTag);
    }

    @Override
    public void OnAnyChatServerAppMessageExCallBack(int dwNotifyMessage, int wParam, int lParam) {
        String str = "";
        if (dwNotifyMessage == 10) {
            if (wParam == 0) {
                str = "Connect AnyChatCoreServer successed!";
                this.jServerStatus.setForeground(new Color(0, 128, 0));
                this.jServerStatus.setText(str);
            } else {
                str = "Connect AnyChatCoreServer failed!(errorcode:" + wParam + ")";
                this.jServerStatus.setForeground(Color.red);
                this.jServerStatus.setText(str);
            }
        } else {
            str = dwNotifyMessage == 11 ? (wParam == 0 ? "Success connected with anychatrecordserver(id:" + lParam + ") ..." : "ERROR: Disconnected from the anychatrecordserver, errorcode:" + wParam) : "OnServerAppMessageExCallBack, dwNotifyMessage:" + dwNotifyMessage + " wParam:" + wParam + " lParam:" + lParam;
        }
        this.generateLog(str);
    }

    @Override
    public int OnAnyChatVerifyUserCallBack(String szUserName, String szPassword, AnyChatVerifyUserOutParam outParam) {
        outParam.SetUserId(iUserIdSeed);
        outParam.SetUserLevel(0);
        outParam.SetNickName(szUserName);
        String str = "OnVerifyUserCallBack: userid:" + iUserIdSeed + " username: " + szUserName;
        this.generateLog(str);
        ++iUserIdSeed;
        return 0;
    }

    @Override
    public void OnAnyChatUserLoginActionCallBack(int dwUserId, String szUserName, int dwLevel, String szIpAddr) {
        String str = "OnAnyChatUserLoginActionCallBack: userid:" + dwUserId + " username: " + szUserName + " Ip: " + szIpAddr;
        this.generateLog(str);
        this.updateUserData(dwUserId, szUserName, szIpAddr, this.getCurrentTime());
    }

    @Override
    public void OnAnyChatUserLogoutActionExCallBack(int dwUserId, int dwErrorCode) {
        String str = "OnUserLogoutActionExCallBack: userid:" + dwUserId + " errorcode:" + dwErrorCode;
        this.generateLog(str);
        this.updateUserData(dwUserId);
    }

    @Override
    public int OnAnyChatPrepareEnterRoomCallBack(int dwUserId, int dwRoomId, String szRoomName, String szPassword) {
        String str = "OnPrepareEnterRoomCallBack: userid:" + dwUserId + " roomid: " + dwRoomId;
        this.generateLog(str);
        return 0;
    }

    @Override
    public void OnAnyChatUserEnterRoomActionCallBack(int dwUserId, int dwRoomId) {
        String str = "OnUserEnterRoomActionCallBack: userid:" + dwUserId + " roomid: " + dwRoomId;
        this.generateLog(str);
        this.updateUserData(dwUserId, dwRoomId);
    }

    @Override
    public void OnAnyChatUserLeaveRoomActionCallBack(int dwUserId, int dwRoomId) {
        String str = "OnAnyChatUserLeaveRoomActionCallBack: userid:" + dwUserId + " roomid: " + dwRoomId;
        this.generateLog(str);
        this.updateUserData(dwUserId, -1);
    }

    @Override
    public void OnAnyChatTransFile(int dwUserId, String szFileName, String szTempFilePath, int dwFileLength, int wParam, int lParam, int dwTaskId) {
        String str = "OnAnyChatTransFile->from:" + dwUserId + ";filename:" + szFileName + "path:" + szTempFilePath;
        this.generateLog(str);
        this.showMessage.setText(this.message.toString());
    }

    @Override
    public void OnAnyChatTransBuffer(int dwUserId, byte[] lpBuf, int dwLen) {
        String str = "";
        try {
            str = new String(lpBuf, "GB2312");
            System.out.println(str);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.generateLog("OnAnyChatTransBuffer: fromUserid:" + dwUserId + str);
    }

    @Override
    public void OnAnyChatTransBufferEx(int dwUserId, byte[] lpBuf, int dwLen, int wParam, int lParam, int dwTaskId) {
        String str = "";
        try {
            str = new String(lpBuf, "GB2312");
            System.out.println(str);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.message.append("OnAnyChatTransBufferEx: fromUserid:" + dwUserId + str);
        this.generateLog("OnAnyChatTransBufferEx: fromUserid:" + dwUserId + str);
    }

    @Override
    public void OnAnyChatSDKFilterData(int dwUserId, byte[] lpBuf, int dwLen) {
        String str = "";
        try {
            str = new String(lpBuf, "GB2312");
            System.out.println(str);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.message.append("OnanychatFilterData: fromUserid:" + dwUserId + str);
        this.generateLog("OnanychatFilterData: fromUserid:" + dwUserId + str);
    }

    @Override
    public void OnAnyChatTimerEventCallBack() {
        System.out.print("OnTimerEventCallBack\r\n");
    }

    @Override
    public void OnAnyChatRecvUserTextMsgCallBack(int dwRoomId, int dwSrcUserId, int dwTarUserId, int bSecret, String szTextMessage, int dwLen) {
        String str = "OnAnyChatRecvUserTextMsgCallBack: " + dwSrcUserId + " to " + dwTarUserId + " " + szTextMessage;
        this.generateLog(str);
    }

    @Override
    public void OnAnyChatServerRecordExCallBack(int dwUserId, String szRecordFileName, int dwElapse, int dwFlags, int dwParam, String lpUserStr, int dwRecordServerId) {
        boolean bSnapShotEvent = (dwFlags & 0x400) != 0;
        String eventStr = bSnapShotEvent ? " ,SnapShot Event" : " ,Record Event";
        String str = "OnAnyChatServerRecordExCallBack: dwUserId" + dwUserId + eventStr + " ,szRecordFileName:" + szRecordFileName + " lpUserStr:" + lpUserStr;
        this.generateLog(str);
    }

    @Override
    public int OnAnyChatVideoCallEventCallBack(int dwEventType, int dwSrcUserId, int dwTarUserId, int dwErrorCode, int dwFlags, int dwParam, String lpUserStr) {
        String str = "OnAnyChatVideoCallEventCallBack: dwEventType:" + dwEventType + " dwSrcUserId:" + dwSrcUserId + " dwTarUserId:" + dwTarUserId + " dwErrorCode:" + dwErrorCode + " dwFlags:" + dwFlags + " dwParam:" + dwParam + " lpUserStr:" + lpUserStr;
        this.generateLog(str);
        return 0;
    }

    @Override
    public int OnAnyChatUserInfoCtrlCallBack(int dwSendUserId, int dwUserId, int dwCtrlCode, int wParam, int lParam, String lpStrValue) {
        String str = "OnAnyChatUserInfoCtrlCallBack: dwSendUserId:" + dwSendUserId + " dwUserId:" + dwUserId + " dwCtrlCode:" + dwCtrlCode + " wParam:" + wParam + " lParam:" + lParam + " lpStrValue:" + lpStrValue;
        this.generateLog(str);
        return 0;
    }

    @Override
    public int OnAnyChatObjectEventCallBack(int dwObjectType, int dwObjectId, int dwEventType, int dwParam1, int dwParam2, int dwParam3, int dwParam4, String lpStrParam) {
        return 0;
    }

    class WindowsEvent
    extends WindowAdapter {
        WindowsEvent() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            try {
                BusinessServer.this.anychat.Release();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

