unit BRAnyChatCoreSDK;
(****************************************************************************
     BRAnyChatCoreSDK.h
****************************************************************************)

interface
uses
  Windows,MMSystem,SysUtils,Messages,Classes,Types,Graphics,
  GVMessageDefine,GVErrorCodeDefine,GVSDK;

const
  C_BRAnyChatCoreLibName = 'BRAnyChatCore.dll';

  // Ƶͼʽ
type BRAC_PixelFormat=(
	          BRAC_PIX_FMT_RGB24 = 0,			///< Packed RGB 8:8:8, 24bpp, RGBRGB...MEDIASUBTYPE_RGB24
	          BRAC_PIX_FMT_RGB32,				///< ӦڣMEDIASUBTYPE_RGB32Packed RGB 8:8:8, 32bpp, (msb)8A 8R 8G 8B(lsb), in cpu endianness
	          BRAC_PIX_FMT_YV12,				///< ӦڣMEDIASUBTYPE_YV12Planar YUV 4:2:0, 12bpp, (1 Cr & Cb sample per 2x2 Y samples)
	          BRAC_PIX_FMT_YUY2					///< ӦڣMEDIASUBTYPE_YUY2Packed YUV 4:2:2, 16bpp, Y0 Cb Y1 Cr
     );

  // Ƶ豸
type BRAC_AudioDevice=(
	        BRAC_AD_WAVEIN = 0,					///< 豸Mic
          	BRAC_AD_WAVEOUT			     		///< 豸Wave
     );


  // ģʽ
const
  BRAC_FUNC_VIDEO_CBDATA		=$00000001;		///< ͨصƵ
  BRAC_FUNC_VIDEO_AUTODISP		=$00000002;		///< SDKƵƵʾָĴ
  BRAC_FUNC_AUDIO_CBDATA		=$00000004;		///< ͨ˳Ƶ
  BRAC_FUNC_AUDIO_AUTOPLAY		=$00000008;		///< SDKƵֱӲ
  BRAC_FUNC_CONFIG_LOCALINI 	=$00000010;		///< ɱļAnyChatSDK.ini
  BRAC_FUNC_FIREWALL_OPEN   	=$00000020;		///< SDKWindowsǽǰӦóǽбWindowsʾûǷֹǰӦó
  BRAC_FUNC_CHKDEPENDMODULE   	=$00000040;		///< ԶSDKԶע
  BRAC_FUNC_AUDIO_VOLUMECALC  	=$00000080;		///< SDKԶ
  BRAC_FUNC_AUDIO_AUTOVOLUME  	=$00000100;		///< SDKԶMic¼
  BRAC_FUNC_NET_SUPPORTUPNP   	=$00000200;		///< SDKûеUPNP豸û·Ƿǽ֧UPNPЭ飬P2P򶴵ĳɹ
  BRAC_FUNC_DISABLEDECODE		=$00000400;		///< ֹյݽнͲţΪߴͻ˵תܣøñ־øñ־

  //ں˲
  BRAC_SO_AUDIO_VADCTRL			=1;	  		    ///< ƵƣΪintͣ1򿪣0رգ
  BRAC_SO_AUDIO_NSCTRL			=2;	    		///< ƵƿƣΪintͣ1򿪣0رգ
  BRAC_SO_AUDIO_ECHOCTRL		=3;	   		    ///< ƵƣΪintͣ1򿪣0رգ
  BRAC_SO_AUDIO_AGCCTRL			=4;	  			///< ƵԶƣΪintͣ1򿪣0رգ
  BRAC_SO_AUDIO_CPATUREMODE		=5;				///< ƵɼģʽãΪintͣ0 ģʽ1 Ÿģʽ2 OKģʽ3 ·ģʽ
  BRAC_SO_AUDIO_MICBOOST		=6;				///< ƵɼMicǿƣΪintͣ0 ȡ1 ѡУ2 豸[ѯʱֵ]
  BRAC_SO_AUDIO_AUTOPARAM		=7;				///< ƵɼģʽԶѡʵزʲȣΪintͣ1 ã0 ر[Ĭ]
  BRAC_SO_AUDIO_MONOBITRATE		=8;				///< õģʽƵĿʣΪintͣλbps
  BRAC_SO_AUDIO_STEREOBITRATE	=9;				///< ˫ģʽƵĿʣΪintͣλbps
  BRAC_SO_AUDIO_PLAYDRVCTRL		=70;			///< Ƶѡ񣨲Ϊintͣ0Ĭ 1 DSound 2 WaveOut
  BRAC_SO_AUDIO_CNGCTRL			=71;			///< ɿƣΪintͣ1򿪣0رգ
  BRAC_SO_AUDIO_SOFTVOLMODE		=73;			///< ģʽƣΪintͣ1򿪣0ر[Ĭ]ʹģʽıϵͳ
  BRAC_SO_AUDIO_RECORDDRVCTRL	=74;			///< ƵɼƣΪintͣ0Ĭ 1 DSound 2 WaveIn 3 Javaɼ[Androidƽ̨ʹ]

  BRAC_SO_RECORD_VIDEOBR		=10;	 		///< ¼ƵãΪintͣλbps
  BRAC_SO_RECORD_AUDIOBR		=11;	  		///< ¼ƵãΪintͣλbps
  BRAC_SO_RECORD_TMPDIR			=12;	 		///< ¼ļʱĿ¼ãΪַPCHARͣ
  BRAC_SO_SNAPSHOT_TMPDIR		=13;	 		///< ļʱĿ¼ãΪַPCHARͣ
  BRAC_SO_RECORD_FILETYPE		=140;			///< ¼ļãΪintͣ 0 MP4[Ĭ], 1 WMV, 2 FLV, 3 MP3
  BRAC_SO_RECORD_WIDTH			=141;			///< ¼ƵãΪintͣ磺320
  BRAC_SO_RECORD_HEIGHT			=142;			///< ¼ļ߶ãΪintͣ磺240
  BRAC_SO_RECORD_FILENAMERULE	=143;			///< ¼ļ򣨲Ϊintͣ
  
  BRAC_SO_CORESDK_TMPDIR		=14;	  		///< AnyChat Core SDKʱĿ¼ΪַPCHARͣ
  BRAC_SO_CORESDK_PATH			=20;	  		///< AnyChat Core SDK·ΪַPCHARͣ
  BRAC_SO_CORESDK_DUMPCOREINFO	=21;			///< ںϢ־ļУڷԭ򣨲Ϊintͣ1 
  BRAC_SO_CORESDK_EXTVIDEOINPUT	=26;			///< ⲿչƵƣΪintͣ 0 رⲿƵ[Ĭ] 1 ⲿƵ룩
  BRAC_SO_CORESDK_EXTAUDIOINPUT	=27;			///< ⲿչƵƣΪintͣ 0 رⲿƵ[Ĭ] 1 ⲿƵ룩

  BRAC_SO_LOCALVIDEO_BITRATECTRL	=30;		///< ƵãΪintͣλbpsͬãVideoBitrate
  BRAC_SO_LOCALVIDEO_QUALITYCTRL	=31;		///< ƵӿƣΪintͣͬãVideoQuality
  BRAC_SO_LOCALVIDEO_GOPCTRL		=32;		///< Ƶؼ֡ƣΪintͣͬãVideoGOPSize
  BRAC_SO_LOCALVIDEO_FPSCTRL		=33;		///< Ƶ֡ʿƣΪintͣͬãVideoFps
  BRAC_SO_LOCALVIDEO_PRESETCTRL		=34;		///< ƵԤƣΪintͣ1-5
  BRAC_SO_LOCALVIDEO_APPLYPARAM		=35;		///< ӦñƵʹǰ޸ļʱЧΪintͣ1 ʹ²0 ʹĬϲ
  BRAC_SO_LOCALVIDEO_VIDEOSIZEPOLITIC=36;		///< ƵɼֱʿƲԣΪintͣ0 Զƥ[Ĭ]1 ʹòɼ豸ĬϷֱʣõķֱʲɼ豸֧ʱЧ
  BRAC_SO_LOCALVIDEO_DEINTERLACE	=37;		///< Ƶ֯ƣΪintͣ 0 з֯[Ĭ]1 ֯ƵԴǸɨԴźţʱͨ֯߻
  BRAC_SO_LOCALVIDEO_WIDTHCTRL		=38;		///< ƵɼֱʿȿƣΪintͣͬãVideoWidth
  BRAC_SO_LOCALVIDEO_HEIGHTCTRL		=39;		///< Ƶɼֱʸ߶ȿƣΪintͣͬãVideoHeight
  BRAC_SO_LOCALVIDEO_TVFORMAT		=104;		///< ƵɼʽãΪintͣΪDirectShow::strmif.h::AnalogVideoStandardĬΪAnalogVideo_PAL_B

  BRAC_SO_NETWORK_P2PPOLITIC		=40;		///< P2PԿƣΪintͣ0 ֹP2P1 P2P[Ĭ]2 ϲӦÿP2Pӣ3 轨P2Pӣ
  BRAC_SO_NETWORK_P2PCONNECT		=41;		///< ָûP2PӣΪintͣʾĿûIDӽɹ󣬻ͨϢϲӦãP2PƲ=2ʱЧ
  BRAC_SO_NETWORK_P2PBREAK			=42;		///< ϿָûP2PӣΪintͣʾĿûID[ݲ֧֣]
  BRAC_SO_NETWORK_TCPSERVICEPORT	=43;		///< ñTCP˿ڣΪintͣӷ֮ǰЧ
  BRAC_SO_NETWORK_UDPSERVICEPORT	=44;		///< ñUDP˿ڣΪintͣӷ֮ǰЧ
  BRAC_SO_NETWORK_MULTICASTPOLITIC	=45;		///< 鲥ԿƣΪintͣ0 ִз·ɲԣֹ鲥[Ĭ] 1 Է·ɲԣֻ鲥㲥ý 2 ִз·ɲԣͬʱ鲥
  BRAC_SO_NETWORK_TRANSBUFMAXBITRATE=46;		///< 仺ļʿƣΪintͣ0 ƣʴ[Ĭ] ʾʣλΪbps

  BRAC_SO_PROXY_FUNCTIONCTRL	=50;			///< ûܿƣΪintͣ10رմ[Ĭ]
  BRAC_SO_PROXY_VIDEOCTRL		=51;			///< ûƵƣƵΪָûƵⷢΪintͣʾûuserid
  BRAC_SO_PROXY_AUDIOCTRL		=52;			///< ûƵƣƵΪָûƵⷢͬBRAC_SO_PROXY_VIDEOCTRL 
  
  BRAC_SO_STREAM_MAXBUFFERTIME	=60;			///< ʱ䣨Ϊintͣλ룬ȡֵΧ500 ~ 5000Ĭϣ800ģʽֵģʽԶһ
  BRAC_SO_STREAM_SMOOTHPLAYMODE =61;			///< ƽģʽΪintͣ0 ر[Ĭ], 1 򿪣״̬Ƶ֡ʱţܳˣῨס
  
  BRAC_SO_CORESDK_TICKOUTUSER		=110;		///< ӷߵָûΪintͣʾĿûID
  BRAC_SO_CORESDK_DEVICEMODE		=130;		///< 豸ģʽƣ豸֮ԻͨţΪintͣ0 ر[Ĭ]1 
  BRAC_SO_CORESDK_SCREENCAMERACTRL	=131;		///< 湲ܿƣΪintͣ 0 ر[Ĭ] 1 
  BRAC_SO_CORESDK_DATAENCRYPTION	=132;		///< ݼܿƣΪintͣ 0 ر[Ĭ] 1 
  
  // Ϣ
  BRAC_TRANSTASK_PROGRESS		=1;	   			///< ȲѯΪDOUBLEͣ0.0 ~ 100.0
  BRAC_TRANSTASK_BITRATE		=2;				///< ǰʣΪintͣλbps
  BRAC_TRANSTASK_STATUS			=3;				///< ǰ״̬Ϊintͣ
  BRAC_TRANSTASK_SAVEASPATH		=4;				///< ļΪ·ãΪַTCHARͣ

  // ¼ܱ־
  BRAC_RECORD_FLAGS_VIDEO		=$00000001;		///< ¼Ƶ
  BRAC_RECORD_FLAGS_AUDIO		=$00000002;		///< ¼Ƶ
  BRAC_RECORD_FLAGS_SERVER		=$00000004;		///< ¼
  BRAC_RECORD_FLAGS_MIXAUDIO	=$00000010;		///< ¼Ƶʱ˵¼
  BRAC_RECORD_FLAGS_MIXVIDEO	=$00000020;		///< ¼Ƶʱ˵ƵӺ¼
  BRAC_RECORD_FLAGS_ABREAST		=$00000100;		///< ¼Ƶʱ˵Ƶ¼

  // û״̬־
  BRAC_USERSTATE_CAMERA			=1;				///< ûͷ״̬ΪDWORDͣ
  BRAC_USERSTATE_HOLDMIC		=2;				///< ûƵ豸״̬ΪDWORDֵͣ0 Ƶɼرգ 1 Ƶɼ
  BRAC_USERSTATE_SPEAKVOLUME	=3;				///< ûǰ˵ΪDOUBLEͣ0.0 ~ 100.0
  BRAC_USERSTATE_RECORDING		=4;				///< û¼״̬ΪDWORDͣ
  BRAC_USERSTATE_LEVEL			=5;				///< û𣨲ΪDWORDͣ
  BRAC_USERSTATE_NICKNAME		=6;				///< ûǳƣΪַPCHARͣ
  BRAC_USERSTATE_LOCALIP		=7;				///< ûIPַΪַPCHARͣ
  BRAC_USERSTATE_INTERNETIP		=8;				///< ûIPַΪַPCHARͣ
  BRAC_USERSTATE_VIDEOBITRATE	=9;				///< ûǰƵʣΪDWORDͣBps
  BRAC_USERSTATE_AUDIOBITRATE	=10;			///< ûǰƵʣΪDWORDͣBps
  BRAC_USERSTATE_P2PCONNECT		=11;			///< ѯûָûĵǰP2P״̬ΪDWORDֵͣ0 P2Pͨ 1 P2Pӳɹ[TCP]2 P2Pӳɹ[UDP]3 P2Pӳɹ[TCPUDP]
  BRAC_USERSTATE_PACKLOSSRATE	=14;			///< ѯָûýݶʣΪDWORDֵͣ0 - 100磺ֵΪ5ʾΪ5%
  BRAC_USERSTATE_DEVICETYPE		=15;			///< ѯָûնͣΪDWORDֵͣ0 Unknow 1 Windows2 Android3 iOS4 Web5 Linux6 Mac7 Win Phone8 WinCE
  BRAC_USERSTATE_SELFUSERSTATUS	=16;			///< ѯûĵǰ״̬ΪDWORDֵͣ0 Unknow1 Connected2 Logined3 In Room4 Logouted5 Link Closed
  BRAC_USERSTATE_SELFUSERID		=17;			///< ѯûIDΪDWORDͣû¼ɹûʵʵuserid򷵻-1

  // Ƶ¼Ͷ壨APIBRAC_VideoCallControl VideoCallEventص
  BRAC_VIDEOCALL_EVENT_REQUEST	=1;				///< 
  BRAC_VIDEOCALL_EVENT_REPLY	=2;				///< ظ
  BRAC_VIDEOCALL_EVENT_START	=3;				///< ƵлỰʼ¼
  BRAC_VIDEOCALL_EVENT_FINISH	=4;				///< ҶϣлỰ

  // Ƶб־壨APIBRAC_VideoCallControl 
  BRAC_VIDEOCALL_FLAGS_AUDIO		=	$01;	///< ͨ
  BRAC_VIDEOCALL_FLAGS_VIDEO		=	$02;	///< Ƶͨ
  BRAC_VIDEOCALL_FLAGS_FBSRCAUDIO	=	$10;	///< ֹԴжˣƵ
  BRAC_VIDEOCALL_FLAGS_FBSRCVIDEO	=	$20;	///< ֹԴжˣƵ
  BRAC_VIDEOCALL_FLAGS_FBTARAUDIO	=	$40;	///< ֹĿ꣨жˣƵ
  BRAC_VIDEOCALL_FLAGS_FBTARVIDEO	=	$80;	///< ֹĿ꣨жˣƵ
  
  // ԶƵ־
  BRAC_ROTATION_FLAGS_MIRRORED		=	$1000;	///< ͼҪת
  BRAC_ROTATION_FLAGS_ROTATION90	=	$2000;	///< ˳ʱת90
  BRAC_ROTATION_FLAGS_ROTATION180	=	$4000;	///< ˳ʱת180
  BRAC_ROTATION_FLAGS_ROTATION270	=	$8000;	///< ˳ʱת270

  // ûϢͶ壨APIBRAC_UserInfoControl 
  BRAC_USERINFO_CTRLCODE_ROTATION	=	8;		///< ָûƵʾʱתwParamΪתǶȲ

  // ݼӣ⣩ܱ־壨DataEncDecص
  BRAC_DATAENCDEC_FLAGS_ENCMODE		=	$01;	///< ģʽ
  BRAC_DATAENCDEC_FLAGS_DECMODE		=	$02;	///< ģʽ
  BRAC_DATAENCDEC_FLAGS_AUDIO		=	$10;	///< Ƶ
  BRAC_DATAENCDEC_FLAGS_VIDEO		=	$20;	///< Ƶ
  BRAC_DATAENCDEC_FLAGS_BUFFER		=	$40;	///< ͸ͨ
  BRAC_DATAENCDEC_FLAGS_TXTMSG		=	$80;	///< 


type
  // Ƶݻص
  BRAC_VideoData_CallBack=procedure(dwUserid:DWORD;lpBuf:Pointer;dwLen:DWORD; bmiHeader:BITMAPINFOHEADER;lpUserValue:Pointer);stdcall;
    
  // Ƶݻص
  BRAC_AudioData_CallBack=procedure(dwUserid:DWORD;lpBuf:Pointer;dwLen:DWORD; waveFormatEx:TWaveFormatEx;lpUserValue:Pointer);stdcall;
    
  // Ϣص
  BRAC_TextMessage_CallBack=procedure(dwFromUserid:DWORD;dwToUserid:DWORD; bSecret:BOOL;lpMsgBuf:LPCTSTR;dwLen:DWORD;lpUserValue:Pointer);stdcall;
    
  // ͸ͨݻص
  BRAC_TransBuffer_CallBack=procedure(dwUserid:DWORD;lpBuf:PByte;dwLen:DWORD; lpUserValue:Pointer);stdcall;

// ͸ͨչص
  BRAC_TransBufferEx_CallBack=procedure(dwUserid:DWORD;lpBuf:PByte;dwLen:DWORD;wParam:DWORD;lParam:DWORD; dwTaskId:DWORD;lpUserValue:Pointer);stdcall;
    
  // 仯ص
  BRAC_VolumeChange_CallBack=procedure(device:BRAC_AudioDevice;dwCurrentVolume:DWORD; lpUserValue:Pointer);stdcall;

  // ļص
  BRAC_TransFile_CallBack=procedure(dwUserid:DWORD;lpFileName:LPCTSTR;lpTempFilePath:LPCTSTR; dwFileLength:DWORD;wParam:DWORD;lParam:DWORD;dwTaskId:DWORD;lpUserValue:Pointer);stdcall;

  // SDK Filter ͨݻص
  BRAC_SDKFilterData_CallBack=procedure(lpBuf:PByte;dwLen:DWORD;lpUserValue:Pointer);stdcall;
  
  // ¼񡢿ɻص
  BRAC_RecordSnapShot_CallBack=procedure(dwUserid:DWORD;lpFileName:LPCTSTR; dwParam:DWORD;bRecordType:BOOL;lpUserValue:Pointer);stdcall;
    
  // 첽Ϣ֪ͨص
  BRAC_NotifyMessage_CallBack=procedure(dwNotifyMsg:DWORD;wParam:DWORD;lParam:DWORD; lpUserValue:Pointer);stdcall;
	
  // ƵͨϢ֪ͨص
  BRAC_VideoCallEvent_CallBack=procedure(dwEventType:DWORD; dwUserId:DWORD; dwErrorCode:DWORD; dwFlags:DWORD; dwParam:DWORD; lpUserStr:LPCTSTR; lpUserValue:Pointer);stdcall;
  
  // ݼܡܻص
  BRAC_DataEncDec_CallBack=procedure(dwUserId:DWORD; dwFlags:DWORD; lpInBuf:PByte; dwInSize:DWORD; lpOutBuf:PByte; lpOutSize:Pointer; lpUserValue:Pointer);stdcall;

(**
 *	API
 *)

  // ȡSDK汾Ϣ
  function BRAC_GetSDKVersion(var dwMainVer:DWORD;var dwSubVer:DWORD;lpCompileTime:LPSTR;dwBufLen:DWORD):DWORD;cdecl;

  // رգSDK־
  function BRAC_ActiveCallLog(bActive:BOOL):DWORD;cdecl;
  
  // ÷֤루ֹǷûSDKӷϷûӣ
  function BRAC_SetServerAuthPass(lpPassword:LPCTSTR):DWORD;cdecl;

  // ʼϵͳ
  function BRAC_InitSDK(hWnd:HWND;dwFuncMode:DWORD):DWORD;cdecl;
  

  // Ƶݻص
  function BRAC_SetVideoDataCallBack(pixFmt:BRAC_PixelFormat;lpFunction:BRAC_VideoData_CallBack;lpUserValue:Pointer=nil):DWORD;cdecl;
  // Ƶݻص
  function BRAC_SetAudioDataCallBack(lpFunction:BRAC_AudioData_CallBack;lpUserValue:Pointer=nil):DWORD;cdecl;
  // Ϣص
  function BRAC_SetTextMessageCallBack(lpFunction:BRAC_TextMessage_CallBack;lpUserValue:Pointer=nil):DWORD;cdecl;
  // ͸ͨݻص
  function BRAC_SetTransBufferCallBack(lpFunction:BRAC_TransBuffer_CallBack;lpUserValue:Pointer=nil):DWORD;cdecl;
  // ͸ͨչص
  function BRAC_SetTransBufferExCallBack(lpFunction:BRAC_TransBufferEx_CallBack;lpUserValue:Pointer=nil):DWORD;cdecl;
  // ļص
  function BRAC_SetTransFileCallBack(lpFunction:BRAC_TransFile_CallBack;lpUserValue:Pointer=nil):DWORD;cdecl;
  // 仯ص
  function BRAC_SetVolumeChangeCallBack(lpFunction:BRAC_VolumeChange_CallBack;lpUserValue:Pointer=nil):DWORD;cdecl;
  // SDK Filterͨݻص
  function BRAC_SetSDKFilterDataCallBack(lpFunction:BRAC_SDKFilterData_CallBack;lpUserValue:Pointer=nil):DWORD;cdecl;
  // ¼֪ͨص
  function BRAC_SetRecordSnapShotCallBack(lpFunction:BRAC_RecordSnapShot_CallBack;lpUserValue:Pointer=nil):DWORD;cdecl;
  // 첽Ϣ֪ͨص
  function BRAC_SetNotifyMessageCallBack(lpFunction:BRAC_NotifyMessage_CallBack;lpUserValue:Pointer=nil):DWORD;cdecl;
  // ƵͨϢ֪ͨص
  function BRAC_SetVideoCallEventCallBack(lpFunction:BRAC_VideoCallEvent_CallBack; lpUserValue:Pointer=nil):DWORD;cdecl;
  // ݼܡܻص
  function BRAC_SetDataEncDecCallBack(lpFunction:BRAC_DataEncDec_CallBack; lpUserValue:Pointer=nil):DWORD;cdecl;


  // ӷ
  function BRAC_Connect(lpServerAddr:LPCTSTR;dwPort:DWORD):DWORD;cdecl;
  // ¼ϵͳ
  function BRAC_Login(lpUserName:LPCTSTR;lpPassword:LPCTSTR;dwPassEncType:DWORD):DWORD;cdecl;
  // 뷿
  function BRAC_EnterRoom(dwRoomid:DWORD;lpRoomPass:LPCTSTR;dwPassEncType:DWORD):DWORD;cdecl;
  // 뷿
  function BRAC_EnterRoomEx(lpRoomName:LPCTSTR;lpRoomPass:LPCTSTR):DWORD;cdecl;
  // 뿪
  function BRAC_LeaveRoom(dwRoomid:DWORD):DWORD;cdecl;
  // עϵͳ
  function BRAC_Logout():DWORD;cdecl;
  // ͷԴ
  function BRAC_Release():DWORD;cdecl;

  // ȡǰûб
  function BRAC_GetOnlineUser(lpUserIDArray:LPDWORD;var dwUserNum:DWORD):DWORD;cdecl;
  // ѯûͷ״̬
  function BRAC_GetCameraState(dwUserid:DWORD;var dwState:DWORD):DWORD;cdecl;
  // ѯû״̬
  function BRAC_GetSpeakState(dwUserid:DWORD;var dwState:DWORD):DWORD;cdecl;
  // ѯû
  function BRAC_GetUserLevel(dwUserid:DWORD;var dwLevel:DWORD):DWORD;cdecl;
  // ѯû
  function BRAC_GetUserName(dwUserid:DWORD;lpUserName:PChar;dwLen:DWORD):DWORD;cdecl;
  // ѯ
  function BRAC_GetRoomName(dwRoomId:DWORD;lpRoomName:PChar;dwLen:DWORD):DWORD;cdecl;  
  // ʾƵڶԻ
  function BRAC_ShowLVProperty(hParent:THandle;szCaption:LPCTSTR=nil;dwX:DWORD=0;dwY:DWORD=0):DWORD;cdecl;
  // ѯָû״̬
  function BRAC_QueryUserState(dwUserId:DWORD;infoname:Integer;infoval:Pointer;infolen:Integer):DWORD;cdecl;


  // öٱƵɼ豸
  function BRAC_EnumVideoCapture(lpDeviceName:PPChar;var dwDeviceNum:DWORD):DWORD;cdecl;
  // ѡָƵɼ豸
  function BRAC_SelectVideoCapture(szCaptureName:LPCTSTR):DWORD;cdecl;
  // ȡǰʹõƵɼ豸
  function BRAC_GetCurVideoCapture(lpDeviceName:PChar;dwLen:DWORD):DWORD;cdecl;
  // öٱƵɼ豸
  function BRAC_EnumAudioCapture(lpDeviceName:PPChar;var dwDeviceNum:DWORD):DWORD;cdecl;
  // ѡָƵɼ豸
  function BRAC_SelectAudioCapture(szCaptureName:LPCTSTR):DWORD;cdecl;
  // ȡǰʹõƵɼ豸
  function BRAC_GetCurAudioCapture(lpDeviceName:PChar;dwLen:DWORD):DWORD;cdecl;


  // ûƵ
  function BRAC_UserCameraControl(dwUserid:DWORD;bOpen:BOOL):DWORD;cdecl;
  // û
  function BRAC_UserSpeakControl(dwUserid:DWORD;bOpen:BOOL):DWORD;cdecl;
  // Ƶʾλ
  function BRAC_SetVideoPos(dwUserid:DWORD;hWnd:THandle;dwLeft:DWORD;dwTop:DWORD;dwRight:DWORD;dwBottom:DWORD):DWORD;cdecl;

  // ȡָƵ豸ĵǰ
  function BRAC_AudioGetVolume(device:BRAC_AudioDevice;var dwVolume:DWORD):DWORD;cdecl;
  // ָƵ豸
  function BRAC_AudioSetVolume(device:BRAC_AudioDevice;dwVolume:DWORD):DWORD;cdecl;

  // ûƵ¼
  function BRAC_StreamRecordCtrl(dwUserId:DWORD;bStartRecord:BOOL;dwFlags:DWORD;dwParam:DWORD):DWORD;cdecl;
  // ûƵץģգ
  function BRAC_SnapShot(dwUserId:DWORD;dwFlags:DWORD;dwParam:DWORD):DWORD;cdecl;
  

  // ͸ͨͻ
  function BRAC_TransBuffer(dwUserid:DWORD;lpBuf:PBYTE;dwLen:DWORD):DWORD;cdecl;
  // ͸ͨͻչ
  function BRAC_TransBufferEx(dwUserid:DWORD;lpBuf:PByte;dwLen:DWORD;wParam:DWORD;
    lParam:DWORD;dwFlags:DWORD;dwTaskId:PDWORD):DWORD;cdecl;
  // ļ
  function BRAC_TransFile(dwUserid:DWORD;lpLocalPathName:LPCTSTR;wParam:DWORD;
    lParam:DWORD;dwFlags:DWORD;dwTaskId:PDWORD):DWORD;cdecl;
  // ѯϢ
  function BRAC_QueryTransTaskInfo(dwUserid:DWORD;dwTaskId:DWORD;infoname:Integer;
    infoval:Pointer;infolen:Integer):DWORD;cdecl;
  // ȡ
  function BRAC_CancelTransTask(dwUserid:DWORD;dwTaskId:DWORD):DWORD;cdecl;
  // ıϢ
  function BRAC_SendTextMessage(dwUserid:DWORD;bSecret:BOOL;lpMsgBuf:LPCTSTR;
    dwLen:DWORD):DWORD;cdecl;
  // SDK Filter ͨ
  function BRAC_SendSDKFilterData(lpBuf:PByte;dwLen:DWORD):DWORD;cdecl;

  // ĵǰģʽ
  function BRAC_ChangeChatMode(dwChatMode:DWORD):DWORD;cdecl;
  // ȡָûǰģʽ
  function BRAC_GetUserChatMode(dwUserid:DWORD;var dwChatMode:DWORD):DWORD;cdecl;
  // Է˽ģԷ˽
  function BRAC_PrivateChatRequest(dwUserid:DWORD):DWORD;cdecl;
  // ظԷ˽
  function BRAC_PrivateChatEcho(dwUserid:DWORD;dwRequestid:DWORD;bAccept:BOOL):DWORD;cdecl;
  // ظԷ˽չԸ룩
  function BRAC_PrivateChatEchoEx(dwUserid:DWORD;dwRequestid:DWORD;dwErrorCode:DWORD):DWORD;cdecl;
  // ˳ĳû˽ģ߽ĳûԼ˽б
  function BRAC_PrivateChatExit(dwUserid:DWORD):DWORD;cdecl;
  // SDKں˲
  function  BRAC_SetSDKOption(optname:Integer;optval:Pointer;optlen:Integer):DWORD;cdecl;
  // SDKں˲״̬ѯ
  function BRAC_GetSDKOption(optname:Integer;optval:Pointer;optlen:Integer):DWORD;cdecl;  
  
  // Ƶ¼ƣ󡢻ظҶϵȣ
  function BRAC_VideoCallControl(dwEventType:DWORD; dwUserId:DWORD; dwErrorCode:DWORD; dwFlags:DWORD; dwParam:DWORD; lpUserStr:LPCTSTR):DWORD;cdecl;

implementation

  // ȡSDK汾Ϣ
  function BRAC_GetSDKVersion(var dwMainVer:DWORD;var dwSubVer:DWORD;lpCompileTime:LPSTR;dwBufLen:DWORD):DWORD;cdecl;
           external C_BRAnyChatCoreLibName name 'BRAC_GetSDKVersion';

  // رգSDK־
  function BRAC_ActiveCallLog(bActive:BOOL):DWORD;cdecl;
           external C_BRAnyChatCoreLibName name 'BRAC_ActiveCallLog';

  // ÷֤루ֹǷûSDKӷϷûӣ
  function BRAC_SetServerAuthPass(lpPassword:LPCTSTR):DWORD;cdecl;
           external C_BRAnyChatCoreLibName name 'BRAC_SetServerAuthPass';

  // ʼϵͳ
  function BRAC_InitSDK(hWnd:HWND;dwFuncMode:DWORD):DWORD;cdecl;
           external C_BRAnyChatCoreLibName name 'BRAC_InitSDK';
  // Ƶݻص
  function BRAC_SetVideoDataCallBack(pixFmt:BRAC_PixelFormat;lpFunction:BRAC_VideoData_CallBack;lpUserValue:Pointer=nil):DWORD;cdecl;
           external C_BRAnyChatCoreLibName name 'BRAC_SetVideoDataCallBack';
  // Ƶݻص
  function BRAC_SetAudioDataCallBack(lpFunction:BRAC_AudioData_CallBack;lpUserValue:Pointer=nil):DWORD;cdecl;
           external C_BRAnyChatCoreLibName name 'BRAC_SetAudioDataCallBack';
  // Ϣص
  function BRAC_SetTextMessageCallBack(lpFunction:BRAC_TextMessage_CallBack;lpUserValue:Pointer=nil):DWORD;cdecl;
           external C_BRAnyChatCoreLibName name 'BRAC_SetTextMessageCallBack';
  // ͸ͨݻص
  function BRAC_SetTransBufferCallBack(lpFunction:BRAC_TransBuffer_CallBack;lpUserValue:Pointer=nil):DWORD;cdecl;
           external C_BRAnyChatCoreLibName name 'BRAC_SetTransBufferCallBack';

  // ͸ͨչص
  function BRAC_SetTransBufferExCallBack(lpFunction:BRAC_TransBufferEx_CallBack;lpUserValue:Pointer=nil):DWORD;cdecl;
           external C_BRAnyChatCoreLibName name 'BRAC_SetTransBufferExCallBack';

  // ļص
  function BRAC_SetTransFileCallBack(lpFunction:BRAC_TransFile_CallBack;lpUserValue:Pointer=nil):DWORD;cdecl;
           external C_BRAnyChatCoreLibName name 'BRAC_SetTransFileCallBack';

  // 仯ص
  function BRAC_SetVolumeChangeCallBack(lpFunction:BRAC_VolumeChange_CallBack;lpUserValue:Pointer=nil):DWORD;cdecl;
           external C_BRAnyChatCoreLibName name 'BRAC_SetVolumeChangeCallBack';

  // SDK Filterͨݻص
  function BRAC_SetSDKFilterDataCallBack(lpFunction:BRAC_SDKFilterData_CallBack;lpUserValue:Pointer=nil):DWORD;cdecl;
           external C_BRAnyChatCoreLibName name 'BRAC_SetSDKFilterDataCallBack';

  // ¼֪ͨص
  function BRAC_SetRecordSnapShotCallBack(lpFunction:BRAC_RecordSnapShot_CallBack;lpUserValue:Pointer=nil):DWORD;cdecl;
           external C_BRAnyChatCoreLibName name 'BRAC_SetRecordSnapShotCallBack';

  // 첽Ϣ֪ͨص
  function BRAC_SetNotifyMessageCallBack(lpFunction:BRAC_NotifyMessage_CallBack;lpUserValue:Pointer=nil):DWORD;cdecl;
           external C_BRAnyChatCoreLibName name 'BRAC_SetNotifyMessageCallBack';

  // ƵͨϢ֪ͨص
  function BRAC_SetVideoCallEventCallBack(lpFunction:BRAC_VideoCallEvent_CallBack; lpUserValue:Pointer=nil):DWORD;cdecl;
			external C_BRAnyChatCoreLibName name 'BRAC_SetVideoCallEventCallBack';


  // ӷ
  function BRAC_Connect(lpServerAddr:LPCTSTR;dwPort:DWORD):DWORD;cdecl;
			external C_BRAnyChatCoreLibName name 'BRAC_Connect';
  // ¼ϵͳ
  function BRAC_Login(lpUserName:LPCTSTR;lpPassword:LPCTSTR;dwPassEncType:DWORD):DWORD;cdecl;
			external C_BRAnyChatCoreLibName name 'BRAC_Login';
  // 뷿
  function BRAC_EnterRoom(dwRoomid:DWORD;lpRoomPass:LPCTSTR;dwPassEncType:DWORD):DWORD;cdecl;
			external C_BRAnyChatCoreLibName name 'BRAC_EnterRoom';
  // 뷿
  function BRAC_EnterRoomEx(lpRoomName:LPCTSTR;lpRoomPass:LPCTSTR):DWORD;cdecl;
			external C_BRAnyChatCoreLibName name 'BRAC_EnterRoomEx';  
  // 뿪
  function BRAC_LeaveRoom(dwRoomid:DWORD):DWORD;cdecl;
			external C_BRAnyChatCoreLibName name 'BRAC_LeaveRoom';
  // עϵͳ
  function BRAC_Logout():DWORD;cdecl;
			external C_BRAnyChatCoreLibName name 'BRAC_Logout';
  // ͷԴ
  function BRAC_Release():DWORD;cdecl;
			external C_BRAnyChatCoreLibName name 'BRAC_Release';  

  // ȡǰûб
  function BRAC_GetOnlineUser(lpUserIDArray:LPDWORD;var dwUserNum:DWORD):DWORD;cdecl;
			external C_BRAnyChatCoreLibName name 'BRAC_GetOnlineUser';
  // ѯûͷ״̬
  function BRAC_GetCameraState(dwUserid:DWORD;var dwState:DWORD):DWORD;cdecl;
			external C_BRAnyChatCoreLibName name 'BRAC_GetCameraState'; 
  // ѯû״̬
  function BRAC_GetSpeakState(dwUserid:DWORD;var dwState:DWORD):DWORD;cdecl;
			external C_BRAnyChatCoreLibName name 'BRAC_GetSpeakState';
  // ѯû
  function BRAC_GetUserLevel(dwUserid:DWORD;var dwLevel:DWORD):DWORD;cdecl;
			external C_BRAnyChatCoreLibName name 'BRAC_GetUserLevel';
  // ѯû
  function BRAC_GetUserName(dwUserid:DWORD;lpUserName:PChar;dwLen:DWORD):DWORD;cdecl;
			external C_BRAnyChatCoreLibName name 'BRAC_GetUserName';
  // ѯ
  function BRAC_GetRoomName(dwRoomId:DWORD;lpRoomName:PChar;dwLen:DWORD):DWORD;cdecl;
			external C_BRAnyChatCoreLibName name 'BRAC_GetRoomName';  

  // ʾƵڶԻ
  function BRAC_ShowLVProperty(hParent:THandle;szCaption:LPCTSTR;dwX:DWORD;dwY:DWORD):DWORD;cdecl;
           external C_BRAnyChatCoreLibName name 'BRAC_ShowLVProperty';

  // ѯָû״̬
  function BRAC_QueryUserState(dwUserId:DWORD;infoname:Integer;infoval:Pointer;infolen:Integer):DWORD;cdecl;
           external C_BRAnyChatCoreLibName name 'BRAC_QueryUserState';             

  // öٱƵɼ豸
  function BRAC_EnumVideoCapture(lpDeviceName:PPChar;var dwDeviceNum:DWORD):DWORD;cdecl;
           external C_BRAnyChatCoreLibName name 'BRAC_EnumVideoCapture';
  // ѡָƵɼ豸
  function BRAC_SelectVideoCapture(szCaptureName:LPCTSTR):DWORD;cdecl;
           external C_BRAnyChatCoreLibName name 'BRAC_SelectVideoCapture';
  // ȡǰʹõƵɼ豸
  function BRAC_GetCurVideoCapture(lpDeviceName:PChar;dwLen:DWORD):DWORD;cdecl;
           external C_BRAnyChatCoreLibName name 'BRAC_GetCurVideoCapture';
  // öٱƵɼ豸
  function BRAC_EnumAudioCapture(lpDeviceName:PPChar;var dwDeviceNum:DWORD):DWORD;cdecl;
           external C_BRAnyChatCoreLibName name 'BRAC_EnumAudioCapture'; 
  // ѡָƵɼ豸
  function BRAC_SelectAudioCapture(szCaptureName:LPCTSTR):DWORD;cdecl;
           external C_BRAnyChatCoreLibName name 'BRAC_SelectAudioCapture'; 
  // ȡǰʹõƵɼ豸
  function BRAC_GetCurAudioCapture(lpDeviceName:PChar;dwLen:DWORD):DWORD;cdecl;
           external C_BRAnyChatCoreLibName name 'BRAC_GetCurAudioCapture';


  // ûƵ
  function BRAC_UserCameraControl(dwUserid:DWORD;bOpen:BOOL):DWORD;cdecl;
           external C_BRAnyChatCoreLibName name 'BRAC_UserCameraControl';
  // û
  function BRAC_UserSpeakControl(dwUserid:DWORD;bOpen:BOOL):DWORD;cdecl;
           external C_BRAnyChatCoreLibName name 'BRAC_UserSpeakControl';
  // Ƶʾλ
  function BRAC_SetVideoPos(dwUserid:DWORD;hWnd:THandle;dwLeft:DWORD;dwTop:DWORD;dwRight:DWORD;dwBottom:DWORD):DWORD;cdecl;
           external C_BRAnyChatCoreLibName name 'BRAC_SetVideoPos'; 

  // ȡָƵ豸ĵǰ
  function BRAC_AudioGetVolume(device:BRAC_AudioDevice;var dwVolume:DWORD):DWORD;cdecl;
           external C_BRAnyChatCoreLibName name 'BRAC_AudioGetVolume';
  // ָƵ豸
  function BRAC_AudioSetVolume(device:BRAC_AudioDevice;dwVolume:DWORD):DWORD;cdecl;
           external C_BRAnyChatCoreLibName name 'BRAC_AudioSetVolume';

  // ûƵ¼
  function BRAC_StreamRecordCtrl(dwUserId:DWORD;bStartRecord:BOOL;dwFlags:DWORD;dwParam:DWORD):DWORD;cdecl;
           external C_BRAnyChatCoreLibName name 'BRAC_StreamRecordCtrl';

  // ûƵץģգ
  function BRAC_SnapShot(dwUserId:DWORD;dwFlags:DWORD;dwParam:DWORD):DWORD;cdecl;
           external C_BRAnyChatCoreLibName name 'BRAC_SnapShot';                          

  // ͸ͨͻ
  function BRAC_TransBuffer(dwUserid:DWORD;lpBuf:PBYTE;dwLen:DWORD):DWORD;cdecl;
           external C_BRAnyChatCoreLibName name 'BRAC_TransBuffer';

  // ͸ͨͻչ
  function BRAC_TransBufferEx(dwUserid:DWORD;lpBuf:PByte;dwLen:DWORD;wParam:DWORD;
    lParam:DWORD;dwFlags:DWORD;dwTaskId:PDWORD):DWORD;cdecl;
           external C_BRAnyChatCoreLibName name 'BRAC_TransBufferEx';

  // ļ           
  function BRAC_TransFile(dwUserid:DWORD;lpLocalPathName:LPCTSTR;wParam:DWORD;
    lParam:DWORD;dwFlags:DWORD;dwTaskId:PDWORD):DWORD;cdecl;
           external C_BRAnyChatCoreLibName name 'BRAC_TransFile';

  // ѯϢ
  function BRAC_QueryTransTaskInfo(dwUserid:DWORD;dwTaskId:DWORD;infoname:Integer;
    infoval:Pointer;infolen:Integer):DWORD;cdecl;
           external C_BRAnyChatCoreLibName name 'BRAC_QueryTransTaskInfo';

  // ȡ
  function BRAC_CancelTransTask(dwUserid:DWORD;dwTaskId:DWORD):DWORD;cdecl;
           external C_BRAnyChatCoreLibName name 'BRAC_CancelTransTask';                                           

  // ıϢ
  function BRAC_SendTextMessage(dwUserid:DWORD;bSecret:BOOL;lpMsgBuf:LPCTSTR;dwLen:DWORD):DWORD;cdecl;
           external C_BRAnyChatCoreLibName name 'BRAC_SendTextMessage';

  // SDK Filter ͨ
  function BRAC_SendSDKFilterData(lpBuf:PByte;dwLen:DWORD):DWORD;cdecl;
           external C_BRAnyChatCoreLibName name 'BRAC_SendSDKFilterData';

  // ĵǰģʽ
  function BRAC_ChangeChatMode(dwChatMode:DWORD):DWORD;cdecl;
           external C_BRAnyChatCoreLibName name 'BRAC_ChangeChatMode';
  // ȡָûǰģʽ
  function BRAC_GetUserChatMode(dwUserid:DWORD;var dwChatMode:DWORD):DWORD;cdecl;
           external C_BRAnyChatCoreLibName name 'BRAC_GetUserChatMode';
  // Է˽ģԷ˽
  function BRAC_PrivateChatRequest(dwUserid:DWORD):DWORD;cdecl;
           external C_BRAnyChatCoreLibName name 'BRAC_PrivateChatRequest';
  // ظԷ˽
  function BRAC_PrivateChatEcho(dwUserid:DWORD;dwRequestid:DWORD;bAccept:BOOL):DWORD;cdecl;
           external C_BRAnyChatCoreLibName name 'BRAC_PrivateChatEcho';
  // ظԷ˽չԸ룩
  function BRAC_PrivateChatEchoEx(dwUserid:DWORD;dwRequestid:DWORD;dwErrorCode:DWORD):DWORD;cdecl;
           external C_BRAnyChatCoreLibName name 'BRAC_PrivateChatEchoEx';
  // ˳ĳû˽ģ߽ĳûԼ˽б
  function BRAC_PrivateChatExit(dwUserid:DWORD):DWORD;cdecl;
           external C_BRAnyChatCoreLibName name 'BRAC_PrivateChatExit';

  // SDKں˲
  function  BRAC_SetSDKOption(optname:Integer;optval:Pointer;optlen:Integer):DWORD;cdecl;
           external C_BRAnyChatCoreLibName name 'BRAC_SetSDKOption';

  // SDKں˲״̬ѯ
  function BRAC_GetSDKOption(optname:Integer;optval:Pointer;optlen:Integer):DWORD;cdecl;
           external C_BRAnyChatCoreLibName name 'BRAC_GetSDKOption';                          
            
  // Ƶ¼ƣ󡢻ظҶϵȣ
  function BRAC_VideoCallControl(dwEventType:DWORD; dwUserId:DWORD; dwErrorCode:DWORD; dwFlags:DWORD; dwParam:DWORD; lpUserStr:LPCTSTR):DWORD;cdecl;
			external C_BRAnyChatCoreLibName name 'BRAC_VideoCallControl';     


end.
