#if !defined(_ANYCHAT_DEFINE_H__INCLUDE_)
#define _ANYCHAT_DEFINE_H__INCLUDE_

/**
 *	AnyChat SDK Client Const Define Include File
 */


// Ƶͼʽ
enum BRAC_PixelFormat{
	BRAC_PIX_FMT_RGB24 = 0,						///< Packed RGB 8:8:8, 24bpp, RGBRGB...MEDIASUBTYPE_RGB24
	BRAC_PIX_FMT_RGB32,							///< ӦڣMEDIASUBTYPE_RGB32Packed RGB 8:8:8, 32bpp, (msb)8A 8R 8G 8B(lsb), in cpu endianness
	BRAC_PIX_FMT_YV12,							///< ӦڣMEDIASUBTYPE_YV12Planar YUV 4:2:0, 12bpp, (1 Cr & Cb sample per 2x2 Y samples)
	BRAC_PIX_FMT_YUY2,							///< ӦڣMEDIASUBTYPE_YUY2Packed YUV 4:2:2, 16bpp, Y0 Cb Y1 Cr
	BRAC_PIX_FMT_YUV420P,						///< Planar YUV 4:2:0, 12bpp, (1 Cr & Cb sample per 2x2 Y samples)
	BRAC_PIX_FMT_RGB565,						///< ӦڣMEDIASUBTYPE_RGB565
	BRAC_PIX_FMT_RGB555,						///< ӦڣMEDIASUBTYPE_RGB555
	BRAC_PIX_FMT_NV12,							///< Planar YUV 4:2:0, 12bpp, Two arrays, one is all Y, the other is U and V
	BRAC_PIX_FMT_NV21,							///< Planar YUV 4:2:0, 12bpp, Two arrays, one is all Y, the other is V and U
	BRAC_PIX_FMT_NV16,							///< YUV422SP
	BRAC_PIX_FMT_BGR32,
	
	BRAC_PIX_FMT_MJPEG = 200,
	BRAC_PIX_FMT_H264,
};

// Ƶ豸
enum BRAC_AudioDevice{
	BRAC_AD_WAVEIN = 0,							///< 豸Mic
	BRAC_AD_WAVEOUT,							///< 豸Wave
};

// Ƶʾ
enum BRAC_VideoShowDriver{
	BRAC_VSD_DEFAULT = 0,						///< Ĭʾ
	BRAC_VSD_DIRECTSHOW,						///< DirectShowʾ
	BRAC_VSD_WINDOWSGDI,						///< Windows GDI
};


// ģʽ壨APIBRAC_InitSDK 
#define BRAC_FUNC_VIDEO_CBDATA		0x00000001	///< ͨصƵ
#define BRAC_FUNC_VIDEO_AUTODISP	0x00000002	///< SDKƵƵʾָĴ
#define BRAC_FUNC_AUDIO_CBDATA		0x00000004	///< ͨصƵ
#define BRAC_FUNC_AUDIO_AUTOPLAY	0x00000008	///< SDKƵֱӲ
#define BRAC_FUNC_CONFIG_LOCALINI	0x00000010	///< ɱļAnyChatSDK.ini
#define BRAC_FUNC_FIREWALL_OPEN		0x00000020	///< SDKWindowsǽǰӦóǽбWindowsʾûǷֹǰӦó
#define BRAC_FUNC_CHKDEPENDMODULE	0x00000040	///< ԶSDKԶע
#define BRAC_FUNC_AUDIO_VOLUMECALC	0x00000080	///< SDKԶ
#define BRAC_FUNC_AUDIO_AUTOVOLUME	0x00000100	///< SDKԶMic¼
#define BRAC_FUNC_NET_SUPPORTUPNP	0x00000200	///< SDKûеUPNP豸û·Ƿǽ֧UPNPЭ飬P2P򶴵ĳɹ
#define BRAC_FUNC_DISABLEDECODE		0x00000400	///< ֹյݽнͲţΪߴͻ˵תܣøñ־øñ־
#define BRAC_FUNC_MAINTHREADCB		0x00000800	///< ߳̽лصĬǶ̻߳µݻص
#define BRAC_FUNC_AUDIO_FORBIDCFGHW	0x00001000	///< ֹ޸ƵӲ
#define BRAC_FUNC_CORE_FORBIDWINMSG	0x00002000	///< ֹʹwindowsϢѭ
#define BRAC_FUNC_AUDIO_LARGEBUFFER	0x00004000	///< Ƶ󻺳ģʽʺֲӦ
#define BRAC_FUNC_NET_LARGEDELAY	0x00010000	///< ӳģʽ绷
#define BRAC_FUNC_DISABLEVIDEODEC	0x00020000	///< ֹƵ
#define BRAC_FUNC_DISABLEAUDIODEC	0x00040000	///< ֹƵ


// ں˲壨APIBRAC_SetSDKOptionBRAC_GetSDKOption 
#define BRAC_SO_AUDIO_VADCTRL				1	///< ƵƣΪintͣ1򿪣0رգ
#define BRAC_SO_AUDIO_NSCTRL				2	///< ƵƿƣΪintͣ1򿪣0رգ
#define BRAC_SO_AUDIO_ECHOCTRL				3	///< ƵƣΪintͣ1򿪣0رգ
#define BRAC_SO_AUDIO_AGCCTRL				4	///< ƵԶƣΪintͣ1򿪣0رգ
#define BRAC_SO_AUDIO_CAPTUREMODE			5	///< ƵɼģʽãΪintͣ0 ģʽ1 Ÿģʽ2 OKģʽ3 ·ģʽ
#define BRAC_SO_AUDIO_MICBOOST				6	///< ƵɼMicǿƣΪintͣ0 ȡ1 ѡУ2 豸[ѯʱֵ]
#define BRAC_SO_AUDIO_AUTOPARAM				7	///< ƵɼģʽԶѡʵزʲȣΪintͣ1 ã0 ر[Ĭ]
#define BRAC_SO_AUDIO_MONOBITRATE			8	///< õģʽƵĿʣΪintͣλbps
#define BRAC_SO_AUDIO_STEREOBITRATE			9	///< ˫ģʽƵĿʣΪintͣλbps
#define BRAC_SO_AUDIO_PLAYDRVCTRL			70	///< Ƶѡ񣨲Ϊintͣ0Ĭ 1 DSound 2 WaveOut 3 Java[Androidƽ̨ʹ]
#define BRAC_SO_AUDIO_CNGCTRL				71	///< ɿƣΪintͣ1򿪣0رգ
#define BRAC_SO_AUDIO_CODECID				72	///< ƵIDãΪintͣ-1ʾĬϣõıIDڣں˻Ĭϵı
#define BRAC_SO_AUDIO_SOFTVOLMODE			73	///< ģʽƣΪintͣ1[Ĭ]0رգʹģʽıϵͳ
#define BRAC_SO_AUDIO_RECORDDRVCTRL			74	///< ƵɼƣΪintͣ0Ĭ 1 DSound 2 WaveIn 3 Javaɼ[Androidƽ̨ʹ]
#define BRAC_SO_AUDIO_ECHODELAY				75	///< ƵӳٲãΪintͣλms
#define BRAC_SO_AUDIO_NSLEVEL				76	///< ƵˮƽãΪintͣ0 - 3ĬΪ2ֵԽˮƽԽߣԽǿ
#define BRAC_SO_AUDIO_CBCODEC				77	///< ƵݻصͣΪintͣ
#define BRAC_SO_AUDIO_ECHOLEVEL				78	///< ƵˮƽãΪintͣ0 - 4ĬΪ4ֵԽԽǿ
#define BRAC_SO_AUDIO_PLAYCAPTURE			79	///< ƵŲɼãΪintͣ0 ر[Ĭ]1 

#define BRAC_SO_RECORD_VIDEOBR				10	///< ¼ƵãΪintͣλbps
#define BRAC_SO_RECORD_AUDIOBR				11	///< ¼ƵãΪintͣλbps
#define BRAC_SO_RECORD_TMPDIR				12	///< ¼ļʱĿ¼ãΪַTCHARͣľ·
#define BRAC_SO_SNAPSHOT_TMPDIR				13	///< ļʱĿ¼ãΪַTCHARͣľ·
#define BRAC_SO_RECORD_FILETYPE				140	///< ¼ļãΪintͣ 0 MP4[Ĭ], 1 WMV, 2 FLV, 3 MP3
#define BRAC_SO_RECORD_WIDTH				141	///< ¼ƵãΪintͣ磺320
#define BRAC_SO_RECORD_HEIGHT				142	///< ¼ļ߶ãΪintͣ磺240
#define BRAC_SO_RECORD_FILENAMERULE			143	///< ¼ļ򣨲Ϊintͣ
#define BRAC_SO_RECORD_CLIPMODE				144	///< ¼ƵüģʽΪintͣ
#define BRAC_SO_RECORD_DISABLEDATEDIR		145	///< ¼ļڷĿ¼棬ȫָļУΪintͣ 0ֹ[Ĭ] 1 
#define BRAC_SO_RECORD_INSERTIMAGE			146	///< ¼ƹвͼƬJsonַ

#define BRAC_SO_CORESDK_TMPDIR				14	///< AnyChat Core SDKʱĿ¼ΪַTCHARͣľ·
#define BRAC_SO_CORESDK_MAGICADJUST			15	///< ں˵Բ
#define BRAC_SO_CORESDK_LOADCODEC			16	///< ⲿΪַTCHARͣľ·ļļľ·
#define BRAC_SO_CORESDK_USEARMV6LIB			17	///< ǿʹARMv6ָĿ⣬androidƽ̨ʹãΪintͣ1ʹARMv6ָ 0ںԶж[Ĭ]
#define BRAC_SO_CORESDK_USEHWCODEC			18	///< ʹƽ̨ӲΪintͣ0 ʹӲ[Ĭ]  1 ʹӲ
#define BRAC_SO_CORESDK_REMOTEDEBUG			19	///< Զ̵ԣΪintͣʾĿûIDòΪͲ

#define BRAC_SO_CORESDK_PATH				20	///< AnyChat Core SDK·ΪַTCHARͣľ·
#define BRAC_SO_CORESDK_DUMPCOREINFO		21	///< ںϢ־ļУڷԭ򣨲Ϊintͣ1 
#define BRAC_SO_CORESDK_MAINVERSION			22	///< ѯSDK汾źţΪintͣ
#define BRAC_SO_CORESDK_SUBVERSION			23	///< ѯSDKӰ汾ţΪintͣ
#define BRAC_SO_CORESDK_BUILDTIME			24	///< ѯSDKʱ䣨ΪַTCHARͣ
#define BRAC_SO_CORESDK_ACTIVESTATE			25	///< Ӧó״̬ƣΪintͣ 1 Ӧóڻ״̬ 0 Ӧóڷǻ״̬iPhone豸ɺ̨еĳ
#define BRAC_SO_CORESDK_EXTVIDEOINPUT		26	///< ⲿչƵƣΪintͣ 0 رⲿƵ[Ĭ] 1 ⲿƵ룩
#define BRAC_SO_CORESDK_EXTAUDIOINPUT		27	///< ⲿչƵƣΪintͣ 0 رⲿƵ[Ĭ] 1 ⲿƵ룩
#define BRAC_SO_CORESDK_LOWDELAYCTRL		28	///< ӳģʽƣΪintͣ0 رյӳģʽ[Ĭ] 1 õӳģʽ
#define BRAC_SO_CORESDK_NEWGUID				29	///< µGUIDַ

#define BRAC_SO_LOCALVIDEO_BITRATECTRL		30	///< ƵãΪintͣλbpsͬãVideoBitrate
#define BRAC_SO_LOCALVIDEO_QUALITYCTRL		31	///< ƵӿƣΪintͣͬãVideoQuality
#define BRAC_SO_LOCALVIDEO_GOPCTRL			32	///< Ƶؼ֡ƣΪintͣͬãVideoGOPSize
#define BRAC_SO_LOCALVIDEO_FPSCTRL			33	///< Ƶ֡ʿƣΪintͣͬãVideoFps
#define BRAC_SO_LOCALVIDEO_PRESETCTRL		34	///< ƵԤƣΪintͣ1-5
#define BRAC_SO_LOCALVIDEO_APPLYPARAM		35	///< ӦñƵʹǰ޸ļʱЧΪintͣ1 ʹ²0 ʹĬϲ
#define BRAC_SO_LOCALVIDEO_VIDEOSIZEPOLITIC	36	///< ƵɼֱʿƲԣΪintͣ0 Զƥ[Ĭ]1 ʹòɼ豸ĬϷֱʣõķֱʲɼ豸֧ʱЧ
#define BRAC_SO_LOCALVIDEO_DEINTERLACE		37	///< Ƶ֯ƣΪintͣ 0 з֯[Ĭ]1 ֯ƵԴǸɨԴźţʱͨ֯߻
#define BRAC_SO_LOCALVIDEO_WIDTHCTRL		38	///< ƵɼֱʿȿƣΪintͣͬãVideoWidth
#define BRAC_SO_LOCALVIDEO_HEIGHTCTRL		39	///< Ƶɼֱʸ߶ȿƣΪintͣͬãVideoHeight
#define BRAC_SO_LOCALVIDEO_FOCUSCTRL		90	///< ƵͷԽƣΪintͣ1ʾԶԽ 0ʾֶԽ
#define BRAC_SO_LOCALVIDEO_PIXFMTCTRL		91	///< ƵɼȸʽƣΪintͣ-1ʾƥ䣬ȲָʽοBRAC_PixelFormat
#define BRAC_SO_LOCALVIDEO_OVERLAY			92	///< ƵOverlayģʽΪintͣ1ʾOverlayģʽ 0ʾͨģʽ[Ĭ]
#define BRAC_SO_LOCALVIDEO_CODECID			93	///< ƵIDãΪintͣ-1ʾĬϣõıIDڣں˻Ĭϵı
#define BRAC_SO_LOCALVIDEO_ROTATECTRL		94	///< ƵתƣʧЧʹãBRAC_SO_LOCALVIDEO_CAMERAROTATION
#define BRAC_SO_LOCALVIDEO_CAPDRIVER		95	///< ƵɼãΪintͣ0ʾԶѡ[Ĭ] 1 Video4Linux, 2 DirectShow, 3 Javaɼ[Androidƽ̨ʹ]
#define BRAC_SO_LOCALVIDEO_FIXCOLORDEVIA	96	///< ƵɼɫƫɫΪintͣ0ʾر[Ĭ]1 
#define BRAC_SO_LOCALVIDEO_ORIENTATION		97	///< Ƶ豸򣨲ΪintͣΪANYCHAT_DEVICEORIENTATION_XXXX
#define BRAC_SO_LOCALVIDEO_AUTOROTATION		98	///< ƵԶתƣΪintͣ 0ʾرգ 1 [Ĭ]ƵתʱҪοƵ豸
#define BRAC_SO_LOCALVIDEO_SURFACEROTATION	99	///< ñƵԤʾתǶȣΪintͣǶȣ
#define BRAC_SO_LOCALVIDEO_CAMERAFACE		100	///< ͷǰáã
#define BRAC_SO_LOCALVIDEO_CAMERAROTATION	101	///< ͷתǶ
#define BRAC_SO_LOCALVIDEO_DEVICEROTATION	102	///< 豸תǶ
#define BRAC_SO_LOCALVIDEO_DEVICEMODE		103	///< 豸
#define BRAC_SO_LOCALVIDEO_TVFORMAT			104	///< ƵɼʽãΪintͣΪDirectShow::strmif.h::AnalogVideoStandardĬΪAnalogVideo_PAL_B
#define BRAC_SO_LOCALVIDEO_OVERLAYTIMESTAMP	105	///< ʱƵΪintͣ 0 [Ĭ] 1 ӣ
#define BRAC_SO_LOCALVIDEO_DEVICENAME		106	///< Ƶɼ豸ƣôָͷ豸Ϊַͣ
#define BRAC_SO_LOCALVIDEO_CLIPMODE			107	///< ƵüģʽΪintͣ 0 Զ[Ĭ]ֹԶתʱЧ
#define BRAC_SO_LOCALVIDEO_SCREENHWND		108	///< Ļɼھ
#define BRAC_SO_LOCALVIDEO_SCREENFLAGS		109	///< Ļɼ־Ϊintͣ
#define BRAC_SO_LOCALVIDEO_VIRTUALBK		111 ///< ƵⱳַͣJSONʽⱳ·ԼΪNULLʾȡⱳ
#define BRAC_SO_LOCALVIDEO_VIDEOCOLOR		112	///< ƵɫƣַͣΪJSON

#define BRAC_SO_NETWORK_P2PPOLITIC			40	///< P2PԿƣΪintͣ0 ֹP2P1 P2P[Ĭ]2 ϲӦÿP2Pӣ3 轨P2Pӣ
#define BRAC_SO_NETWORK_P2PCONNECT			41	///< ָûP2PӣΪintͣʾĿûIDӽɹ󣬻ͨϢϲӦãP2PƲ=2ʱЧ
#define BRAC_SO_NETWORK_P2PBREAK			42	///< ϿָûP2PӣΪintͣʾĿûID[ݲ֧֣]
#define BRAC_SO_NETWORK_TCPSERVICEPORT		43	///< ñTCP˿ڣΪintͣӷ֮ǰЧ
#define BRAC_SO_NETWORK_UDPSERVICEPORT		44	///< ñUDP˿ڣΪintͣӷ֮ǰЧ
#define BRAC_SO_NETWORK_MULTICASTPOLITIC	45	///< 鲥ԿƣΪintͣΪBRAC_MCPOLITIC_XXXX
#define BRAC_SO_NETWORK_TRANSBUFMAXBITRATE	46	///< 仺ļʿƣΪintͣ0 ƣʴ[Ĭ] ʾʣλΪbps
#define BRAC_SO_NETWORK_AUTORECONNECT		47	///< ԶܿƣΪintͣ0 رգ 1 [Ĭ]
#define BRAC_SO_NETWORK_MTUSIZE				48	///< MTUСΪintͣ
#define BRAC_SO_NETWORK_UDPSTATUS			49	///< UDPͨ״̬ѯΪintͣ
#define BRAC_SO_NETWORK_LARGEDELAY			53	///< ӳģʽ绷Ϊintͣ
#define BRAC_SO_NETWORK_IPV6DNS				54	///< IPv6ƣΪintͣ0 رգ 1[Ĭ]ͳ磨IPv4£IPv6ٶ

#define BRAC_SO_PROXY_FUNCTIONCTRL			50	///< ûܿƣΪintͣ10رմ[Ĭ]
#define BRAC_SO_PROXY_VIDEOCTRL				51	///< ûƵƣƵΪָûƵⷢΪintͣʾûuserid
#define BRAC_SO_PROXY_AUDIOCTRL				52	///< ûƵƣƵΪָûƵⷢͬBRAC_SO_PROXY_VIDEOCTRL

#define BRAC_SO_STREAM_MAXBUFFERTIME		60	///< ʱ䣨Ϊintͣλ룬ȡֵΧ500 ~ 5000Ĭϣ800ģʽֵģʽԶһ
#define BRAC_SO_STREAM_SMOOTHPLAYMODE		61	///< ƽģʽΪintͣ0 ر[Ĭ], 1 򿪣״̬Ƶ֡ʱţܳˣῨס

#define BRAC_SO_VIDEOSHOW_MODECTRL			80	///< ƵʾģʽƣΪintͣ0 ʾ1 Ƶʾ
#define BRAC_SO_VIDEOSHOW_SETPRIMARYUSER	81	///< ʾûţΪintͣûIDţ
#define BRAC_SO_VIDEOSHOW_SETOVERLAYUSER	82	///< õʾûţΪintͣûIDţ
#define BRAC_SO_VIDEOSHOW_DRIVERCTRL		83	///< ƵʾƣΪintͣ0 Ĭ 1 Windows DirectShow2 Windows GDI3 SDL, 4 Android2X, 5 Android Java
#define BRAC_SO_VIDEOSHOW_GPUDIRECTRENDER	84	///< ƵݾGPUֱȾƵֱӴ䵽GPUַΪintͣ 0 ر[Ĭ] 1 򿪣Ӳƽ̨
#define BRAC_SO_VIDEOSHOW_AUTOROTATION		85	///< ԶƵʾԶתƣΪintͣ 0ʾرգ 1 [Ĭ]ƵתʱҪοƵ豸
#define BRAC_SO_VIDEOSHOW_CLIPMODE			86	///< ԶƵʾתüģʽΪintͣ 0 Զ[Ĭ]
#define BRAC_SO_VIDEOSHOW_CBPIXFMT			87	///< ƵݻصʽΪintͣ

#define BRAC_SO_CORESDK_TICKOUTUSER			110	///< ӷߵָûΪintͣʾĿûID

#define BRAC_SO_CORESDK_DEVICEMODE			130	///< 豸ģʽƣ豸֮ԻͨţΪintͣ0 ر[Ĭ]1 
#define BRAC_SO_CORESDK_SCREENCAMERACTRL	131	///< 湲ܿƣΪintͣ 0 ر[Ĭ] 1 
#define BRAC_SO_CORESDK_DATAENCRYPTION		132	///< ݼܿƣΪintͣ 0 ر[Ĭ] 1 
#define BRAC_SO_CORESDK_MEDIAUTILLIB		133	///< ȡbrMediaUtil.dllĿؾ
#define BRAC_SO_CORESDK_UPLOADLOGINFO		134	///< ϴ־ϢΪintͣ0 ر[Ĭ] 1 
#define BRAC_SO_CORESDK_WRITELOG			135	///< дϢͻ־ļ
#define BRAC_SO_CORESDK_NEWLOGFILE			136	///< µ־ļ
#define BRAC_SO_CORESDK_SUPPORTSIP			137	///< жϵǰǷ֧SIPͨ
#define BRAC_SO_CORESDK_SUPPORTHTML5		138	///< жϵǰǷ֧HTML5
#define BRAC_SO_CORESDK_DISABLELOGFILE		139	///< ֹɱ־ļ
#define BRAC_SO_CORESDK_SUPPORTVIDEOCODEC	210	///< ֵ֧Ƶ
#define BRAC_SO_CORESDK_SUPPORTAUDIOCODEC	211	///< ֵ֧Ƶ
#define BRAC_SO_CORESDK_DISABLEMEDIACONSUL	212	///< ֹýЭ
#define BRAC_SO_CORESDK_QUERYTIMEOUTTIME	213	///< Ϣѯʱʱ䣨ΪintͣλmsĬֵ1000
#define BRAC_SO_CORESDK_REMOTEASSISTHWND	214	///< ԶЭھ
#define BRAC_SO_CORESDK_REMOTEASSISTXPOS	215	///< ԶЭڹλãX
#define BRAC_SO_CORESDK_REMOTEASSISTYPOS	216	///< ԶЭڹλãY
#define BRAC_SO_CORESDK_FITTENCENTLIVE		217	///< ѶƵֱSDK
#define BRAC_SO_CORESDK_DFCFLIVE			218
#define BRAC_SO_CORESDK_DISABLEDNSCONNECT	219	///< DNSѰַ
#define BRAC_SO_CORESDK_LOGFILEROOTPATH		220	///< ־ļ·־ض򣬲Ϊַ·
#define BRAC_SO_CORESDK_LOGFILERULE			221	///< ͻ־ļ򣨲Ϊintͣ0 Զ[Ĭ] 1 ڱ棬ǣ
#define BRAC_SO_CORESDK_FILEENCANDDEC		222	///< ļӽܿƣΪַͣJSONʽ
#define BRAC_SO_CORESDK_PPTHELPERINIT		223	///< PPTʼ
#define BRAC_SO_CORESDK_PPTFILECTRL			224	///< PPTļ
#define BRAC_SO_CORESDK_CBMEDIASTREAM		225	///< صԭʼƵ
#define BRAC_SO_CORESDK_CBVIDEOSTREAM		226	///< صԭʼƵ
#define BRAC_SO_CORESDK_CBAUDIOSTREAM		227 ///< صԭʼƵ
#define BRAC_SO_CORESDK_STREAMADAPTIVE		228	///< ýӦƣΪintͣ0 ر 1 [Ĭ]
#define BRAC_SO_CORESDK_MAXTRANSFILESIZE	229	///< ļСΪintͣλMByte
#define BRAC_SO_CORESDK_USESERVERTIME		230	///< ʹ÷ʱΪintͣ0 ر[Ĭ] 1 
#define BRAC_SO_CORESDK_APPMONITORLIST		231	///< ӦóбӦóģʹãΪַ
#define BRAC_SO_CORESDK_SSLCERTCHAIN		232	///< SSL֤
#define BRAC_SO_CORESDK_SETUSERAPPINFO		236	///< ûAPPϢ
#define BRAC_SO_CORESDK_LASTERRORCODE		237	///< ȡĳ

#define BRAC_SO_UDPTRACE_MODE				160 ///< UDPݰģʽ
#define BRAC_SO_UDPTRACE_PACKSIZE			161	///< UDPݰٵĴСλBYTE
#define BRAC_SO_UDPTRACE_BITRATE			162	///< UDPݰٵİʣλbps
#define BRAC_SO_UDPTRACE_START				163	///< UDPݰٿƣΪintͣ1  0 ֹͣ
#define BRAC_SO_UDPTRACE_LOCALRECVNUM		164 ///< UDPݰٱؽհ
#define BRAC_SO_UDPTRACE_SERVERRECVNUM		165	///< UDPݰٷհ
#define BRAC_SO_UDPTRACE_SOURCESENDNUM		166	///< UDPݰԴ
#define BRAC_SO_UDPTRACE_SENDUSERID			167	///< UDPݰԴûID
#define BRAC_SO_UDPTRACE_NETDELAY			168	///< UDPݰӳ٣λms-1ʾδ֪

// ûý壨APIBRAC_GetUserStreamInfo 
#define BRAC_STREAMINFO_VIDEOWIDTH			180 ///< Ƶ
#define BRAC_STREAMINFO_VIDEOHEIGHT			181	///< Ƶ߶
#define BRAC_STREAMINFO_VIDEOFPS			182	///< Ƶ֡
#define BRAC_STREAMINFO_VIDEOBITRATE		183	///< Ƶʣλbps
#define BRAC_STREAMINFO_VIDEOCODECID		184	///< ƵID
#define BRAC_STREAMINFO_VIDEOPACKLOSSRATE	185	///< Ƶ
#define BRAC_STREAMINFO_VIDEODEVICENAME		186	///< Ƶɼ豸
#define BRAC_STREAMINFO_AUDIOCHANNELS		190	///< Ƶͨ
#define BRAC_STREAMINFO_AUDIOSAMPLERATE		191	///< Ƶ
#define BRAC_STREAMINFO_AUDIOBITRATE		192	///< Ƶʣλbps
#define BRAC_STREAMINFO_AUDIOCODECID		193	///< ƵID
#define BRAC_STREAMINFO_AUDIOPACKLOSSRATE	194	///< Ƶ
#define BRAC_STREAMINFO_AUDIODEVICENAME		195	///< Ƶɼ豸


#define BRAC_SO_OBJECT_INITFLAGS			200	///< ҵݳʼ

#define BRAC_SO_CLOUD_APPGUID				300	///< ƽ̨ӦGUIDΪַͣӷ֮ǰã
#define BRAC_SO_CLOUD_ACCTYPE				301	///< ƽ̨Ӧü˺
#define BRAC_SO_CLOUD_APPID3RD				302	///< ƽ̨Ӧüʱƽ̨ӦGUID


// Ϣ壨APIBRAC_QueryTransTaskInfo 
#define BRAC_TRANSTASK_PROGRESS				1	///< ȲѯΪDWORDֵͣ0 ~ 100
#define BRAC_TRANSTASK_BITRATE				2	///< ǰʣΪDWORDͣλbps
#define BRAC_TRANSTASK_STATUS				3	///< ǰ״̬ΪDWORDͣ
#define BRAC_TRANSTASK_SAVEASPATH			4	///< ļΪ·ãļΪַTCHARͣ
#define BRAC_TRANSTASK_SOURCEFILE			5	///< Դļ·ΪַTCHARͣ
#define BRAC_TRANSTASK_JSONSTATUS			6	///< ״̬Jsonַ

// ¼ܱ־壨APIBRAC_StreamRecordCtrl 
#define BRAC_RECORD_FLAGS_VIDEO			0x00000001	///< ¼Ƶ
#define BRAC_RECORD_FLAGS_AUDIO			0x00000002	///< ¼Ƶ
#define BRAC_RECORD_FLAGS_SERVER		0x00000004	///< ¼
#define BRAC_RECORD_FLAGS_MIXAUDIO		0x00000010	///< ¼Ƶʱ˵¼
#define BRAC_RECORD_FLAGS_MIXVIDEO		0x00000020	///< ¼Ƶʱ˵ƵӺ¼
#define BRAC_RECORD_FLAGS_ABREAST		0x00000100	///< ¼Ƶʱ˵Ƶ¼
#define BRAC_RECORD_FLAGS_STEREO		0x00000200	///< ¼Ƶʱ˵Ϊ¼
#define BRAC_RECORD_FLAGS_SNAPSHOT		0x00000400	///< 
#define BRAC_RECORD_FLAGS_LOCALCB		0x00000800	///< ػص
#define BRAC_RECORD_FLAGS_STREAM		0x00001000	///< Ƶ¼ƣЧʸߣ
#define BRAC_RECORD_FLAGS_USERFILENAME	0x00002000	///< ûԶļ


// ͻˡ¼Ʊ־屣ͳһ
#if !defined(ANYCHAT_RECORD_FLAGS_VIDEO)
#define ANYCHAT_RECORD_FLAGS_VIDEO			BRAC_RECORD_FLAGS_VIDEO
#define ANYCHAT_RECORD_FLAGS_AUDIO			BRAC_RECORD_FLAGS_AUDIO
#define ANYCHAT_RECORD_FLAGS_SERVER			BRAC_RECORD_FLAGS_SERVER
#define ANYCHAT_RECORD_FLAGS_MIXAUDIO		BRAC_RECORD_FLAGS_MIXAUDIO
#define ANYCHAT_RECORD_FLAGS_MIXVIDEO		BRAC_RECORD_FLAGS_MIXVIDEO
#define ANYCHAT_RECORD_FLAGS_ABREAST		BRAC_RECORD_FLAGS_ABREAST
#define ANYCHAT_RECORD_FLAGS_STEREO			BRAC_RECORD_FLAGS_STEREO
#define ANYCHAT_RECORD_FLAGS_SNAPSHOT		BRAC_RECORD_FLAGS_SNAPSHOT
#define ANYCHAT_RECORD_FLAGS_LOCALCB		BRAC_RECORD_FLAGS_LOCALCB
#define ANYCHAT_RECORD_FLAGS_STREAM			BRAC_RECORD_FLAGS_STREAM
#define ANYCHAT_RECORD_FLAGS_USERFILENAME	BRAC_RECORD_FLAGS_USERFILENAME
#define ANYCHAT_RECORD_FLAGS_ERRORCODE		0x00004000	///< ֳ֧
#define ANYCHAT_RECORD_FLAGS_MULTISTREAM	0x00008000	///< ֶ֧·¼ƣգ
#define ANYCHAT_RECORD_FLAGS_CANCEL			0x00010000	///< ȡ¼ɾ¼ļ
#define ANYCHAT_RECORD_FLAGS_BUFFERCB		0x00020000	///< ݻص
#define ANYCHAT_RECORD_FLAGS_FILEMD5		0x00040000	///< ¼ļMD5ֵ
#endif


// 鲥Զ
#define BRAC_MCPOLITIC_DISABLE				0	///< ִз·ɲԣֹ鲥[Ĭ]
#define BRAC_MCPOLITIC_ONLYLOCALMC			1	///< Է·ɲԣֻͻ˱鲥㲥ý
#define BRAC_MCPOLITIC_SERVERANDLOCALMC		2	///< ִз·ɲԣͬʱڿͻ˱ط鲥
#define BRAC_MCPOLITIC_ONLYSERVERMC			3	///< Է·ɲԣֻ鲥㲥ý
#define BRAC_MCPOLITIC_SERVERANDSERVERMC	4	///< ִз·ɲԣͬʱڷ˷鲥

// 鲥ܱ־
#define BRAC_MCFLAGS_JOINGROUP		0x00000001	///< ಥ
#define BRAC_MCFLAGS_LEAVEGROUP		0x00000002	///< 뿪ಥ
#define BRAC_MCFLAGS_SENDDATA		0x00000010	///< ݷͱ־ָʾöಥڷ
#define BRAC_MCFLAGS_RECVDATA		0x00000020	///< ݽձ־ָʾöಥڽ


// û״̬־壨APIBRAC_QueryUserState 
#define BRAC_USERSTATE_CAMERA				1	///< ûͷ״̬ΪDWORDͣ
#define BRAC_USERSTATE_HOLDMIC				2	///< ûƵ豸״̬ΪDWORDֵͣ0 Ƶɼرգ 1 Ƶɼ
#define BRAC_USERSTATE_SPEAKVOLUME			3	///< ûǰ˵ΪDWORDͣ0 ~ 100
#define BRAC_USERSTATE_RECORDING			4	///< û¼״̬ΪDWORDͣ
#define	BRAC_USERSTATE_LEVEL				5	///< û𣨲ΪDWORDͣ
#define BRAC_USERSTATE_NICKNAME				6	///< ûǳƣΪַTCHARͣ
#define BRAC_USERSTATE_LOCALIP				7	///< ûIPַΪַTCHARͣ
#define BRAC_USERSTATE_INTERNETIP			8	///< ûIPַΪַTCHARͣ
#define BRAC_USERSTATE_VIDEOBITRATE			9	///< ûǰƵʣΪDWORDͣBps
#define BRAC_USERSTATE_AUDIOBITRATE			10	///< ûǰƵʣΪDWORDͣBps
#define BRAC_USERSTATE_P2PCONNECT			11	///< ѯûָûĵǰP2P״̬ΪDWORDֵͣ0 P2Pͨ 1 P2Pӳɹ[TCP]2 P2Pӳɹ[UDP]3 P2Pӳɹ[TCPUDP]
#define BRAC_USERSTATE_NETWORKSTATUS		12	///< ѯָû״̬ΪDWORDֵͣ0 1 Ϻã2 һ㣬3 ϲ4 ǳ
#define BRAC_USERSTATE_VIDEOSIZE			13	///< ѯָûƵֱʣΪDWORDֵͣ16λʾȣ16λʾ߶ȣ
#define BRAC_USERSTATE_PACKLOSSRATE			14	///< ѯָûýݶʣΪDWORDֵͣ0 - 100磺ֵΪ5ʾΪ5%
#define BRAC_USERSTATE_DEVICETYPE			15	///< ѯָûնͣΪDWORDֵͣ0 Unknow1 Windows2 Android3 iOS4 Web5 Linux6 Mac7 Win Phone8 WinCE
#define BRAC_USERSTATE_SELFUSERSTATUS		16	///< ѯûĵǰ״̬ΪDWORDֵͣ0 Unknow1 Connected2 Logined3 In Room4 Logouted5 Link Closed
#define BRAC_USERSTATE_SELFUSERID			17	///< ѯûIDΪDWORDͣû¼ɹûʵʵuserid򷵻-1
#define BRAC_USERSTATE_VIDEOROTATION		18	///< ѯָûĵǰƵתǶȣΪDWORDͣؽǶֵ
#define BRAC_USERSTATE_VIDEOMIRRORED		19	///< ѯָûƵǷҪת
#define BRAC_USERSTATE_AUDIOCODECID			20	///< ѯָûƵID
#define BRAC_USERSTATE_VIDEOCODECID			21	///< ѯָûƵID
#define BRAC_USERSTATE_RESENDLOSSRATE		22	///< ĶʣΪDWORDֵͣ0 - 100磺ֵΪ5ʾΪ5%

// ״̬־壨APIBRAC_QueryRoomState 
#define BRAC_ROOMSTATE_ROOMNAME				1	///< ƣΪַTCHARͣ
#define BRAC_ROOMSTATE_ONLINEUSERS			2	///< ûΪDWORDͣԼ

// Ƶ¼Ͷ壨APIBRAC_VideoCallControl VideoCallEventص
#define BRAC_VIDEOCALL_EVENT_REQUEST		1	///< 
#define BRAC_VIDEOCALL_EVENT_REPLY			2	///< ظ
#define BRAC_VIDEOCALL_EVENT_START			3	///< ƵлỰʼ¼
#define BRAC_VIDEOCALL_EVENT_FINISH			4	///< ҶϣлỰ

// Ƶб־壨APIBRAC_VideoCallControl 
#define BRAC_VIDEOCALL_FLAGS_AUDIO		0x0001	///< ͨ
#define BRAC_VIDEOCALL_FLAGS_VIDEO		0x0002	///< Ƶͨ
#define BRAC_VIDEOCALL_FLAGS_FBSRCAUDIO	0x0010	///< ֹԴжˣƵ
#define BRAC_VIDEOCALL_FLAGS_FBSRCVIDEO	0x0020	///< ֹԴжˣƵ
#define BRAC_VIDEOCALL_FLAGS_FBTARAUDIO	0x0040	///< ֹĿ꣨жˣƵ
#define BRAC_VIDEOCALL_FLAGS_FBTARVIDEO	0x0080	///< ֹĿ꣨жˣƵ
#define BRAC_VIDEOCALL_FLAGS_ASSISTREQ	0x0100	///< ĿûԶЭ
#define BRAC_VIDEOCALL_FLAGS_CONTROLREQ	0x0200	///< Ŀû

// ԶƵ־
#define BRAC_ROTATION_FLAGS_MIRRORED	0x1000	///< ͼҪת
#define BRAC_ROTATION_FLAGS_ROTATION90	0x2000	///< ˳ʱת90
#define BRAC_ROTATION_FLAGS_ROTATION180	0x4000	///< ˳ʱת180
#define BRAC_ROTATION_FLAGS_ROTATION270	0x8000	///< ˳ʱת270

// ûϢͶ壨APIBRAC_UserInfoControl 
#define BRAC_USERINFO_CTRLCODE_ROTATION		8	///< ָûƵʾʱתwParamΪתǶȲ
#define BRAC_USERINFO_CTRLCODE_DEBUGLOG		9	///< ûĵ־wParamΪ־ͣlParamΪǷ
#define BRAC_USERINFO_CTRLCODE_LVORIENTFIX	10	///< ƵɼwParamΪlParamΪǶ

// ݼӣ⣩ܱ־壨DataEncDecص
#define BRAC_DATAENCDEC_FLAGS_ENCMODE	0x01	///< ģʽ
#define BRAC_DATAENCDEC_FLAGS_DECMODE	0x02	///< ģʽ
#define BRAC_DATAENCDEC_FLAGS_AUDIO		0x10	///< Ƶ
#define BRAC_DATAENCDEC_FLAGS_VIDEO		0x20	///< Ƶ
#define BRAC_DATAENCDEC_FLAGS_BUFFER	0x40	///< ͸ͨ
#define BRAC_DATAENCDEC_FLAGS_TXTMSG	0x80	///< 

// صͶ壨APIBRAC_SetCallBack 
#define BRAC_CBTYPE_NOTIFYMESSAGE			1	///< 첽Ϣ֪ͨص
#define BRAC_CBTYPE_VIDEODATA				2	///< Ƶݻص
#define BRAC_CBTYPE_VIDEODATAEX				3	///< Ƶչص
#define BRAC_CBTYPE_AUDIODATA				4	///< Ƶݻص
#define BRAC_CBTYPE_AUDIODATAEX				5	///< Ƶչص
#define BRAC_CBTYPE_TEXTMESSAGE				6	///< Ϣص
#define BRAC_CBTYPE_TRANSBUFFER				7	///< ͸ͨݻص
#define BRAC_CBTYPE_TRANSBUFFEREX			8	///< ͸ͨչص
#define BRAC_CBTYPE_TRANSFILE				9	///< ļص
#define BRAC_CBTYPE_VOLUMECHANGE			10	///< 仯ص
#define BRAC_CBTYPE_SDKFILTERDATA			11	///< SDK Filterͨݻص
#define BRAC_CBTYPE_STREAMRECORD			12	///< ¼֪ͨص
#define BRAC_CBTYPE_STREAMRECORDEX			13	///< ¼֪ͨչص
#define BRAC_CBTYPE_VIDEOCALLEVENT			14	///< ƵͨϢ֪ͨص
#define BRAC_CBTYPE_DATAENCDEC				15	///< ݼܡܻص
#define BRAC_CBTYPE_SCREENEVENT				16	///< Ļ¼ص
#define BRAC_CBTYPE_NETWORKDATASEND			17	///< ݻص
#define BRAC_CBTYPE_OBJECTEVENT				18	///< ҵ¼֪ͨ
#define BRAC_CBTYPE_VIDEODATAEX2			19	///< Ƶչصֶ֧·
#define BRAC_CBTYPE_AUDIODATAEX2			20	///< Ƶչصֶ֧·
#define BRAC_CBTYPE_STREAMRECORDEX2			21	///< ¼֪ͨչصֳ֧룩
#define BRAC_CBTYPE_TRANSFILEEX				22	///< ļչصֳ֧룩
#define BRAC_CBTYPE_CORESDKEVENT			23	///< Core SDK¼صJsonʽ
#define BRAC_CBTYPE_CORESDKDATA				24	///< Core SDKݻص


// Ƶüģʽ
#define ANYCHAT_VIDEOCLIPMODE_UNKNOW		-1	///< δ֪ģʽҪüʱʹ
#define ANYCHAT_VIDEOCLIPMODE_AUTO			0	///< ĬģʽвüȻ죬汣ֱüϴ
#define ANYCHAT_VIDEOCLIPMODE_OVERLAP		1	///< صģʽֻȡЧ֣ԱԵвü
#define ANYCHAT_VIDEOCLIPMODE_SHRINK		2	///< СģʽСʵıвü
#define ANYCHAT_VIDEOCLIPMODE_STRETCH		3	///< ƽģʽвüܵ»治ɱ
#define ANYCHAT_VIDEOCLIPMODE_DYNAMIC		4	///< ̬ģʽϲӦøݷֱʾ棬ֻ治


// Ϣѯ壨APIBRAC_QueryInfoFromServer 
#define ANYCHAT_SERVERQUERY_USERIDBYNAME	1	///< ûǳƲѯûID
#define ANYCHAT_SERVERQUERY_USERIDBYSTRID	2	///< ַIDѯûID
#define ANYCHAT_SERVERQUERY_STRIDBYUSERID	3	///< ûIDѯַID
#define ANYCHAT_SERVERQUERY_NAMEBYUSERID	4	///< ûIDѯû
#define ANYCHAT_SERVERQUERY_NAMEBYSTRID		5	///< ַIDѯû
#define ANYCHAT_SERVERQUERY_USERINFOBYID	6	///< ûIDѯûϢ
#define ANYCHAT_SERVERQUERY_PPTFILEINFO		10	///< PPTļϢ
#define ANYCHAT_SERVERQUERY_QUEUEAGENTINFO	100	///< ѯָеϯϢ
#define ANYCHAT_SERVERQUERY_RUNNINGSTATUS	200	///< ѯ״̬
#define ANYCHAT_SERVERQUERY_ONLINEUSERS		201	///< ѯû

// ⲿƵ־
#define ANYCHAT_INPUTMEDIAFLAGS_STREAM		0x01	///< 
#define ANYCHAT_INPUTMEDIAFLAGS_KEYFRAME	0x02	///< ؼ֡
#define ANYCHAT_INPUTMEDIAFLAGS_ROTATION	0x04	///< ϳƵ־
#define ANYCHAT_INPUTMEDIAFLAGS_MIXRECORD	0x08	///< кϳ¼


// SDKƳ壨APIBRAC_SDKControl 
#define ANYCHAT_SDKCTRL_BASE				1	///< ܿ
#define ANYCHAT_SDKCTRL_SERVER				2	///< ͨ
#define ANYCHAT_SDKCTRL_USERBUFFER			3	///< û
#define ANYCHAT_SDKCTRL_INVOKEEVENT			4	///< 첽¼
#define ANYCHAT_SDKCTRL_RECORD				5	///< Ƶ¼
#define ANYCHAT_SDKCTRL_OBJECT				20	///< 
#define ANYCHAT_SDKCTRL_VIDEOCALL			30	///< п
#define ANYCHAT_SDKCTRL_USERINFO			40	///< ûϢ
#define ANYCHAT_SDKCTRL_STREAMPLAY			50	///< ý岥
#define ANYCHAT_SDKCTRL_MEDIAPROCESS		51	///< ý崦
#define ANYCHAT_SDKCTRL_NETWORK				60	///< 
#define ANYCHAT_SDKCTRL_MEDIA				70	///< ý
#define ANYCHAT_SDKCTRL_RECORDTAG			71	///< ¼ǩ
#define ANYCHAT_SDKCTRL_SCREENCAPPARAM		72	///< Ļɼ
#define ANYCHAT_SDKCTRL_FILEDELETE			80	///< ɾļ
#define ANYCHAT_SDKCTRL_FILEINFO			81	///< ȡļϢ
#define ANYCHAT_SDKCTRL_DISKSIZE			82	///< ȡ
#define ANYCHAT_SDKCTRL_FILEENCRYPT			83	///< ļӽܿ
#define ANYCHAT_SDKCTRL_DELETEDIR			84	///< ɾĿ¼
#define ANYCHAT_SDKCTRL_CREATEDIR			85	///< Ŀ¼
#define ANYCHAT_SDKCTRL_DIRCLEAN			86	///< Ŀ¼
#define ANYCHAT_SDKCTRL_FINDFILE			87	///< ļ
#define ANYCHAT_SDKCTRL_PPTHELPERINIT		90	///< PPTʼ
#define ANYCHAT_SDKCTRL_PPTFILECTRL			91	///< PPTļ
#define ANYCHAT_SDKCTRL_PPTFILEINFO			92	///< PPTļϢ
#define ANYCHAT_SDKCTRL_BUSINESS			95	///< ҵ
#define ANYCHAT_SDKCTRL_MEDIAFILTERINIT		96	///< ýʼ
#define ANYCHAT_SDKCTRL_VIDEODEVICEINFO		97	///< ȡƵɼ豸Ϣ
#define ANYCHAT_SDKCTRL_UPDATERECUSERSTR	98	///< ¼û
#define ANYCHAT_SDKCTRL_SYNCRECORD			99	///< ͬ¼
#define ANYCHAT_SDKCTRL_BUSINESSBUFFER		100	///< ҵ񻺳
#define ANYCHAT_SDKCTRL_LIVESTREAM			101	///< ֱҵ
#define ANYCHAT_SDKCTRL_AIABILITY			102	///< AI
#define ANYCHAT_SDKCTRL_APPBUFFER			103	///< APPԶ建
#define ANYCHAT_SDKCTRL_FACEEMOTIONCTRL		300	///< ΢


// ý岥¼Ͷ
#define ANYCHAT_STREAMPLAY_EVENT_START		3	///< ſʼ¼
#define ANYCHAT_STREAMPLAY_EVENT_FINISH		4	///< Ž¼

// ý岥ű־壨APIBRAC_StreamPlayInit 
#define ANYCHAT_STREAMPLAY_FLAGS_REPLACEAUDIOINPUT	0x00000001	///< Ƶ汾Ƶ루Mic
#define ANYCHAT_STREAMPLAY_FLAGS_REPLACEVIDEOINPUT	0x00000002	///< Ƶ汾Ƶ루Camera
#define ANYCHAT_STREAMPLAY_FLAGS_CALLBACKDATA		0x00000010	///< صݸϲ
#define ANYCHAT_STREAMPLAY_FLAGS_PPTPLAY			0x00000080	///< ˫¼սʾPPT

// ý岥ϢͶ壨APIBRAC_StreamPlayGetInfo 
#define ANYCHAT_STREAMPLAY_INFO_JSONVALUE	1	///< вϢJsonַ

// ý岥ſͶ壨APIBRAC_StreamPlayControl 
#define ANYCHAT_STREAMPLAY_CTRL_START		1	///< ʼ
#define ANYCHAT_STREAMPLAY_CTRL_PAUSE		2	///< ͣ
#define ANYCHAT_STREAMPLAY_CTRL_STOP		3	///< ֹͣ
#define ANYCHAT_STREAMPLAY_CTRL_SEEK		4	///< λ϶
#define ANYCHAT_STREAMPLAY_CTRL_SPEEDCTRL	5	///< ٶȵ
#define ANYCHAT_STREAMPLAY_CTRL_OPENLOOP	6	///< ѭ
#define ANYCHAT_STREAMPLAY_CTRL_CLOSELOOP	7	///< رѭ


// CoreSDK¼Ͷ壨صBRAC_CoreSDKEvent_CallBack
#define ANYCHAT_CORESDKEVENT_BASEEVENT		1	///< SDK¼
#define ANYCHAT_CORESDKEVENT_CONNECTHOLD	2	///< ӱ¼
#define ANYCHAT_CORESDKEVENT_CAMERASTATE	10	///< ͷ״̬¼
#define ANYCHAT_CORESDKEVENT_MICSTATE		11	///< Mic״̬¼
#define ANYCHAT_CORESDKEVENT_TRANSFILE		12	///< ļ¼
#define ANYCHAT_CORESDKEVENT_RECORDSTATUS	13	///< ¼״̬¼
#define ANYCHAT_CORESDKEVENT_STREAMPLAY		30	///< ý岥¼
#define ANYCHAT_CORESDKEVENT_PPTHELPER		31	///< PPTHelper¼
#define ANYCHAT_CORESDKEVENT_BUSINESS		32	///< ҵ¼
#define ANYCHAT_CORESDKEVENT_DEVICEFAIL		33	///< 豸ʧ¼
#define ANYCHAT_CORESDKEVENT_MEDIABUFFER	34	///< ý建¼
#define ANYCHAT_CORESDKEVENT_USERBUFFER		35	///< û¼
#define ANYCHAT_CORESDKEVENT_MEDIAPROCESS	36	///< ý崦¼
#define ANYCHAT_CORESDKEVENT_FACEEMOTION	40	///< ΢
#define ANYCHAT_CORESDKEVENT_REGEDITDATA	41	///< ݽӿڷ
#define ANYCHAT_CORESDKEVENT_REQUESTEX		42	///< չ󷵻
#define ANYCHAT_CORESDKEVENT_BUSINESSBUFFER	100	///< ҵ񻺳¼
#define ANYCHAT_CORESDKEVENT_LIVESTREAM		101	///< ֱҵ¼
#define ANYCHAT_CORESDKEVENT_AIABILITY		102	///< AI¼
#define ANYCHAT_CORESDKEVENT_APPBUFFER		103	///< APPԶ建¼
#define ANYCHAT_CORESDKEVENT_USERDEFINE		800	///< ûԶ¼ʼ

// CoreSDKصͶ壨صBRAC_CoreSDKData_CallBack
#define ANYCHAT_CORESDKDATA_AUDIO			1	///< Ƶ
#define ANYCHAT_CORESDKDATA_VIDEO			2	///< Ƶ
#define ANYCHAT_CORESDKDATA_MESSAGE			3	///< 
#define ANYCHAT_CORESDKDATA_BUFFER			4	///< 


#endif //_ANYCHAT_DEFINE_H__INCLUDE_
