// BRAnyChatMeetingDlg.h : header file
//

#if !defined(AFX_BRANYCHATMEETINGDLG_H__C55CF205_B790_49C7_B91F_6035C8EFC030__INCLUDED_)
#define AFX_BRANYCHATMEETINGDLG_H__C55CF205_B790_49C7_B91F_6035C8EFC030__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "LoginDlg.h"
#include "hallDlg.h"
#include "VideoPanelDlg.h"
#include "SettingsDlg.h"
#include <BRAnyChatSDKProc.h>

class CLoginDlg;
class CHallDlg;
class CVideoPanelDlg;
class CSettingsDlg;

class CBRAnyChatMeetingDlg : public CDialog,
							 public CBRAnyChatSDKProc
{
// Construction
public:
	CBRAnyChatMeetingDlg(CWnd* pParent = NULL);	// standard constructor


public:
	CLoginDlg*	m_pLoginDlg;			///< ¼Ի
	CHallDlg*	m_pHallDlg;				///< Ի
	CSettingsDlg*	m_pSettingsDlg;		///< ߼öԻ

	CVideoPanelDlg*	m_pSelfVideoDlg;	///< ƵԻ
	CVideoPanelDlg*	m_pPanelObjectArray[MAX_VIDEOPANEL_NUM];		///< ûƵʾ


	DWORD		m_dwSelfUserId;			///< Լû

private:
	CImageList	m_UserStateImageList;	///< û״̬ͼ
	CString		m_strTextOutput;		///< Ϣ
	CPicture	m_LogoPic;				///< LogoͼƬ

private:
	// ʼAnyChat SDK
	void InitAnyChatSDK(void);
	// ʼûбؼ
	void InitUserListCtrl(void);
	// ˢûʾ
	void RefreshOnlineUserNum(void);
	// ˢָб״̬
	void RefreshListItemState(DWORD dwItemNo, DWORD dwUserId);
	// µûб
	void AddNewUserToList(DWORD dwUserId);

	// ݷλƵʾλ
	void RelocateVideoPanel(DWORD dwSplitNum);
	// ˢƵʾ
	void RefreshVideoPanel(void);
	// ȡһеʾ
	DWORD GetEmptyVideoPanelIndex(void);
	// жָûƵǷʾ
	BOOL IsUserVideoPanelShow(DWORD dwUserId);
	// ûƵ
	void BindUserAndVideoPanel(DWORD dwUserId, CVideoPanelDlg* lpVideoPanelDlg);
	// ȡƵûİ
	void CleanVideoPanelBind(CVideoPanelDlg* lpVideoPanelDlg, BOOL bErase=TRUE);

	// ϢϢ
	void InsertStringToTextOutput(CString strMsg);

public:
	// ûرϵͳ
	void OnUserExitSystem(void);


protected:		// CBRAnyChatSDKProc麯

	// ӷϢ
	virtual void OnAnyChatConnectMessage(BOOL bSuccess, DWORD dwErrorCode);
	// û½Ϣ
	virtual void OnAnyChatLoginMessage(DWORD dwUserId, DWORD dwErrorCode);
	// û뷿Ϣ
	virtual void OnAnyChatEnterRoomMessage(DWORD dwRoomId, DWORD dwErrorCode);
	// ûϢ
	virtual void OnAnyChatOnlineUserMessage(DWORD dwUserNum, DWORD dwRoomId);
	// ûõ/ͷmicϢ
	virtual void OnAnyChatMicStateChgMessage(DWORD dwUserId, BOOL bGetMic);
	// û/˳Ϣ
	virtual void OnAnyChatUserAtRoomMessage(DWORD dwUserId, BOOL bEnter);
	//ϿϢ
	virtual void OnAnyChatLinkCloseMessage(DWORD dwReason, DWORD dwErrorCode);
	
	// ûͷ״̬ıϢ
	virtual void OnAnyChatCameraStateChgMessage(DWORD dwUserId, DWORD dwState);
	// ûģʽıϢ
	virtual void OnAnyChatChatModeChgMessage(DWORD dwUserId, BOOL bPublicChat);
	// û״̬仯Ϣ
	virtual void OnAnyChatActiveStateChgMessage(DWORD dwUserId, DWORD dwState);
	// P2P״̬仯Ϣ
	virtual void OnAnyChatP2PConnectStateMessage(DWORD dwUserId, DWORD dwState);
	// ûƵֱʸıϢ
	virtual void OnAnyChatVideoSizeChgMessage(DWORD dwUserId, DWORD dwWidth, DWORD dwHeight);
	
	// û˽Ϣ
	virtual void OnAnyChatPrivateRequestMessage(DWORD dwUserId, DWORD dwRequestId);
	// û˽ظϢ
	virtual void OnAnyChatPrivateEchoMessage(DWORD dwUserId, DWORD dwErrorCode);
	// û˳˽Ϣ
	virtual void OnAnyChatPrivateExitMessage(DWORD dwUserId, DWORD dwErrorCode);
	
	// SDKϢ
	virtual void OnAnyChatSDKWarningMessage(DWORD dwErrorCode, DWORD dwReserved);
	
	// Ƶݻص
	virtual void OnAnyChatVideoDataCallBack(DWORD dwUserid, LPVOID lpBuf, DWORD dwLen, LPBITMAPINFOHEADER lpbmiHeader);
	// Ƶݻص
	virtual void OnAnyChatAudioDataCallBack(DWORD dwUserid, LPVOID lpBuf, DWORD dwLen, LPWAVEFORMATEX lpWaveFormatEx);
	// ֵĻص
	virtual void OnAnyChatTextMsgCallBack(DWORD dwFromUserid, DWORD dwToUserid, BOOL bSecret, LPCTSTR lpMsgBuf, DWORD dwLen);
	// ͸ͨص
	virtual void OnAnyChatTransBufferCallBack(DWORD dwUserid, LPBYTE lpBuf, DWORD dwLen);
	// ͸ͨչص
	virtual void OnAnyChatTransBufferExCallBack(DWORD dwUserid, LPBYTE lpBuf, DWORD dwLen, DWORD wParam, DWORD lParam, DWORD dwTaskId);
	// ļص
	virtual void OnAnyChatTransFileCallBack(DWORD dwUserid, LPCTSTR lpFileName, LPCTSTR lpTempFilePath, DWORD dwFileLength, DWORD wParam, DWORD lParam, DWORD dwTaskId);
	// 仯ص
	virtual void OnAnyChatVolumeChangeCallBack(BRAC_AudioDevice device, DWORD dwCurrentVolume);
	// SDK Filter ͨݻص
	virtual void OnAnyChatSDKFilterDataCallBack(LPBYTE lpBuf, DWORD dwLen);
	// ¼񡢿ɻص
	virtual void OnAnyChatRecordSnapShotCallBack(DWORD dwUserid, LPCTSTR lpFileName, DWORD dwParam, BOOL bRecordType);
	// 첽Ϣ֪ͨص
	virtual void OnAnyChatNotifyMessageCallBack(DWORD dwNotifyMsg, DWORD wParam, DWORD lParam);


// Dialog Data
	//{{AFX_DATA(CBRAnyChatMeetingDlg)
	enum { IDD = IDD_DIALOG_MEETING };
	CEdit	m_ctrlTextOutput;
	CComboBox	m_ctrlDispNumCombo;
	CListCtrl	m_ctrlUserList;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CBRAnyChatMeetingDlg)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CBRAnyChatMeetingDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnDestroy();
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnClose();
	afx_msg void OnSelchangeComboDispNum();
	afx_msg void OnDblclkListUser(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnButtonSendText();
	afx_msg void OnButtonAdvSet();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_BRANYCHATMEETINGDLG_H__C55CF205_B790_49C7_B91F_6035C8EFC030__INCLUDED_)
