#ifndef _SKINPPWTL_H_
#define _SKINPPWTL_H_

#ifdef _SKINPP_STATIC
	#define SKINPPWTL_API
#else
	#ifdef SKINPPWTL_EXPORTS
		#define SKINPPWTL_API __declspec(dllexport)
	#else
		#define SKINPPWTL_API __declspec(dllimport)
	#endif
#endif

#define WM_TOOLBARPAINTPRE (WM_USER + 802)
#define WM_TOOLBARPAINTEND (WM_USER + 803)

#define SM_LBUTTONUP (WM_USER + 804)

//ť״̬
enum BUTTONSTATE 
{
	NORMAL	= 0,
	PRESS	= 1,
	DISABLE	= 2,
	HOT		= 3,
	FOCUS   = 4,
	LAST	= 5
};

//
enum DRAWTYPE
{
	BUTTON = 0,
	SCROLLARROWUP = 1,
	SCROLLARROWDOWN = 2,
	SPLITTERBARHORZ = 3,
	SPLITTERBARVERT = 4,
	SPLITTERBARBORDER = 5,
	LISTHEAD = 6
};

//ƤԴ
enum SKINOBJTYPE
{
	DIALOGTYPE = 0,
	BUTTONTYPE = 1,
	CHECKBOXTYPE = 2,
	RADIOBOXTYPE = 3,
	STATICTYPE = 4,
	TRACKBARTYPE = 5,
};

struct ListBoxItem
{
	HIMAGELIST	hImageList;
	int			nImageIndex;

	ListBoxItem()
	{
		hImageList = NULL;
		nImageIndex = -1;
	}
};

#define REST_BITMAP      0x0001 //.bmp
#define REST_ICON        0x0002 //.ico
#define REST_CURSOR      0x0003 //.cur
#define REST_ANIMATE	 0x0004 //.ani

typedef struct _ResourceInfo
{
	HGDIOBJ hGdiObj;//[OUT]
	DWORD   dwType; //[OUT]
	int		nWidth; //[OUT]
	int		nHeight;//[OUT]

	TCHAR	szResImageName[_MAX_FNAME];//[IN]
	BOOL	bHorzSplit;//[IN]
	int		nLength;//[IN]
	int		nCount; //[IN]
	int		nIndex; //[IN]
	
	_ResourceInfo()
	{
		hGdiObj = NULL;
		dwType = REST_BITMAP;
		nWidth = 0;
		nHeight = 0;

		_tcscpy(szResImageName,_T(""));
		bHorzSplit = TRUE;
		nLength = -1;
		nCount = -1;
		nIndex = -1;
	}
	
}ResInfo,* PRESINFO;

//////////////////////////////////////////////////////////////////////////

//Ƥ
//SkinFile		:Ƥ·,ע*.ssk,ҲƤĿ¼еINIļ.
//bFromIni		:òָƤļǴ*.sskȡ,ǴINIļȡ.
SKINPPWTL_API BOOL  skinppLoadSkin(char* szSkinFile,BOOL bFromIni = FALSE);
//SKINPPWTL_API BOOL  skinppLoadSkin(TCHAR* szSkinFile,BOOL bFromIni = FALSE);

SKINPPWTL_API BOOL skinppLoadSkinFromRes(HINSTANCE hInstance,LPCTSTR szResourceName,
										 LPCTSTR szResourceType,TCHAR* szSkinFileName);

//ƳƤ
SKINPPWTL_API BOOL  skinppRemoveSkin();

//˳⣬
SKINPPWTL_API BOOL  skinppExitSkin();

//ListBoxؼԻϢ
//hWnd			: ListBoxؼľ
//nIndex		: Item
//pListBoxItem	: ItemԻĽṹϢ
SKINPPWTL_API void skinppSetListBoxItemDrawInfo(HWND hWnd,int nIndex,struct ListBoxItem* pListBoxItem);

//ûϵͳɫ
//nColorIndex	: Ҫȡɫ
SKINPPWTL_API COLORREF skinppGetSkinSysColor(int nColorIndex);

//WindowsϵͳĬϵɫ
//nColorIndex	: Ҫȡɫ
SKINPPWTL_API COLORREF skinppGetDefaultSysColor(int nColorIndex);

//hWnd			: Ի򴰿ڵľ
//nResID		: ԻԴID
SKINPPWTL_API BOOL skinppSetWindowResID(HWND hWnd,int nResID);//[]

SKINPPWTL_API BOOL skinppSetFreeDlgID(HWND hWnd,int nResID);

SKINPPWTL_API BOOL skinppSetSkinResID(HWND hWnd,int nResID);

//ListHeaderڵϢ
//hWnd			: ListHeaderĴھ
//nSortColumn	: ҪListHeaderе
//bSortAscending: ǷΪ
SKINPPWTL_API void skinppSetListHeaderSortInfo(HWND hWnd,int nSortColumn,BOOL bSortAscending = TRUE);

//ڸHDC,ָӦĻͺ״̬,Ӧľнл.
//hdc			:ĿDC
//rect			:
//eDrawType		:ͣĿǰ֧SPLITTERBARHORZ,SPLITTERBARVERT,SPLITTERBARBORDER
//nState		:ѡ״̬
SKINPPWTL_API void  skinppDrawSkinObject(HDC hdc,RECT rect,DRAWTYPE eDrawType,int nState);

//ͨԴID,Ӧ͵ƤԴλͼ
//nSkinObjType	: Ƥ,Ŀǰ֧	DIALOGTYPE,BUTTONTYPE,CHECKBOXTYPE,RADIOBOXTYPE
//nResID		: ԴID
//nState		: ״̬,BUTTONTYPE,CHECKBOXTYPE,RADIOBOXTYPEЧ
SKINPPWTL_API HBITMAP skinppGetResFromID(SKINOBJTYPE nSkinObjType,int nResID,int nState =0 );

//ǷԼԻ򱳾,÷ҪԼԱд.
//hWnd			: Իľ
//bErase		: TRUE ΪԼ,FALSE ΪSkin++,ûеø÷,Skin++Ի򱳾.
SKINPPWTL_API void skinppSetDialogEraseBkgnd(HWND hWnd,BOOL bErase);

//öԻ򱳾Ƿӿؼ
//hWnd			: Ի
//bNoClip		: TRUEΪҪ,FALSEΪҪ
//bAllChild		: TRUEΪôӶԻ򶼼.
SKINPPWTL_API void skinppSetDialogBkClipRgn(HWND hWnd,BOOL bClip,BOOL bAllChild = TRUE);

//ͨƤԴƻƤԴλͼ
//szName		: ƤԴ
//HBITMAP		: Դеλͼ
SKINPPWTL_API HBITMAP skinppGetBitmapRes(LPCTSTR szName);

//ͨԴȡԴڴָ
//szName		: Դ
//nSize			: ԴС
//pByte			: ֵɹطNULLʧܷNULL
SKINPPWTL_API BYTE*  skinppGetSkinResource(LPCTSTR szName,int& nSize);

//ͨƤԴƻλͼֵ
//szName		: ƤԴ
//nTopHeight	: زĶ
//nBottomHeight : زĵ׸
//nLeftWidth	: ز
//nRightWidth	: زҿ
SKINPPWTL_API BOOL skinppGetBitmapResRect(LPCTSTR szName,int& nTopHeight,int& nBottomHeight,
												   int& nLeftWidth,int& nRightWidth);

//ôԻǷԼ,÷ԻҪԼ
//hWnd			: ҪԻĴھ
//bCustomDraw	: TRUEΪԼԻ,FALSEΪSkin++Ի
SKINPPWTL_API void skinppSetCustomDraw(HWND hWnd,BOOL bCustomDraw);

//ò˵Ƥʶ
//hWnd			: ӵв˵Ĵھ
//nSkinObjectID	: ˵Ƥıʶ
SKINPPWTL_API void skinppSetMenuSkinObjectID(HWND hWnd,int nSkinObjectID);

//ǷԻ˵л
//bSkin			: TRUEΪ
SKINPPWTL_API void skinppSetSkinOwnerMenu(BOOL bSkin);

//Բ˵л
//hMenu   : 뻻Ĳ˵
//bNoSkin : Ƿ񻻷,TRUEΪ,FALSEΪ
SKINPPWTL_API void  skinppSetDrawMenu(HMENU hMenu,BOOL bNoSkin);
	
//ָĴȥƤ,ұ֤ٱ,ʹʹSetSkinHwndҲỻ.
//hWnd			: ָĴھ
//bChildNoSkin	: ǷԸôеӴȥƤ
SKINPPWTL_API void skinppSetNoSkinHwnd(HWND hWnd,BOOL bChildNoSkin = TRUE);

//ָĴڽл
//hWnd			: ָĴھ
//szClassName	: Ҫ໯Skin WC_DIALOGBOX/WC_CONTROLBAR
SKINPPWTL_API void skinppSetSkinHwnd(HWND hWnd,LPCTSTR szClassName = NULL);

//ָĴʱȥƤ,ͨSetSkinHwndٴλ
SKINPPWTL_API void skinppRemoveSkinHwnd(HWND hWnd);

//ǶSetNoSkinHwndĽһ,ԽʹSetNoSkinHwndDebugĶԴ
#define SETNOSKINHWND(x) {\
    HWND w=(x).UnsubclassWindow();\
	skinppSetNoSkinHwnd(w);\
	(x).SubclassWindow(w);\
} 

//ǶRemoveSkinHwndĽһ,ԽʹRemoveSkinHwndDebugĶԴ
#define REMOVESKINHWND(x){\
    HWND w=(x).UnsubclassWindow();\
	skinppRemoveSkinHwnd(w);\
	(x).SubclassWindow(w);\
}

SKINPPWTL_API HGDIOBJ skinppGetResFromID(PRESINFO pResInfo);


#endif //_SKINPPWTL_H_

