/*
 * Decompiled with CFR 0.152.
 */
package com.bairuitech.server;

import com.bairuitech.anychat.AnyChatServerEvent;
import com.bairuitech.anychat.AnyChatServerSDK;
import com.bairuitech.anychat.AnyChatVerifyUserOutParam;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

public class SampleServer
implements AnyChatServerEvent {
    public static AnyChatServerSDK anychat;
    public static int iUserIdSeed;
    public static boolean bShowActionLog;
    public static ArrayList<Integer> onlineusers;

    static {
        iUserIdSeed = 1;
        bShowActionLog = true;
        onlineusers = new ArrayList();
    }

    public static void main(String[] args) throws InterruptedException, IOException {
        char c;
        anychat = new AnyChatServerSDK();
        anychat.SetServerEvent(new SampleServer());
        anychat.InitSDK(0);
        anychat.RegisterVerifyUserClass(new AnyChatVerifyUserOutParam());
        System.out.print(String.valueOf(SampleServer.getCurrentTime()) + "Welcome use AnyChat! (" + anychat.GetSDKVersion() + ")\r\n");
        InputStreamReader reader = new InputStreamReader(System.in);
        int ch = 0;
        do {
            if (ch == 100) {
                bShowActionLog = !bShowActionLog;
            } else if (ch != 13) {
                System.out.print(String.valueOf(SampleServer.getCurrentTime()) + "Business server(Java) still running, press 'q' to exit...(Online users: " + onlineusers.size() + ")\r\n");
            }
            Thread.sleep(100L);
            c = (char)((Reader)reader).read();
            ch = c;
        } while (c != 'q');
        anychat.Release();
        System.out.print(String.valueOf(SampleServer.getCurrentTime()) + "Business server(Java) already exited...\r\n");
    }

    public static String getCurrentTime() {
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat tm = new SimpleDateFormat("MM-dd HH:mm:ss:SSS");
        String strTime = "";
        try {
            strTime = String.valueOf(tm.format(date)) + "\t";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strTime;
    }

    @Override
    public void OnAnyChatServerAppMessageExCallBack(int dwNotifyMessage, int wParam, int lParam) {
        if (dwNotifyMessage == 10) {
            if (wParam == 0) {
                System.out.print(String.valueOf(SampleServer.getCurrentTime()) + "Success connected with anychatcoreserver...\r\n");
            } else {
                System.out.print(String.valueOf(SampleServer.getCurrentTime()) + "ERROR: Disconnected from the anychatcoreserver, errorcode:" + wParam + "\r\n");
            }
            onlineusers.clear();
        } else if (dwNotifyMessage == 11) {
            if (wParam == 0) {
                System.out.print(String.valueOf(SampleServer.getCurrentTime()) + "Success connected with anychatrecordserver(id:" + lParam + ") ...\r\n");
            } else {
                System.out.print(String.valueOf(SampleServer.getCurrentTime()) + "ERROR: Disconnected from the anychatrecordserver, errorcode:" + wParam + "\r\n");
            }
        } else {
            System.out.print(String.valueOf(SampleServer.getCurrentTime()) + "OnServerAppMessageExCallBack, dwNotifyMessage:" + dwNotifyMessage + " wParam:" + wParam + " lParam:" + lParam + "\r\n");
        }
    }

    @Override
    public int OnAnyChatVerifyUserCallBack(String szUserName, String szPassword, AnyChatVerifyUserOutParam outParam) {
        outParam.SetUserId(iUserIdSeed);
        outParam.SetUserLevel(0);
        outParam.SetNickName(szUserName);
        if (bShowActionLog) {
            System.out.print(String.valueOf(SampleServer.getCurrentTime()) + "OnVerifyUserCallBack: userid:" + iUserIdSeed + " username: " + szUserName + "\r\n");
        }
        ++iUserIdSeed;
        return 0;
    }

    @Override
    public void OnAnyChatUserLoginActionCallBack(int dwUserId, String szUserName, int dwLevel, String szIpAddr) {
        if (bShowActionLog) {
            System.out.print(String.valueOf(SampleServer.getCurrentTime()) + "OnUserLoginActionCallBack: userid:" + dwUserId + " username: " + szUserName + " ip: " + szIpAddr + "\r\n");
        }
        onlineusers.add(dwUserId);
    }

    @Override
    public void OnAnyChatUserLogoutActionExCallBack(int dwUserId, int dwErrorCode) {
        Iterator<Integer> it = onlineusers.iterator();
        while (it.hasNext()) {
            if (it.next() != dwUserId) continue;
            it.remove();
            break;
        }
        if (bShowActionLog) {
            System.out.print(String.valueOf(SampleServer.getCurrentTime()) + "OnUserLogoutActionExCallBack: userid:" + dwUserId + " errorcode:" + dwErrorCode + "\r\n");
        }
    }

    @Override
    public int OnAnyChatPrepareEnterRoomCallBack(int dwUserId, int dwRoomId, String szRoomName, String szPassword) {
        if (bShowActionLog) {
            System.out.print(String.valueOf(SampleServer.getCurrentTime()) + "OnPrepareEnterRoomCallBack: userid:" + dwUserId + " roomid: " + dwRoomId + "\r\n");
        }
        return 0;
    }

    @Override
    public void OnAnyChatUserEnterRoomActionCallBack(int dwUserId, int dwRoomId) {
        if (bShowActionLog) {
            System.out.print(String.valueOf(SampleServer.getCurrentTime()) + "OnUserEnterRoomActionCallBack: userid:" + dwUserId + " roomid: " + dwRoomId + "\r\n");
        }
    }

    @Override
    public void OnAnyChatUserLeaveRoomActionCallBack(int dwUserId, int dwRoomId) {
        if (bShowActionLog) {
            System.out.print(String.valueOf(SampleServer.getCurrentTime()) + "OnUserLeaveRoomActionCallBack: userid:" + dwUserId + " roomid: " + dwRoomId + "\r\n");
        }
    }

    @Override
    public void OnAnyChatTransFile(int dwUserId, String szFileName, String szTempFilePath, int dwFileLength, int wParam, int lParam, int dwTaskId) {
    }

    @Override
    public void OnAnyChatTransBuffer(int dwUserId, byte[] lpBuf, int dwLen) {
        if (bShowActionLog) {
            System.out.print(String.valueOf(SampleServer.getCurrentTime()) + "OnAnyChatTransBuffer: userid:" + dwUserId + "len: " + dwLen + " timestamp: " + AnyChatServerSDK.SetSDKOptionInt(1, dwUserId) + "\r\n");
        }
    }

    @Override
    public void OnAnyChatTransBufferEx(int dwUserId, byte[] lpBuf, int dwLen, int wParam, int lParam, int dwTaskId) {
    }

    @Override
    public void OnAnyChatSDKFilterData(int dwUserId, byte[] lpBuf, int dwLen) {
        System.out.print(String.valueOf(SampleServer.getCurrentTime()) + "OnAnyChatSDKFilterData\r\n");
    }

    @Override
    public void OnAnyChatTimerEventCallBack() {
        System.out.print(String.valueOf(SampleServer.getCurrentTime()) + "OnTimerEventCallBack\r\n");
    }

    @Override
    public void OnAnyChatRecvUserTextMsgCallBack(int dwRoomId, int dwSrcUserId, int dwTarUserId, int bSecret, String szTextMessage, int dwLen) {
        if (bShowActionLog) {
            System.out.print(String.valueOf(SampleServer.getCurrentTime()) + "OnAnyChatRecvUserTextMsgCallBack: " + dwSrcUserId + " to " + dwTarUserId + " " + szTextMessage + "\r\n");
        }
    }

    @Override
    public void OnAnyChatServerRecordExCallBack(int dwUserId, String szRecordFileName, int dwElapse, int dwFlags, int dwParam, String lpUserStr, int dwRecordServerId) {
        boolean bSnapShotEvent = (dwFlags & 0x400) != 0;
        String eventStr = bSnapShotEvent ? " ,SnapShot Event" : " ,Record Event";
        String str = "OnAnyChatServerRecordExCallBack: dwUserId" + dwUserId + eventStr + " ,szRecordFileName:" + szRecordFileName + " lpUserStr:" + lpUserStr;
        if (bShowActionLog) {
            System.out.print(String.valueOf(SampleServer.getCurrentTime()) + str + "\r\n");
        }
    }

    @Override
    public int OnAnyChatVideoCallEventCallBack(int dwEventType, int dwSrcUserId, int dwTarUserId, int dwErrorCode, int dwFlags, int dwParam, String lpUserStr) {
        String str = "OnAnyChatVideoCallEventCallBack: dwEventType:" + dwEventType + " dwSrcUserId:" + dwSrcUserId + " dwTarUserId:" + dwTarUserId + " dwErrorCode:" + dwErrorCode + " dwFlags:" + dwFlags + " dwParam:" + dwParam + " lpUserStr:" + lpUserStr;
        if (bShowActionLog) {
            System.out.print(String.valueOf(SampleServer.getCurrentTime()) + str + "\r\n");
        }
        return 0;
    }

    @Override
    public int OnAnyChatUserInfoCtrlCallBack(int dwSendUserId, int dwUserId, int dwCtrlCode, int wParam, int lParam, String lpStrValue) {
        String str = "OnAnyChatUserInfoCtrlCallBack: dwSendUserId:" + dwSendUserId + " dwUserId:" + dwUserId + " dwCtrlCode:" + dwCtrlCode + " wParam:" + wParam + " lParam:" + lParam + " lpStrValue:" + lpStrValue;
        if (bShowActionLog) {
            System.out.print(String.valueOf(SampleServer.getCurrentTime()) + str + "\r\n");
        }
        return 0;
    }
}

