/*
 * Decompiled with CFR 0.152.
 */
package com.bairuitech.anychat;

import com.bairuitech.anychat.AnyChatBaseEvent;
import com.bairuitech.anychat.AnyChatDataEncDecEvent;
import com.bairuitech.anychat.AnyChatOutParam;
import com.bairuitech.anychat.AnyChatPrivateChatEvent;
import com.bairuitech.anychat.AnyChatRecordEvent;
import com.bairuitech.anychat.AnyChatStateChgEvent;
import com.bairuitech.anychat.AnyChatTextMsgEvent;
import com.bairuitech.anychat.AnyChatTransDataEvent;
import com.bairuitech.anychat.AnyChatUserInfoEvent;
import com.bairuitech.anychat.AnyChatVideoCallEvent;
import java.awt.Component;

public class AnyChatCoreSDK {
    AnyChatBaseEvent baseEvent;
    AnyChatStateChgEvent stateChgEvent;
    AnyChatPrivateChatEvent privateChatEvent;
    AnyChatTextMsgEvent textMsgEvent;
    AnyChatTransDataEvent transDataEvent;
    AnyChatVideoCallEvent videoCallEvent;
    AnyChatUserInfoEvent userInfoEvent;
    AnyChatDataEncDecEvent encdecEvent;
    AnyChatRecordEvent recordEvent;
    private final int HANDLE_TYPE_NOTIFYMSG = 1;
    private final int HANDLE_TYPE_TEXTMSG = 2;
    private final int HANDLE_TYPE_TRANSFILE = 3;
    private final int HANDLE_TYPE_TRANSBUF = 4;
    private final int HANDLE_TYPE_TRANSBUFEX = 5;
    private final int HANDLE_TYPE_SDKFILTER = 6;
    private static int HANDLE_TYPE_VIDEOCALL = 7;
    private static int HANDLE_TYPE_RECORD = 8;

    static {
        System.loadLibrary("anychatcore4java");
    }

    public void SetBaseEvent(AnyChatBaseEvent e) {
        this.RegisterNotify();
        this.baseEvent = e;
    }

    public void SetStateChgEvent(AnyChatStateChgEvent e) {
        this.RegisterNotify();
        this.stateChgEvent = e;
    }

    public void SetPrivateChatEvent(AnyChatPrivateChatEvent e) {
        this.RegisterNotify();
        this.privateChatEvent = e;
    }

    public void SetTextMessageEvent(AnyChatTextMsgEvent e) {
        this.RegisterNotify();
        this.textMsgEvent = e;
    }

    public void SetTransDataEvent(AnyChatTransDataEvent e) {
        this.RegisterNotify();
        this.transDataEvent = e;
    }

    public void SetVideoCallEvent(AnyChatVideoCallEvent e) {
        this.RegisterNotify();
        this.videoCallEvent = e;
    }

    public void SetUserInfoEvent(AnyChatUserInfoEvent e) {
        this.RegisterNotify();
        this.userInfoEvent = e;
    }

    public void SetDataEncDecEvent(AnyChatDataEncDecEvent e) {
        this.RegisterNotify();
        this.encdecEvent = e;
    }

    public void SetRecordSnapShotEvent(AnyChatRecordEvent e) {
        this.RegisterNotify();
        this.recordEvent = e;
    }

    public int GetSDKMainVersion() {
        return this.GetSDKOptionInt(22);
    }

    public int GetSDKSubVersion() {
        return this.GetSDKOptionInt(23);
    }

    public String GetSDKBuildTime() {
        return this.GetSDKOptionString(24);
    }

    public native int RegisterNotify();

    public native int InitSDK(int var1, int var2);

    public native int Connect(String var1, int var2);

    public native int Login(String var1, String var2);

    public native int EnterRoom(int var1, String var2);

    public native int EnterRoomEx(String var1, String var2);

    public native int LeaveRoom(int var1);

    public native int Logout();

    public native int Release();

    public native int[] GetOnlineUser();

    public native int SetVideoPos(int var1, Component var2, int var3, int var4, int var5, int var6);

    public native int UserCameraControl(int var1, int var2);

    public native int UserSpeakControl(int var1, int var2);

    public native int StreamRecordCtrl(int var1, int var2, int var3, int var4);

    public native int StreamRecordCtrlEx(int var1, int var2, int var3, int var4, String var5);

    public native String QueryUserStateString(int var1, int var2);

    public native int GetUserSpeakVolume(int var1);

    public native int GetCameraState(int var1);

    public native int GetSpeakState(int var1);

    public native int GetUserVideoWidth(int var1);

    public native int GetUserVideoHeight(int var1);

    public native int SetServerAuthPass(String var1);

    public native int SetSDKOptionInt(int var1, int var2);

    public native int SetSDKOptionString(int var1, String var2);

    public native int GetSDKOptionInt(int var1);

    public native String GetSDKOptionString(int var1);

    public native int SendTextMessage(int var1, int var2, String var3);

    public native int TransFile(int var1, String var2, int var3, int var4, int var5, AnyChatOutParam var6);

    public native int TransBuffer(int var1, byte[] var2, int var3);

    public native int TransBufferEx(int var1, byte[] var2, int var3, int var4, int var5, int var6, AnyChatOutParam var7);

    public native int CancelTransTask(int var1, int var2);

    public native int QueryTransTaskInfo(int var1, int var2, int var3, AnyChatOutParam var4);

    public native int SendSDKFilterData(byte[] var1, int var2);

    public static native byte[] FetchAudioPlayBuffer(int var0);

    public void CameraAutoFocus() {
        this.SetSDKOptionInt(90, 1);
    }

    public String GetUserName(int userid) {
        return this.QueryUserStateString(userid, 6);
    }

    public String GetUserIPAddr(int userid) {
        return this.QueryUserStateString(userid, 8);
    }

    public native String[] EnumVideoCapture();

    public native int SelectVideoCapture(String var1);

    public native String GetCurVideoCapture();

    public native String[] EnumAudioCapture();

    public native int SelectAudioCapture(String var1);

    public native String GetCurAudioCapture();

    public native String[] EnumAudioPlayback();

    public native int SelectAudioPlayback(String var1);

    public native String GetCurAudioPlayback();

    public native int ChangeChatMode(int var1);

    public native int GetUserChatMode(int var1);

    public native int PrivateChatRequest(int var1);

    public native int PrivateChatEcho(int var1, int var2, int var3);

    public native int PrivateChatEchoEx(int var1, int var2, int var3);

    public native int PrivateChatExit(int var1);

    public static native int SetInputVideoFormat(int var0, int var1, int var2, int var3, int var4);

    public static native int InputVideoData(byte[] var0, int var1, int var2);

    public static native int SetInputAudioFormat(int var0, int var1, int var2, int var3);

    public static native int InputAudioData(byte[] var0, int var1, int var2);

    public native int VideoCallControl(int var1, int var2, int var3, int var4, int var5, String var6);

    public native int[] GetUserFriends();

    public native int GetFriendStatus(int var1);

    public native int[] GetUserGroups();

    public native int[] GetGroupFriends(int var1);

    public native String GetUserInfo(int var1, int var2);

    public native String GetGroupName(int var1);

    public native int UserInfoControl(int var1, int var2, int var3, int var4, String var5);

    public native int MultiCastControl(String var1, int var2, String var3, int var4, int var5);

    public void OnNotifyMsg(int dwNotifyMsg, int wParam, int lParam) {
        switch (dwNotifyMsg) {
            case 1225: {
                if (this.baseEvent == null) break;
                this.baseEvent.OnAnyChatConnectMessage(wParam >= 1);
                break;
            }
            case 1226: {
                if (this.baseEvent == null) break;
                this.baseEvent.OnAnyChatLoginMessage(wParam, lParam);
                break;
            }
            case 1227: {
                if (this.baseEvent == null) break;
                this.baseEvent.OnAnyChatEnterRoomMessage(wParam, lParam);
                break;
            }
            case 1229: {
                if (this.baseEvent == null) break;
                this.baseEvent.OnAnyChatUserAtRoomMessage(wParam, lParam >= 1);
                break;
            }
            case 1230: {
                if (this.baseEvent == null) break;
                this.baseEvent.OnAnyChatLinkCloseMessage(lParam);
                break;
            }
            case 1231: {
                if (this.baseEvent == null) break;
                this.baseEvent.OnAnyChatOnlineUserMessage(wParam, lParam);
                break;
            }
            case 1228: {
                if (this.stateChgEvent == null) break;
                this.stateChgEvent.OnAnyChatMicStateChgMessage(wParam, lParam != 0);
                break;
            }
            case 1235: {
                if (this.stateChgEvent == null) break;
                this.stateChgEvent.OnAnyChatCameraStateChgMessage(wParam, lParam);
                break;
            }
            case 1236: {
                if (this.stateChgEvent == null) break;
                this.stateChgEvent.OnAnyChatChatModeChgMessage(wParam, lParam == 0);
                break;
            }
            case 1237: {
                if (this.stateChgEvent == null) break;
                this.stateChgEvent.OnAnyChatActiveStateChgMessage(wParam, lParam);
                break;
            }
            case 1238: {
                if (this.stateChgEvent == null) break;
                this.stateChgEvent.OnAnyChatP2PConnectStateMessage(wParam, lParam);
                break;
            }
            case 1239: {
                break;
            }
            case 1245: {
                if (this.privateChatEvent == null) break;
                this.privateChatEvent.OnAnyChatPrivateRequestMessage(wParam, lParam);
                break;
            }
            case 1246: {
                if (this.privateChatEvent == null) break;
                this.privateChatEvent.OnAnyChatPrivateEchoMessage(wParam, lParam);
                break;
            }
            case 1247: {
                if (this.privateChatEvent == null) break;
                this.privateChatEvent.OnAnyChatPrivateExitMessage(wParam, lParam);
                break;
            }
        }
    }

    private void OnAnyChatNotifyMsg(int dwNotifyMsg, int wParam, int lParam) {
        this.OnNotifyMsg(dwNotifyMsg, wParam, lParam);
    }

    private void OnTextMessageCallBack(int dwFromUserid, int dwToUserid, int bSecret, String message) {
        if (this.textMsgEvent != null) {
            this.textMsgEvent.OnAnyChatTextMessage(dwFromUserid, dwToUserid, bSecret != 0, message);
        }
    }

    private void OnTransFileCallBack(int userid, String filename, String tempfilepath, int filelength, int wparam, int lparam, int taskid) {
        if (this.transDataEvent != null) {
            this.transDataEvent.OnAnyChatTransFile(userid, filename, tempfilepath, filelength, wparam, lparam, taskid);
        }
    }

    private void OnTransBufferCallBack(int userid, byte[] buf, int len) {
        if (this.transDataEvent != null) {
            this.transDataEvent.OnAnyChatTransBuffer(userid, buf, len);
        }
    }

    private void OnTransBufferExCallBack(int userid, byte[] buf, int len, int wparam, int lparam, int taskid) {
        if (this.transDataEvent != null) {
            this.transDataEvent.OnAnyChatTransBufferEx(userid, buf, len, wparam, lparam, taskid);
        }
    }

    private void OnSDKFilterDataCallBack(byte[] buf, int len) {
        if (this.transDataEvent != null) {
            this.transDataEvent.OnAnyChatSDKFilterData(buf, len);
        }
    }

    private void OnVideoCallEventCallBack(int eventtype, int userid, int errorcode, int flags, int param, String userStr) {
        if (this.videoCallEvent != null) {
            this.videoCallEvent.OnAnyChatVideoCallEvent(eventtype, userid, errorcode, flags, param, userStr);
        }
    }

    private void OnRecordSnapShotExCallBack(int dwUserId, String lpFileName, int dwElapse, int dwFlags, int dwParam, String lpUserStr) {
        if (this.recordEvent != null) {
            if ((dwFlags & 0x400) == 0) {
                this.recordEvent.OnAnyChatRecordEvent(dwUserId, lpFileName, dwElapse, dwFlags, dwParam, lpUserStr);
            } else {
                this.recordEvent.OnAnyChatSnapShotEvent(dwUserId, lpFileName, dwFlags, dwParam, lpUserStr);
            }
        }
    }

    private int OnDataEncDecCallBack(int userid, int flags, byte[] buf, int len, AnyChatOutParam outParam) {
        if (this.encdecEvent != null) {
            return this.encdecEvent.OnAnyChatDataEncDec(userid, flags, buf, len, outParam);
        }
        return -1;
    }
}

