/*
 * Decompiled with CFR 0.152.
 */
package com.bairuitech.server;

import com.bairuitech.anychat.AnyChatServerEvent;
import com.bairuitech.anychat.AnyChatServerSDK;
import com.bairuitech.anychat.AnyChatVerifyUserOutParam;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class BusinessServer
extends JFrame
implements AnyChatServerEvent {
    private static final long serialVersionUID = 1L;
    public AnyChatServerSDK anychat;
    public StringBuilder message = new StringBuilder();
    public JTextArea showMessage;
    public JScrollPane jPanlMsg;
    public JScrollPane jPanlUser;
    public JPanel jContent;
    public JTable jTableUser;
    public JLabel jServerStatus;
    public GridBagLayout gridBagLayout;
    public GridBagConstraints gridConstraints;
    public Vector<String> tableTitles = new Vector();
    public DefaultTableModel model;
    public static int iUserIdSeed = 1;
    public static final int COLUM_COUNT = 5;
    public static final int ROOM_INDEX = 3;
    public static ArrayList<Integer> onlineusers = new ArrayList();

    public BusinessServer() {
        this.initView();
    }

    private void initUserTable() {
        this.tableTitles.addElement("\u7528\u6237ID");
        this.tableTitles.addElement("\u7528\u6237\u59d3\u540d");
        this.tableTitles.addElement("\u7528\u6237IP");
        this.tableTitles.addElement("\u623f\u95f4ID");
        this.tableTitles.addElement("\u767b\u5f55\u65f6\u95f4");
        this.model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.jTableUser = new JTable(this.model);
        this.jTableUser.setForeground(Color.white);
        this.jTableUser.setRowHeight(20);
        this.jTableUser.setPreferredScrollableViewportSize(new Dimension(200, 200));
        this.jTableUser.doLayout();
        this.jTableUser.setGridColor(Color.gray);
        int i = 0;
        while (i < 5) {
            this.model.addColumn(this.tableTitles.get(i));
            ++i;
        }
        DefaultTableCellRenderer render = new DefaultTableCellRenderer(){

            @Override
            public void setValue(Object value) {
                this.setForeground(Color.blue);
                super.setValue(value);
            }
        };
        render.setHorizontalAlignment(0);
        render.setVerticalAlignment(0);
        this.jTableUser.setDefaultRenderer(Object.class, render);
        DefaultTableCellRenderer hendRender = (DefaultTableCellRenderer)this.jTableUser.getTableHeader().getDefaultRenderer();
        Dimension d = render.getSize();
        d.height = 20;
        hendRender.setPreferredSize(d);
    }

    private void updateUserData(int userId, String name, String ip, String time) {
        if (userId != 0) {
            Vector<Object> verctor = new Vector<Object>();
            verctor.addElement(userId);
            verctor.addElement(name);
            verctor.addElement(ip);
            verctor.addElement("");
            verctor.addElement(time);
            this.model.addRow(verctor);
        }
    }

    private void updateUserData(int userId) {
        int index = -1;
        index = this.findUserDataById(userId);
        if (index != -1) {
            this.model.removeRow(index);
        }
    }

    private void updateUserData(int userId, int roomId) {
        int index = -1;
        index = this.findUserDataById(userId);
        if (index != -1) {
            if (roomId != -1) {
                this.model.setValueAt(roomId, index, 3);
            } else {
                this.model.setValueAt("", index, 3);
            }
            this.jTableUser.updateUI();
        }
    }

    private int findUserDataById(int userId) {
        int index = -1;
        Vector<Vector> userDatas = this.model.getDataVector();
        int size = userDatas.size();
        System.out.print(size);
        int i = 0;
        while (i < size) {
            index = i;
            Vector vector = userDatas.get(i);
            if (vector != null && vector.indexOf(userId) != -1) {
                return index;
            }
            ++i;
        }
        return -1;
    }

    private String getCurrentTime() {
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat sdf = new SimpleDateFormat("MM-dd HH:mm:ss:SS");
        String strTime = "";
        try {
            strTime = sdf.format(date);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strTime;
    }

    public void initView() {
        this.setLayout(null);
        this.showMessage = new JTextArea();
        this.showMessage.setEditable(false);
        this.jContent = new JPanel();
        this.jContent.setLayout(new GridLayout(2, 1));
        this.jPanlMsg = new JScrollPane(this.showMessage);
        this.jPanlMsg.setVerticalScrollBarPolicy(20);
        this.jPanlMsg.setHorizontalScrollBarPolicy(30);
        this.initUserTable();
        this.jPanlUser = new JScrollPane(this.jTableUser);
        this.jPanlUser.setVerticalScrollBarPolicy(20);
        this.jPanlUser.setHorizontalScrollBarPolicy(30);
        this.jPanlUser.getViewport().setBackground(Color.white);
        this.jServerStatus = new JLabel();
        this.jContent.add(this.jPanlUser);
        this.jContent.add(this.jPanlMsg);
        this.jContent.setBounds(0, 0, 850, 540);
        this.jServerStatus.setBounds(620, 540, 200, 30);
        this.add(this.jContent);
        this.add(this.jServerStatus);
        this.setSize(850, 600);
        this.setLocation(400, 150);
        this.setResizable(false);
        this.setTitle("AnyChat Server SDK for Java \u793a\u4f8b");
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.createImage("bairuitech.png");
        this.setIconImage(image);
        this.setDefaultCloseOperation(3);
        this.addWindowListener(new WindowsEvent());
        this.setVisible(true);
    }

    private void initSdk() {
        this.anychat = new AnyChatServerSDK();
        this.anychat.SetServerEvent(this);
        this.anychat.InitSDK(0);
        this.anychat.RegisterVerifyUserClass(new AnyChatVerifyUserOutParam());
        String sdkVersion = this.anychat.GetSDKVersion();
        this.message.append(String.valueOf(sdkVersion) + "\r\n");
        this.showMessage.setText(this.message.toString());
    }

    private void generateLog(String str) {
        this.message.append(String.valueOf(this.getCurrentTime()) + "  ");
        this.message.append(str);
        this.message.append("\n");
        this.showMessage.setText(this.message.toString());
    }

    public static void main(String[] args) {
        BusinessServer server = new BusinessServer();
        server.initSdk();
    }

    @Override
    public void OnAnyChatServerAppMessageExCallBack(int dwNotifyMessage, int wParam, int lParam) {
        String str = "";
        if (dwNotifyMessage == 10) {
            if (wParam == 0) {
                str = "Connect AnyChatCoreServer successed!";
                this.jServerStatus.setForeground(new Color(0, 128, 0));
                this.jServerStatus.setText(str);
            } else {
                str = "Connect AnyChatCoreServer failed!(errorcode:" + wParam + ")";
                this.jServerStatus.setForeground(Color.red);
                this.jServerStatus.setText(str);
            }
            onlineusers.clear();
        } else {
            str = dwNotifyMessage == 11 ? (wParam == 0 ? "Success connected with anychatrecordserver(id:" + lParam + ") ..." : "ERROR: Disconnected from the anychatrecordserver, errorcode:" + wParam) : "OnServerAppMessageExCallBack, dwNotifyMessage:" + dwNotifyMessage + " wParam:" + wParam + " lParam:" + lParam;
        }
        this.generateLog(str);
    }

    @Override
    public int OnAnyChatVerifyUserCallBack(String szUserName, String szPassword, AnyChatVerifyUserOutParam outParam) {
        outParam.SetUserId(iUserIdSeed);
        outParam.SetUserLevel(0);
        outParam.SetNickName(szUserName);
        String str = "OnVerifyUserCallBack: userid:" + iUserIdSeed + " username: " + szUserName;
        this.generateLog(str);
        ++iUserIdSeed;
        return 0;
    }

    @Override
    public void OnAnyChatUserLoginActionCallBack(int dwUserId, String szUserName, int dwLevel, String szIpAddr) {
        String str = "OnAnyChatUserLoginActionCallBack: userid:" + dwUserId + " username: " + szUserName + " Ip: " + szIpAddr;
        this.generateLog(str);
        this.updateUserData(dwUserId, szUserName, szIpAddr, this.getCurrentTime());
    }

    @Override
    public void OnAnyChatUserLogoutActionExCallBack(int dwUserId, int dwErrorCode) {
        String str = "OnUserLogoutActionExCallBack: userid:" + dwUserId + " errorcode:" + dwErrorCode;
        this.generateLog(str);
        this.updateUserData(dwUserId);
        Iterator<Integer> it = onlineusers.iterator();
        while (it.hasNext()) {
            if (it.next() != dwUserId) continue;
            it.remove();
            break;
        }
    }

    @Override
    public int OnAnyChatPrepareEnterRoomCallBack(int dwUserId, int dwRoomId, String szRoomName, String szPassword) {
        String str = "OnPrepareEnterRoomCallBack: userid:" + dwUserId + " roomid: " + dwRoomId;
        this.generateLog(str);
        return 0;
    }

    @Override
    public void OnAnyChatUserEnterRoomActionCallBack(int dwUserId, int dwRoomId) {
        String str = "OnUserEnterRoomActionCallBack: userid:" + dwUserId + " roomid: " + dwRoomId;
        this.generateLog(str);
        this.updateUserData(dwUserId, dwRoomId);
    }

    @Override
    public void OnAnyChatUserLeaveRoomActionCallBack(int dwUserId, int dwRoomId) {
        String str = "OnAnyChatUserLeaveRoomActionCallBack: userid:" + dwUserId + " roomid: " + dwRoomId;
        this.generateLog(str);
        this.updateUserData(dwUserId, -1);
    }

    @Override
    public void OnAnyChatTransFile(int dwUserId, String szFileName, String szTempFilePath, int dwFileLength, int wParam, int lParam, int dwTaskId) {
        String str = "OnAnyChatTransFile->from:" + dwUserId + ";filename:" + szFileName + "path:" + szTempFilePath;
        this.generateLog(str);
        this.showMessage.setText(this.message.toString());
    }

    @Override
    public void OnAnyChatTransBuffer(int dwUserId, byte[] lpBuf, int dwLen) {
        String str = "";
        try {
            str = new String(lpBuf, "GB2312");
            System.out.println(str);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.generateLog("OnAnyChatTransBuffer: fromUserid:" + dwUserId + str);
    }

    @Override
    public void OnAnyChatTransBufferEx(int dwUserId, byte[] lpBuf, int dwLen, int wParam, int lParam, int dwTaskId) {
        String str = "";
        try {
            str = new String(lpBuf, "GB2312");
            System.out.println(str);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.message.append("OnAnyChatTransBufferEx: fromUserid:" + dwUserId + str);
        this.generateLog("OnAnyChatTransBufferEx: fromUserid:" + dwUserId + str);
    }

    @Override
    public void OnAnyChatSDKFilterData(int dwUserId, byte[] lpBuf, int dwLen) {
        String str = "";
        try {
            str = new String(lpBuf, "GB2312");
            System.out.println(str);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.message.append("OnanychatFilterData: fromUserid:" + dwUserId + str);
        this.generateLog("OnanychatFilterData: fromUserid:" + dwUserId + str);
    }

    @Override
    public void OnAnyChatTimerEventCallBack() {
        System.out.print("OnTimerEventCallBack\r\n");
    }

    @Override
    public void OnAnyChatRecvUserTextMsgCallBack(int dwRoomId, int dwSrcUserId, int dwTarUserId, int bSecret, String szTextMessage, int dwLen) {
        String str = "OnAnyChatRecvUserTextMsgCallBack: " + dwSrcUserId + " to " + dwTarUserId + " " + szTextMessage;
        this.generateLog(str);
    }

    @Override
    public void OnAnyChatServerRecordExCallBack(int dwUserId, String szRecordFileName, int dwElapse, int dwFlags, int dwParam, String lpUserStr, int dwRecordServerId) {
        boolean bSnapShotEvent = (dwFlags & 0x400) != 0;
        String eventStr = bSnapShotEvent ? " ,SnapShot Event" : " ,Record Event";
        String str = "OnAnyChatServerRecordExCallBack: dwUserId" + dwUserId + eventStr + " ,szRecordFileName:" + szRecordFileName + " lpUserStr:" + lpUserStr;
        this.generateLog(str);
    }

    @Override
    public int OnAnyChatVideoCallEventCallBack(int dwEventType, int dwSrcUserId, int dwTarUserId, int dwErrorCode, int dwFlags, int dwParam, String lpUserStr) {
        String str = "OnAnyChatVideoCallEventCallBack: dwEventType:" + dwEventType + " dwSrcUserId:" + dwSrcUserId + " dwTarUserId:" + dwTarUserId + " dwErrorCode:" + dwErrorCode + " dwFlags:" + dwFlags + " dwParam:" + dwParam + " lpUserStr:" + lpUserStr;
        this.generateLog(str);
        return 0;
    }

    @Override
    public int OnAnyChatUserInfoCtrlCallBack(int dwSendUserId, int dwUserId, int dwCtrlCode, int wParam, int lParam, String lpStrValue) {
        String str = "OnAnyChatUserInfoCtrlCallBack: dwSendUserId:" + dwSendUserId + " dwUserId:" + dwUserId + " dwCtrlCode:" + dwCtrlCode + " wParam:" + wParam + " lParam:" + lParam + " lpStrValue:" + lpStrValue;
        this.generateLog(str);
        return 0;
    }

    class WindowsEvent
    extends WindowAdapter {
        WindowsEvent() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            try {
                BusinessServer.this.anychat.Release();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

