#if !defined(BR_ANYCHAT_CORE_SDK_H__INCLUDED_)
#define BR_ANYCHAT_CORE_SDK_H__INCLUDED_

#include <windows.h>

/**
 *	AnyChat Core SDK Include File
 */


#pragma once

#include "GVSDK.h"

#define BRAC_API extern "C" __declspec(dllexport)

// Ƶͼʽ
enum BRAC_PixelFormat{
	BRAC_PIX_FMT_RGB24 = 0,						///< Packed RGB 8:8:8, 24bpp, RGBRGB...MEDIASUBTYPE_RGB24
	BRAC_PIX_FMT_RGB32,							///< ӦڣMEDIASUBTYPE_RGB32Packed RGB 8:8:8, 32bpp, (msb)8A 8R 8G 8B(lsb), in cpu endianness
	BRAC_PIX_FMT_YV12,							///< ӦڣMEDIASUBTYPE_YV12Planar YUV 4:2:0, 12bpp, (1 Cr & Cb sample per 2x2 Y samples)
	BRAC_PIX_FMT_YUY2,							///< ӦڣMEDIASUBTYPE_YUY2Packed YUV 4:2:2, 16bpp, Y0 Cb Y1 Cr
};

// Ƶ豸
enum BRAC_AudioDevice{
	BRAC_AD_WAVEIN = 0,							///< 豸Mic
	BRAC_AD_WAVEOUT,							///< 豸Wave
};

// ģʽ
#define BRAC_FUNC_VIDEO_CBDATA		0x00000001L	///< ͨصƵ
#define BRAC_FUNC_VIDEO_AUTODISP	0x00000002L	///< SDKƵƵʾָĴ
#define BRAC_FUNC_AUDIO_CBDATA		0x00000004L	///< ͨصƵ
#define BRAC_FUNC_AUDIO_AUTOPLAY	0x00000008L	///< SDKƵֱӲ
#define BRAC_FUNC_CONFIG_LOCALINI	0x00000010L	///< ɱļAnyChatSDK.ini
#define BRAC_FUNC_FIREWALL_OPEN		0x00000020L	///< SDKWindowsǽǰӦóǽбWindowsʾûǷֹǰӦó
#define BRAC_FUNC_CHKDEPENDMODULE	0x00000040L	///< ԶSDKԶע
#define BRAC_FUNC_AUDIO_VOLUMECALC	0x00000080L	///< SDKԶ
#define BRAC_FUNC_AUDIO_AUTOVOLUME	0x00000100L	///< SDKԶMic¼
#define BRAC_FUNC_NET_SUPPORTUPNP	0x00000200L	///< SDKûеUPNP豸û·Ƿǽ֧UPNPЭ飬P2P򶴵ĳɹ
#define BRAC_FUNC_DISABLEDECODE		0x00000400L	///< ֹյݽнͲţΪߴͻ˵תܣøñ־øñ־
#define BRAC_FUNC_AUDIO_FORBIDCFGHW	0x00001000L	///< ֹ޸ƵӲ
#define BRAC_FUNC_CORE_FORBIDWINMSG	0x00002000L	///< ֹʹwindowsϢѭ
#define BRAC_FUNC_AUDIO_LARGEBUFFER	0x00004000L	///< Ƶ󻺳ģʽʺֲӦ
#define BRAC_FUNC_NET_LARGEDELAY	0x00010000L	///< ӳģʽ绷


// ں˲
#define BRAC_SO_AUDIO_VADCTRL				1	///< ƵƣΪintͣ1򿪣0رգ
#define BRAC_SO_AUDIO_NSCTRL				2	///< ƵƿƣΪintͣ1򿪣0رգ
#define BRAC_SO_AUDIO_ECHOCTRL				3	///< ƵƣΪintͣ1򿪣0رգ
#define BRAC_SO_AUDIO_AGCCTRL				4	///< ƵԶƣΪintͣ1򿪣0رգ
#define BRAC_SO_AUDIO_CAPTUREMODE			5	///< ƵɼģʽãΪintͣ0 ģʽ1 Ÿģʽ2 OKģʽ3 ·ģʽ
#define BRAC_SO_AUDIO_MICBOOST				6	///< ƵɼMicǿƣΪintͣ0 ȡ1 ѡУ2 豸[ѯʱֵ]
#define BRAC_SO_AUDIO_AUTOPARAM				7	///< ƵɼģʽԶѡʵزʲȣΪintͣ1 ã0 ر[Ĭ]
#define BRAC_SO_AUDIO_MONOBITRATE			8	///< õģʽƵĿʣΪintͣλbps
#define BRAC_SO_AUDIO_STEREOBITRATE			9	///< ˫ģʽƵĿʣΪintͣλbps
#define BRAC_SO_AUDIO_PLAYDRVCTRL			70	///< Ƶѡ񣨲Ϊintͣ0Ĭ 1 DSound 2 WaveOut 3 Java[Androidƽ̨ʹ]
#define BRAC_SO_AUDIO_CNGCTRL				71	///< ɿƣΪintͣ1򿪣0رգ
#define BRAC_SO_AUDIO_CODECID				72	///< ƵIDãΪintͣ-1ʾĬϣõıIDڣں˻Ĭϵı
#define BRAC_SO_AUDIO_SOFTVOLMODE			73	///< ģʽƣΪintͣ1[Ĭ]0رգʹģʽıϵͳ
#define BRAC_SO_AUDIO_RECORDDRVCTRL			74	///< ƵɼƣΪintͣ0Ĭ 1 DSound 2 WaveIn 3 Javaɼ[Androidƽ̨ʹ]

#define BRAC_SO_RECORD_VIDEOBR				10	///< ¼ƵãΪintͣλbps
#define BRAC_SO_RECORD_AUDIOBR				11	///< ¼ƵãΪintͣλbps
#define BRAC_SO_RECORD_TMPDIR				12	///< ¼ļʱĿ¼ãΪַTCHARͣľ·
#define BRAC_SO_SNAPSHOT_TMPDIR				13	///< ļʱĿ¼ãΪַTCHARͣľ·
#define BRAC_SO_CORESDK_TMPDIR				14	///< AnyChat Core SDKʱĿ¼ΪַTCHARͣľ·
#define BRAC_SO_CORESDK_LOADCODEC			16	///< ⲿΪַTCHARͣľ·ļļľ·
#define BRAC_SO_CORESDK_USEARMV6LIB			17	///< ǿʹARMv6ָĿ⣬androidƽ̨ʹãΪintͣ1ʹARMv6ָ 0ںԶж[Ĭ]
#define BRAC_SO_CORESDK_USEHWCODEC			18	///< ʹƽ̨ӲΪintͣ0 ʹӲ[Ĭ]  1 ʹӲ

#define BRAC_SO_CORESDK_PATH				20	///< AnyChat Core SDK·ΪַTCHARͣľ·
#define BRAC_SO_CORESDK_DUMPCOREINFO		21	///< ںϢ־ļУڷԭ򣨲Ϊintͣ1 
#define BRAC_SO_CORESDK_MAINVERSION			22	///< ѯSDK汾źţΪintͣ
#define BRAC_SO_CORESDK_SUBVERSION			23	///< ѯSDKӰ汾ţΪintͣ
#define BRAC_SO_CORESDK_BUILDTIME			24	///< ѯSDKʱ䣨ΪַTCHARͣ
#define BRAC_SO_CORESDK_ACTIVESTATE			25	///< Ӧó״̬ƣΪintͣ 1 Ӧóڻ״̬ 0 Ӧóڷǻ״̬iPhone豸ɺ̨еĳ
#define BRAC_SO_CORESDK_EXTVIDEOINPUT		26	///< ⲿչƵƣΪintͣ 0 رⲿƵ[Ĭ] 1 ⲿƵ룩
#define BRAC_SO_CORESDK_EXTAUDIOINPUT		27	///< ⲿչƵƣΪintͣ 0 رⲿƵ[Ĭ] 1 ⲿƵ룩
#define BRAC_SO_CORESDK_LOWDELAYCTRL		28	///< ӳģʽƣΪintͣ0 رյӳģʽ[Ĭ] 1 õӳģʽ

#define BRAC_SO_LOCALVIDEO_BITRATECTRL		30	///< ƵãΪintͣλbpsͬãVideoBitrate
#define BRAC_SO_LOCALVIDEO_QUALITYCTRL		31	///< ƵӿƣΪintͣͬãVideoQuality
#define BRAC_SO_LOCALVIDEO_GOPCTRL			32	///< Ƶؼ֡ƣΪintͣͬãVideoGOPSize
#define BRAC_SO_LOCALVIDEO_FPSCTRL			33	///< Ƶ֡ʿƣΪintͣͬãVideoFps
#define BRAC_SO_LOCALVIDEO_PRESETCTRL		34	///< ƵԤƣΪintͣ1-5
#define BRAC_SO_LOCALVIDEO_APPLYPARAM		35	///< ӦñƵʹǰ޸ļʱЧΪintͣ1 ʹ²0 ʹĬϲ
#define BRAC_SO_LOCALVIDEO_VIDEOSIZEPOLITIC	36	///< ƵɼֱʿƲԣΪintͣ0 Զƥ[Ĭ]1 ʹòɼ豸ĬϷֱʣõķֱʲɼ豸֧ʱЧ
#define BRAC_SO_LOCALVIDEO_DEINTERLACE		37	///< Ƶ֯ƣΪintͣ 0 з֯[Ĭ]1 ֯ƵԴǸɨԴźţʱͨ֯߻
#define BRAC_SO_LOCALVIDEO_WIDTHCTRL		38	///< ƵɼֱʿȿƣΪintͣͬãVideoWidth
#define BRAC_SO_LOCALVIDEO_HEIGHTCTRL		39	///< Ƶɼֱʸ߶ȿƣΪintͣͬãVideoHeight
#define BRAC_SO_LOCALVIDEO_FOCUSCTRL		90	///< ƵͷԽƣΪintͣ1ʾԶԽ 0ʾֶԽ
#define BRAC_SO_LOCALVIDEO_PIXFMTCTRL		91	///< ƵɼȸʽƣΪintͣ-1ʾƥ䣬ȲָʽοBRAC_PixelFormat
#define BRAC_SO_LOCALVIDEO_OVERLAY			92	///< ƵOverlayģʽΪintͣ1ʾOverlayģʽ 0ʾͨģʽ[Ĭ]
#define BRAC_SO_LOCALVIDEO_CODECID			93	///< ƵIDãΪintͣ-1ʾĬϣõıIDڣں˻Ĭϵı
#define BRAC_SO_LOCALVIDEO_ROTATECTRL		94	///< ƵתƣΪintͣ0ʾת1ʾֱת
#define BRAC_SO_LOCALVIDEO_CAPDRIVER		95	///< ƵɼãΪintͣ0ʾԶѡ[Ĭ] 1 Video4Linux, 2 DirectShow, 3 Javaɼ[Androidƽ̨ʹ]
#define BRAC_SO_LOCALVIDEO_FIXCOLORDEVIA	96	///< ƵɼɫƫɫΪintͣ0ʾر[Ĭ]1 
#define BRAC_SO_LOCALVIDEO_ORIENTATION		97	///< Ƶ豸򣨲ΪintͣΪANYCHAT_DEVICEORIENTATION_XXXX
#define BRAC_SO_LOCALVIDEO_AUTOROTATION		98	///< ƵԶתƣΪintͣ 0ʾرգ 1 [Ĭ]ƵתʱҪοƵ豸
#define BRAC_SO_LOCALVIDEO_SURFACEROTATION	99	///< ñƵԤʾתǶȣΪintͣǶȣ
#define BRAC_SO_LOCALVIDEO_CAMERAFACE		100	///< ͷǰáã
#define BRAC_SO_LOCALVIDEO_CAMERAROTATION	101	///< ͷתǶ
#define BRAC_SO_LOCALVIDEO_DEVICEROTATION	102	///< 豸תǶ
#define BRAC_SO_LOCALVIDEO_DEVICEMODE		103	///< 豸

#define BRAC_SO_NETWORK_P2PPOLITIC			40	///< P2PԿƣΪintͣ0 ֹP2P1 P2P[Ĭ]2 ϲӦÿP2Pӣ3 轨P2Pӣ
#define BRAC_SO_NETWORK_P2PCONNECT			41	///< ָûP2PӣΪintͣʾĿûIDӽɹ󣬻ͨϢϲӦãP2PƲ=2ʱЧ
#define BRAC_SO_NETWORK_P2PBREAK			42	///< ϿָûP2PӣΪintͣʾĿûID[ݲ֧֣]
#define BRAC_SO_NETWORK_TCPSERVICEPORT		43	///< ñTCP˿ڣΪintͣӷ֮ǰЧ
#define BRAC_SO_NETWORK_UDPSERVICEPORT		44	///< ñUDP˿ڣΪintͣӷ֮ǰЧ
#define BRAC_SO_NETWORK_MULTICASTPOLITIC	45	///< 鲥ԿƣΪintͣ0 ִз·ɲԣֹ鲥[Ĭ] 1 Է·ɲԣֻ鲥㲥ý 2 ִз·ɲԣͬʱ鲥
#define BRAC_SO_NETWORK_TRANSBUFMAXBITRATE	46	///< 仺ļʿƣΪintͣ0 ƣʴ[Ĭ] ʾʣλΪbps

#define BRAC_SO_PROXY_FUNCTIONCTRL			50	///< ûܿƣΪintͣ10رմ[Ĭ]
#define BRAC_SO_PROXY_VIDEOCTRL				51	///< ûƵƣƵΪָûƵⷢΪintͣʾûuserid
#define BRAC_SO_PROXY_AUDIOCTRL				52	///< ûƵƣƵΪָûƵⷢͬBRAC_SO_PROXY_VIDEOCTRL

#define BRAC_SO_STREAM_MAXBUFFERTIME		60	///< ʱ䣨Ϊintͣλ룬ȡֵΧ500 ~ 5000Ĭϣ800ģʽֵģʽԶһ
#define BRAC_SO_STREAM_SMOOTHPLAYMODE		61	///< ƽģʽΪintͣ0 ر[Ĭ], 1 򿪣״̬Ƶ֡ʱţܳˣῨס

#define BRAC_SO_VIDEOSHOW_MODECTRL			80	///< ƵʾģʽƣΪintͣ0 ʾ1 Ƶʾ
#define BRAC_SO_VIDEOSHOW_SETPRIMARYUSER	81	///< ʾûţΪintͣûIDţ
#define BRAC_SO_VIDEOSHOW_SETOVERLAYUSER	82	///< õʾûţΪintͣûIDţ
#define BRAC_SO_VIDEOSHOW_DRIVERCTRL		83	///< ƵʾƣΪintͣ0 Ĭ 1 Windows DirectShow2 Windows GDI3 SDL, 4 Android2X, 5 Android Java
#define BRAC_SO_VIDEOSHOW_GPUDIRECTRENDER	84	///< ƵݾGPUֱȾƵֱӴ䵽GPUַΪintͣ 0 ر[Ĭ] 1 򿪣Ӳƽ̨

#define BRAC_SO_CORESDK_TICKOUTUSER			110	///< ӷߵָûΪintͣʾĿûID

#define BRAC_SO_CORESDK_DEVICEMODE			130	///< 豸ģʽƣ豸֮ԻͨţΪintͣ0 ر[Ĭ]1 
#define BRAC_SO_CORESDK_SCREENCAMERACTRL	131	///< 湲ܿƣΪintͣ 0 رգ 1 [Ĭ]

// Ϣ壨APIBRAC_QueryTransTaskInfo 
#define BRAC_TRANSTASK_PROGRESS				1	///< ȲѯΪDWORDֵͣ0 ~ 100
#define BRAC_TRANSTASK_BITRATE				2	///< ǰʣΪDWORDͣλbps
#define BRAC_TRANSTASK_STATUS				3	///< ǰ״̬ΪDWORDͣ
#define BRAC_TRANSTASK_SAVEASPATH			4	///< ļΪ·ãļΪַTCHARͣ

// ¼ܱ־壨APIBRAC_StreamRecordCtrl 
#define BRAC_RECORD_FLAGS_VIDEO		0x00000001L	///< ¼Ƶ
#define BRAC_RECORD_FLAGS_AUDIO		0x00000002L	///< ¼Ƶ
#define BRAC_RECORD_FLAGS_SERVER	0x00000004L	///< ¼
#define BRAC_RECORD_FLAGS_MIXAUDIO	0x00000010L	///< ¼Ƶʱ˵¼
#define BRAC_RECORD_FLAGS_MIXVIDEO	0x00000020L	///< ¼Ƶʱ˵ƵӺ¼

// 鲥ܱ־
#define BRAC_MCFLAGS_JOINGROUP		0x00000001L	///< ಥ
#define BRAC_MCFLAGS_LEAVEGROUP		0x00000002L	///< 뿪ಥ
#define BRAC_MCFLAGS_SENDDATA		0x00000010L	///< ݷͱ־ָʾöಥڷ
#define BRAC_MCFLAGS_RECVDATA		0x00000020L	///< ݽձ־ָʾöಥڽ


// û״̬־壨APIBRAC_QueryUserState 
#define BRAC_USERSTATE_CAMERA				1	///< ûͷ״̬ΪDWORDͣ
#define BRAC_USERSTATE_HOLDMIC				2	///< ûƵ豸״̬ΪDWORDֵͣ0 Ƶɼرգ 1 Ƶɼ
#define BRAC_USERSTATE_SPEAKVOLUME			3	///< ûǰ˵ΪDOUBLEͣ0.0 ~ 100.0
#define BRAC_USERSTATE_RECORDING			4	///< û¼״̬ΪDWORDͣ
#define	BRAC_USERSTATE_LEVEL				5	///< û𣨲ΪDWORDͣ
#define BRAC_USERSTATE_NICKNAME				6	///< ûǳƣΪַTCHARͣ
#define BRAC_USERSTATE_LOCALIP				7	///< ûIPַΪַTCHARͣ
#define BRAC_USERSTATE_INTERNETIP			8	///< ûIPַΪַTCHARͣ
#define BRAC_USERSTATE_VIDEOBITRATE			9	///< ûǰƵʣΪDWORDͣBps
#define BRAC_USERSTATE_AUDIOBITRATE			10	///< ûǰƵʣΪDWORDͣBps
#define BRAC_USERSTATE_P2PCONNECT			11	///< ѯûָûĵǰP2P״̬ΪDWORDֵͣ0 P2Pͨ 1 P2Pӳɹ[TCP]2 P2Pӳɹ[UDP]3 P2Pӳɹ[TCPUDP]
#define BRAC_USERSTATE_NETWORKSTATUS		12	///< ѯָû״̬ΪDWORDֵͣ0 1 Ϻã2 һ㣬3 ϲ4 ǳעѯҪ>1s
#define BRAC_USERSTATE_VIDEOSIZE			13	///< ѯָûƵֱʣΪDWORDֵͣ16λʾȣ16λʾ߶ȣ
#define BRAC_USERSTATE_PACKLOSSRATE			14	///< ѯָûýݶʣΪDWORDֵͣ0 - 100磺ֵΪ5ʾΪ5%
#define BRAC_USERSTATE_DEVICETYPE			15	///< ѯָûնͣΪDWORDֵͣ0 Unknow1 Windows2 Android3 iOS4 Web5 Linux6 Mac7 Win Phone8 WinCE
#define BRAC_USERSTATE_SELFUSERSTATUS		16	///< ѯûĵǰ״̬ΪDWORDֵͣ0 Unknow1 Connected2 Logined3 In Room4 Logouted5 Link Closed
#define BRAC_USERSTATE_SELFUSERID			17	///< ѯûIDΪDWORDͣû¼ɹûʵʵuserid򷵻-1
#define BRAC_USERSTATE_VIDEOROTATION		18	///< ѯָûĵǰƵתǶȣΪDWORDͣؽǶֵ
#define BRAC_USERSTATE_VIDEOMIRRORED		19	///< ѯָûƵǷҪת

// Ƶ¼Ͷ壨APIBRAC_VideoCallControl VideoCallEventص
#define BRAC_VIDEOCALL_EVENT_REQUEST		1	///< 
#define BRAC_VIDEOCALL_EVENT_REPLY			2	///< ظ
#define BRAC_VIDEOCALL_EVENT_START			3	///< ƵлỰʼ¼
#define BRAC_VIDEOCALL_EVENT_FINISH			4	///< ҶϣлỰ

// Ƶб־壨APIBRAC_VideoCallControl 
#define BRAC_VIDEOCALL_FLAGS_AUDIO		0x01	///< ͨ
#define BRAC_VIDEOCALL_FLAGS_VIDEO		0x02	///< Ƶͨ
#define BRAC_VIDEOCALL_FLAGS_FBSRCAUDIO	0x10	///< ֹԴжˣƵ
#define BRAC_VIDEOCALL_FLAGS_FBSRCVIDEO	0x20	///< ֹԴжˣƵ
#define BRAC_VIDEOCALL_FLAGS_FBTARAUDIO	0x40	///< ֹĿ꣨жˣƵ
#define BRAC_VIDEOCALL_FLAGS_FBTARVIDEO	0x80	///< ֹĿ꣨жˣƵ


// Ƶݻص
typedef void (CALLBACK * BRAC_VideoData_CallBack)(DWORD dwUserid, LPVOID lpBuf, DWORD dwLen, BITMAPINFOHEADER bmiHeader, LPVOID lpUserValue);
// Ƶչص壨ʱ
typedef void (CALLBACK * BRAC_VideoDataEx_CallBack)(DWORD dwUserid, LPVOID lpBuf, DWORD dwLen, BITMAPINFOHEADER bmiHeader, DWORD dwTimeStamp, LPVOID lpUserValue);
// Ƶݻص
typedef void (CALLBACK * BRAC_AudioData_CallBack)(DWORD dwUserid, LPVOID lpBuf, DWORD dwLen, WAVEFORMATEX waveFormatEx, LPVOID lpUserValue);
// Ƶչص壨ʱ
typedef void (CALLBACK * BRAC_AudioDataEx_CallBack)(DWORD dwUserid, LPVOID lpBuf, DWORD dwLen, WAVEFORMATEX waveFormatEx, DWORD dwTimeStamp, LPVOID lpUserValue);
// Ϣص
typedef void (CALLBACK * BRAC_TextMessage_CallBack)(DWORD dwFromUserid, DWORD dwToUserid, BOOL bSecret, LPCTSTR lpMsgBuf, DWORD dwLen, LPVOID lpUserValue);
// ͸ͨݻص
typedef void (CALLBACK * BRAC_TransBuffer_CallBack)(DWORD dwUserid, LPBYTE lpBuf, DWORD dwLen, LPVOID lpUserValue);
// ͸ͨչص
typedef void (CALLBACK * BRAC_TransBufferEx_CallBack)(DWORD dwUserid, LPBYTE lpBuf, DWORD dwLen, DWORD wParam, DWORD lParam, DWORD dwTaskId, LPVOID lpUserValue);
// ļص
typedef void (CALLBACK * BRAC_TransFile_CallBack)(DWORD dwUserid, LPCTSTR lpFileName, LPCTSTR lpTempFilePath, DWORD dwFileLength, DWORD wParam, DWORD lParam, DWORD dwTaskId, LPVOID lpUserValue);
// 仯ص
typedef void (CALLBACK * BRAC_VolumeChange_CallBack)(BRAC_AudioDevice device, DWORD dwCurrentVolume, LPVOID lpUserValue);
// SDK Filter ͨݻص
typedef void (CALLBACK * BRAC_SDKFilterData_CallBack)(LPBYTE lpBuf, DWORD dwLen, LPVOID lpUserValue);
// ¼񡢿ɻص
typedef void (CALLBACK * BRAC_RecordSnapShot_CallBack)(DWORD dwUserid, LPCTSTR lpFileName, DWORD dwParam, BOOL bRecordType, LPVOID lpUserValue);
// 첽Ϣ֪ͨص
typedef void (CALLBACK* BRAC_NotifyMessage_CallBack)(DWORD dwNotifyMsg, DWORD wParam, DWORD lParam, LPVOID lpUserValue);
// ƵͨϢ֪ͨص
typedef void (CALLBACK * BRAC_VideoCallEvent_CallBack)(DWORD dwEventType, DWORD dwUserId, DWORD dwErrorCode, DWORD dwFlags, DWORD dwParam, LPCTSTR lpUserStr, LPVOID lpUserValue);


/**
 *	API
 */

// ȡSDK汾Ϣ
BRAC_API DWORD BRAC_GetSDKVersion(DWORD& dwMainVer, DWORD& dwSubVer, TCHAR* lpCompileTime, DWORD dwBufLen);
// رգSDK־
BRAC_API DWORD BRAC_ActiveCallLog(BOOL bActive);

// ÷֤루ֹǷûSDKӷϷûӣ
BRAC_API DWORD BRAC_SetServerAuthPass(LPCTSTR lpPassword);
// ʼϵͳ
BRAC_API DWORD BRAC_InitSDK(HWND hWnd, DWORD dwFuncMode);

// Ƶݻص
BRAC_API DWORD BRAC_SetVideoDataCallBack(BRAC_PixelFormat pixFmt, BRAC_VideoData_CallBack lpFunction, LPVOID lpUserValue=NULL);
// Ƶչصʱ
BRAC_API DWORD BRAC_SetVideoDataExCallBack(BRAC_PixelFormat pixFmt, BRAC_VideoDataEx_CallBack lpFunction, LPVOID lpUserValue=NULL);
// Ƶݻص
BRAC_API DWORD BRAC_SetAudioDataCallBack(BRAC_AudioData_CallBack lpFunction, LPVOID lpUserValue=NULL);
// Ƶݻصչʱ
BRAC_API DWORD BRAC_SetAudioDataExCallBack(BRAC_AudioDataEx_CallBack lpFunction, LPVOID lpUserValue=NULL);
// Ϣص
BRAC_API DWORD BRAC_SetTextMessageCallBack(BRAC_TextMessage_CallBack lpFunction, LPVOID lpUserValue=NULL);
// ͸ͨݻص
BRAC_API DWORD BRAC_SetTransBufferCallBack(BRAC_TransBuffer_CallBack lpFunction, LPVOID lpUserValue=NULL);
// ͸ͨչص
BRAC_API DWORD BRAC_SetTransBufferExCallBack(BRAC_TransBufferEx_CallBack lpFunction, LPVOID lpUserValue=NULL);
// ļص
BRAC_API DWORD BRAC_SetTransFileCallBack(BRAC_TransFile_CallBack lpFunction, LPVOID lpUserValue=NULL);
// 仯ص
BRAC_API DWORD BRAC_SetVolumeChangeCallBack(BRAC_VolumeChange_CallBack lpFunction, LPVOID lpUserValue=NULL);
// SDK Filterͨݻص
BRAC_API DWORD BRAC_SetSDKFilterDataCallBack(BRAC_SDKFilterData_CallBack lpFunction, LPVOID lpUserValue=NULL);
// ¼֪ͨص
BRAC_API DWORD BRAC_SetRecordSnapShotCallBack(BRAC_RecordSnapShot_CallBack lpFunction, LPVOID lpUserValue=NULL);
// 첽Ϣ֪ͨص
BRAC_API DWORD BRAC_SetNotifyMessageCallBack(BRAC_NotifyMessage_CallBack lpFunction, LPVOID lpUserValue=NULL);
// ƵͨϢ֪ͨص
BRAC_API DWORD BRAC_SetVideoCallEventCallBack(BRAC_VideoCallEvent_CallBack lpFunction, LPVOID lpUserValue=NULL);


// ӷ
BRAC_API DWORD BRAC_Connect(LPCTSTR lpServerAddr, DWORD dwPort);
// ¼ϵͳ
BRAC_API DWORD BRAC_Login(LPCTSTR lpUserName, LPCTSTR lpPassword, DWORD dwPassEncType);
// 뷿
BRAC_API DWORD BRAC_EnterRoom(DWORD dwRoomid, LPCTSTR lpRoomPass, DWORD dwPassEncType);
// 뷿
BRAC_API DWORD BRAC_EnterRoomEx(LPCTSTR lpRoomName, LPCTSTR lpRoomPass);
// 뿪
BRAC_API DWORD BRAC_LeaveRoom(DWORD dwRoomid);
// עϵͳ
BRAC_API DWORD BRAC_Logout(VOID);

// ͷԴ
BRAC_API DWORD BRAC_Release(VOID);

// ȡǰûб
BRAC_API DWORD BRAC_GetOnlineUser(LPDWORD lpUserIDArray, DWORD& dwUserNum);
// ѯûͷ״̬
BRAC_API DWORD BRAC_GetCameraState(DWORD dwUserid, DWORD& dwState);
// ѯû״̬
BRAC_API DWORD BRAC_GetSpeakState(DWORD dwUserid, DWORD& dwState);
// ѯû
BRAC_API DWORD BRAC_GetUserLevel(DWORD dwUserid, DWORD& dwLevel);
// ѯû
BRAC_API DWORD BRAC_GetUserName(DWORD dwUserid, TCHAR* lpUserName, DWORD dwLen);
// ѯ
BRAC_API DWORD BRAC_GetRoomName(DWORD dwRoomId, TCHAR* lpRoomName, DWORD dwLen);
// ʾƵڶԻ
BRAC_API DWORD BRAC_ShowLVProperty(HWND hParent, LPCTSTR szCaption=NULL, DWORD dwX=0, DWORD dwY=0);

// ѯָû״̬
BRAC_API DWORD BRAC_QueryUserState(DWORD dwUserId, int infoname, char FAR* infoval, int infolen);

// öٱƵɼ豸
BRAC_API DWORD BRAC_EnumVideoCapture(TCHAR** lpDeviceName, DWORD& dwDeviceNum);
// ѡָƵɼ豸
BRAC_API DWORD BRAC_SelectVideoCapture(LPCTSTR szCaptureName);
// ȡǰʹõƵɼ豸
BRAC_API DWORD BRAC_GetCurVideoCapture(TCHAR* lpDeviceName, DWORD dwLen);
// öٱƵɼ豸
BRAC_API DWORD BRAC_EnumAudioCapture(TCHAR** lpDeviceName, DWORD& dwDeviceNum);
// ѡָƵɼ豸
BRAC_API DWORD BRAC_SelectAudioCapture(LPCTSTR szCaptureName);
// ȡǰʹõƵɼ豸
BRAC_API DWORD BRAC_GetCurAudioCapture(TCHAR* lpDeviceName, DWORD dwLen);
// öٱƵ豸
BRAC_API DWORD BRAC_EnumAudioPlayback(TCHAR** lpDeviceName, DWORD& dwDeviceNum);
// ѡָƵ豸
BRAC_API DWORD BRAC_SelectAudioPlayback(LPCTSTR szDeviceName);
// ȡǰʹõƵ豸
BRAC_API DWORD BRAC_GetCurAudioPlayback(TCHAR* lpDeviceName, DWORD dwLen);

// ûƵ
BRAC_API DWORD BRAC_UserCameraControl(DWORD dwUserid, BOOL bOpen);
// û
BRAC_API DWORD BRAC_UserSpeakControl(DWORD dwUserid, BOOL bOpen);
// Ƶʾλ
BRAC_API DWORD BRAC_SetVideoPos(DWORD dwUserid, HWND hWnd, DWORD dwLeft, DWORD dwTop, DWORD dwRight, DWORD dwBottom);
// ػָûƵ
BRAC_API DWORD BRAC_RepaintVideo(DWORD dwUserId, HDC hDC);

// ȡָƵ豸ĵǰ
BRAC_API DWORD BRAC_AudioGetVolume(BRAC_AudioDevice device, DWORD& dwVolume);
// ָƵ豸
BRAC_API DWORD BRAC_AudioSetVolume(BRAC_AudioDevice device, DWORD dwVolume);

// ûƵ¼
BRAC_API DWORD BRAC_StreamRecordCtrl(DWORD dwUserId, BOOL bStartRecord, DWORD dwFlags, DWORD dwParam);
// ûƵץģգ
BRAC_API DWORD BRAC_SnapShot(DWORD dwUserId, DWORD dwFlags, DWORD dwParam);

// ͸ͨͻ
BRAC_API DWORD BRAC_TransBuffer(DWORD dwUserid, LPBYTE lpBuf, DWORD dwLen);
// ͸ͨͻչ
BRAC_API DWORD BRAC_TransBufferEx(DWORD dwUserid, LPBYTE lpBuf, DWORD dwLen, DWORD wParam, DWORD lParam, DWORD dwFlags, DWORD& dwTaskId);
// ļ
BRAC_API DWORD BRAC_TransFile(DWORD dwUserid, LPCTSTR lpLocalPathName, DWORD wParam, DWORD lParam, DWORD dwFlags, DWORD& dwTaskId);
// ѯϢ
BRAC_API DWORD BRAC_QueryTransTaskInfo(DWORD dwUserid, DWORD dwTaskId, int infoname, char FAR* infoval, int infolen);
// ȡ
BRAC_API DWORD BRAC_CancelTransTask(DWORD dwUserid, DWORD dwTaskId);
// ıϢ
BRAC_API DWORD BRAC_SendTextMessage(DWORD dwUserid, BOOL bSecret, LPCTSTR lpMsgBuf, DWORD dwLen);
// SDK Filter ͨ
BRAC_API DWORD BRAC_SendSDKFilterData(LPBYTE lpBuf, DWORD dwLen);

// ĵǰģʽ
BRAC_API DWORD BRAC_ChangeChatMode(DWORD dwChatMode);
// ȡָûǰģʽ
BRAC_API DWORD BRAC_GetUserChatMode(DWORD dwUserid, DWORD& dwChatMode);
// Է˽ģԷ˽
BRAC_API DWORD BRAC_PrivateChatRequest(DWORD dwUserid);
// ظԷ˽
BRAC_API DWORD BRAC_PrivateChatEcho(DWORD dwUserid, DWORD dwRequestid,BOOL bAccept);
// ظԷ˽չԸ룩
BRAC_API DWORD BRAC_PrivateChatEchoEx(DWORD dwUserid, DWORD dwRequestid,DWORD dwErrorCode);
// ˳ĳû˽ģ߽ĳûԼ˽б
BRAC_API DWORD BRAC_PrivateChatExit(DWORD dwUserid);

// SDKں˲
BRAC_API DWORD BRAC_SetSDKOption(int optname, const char FAR* optval, int optlen);
// SDKں˲״̬ѯ
BRAC_API DWORD BRAC_GetSDKOption(int optname, char FAR* optval, int optlen);

// 鲥ܿ
BRAC_API DWORD BRAC_MultiCastControl(LPCTSTR lpMultiCastAddr, DWORD dwPort, LPCTSTR lpNicAddr, DWORD dwTTL, DWORD dwFlags);

// ⲿƵʽ
BRAC_API DWORD BRAC_SetInputVideoFormat(BRAC_PixelFormat pixFmt, DWORD dwWidth, DWORD dwHeight, DWORD dwFps, DWORD dwFlags);
// ⲿƵ
BRAC_API DWORD BRAC_InputVideoData(LPBYTE lpVideoFrame, DWORD dwSize, DWORD dwTimeStamp);
// ⲿƵʽ
BRAC_API DWORD BRAC_SetInputAudioFormat(DWORD dwChannels, DWORD dwSamplesPerSec, DWORD dwBitsPerSample, DWORD dwFlags);
// ⲿƵ
BRAC_API DWORD BRAC_InputAudioData(LPBYTE lpSamples, DWORD dwSize, DWORD dwTimeStamp);

// ȡƵ
BRAC_API DWORD BRAC_FetchAudioPlayBuffer(LPBYTE lpSamples, DWORD dwSize, DWORD wParam);

// Զ̵
BRAC_API DWORD BRAC_RemoteDebug(DWORD dwUserId, DWORD dwDebugCode, DWORD dwParam=0, DWORD dwBufLen=0, char* szBuf=NULL);


// Ƶ¼ƣ󡢻ظҶϵȣ
BRAC_API DWORD BRAC_VideoCallControl(DWORD dwEventType, DWORD dwUserId, DWORD dwErrorCode, DWORD dwFlags=0, DWORD dwParam=0, LPCTSTR lpUserStr=NULL);

// ȡûIDб
BRAC_API DWORD BRAC_GetUserFriends(LPDWORD lpUserIDArray, DWORD& dwUserNum);
// ȡ״̬
BRAC_API DWORD BRAC_GetFriendStatus(DWORD dwFriendUserId, DWORD& dwStatus);
// ȡûIDб
BRAC_API DWORD BRAC_GetUserGroups(LPDWORD lpGroupIDArray, DWORD& dwGroupNum);
// ȡĺб
BRAC_API DWORD BRAC_GetGroupFriends(DWORD dwGroupId, LPDWORD lpUserIDArray, DWORD& dwUserNum);
// ȡûϢ
BRAC_API DWORD BRAC_GetUserInfo(DWORD dwUserId, DWORD dwInfoId, TCHAR* lpInfoValue, DWORD dwLen);
// ȡû
BRAC_API DWORD BRAC_GetGroupName(DWORD dwGroupId, TCHAR* lpGroupName, DWORD dwLen);
// ûϢ
BRAC_API DWORD BRAC_UserInfoControl(DWORD dwUserId, DWORD dwCtrlCode, DWORD wParam=0, DWORD lParam=0, LPCTSTR lpStrValue=NULL);



#endif //BR_ANYCHAT_CORE_SDK_H__INCLUDED_
