#if !defined(BR_ANYCHAT_SERVER_SDK_H__INCLUDED_)
#define BR_ANYCHAT_SERVER_SDK_H__INCLUDED_


/**
 *	AnyChat Server SDK Include File
 */


#pragma once


#define BRAS_API extern "C" __declspec(dllexport)

#define BRAS_SERVERAPPMSG_CONNECTED		1		///< AnyChatɹ
#define BRAS_SERVERAPPMSG_DISCONNECT	2		///< AnyChatϿ

// ϢͶ壨ص¼BRAS_OnServerAppMessageEx_CallBack 
#define BRAS_MESSAGE_CORESERVERCONN			10	///< ķϢwParamΪerrorcode
#define BRAS_MESSAGE_RECORDSERVERCONN		11	///< ¼ϢwParamΪerrorcodelParamΪrecordserverid
#define BRAS_MESSAGE_LOGINSERVERCONN		12	///< ¼ϢwParamΪerrorcodelParamΪloginserverid
#define BRAS_MESSAGE_ROOMSERVERCONN			13	///< 뷿ϢwParamΪerrorcodelParamΪroomserverid
#define BRAS_MESSAGE_MEDIASERVERCONN		14	///< ýϢwParamΪerrorcodelParamΪmediaserverid

// Ƶ¼Ͷ壨APIBRAS_VideoCallControl OnVideoCallEventص
#define BRAS_VIDEOCALL_EVENT_REQUEST    1        ///< 
#define BRAS_VIDEOCALL_EVENT_REPLY      2        ///< ظ
#define BRAS_VIDEOCALL_EVENT_START      3        ///< ƵлỰʼ¼
#define BRAS_VIDEOCALL_EVENT_FINISH     4        ///< ҶϣлỰ

// ûϢͶ壨APIBRAS_UserInfoControl OnUserInfoControlص
#define BRAS_USERINFO_CTRLCODE_KICKOUT		1	///< ָûϵͳߵ
#define BRAS_USERINFO_CTRLCODE_SYNCDATA		2	///< ָûͬͻ
#define BRAS_USERINFO_CTRLCODE_FUNCCTRL		3	///< ͻ˹ܿƣwParamΪܲ
#define BRAS_USERINFO_CTRLCODE_BLOCKIP		4	///< ֹIPַӷlpStrValueΪIPַַ֧ͨ*
#define BRAS_USERINFO_CTRLCODE_UNBLOCKIP	5	///< IPַӷlpStrValueΪIPַַ֧ͨ*

#define BRAS_USERINFO_CTRLCODE_ADDGROUP		20	///< û飬wParamΪIdlpStrValueΪ
#define BRAS_USERINFO_CTRLCODE_DELGROUP		21	///< ɾû飬wParamΪId
#define BRAS_USERINFO_CTRLCODE_ADDFRIEND	22	///< ûѣwParamΪId
#define BRAS_USERINFO_CTRLCODE_DELFRIEND	23	///< ɾûѣwParamΪId
#define BRAS_USERINFO_CTRLCODE_SETGROUPRELATION	24	///< úĹϵwParamΪIdlParamΪIdʾĳ

#define BRAS_USERINFO_CTRLCODE_APPDEFINE	100	///< ӦòԶʼָ

// ں˲ó壨APIBRAS_SetSDKOption 
#define BRAS_SO_RECORD_VIDEOBR				2	///< ¼ƵãΪintͣλbps
#define BRAS_SO_RECORD_AUDIOBR				3	///< ¼ƵãΪintͣλbps
#define BRAS_SO_RECORD_FILETYPE				4	///< ¼ļãΪintͣ 0 MP4[Ĭ], 1 WMV, 2 FLV, 3 MP3
#define BRAS_SO_RECORD_WIDTH				5	///< ¼ƵãΪintͣ磺320
#define BRAS_SO_RECORD_HEIGHT				6	///< ¼ļ߶ãΪintͣ磺240
#define BRAS_SO_RECORD_FILENAMERULE			7	///< ¼ļ򣨲Ϊintͣ

// ʼ־APIBRAS_InitSDK 
#define BRAS_INITFLAGS_MULTITHREADS		0x01	///< ߳ģʽ

// صͶ壨APIBRAS_SetCallBack 
#define BRAS_CBTYPE_APPMESSAGE				1	// ӦóϢص
#define BRAS_CBTYPE_APPMESSAGEEX			2	// ӦóϢչص
#define BRAS_CBTYPE_ONTIMER					3	// SDKʱص
#define BRAS_CBTYPE_VERIFYUSER				4	// û֤ص
#define BRAS_CBTYPE_PERPAREENTERROOM		5	// û뷿ص
#define BRAS_CBTYPE_USERLOGIN				6	// û¼ɹص
#define BRAS_CBTYPE_USERLOGOUT				7	// ûעص
#define BRAS_CBTYPE_USERLOGOUTEX			8	// ûעչص
#define BRAS_CBTYPE_USERENTERROOM			9	// û뷿ص
#define BRAS_CBTYPE_USERLEAVEROOM			10	// û뿪ص
#define BRAS_CBTYPE_FILTERDATA				11	// ϲҵԶݻص
#define BRAS_CBTYPE_TEXTMESSAGE				12	// ͨݻص
#define BRAS_CBTYPE_TRANSBUFFER				13	// ͸ͨݻص
#define BRAS_CBTYPE_TRANSBUFFEREX			14	// ͸ͨչص
#define BRAS_CBTYPE_TRANSFILE				15	// ļص
#define BRAS_CBTYPE_SERVERRECORD			16	// ¼ص
#define BRAS_CBTYPE_SERVERRECORDEX			17	// ¼չص
#define BRAS_CBTYPE_VIDEOCALL				18	// ƵͨϢ֪ͨص
#define BRAS_CBTYPE_USERINFOCTRL			19	// ûϢƻص


// ¼ܱ־壨APIBRAS_StreamRecordCtrl 
#define ANYCHAT_RECORD_FLAGS_VIDEO		0x00000001	// ¼Ƶ
#define ANYCHAT_RECORD_FLAGS_AUDIO		0x00000002	// ¼Ƶ
#define ANYCHAT_RECORD_FLAGS_SERVER		0x00000004	// ¼
#define ANYCHAT_RECORD_FLAGS_MIXAUDIO	0x00000010	// ¼Ƶʱ˵¼
#define ANYCHAT_RECORD_FLAGS_MIXVIDEO	0x00000020	// ¼Ƶʱ˵ƵӺ¼
#define ANYCHAT_RECORD_FLAGS_ABREAST	0x00000100	// ¼Ƶʱ˵Ƶ¼
#define ANYCHAT_RECORD_FLAGS_STEREO		0x00000200	// ¼Ƶʱ˵Ϊ¼
#define ANYCHAT_RECORD_FLAGS_SNAPSHOT	0x00000400	// 
#define ANYCHAT_RECORD_FLAGS_LOCALCB	0x00000800	// ػص
#define ANYCHAT_RECORD_FLAGS_STREAM		0x00001000	///< Ƶ¼ƣЧʸߣܴƵת⣩



// ӦóϢص
typedef void (CALLBACK* BRAS_OnServerAppMessage_CallBack)(DWORD dwMsg, LPVOID lpUserValue);
// ӦóϢչص
typedef void (CALLBACK* BRAS_OnServerAppMessageEx_CallBack)(DWORD dwNotifyMessage, DWORD wParam, DWORD lParam, LPVOID lpUserValue);
// SDKʱص壨ϲӦÿڸûصдʱ񣬶Ҫ⿪̣߳Ƕʱ
typedef void (CALLBACK* BRAS_OnTimerEvent_CallBack)(LPVOID lpUserValue);

// û֤ص
typedef DWORD (CALLBACK* BRAS_VerifyUser_CallBack)(IN LPCTSTR lpUserName,IN LPCTSTR lpPassword, OUT LPDWORD lpUserID, OUT LPDWORD lpUserLevel, OUT LPTSTR lpNickName,IN DWORD dwNCLen, LPVOID lpUserValue);
// û뷿ص
typedef DWORD (CALLBACK* BRAS_PrepareEnterRoom_CallBack)(DWORD dwUserId, DWORD dwRoomId, LPCTSTR lpRoomName,LPCTSTR lpPassword, LPVOID lpUserValue);
// û¼ɹص
typedef void (CALLBACK* BRAS_OnUserLoginAction_CallBack)(DWORD dwUserId, LPCTSTR szUserName, DWORD dwLevel, LPCTSTR szIpAddr, LPVOID lpUserValue);
// ûעص
typedef void (CALLBACK* BRAS_OnUserLogoutAction_CallBack)(DWORD dwUserId, LPVOID lpUserValue);
// ûעչص壨עĴ룩
typedef void (CALLBACK* BRAS_OnUserLogoutActionEx_CallBack)(DWORD dwUserId, DWORD dwErrorCode, LPVOID lpUserValue);
// û뷿ص
typedef void (CALLBACK* BRAS_OnUserEnterRoomAction_CallBack)(DWORD dwUserId, DWORD dwRoomId, LPVOID lpUserValue);
// û뿪ص
typedef void (CALLBACK* BRAS_OnUserLeaveRoomAction_CallBack)(DWORD dwUserId, DWORD dwRoomId, LPVOID lpUserValue);
// ϲҵԶݻص
typedef void (CALLBACK* BRAS_OnRecvUserFilterData_CallBack)(DWORD dwUserId, BYTE* lpBuf, DWORD dwLen, LPVOID lpUserValue);
// յûͨݻص
typedef void (CALLBACK* BRAS_OnRecvUserTextMsg_CallBack)(DWORD dwRoomId, DWORD dwSrcUserId, DWORD dwTarUserId, BOOL bSecret, LPCTSTR lpTextMessage, DWORD dwLen, LPVOID lpUserValue);
// ͸ͨݻص
typedef void (CALLBACK * BRAS_OnTransBuffer_CallBack)(DWORD dwUserId, LPBYTE lpBuf, DWORD dwLen, LPVOID lpUserValue);
// ͸ͨչص
typedef void (CALLBACK * BRAS_OnTransBufferEx_CallBack)(DWORD dwUserId, LPBYTE lpBuf, DWORD dwLen, DWORD wParam, DWORD lParam, DWORD dwTaskId, LPVOID lpUserValue);
// ļص
typedef void (CALLBACK * BRAS_OnTransFile_CallBack)(DWORD dwUserId, LPCTSTR lpFileName, LPCTSTR lpTempFilePath, DWORD dwFileLength, DWORD wParam, DWORD lParam, DWORD dwTaskId, LPVOID lpUserValue);
// ¼ص
typedef void (CALLBACK * BRAS_OnServerRecord_CallBack)(DWORD dwUserId, DWORD dwParam, DWORD dwRecordServerId, DWORD dwElapse, LPCTSTR lpRecordFileName, LPVOID lpUserValue);
// ¼ص壨չ
typedef void (CALLBACK * BRAS_OnServerRecordEx_CallBack)(DWORD dwUserId, LPCTSTR lpFileName, DWORD dwElapse, DWORD dwFlags, DWORD dwParam, LPCTSTR lpUserStr, DWORD dwRecordServerId, LPVOID lpUserValue);
// ƵͨϢ֪ͨص
typedef DWORD (CALLBACK * BRAS_OnVideoCallEvent_CallBack)(DWORD dwEventType, DWORD dwSrcUserId, DWORD dwTarUserId, DWORD dwErrorCode, DWORD dwFlags, DWORD dwParam, LPCTSTR lpUserStr, LPVOID lpUserValue);
// ûϢƻص
typedef DWORD (CALLBACK * BRAS_OnUserInfoControl_CallBack)(DWORD dwSendUserId, DWORD dwUserId, DWORD dwCtrlCode, DWORD wParam, DWORD lParam, LPCTSTR lpStrValue, LPVOID lpUserValue); 

/**
 *	API 
 */
// ÷ӦóϢص
BRAS_API DWORD BRAS_SetOnServerAppMessageCallBack(BRAS_OnServerAppMessage_CallBack lpFunction, LPVOID lpUserValue=NULL);
// ÷ӦóϢչص
BRAS_API DWORD BRAS_SetOnServerAppMessageExCallBack(BRAS_OnServerAppMessageEx_CallBack lpFunction, LPVOID lpUserValue=NULL);
// SDKʱصdwElapseʱλms
BRAS_API DWORD BRAS_SetTimerEventCallBack(DWORD dwElapse, BRAS_OnTimerEvent_CallBack lpFunction, LPVOID lpUserValue=NULL);

// û֤ص
BRAS_API DWORD BRAS_SetVerifyUserCallBack(BRAS_VerifyUser_CallBack lpFunction, LPVOID lpUserValue=NULL);
// û뷿ص
BRAS_API DWORD BRAS_SetPrepareEnterRoomCallBack(BRAS_PrepareEnterRoom_CallBack lpFunction, LPVOID lpUserValue=NULL);
// û¼ɹص
BRAS_API DWORD BRAS_SetOnUserLoginActionCallBack(BRAS_OnUserLoginAction_CallBack lpFunction, LPVOID lpUserValue=NULL);
// ûעص
BRAS_API DWORD BRAS_SetOnUserLogoutActionCallBack(BRAS_OnUserLogoutAction_CallBack lpFunction, LPVOID lpUserValue=NULL);
// ûעչص
BRAS_API DWORD BRAS_SetOnUserLogoutActionExCallBack(BRAS_OnUserLogoutActionEx_CallBack lpFunction, LPVOID lpUserValue=NULL);
// û뷿ص
BRAS_API DWORD BRAS_SetOnUserEnterRoomActionCallBack(BRAS_OnUserEnterRoomAction_CallBack lpFunction, LPVOID lpUserValue=NULL);
// û뿪ص
BRAS_API DWORD BRAS_SetOnUserLeaveRoomActionCallBack(BRAS_OnUserLeaveRoomAction_CallBack lpFunction, LPVOID lpUserValue=NULL);
// ûϲҵԶݻص
BRAS_API DWORD BRAS_SetOnRecvUserFilterDataCallBack(BRAS_OnRecvUserFilterData_CallBack lpFunction, LPVOID lpUserValue=NULL);
// ûͨݻص
BRAS_API DWORD BRAS_SetOnRecvUserTextMsgCallBack(BRAS_OnRecvUserTextMsg_CallBack lpFunction, LPVOID lpUserValue=NULL);
// ͸ͨݻص
BRAS_API DWORD BRAS_SetOnTransBufferCallBack(BRAS_OnTransBuffer_CallBack lpFunction, LPVOID lpUserValue=NULL);
// ͸ͨչص
BRAS_API DWORD BRAS_SetOnTransBufferExCallBack(BRAS_OnTransBufferEx_CallBack lpFunction, LPVOID lpUserValue=NULL);
// ļص
BRAS_API DWORD BRAS_SetOnTransFileCallBack(BRAS_OnTransFile_CallBack lpFunction, LPVOID lpUserValue=NULL);
// ÷¼֪ͨص
BRAS_API DWORD BRAS_SetOnServerRecordCallBack(BRAS_OnServerRecord_CallBack lpFunction, LPVOID lpUserValue=NULL);
// ƵͨϢ֪ͨص
BRAS_API DWORD BRAS_SetOnVideoCallEventCallBack(BRAS_OnVideoCallEvent_CallBack lpFunction, LPVOID lpUserValue=NULL);
// ûϢƻص
BRAS_API DWORD BRAS_SetOnUserInfoControlCallBack(BRAS_OnUserInfoControl_CallBack lpFunction, LPVOID lpUserValue=NULL);
// ûص
BRAS_API DWORD BRAS_SetCallBack(DWORD dwCBType, LPVOID lpFunction, LPVOID lpUserValue=NULL);

// ȡSDK汾Ϣ
BRAS_API DWORD BRAS_GetSDKVersion(DWORD& dwMainVer, DWORD& dwSubVer, TCHAR* lpCompileTime, DWORD dwBufLen);
// ʼSDK
BRAS_API DWORD BRAS_InitSDK(DWORD dwReserved);
// ͷԴ
BRAS_API DWORD BRAS_Release(void);

// ָû
BRAS_API DWORD BRAS_SendBufToUser(DWORD dwUserId, LPCTSTR lpBuf, DWORD dwLen);
// ָû
BRAS_API DWORD BRAS_SendBufToRoom(DWORD dwRoomId, LPCTSTR lpBuf, DWORD dwLen);

// ָû͸ͨ
BRAS_API DWORD BRAS_TransBuffer(DWORD dwUserId, LPBYTE lpBuf, DWORD dwLen);
// ָûչ
BRAS_API DWORD BRAS_TransBufferEx(DWORD dwUserId, LPBYTE lpBuf, DWORD dwLen, DWORD wParam, DWORD lParam, DWORD dwFlags, DWORD& dwTaskId);
// ָûļ
BRAS_API DWORD BRAS_TransFile(DWORD dwUserId, LPCTSTR lpLocalPathName, DWORD wParam, DWORD lParam, DWORD dwFlags, DWORD& dwTaskId);

// Ķ¼
BRAS_API DWORD BRAS_StreamRecordCtrl(DWORD dwUserId, BOOL bStartRecord, DWORD dwFlags, DWORD dwParam, DWORD dwRecordServerId);
// Ķ¼ƣչ
BRAS_API DWORD BRAS_StreamRecordCtrlEx(DWORD dwUserId, BOOL bStartRecord, DWORD dwFlags, DWORD dwParam, LPCTSTR lpUserStr=NULL, DWORD dwRecordServerId=-1);
// ͸ͨݸ¼
BRAS_API DWORD BRAS_TransBuffer2RecordServer(DWORD dwUserId, LPBYTE lpBuf, DWORD dwLen, DWORD dwParam, DWORD dwRecordServerId);

// Ƶ¼ƣ󡢻ظҶϵȣ
BRAS_API DWORD BRAS_VideoCallControl(DWORD dwEventType, DWORD dwUserId, DWORD dwErrorCode, DWORD dwFlags=0, DWORD dwParam=0, LPCTSTR lpUserStr=NULL);

// ûϸϢ
BRAS_API DWORD BRAS_SetUserInfo(DWORD dwUserId, DWORD dwInfoId, LPCTSTR lpInfoValue, DWORD dwFlags=0);
// ȡûϸϢ
BRAS_API DWORD BRAS_GetUserInfo(DWORD dwUserId, DWORD dwInfoId, TCHAR* lpInfoValue, DWORD dwSize);
// ûϢ
BRAS_API DWORD BRAS_UserInfoControl(DWORD dwUserId, DWORD dwCtrlCode, DWORD wParam=0, DWORD lParam=0, LPCTSTR lpStrValue=NULL);

// SDKں˲
BRAS_API DWORD BRAS_SetSDKOption(DWORD optname, CHAR* optval, DWORD optlen);



#endif //BR_ANYCHAT_SERVER_SDK_H__INCLUDED_