const withIs = require('class-is');
const path = require('path')


//const ffplay_addon = require('prebuildify-load')(path.join(__dirname, '..'))
const { EventEmitter } = require('events');
/**
 * 播放中的错误代码
 * @type {Object}
 * @property {number} UnkownError - 未知错误
 */
const FFPlayerError = {
  UnkownError: -1,
}
var ffplayer
class FFPlayer extends EventEmitter {
  /**
  * FFPlayer
  * @constructor
  * @param {string} cmd - 播放命令行
  * @example <caption>模块用法示例.</caption>
  * const FFPlayer = require("@mingjie/ffplayer")
  * 
  * ff = new FFPlayer("xx/xx/xx.mp4")
  * 
  * ff.on('yuv', (frame)=>{ //frame的类型为YUVFrame
  *    //在此处处理yuv数据
  * });
  * obj.on('log', ({ msg, level }) => {
  * 	console.log('log:', level, msg)
  *     //level 1:fatal 2:error 3:warning 4:info 5.verbose
  *	})
  * ff.on('error',(errorcode)=>{
  *   //errorcode播放中的错误代码,按照FFPlayerError取值
  * })
  * 
  * ff.on('done',()=>{
  *   //播放完成处理
  * })
  * 
  * async function asyncTest(){
  *   let {result,info} = await ff.play()
  *   if (!result) return false
  * 
  *   if (!await ff.mute()){
  *     //错误处理
  *   }
  * 
  *   //其余接口调用方法类似
  *   // ff.unmute()
  *   // ff.setVolume(50)
  *   // ff.pause()
  *   // ff.seek(1000)
  *   // ff.stop()
  * }
  * asyncTest()
  */
  constructor(cmdStr, logPath = '', addonPath = '') {
    super()
    console.log('ffplayer index.js constructor cmdStr:', cmdStr, 'logPath:', logPath, 'addonPath:', addonPath)
    var ffplay_addon = null
    if (addonPath) { ffplay_addon = require(addonPath) } else { ffplay_addon = require('node-gyp-build')(path.join(__dirname, '..')) }
    console.log('ffplayer index.js constructor ffplay_addon:', ffplay_addon)
    if (!ffplayer) { ffplayer = new ffplay_addon() }
    ffplayer.StartWorker(cmdStr, (event, obj) => {
      this.emit(event, obj)
    }, logPath)
    console.log('ffplayer index.js constructor ffplayer:', ffplayer)
  }



  /**
   * 播放/恢复,可多次调用,第一次调用是开始播放,之后的调用是从暂停状态恢复播放(进度保持)
   * @async
   * @function
   * @return {Promise<boolean, VideoInfo>} 正常返回视频信息 true和VideoInfo对象,错误返回false和undefined
   */
  play () {
    var isSuccess = false
    var info = {}
    isSuccess = ffplayer.Play()
    if (isSuccess) {
      info = ffplayer.GetInfo()
    }
    return new Promise(function (resolve, reject) {
      var obj = { result: isSuccess, info: info }
      resolve(obj)
    })
  }
  /**
   * 暂停播放,需要play调用成功后调用
   * @async
   * @function
   * @return {{Promise<boolen>} 正常返回true,错误返回错误信息
   */
  pause () {
    var isSuccess = ffplayer.Pause()
    return new Promise(function (resolve, reject) {
      resolve(isSuccess)
    })
  }
  /**
   * 停止播放,需要play调用成功后调用,并且停止以后,对象销毁无法再次进行播放;调用成功返回前会触发done事件
   * @async
   * @function
   * @return {Promise<boolen>} 正常返回true,错误返回false
   */
  stop () {
    var isSuccess = ffplayer.Stop()
    return new Promise(function (resolve, reject) {
      resolve(isSuccess)
    })
  }
  /**
   * 设置静音,需要play调用成功后调用
   * @async
   * @function
   * @return {Promise<boolen>} 正常返回true,错误返回false
   */
  mute () {
    var isSuccess = ffplayer.SetMute(true)
    return new Promise(function (resolve, reject) {
      resolve(isSuccess)
    })
  }
  /**
   * 取消静音,需要play调用成功后调用
   * @async
   * @function
   * @return {Promise<boolen>} 正常返回true,错误返回false
   */
  unmute () {
    var isSuccess = ffplayer.SetMute(false)
    return new Promise(function (resolve, reject) {
      resolve(isSuccess)
    })
  }
  /**
   * 设置音量,需要play调用成功后调用
   * @async
   * @function
   * @param {number}	volume - 代表音量值 范围在0~100
   * @return {Promise<boolen>} 正常返回true,错误返回false
   */
  setVolume (volume) {
    this.volume = volume
    var isSuccess = ffplayer.SetVolume(volume)
    return new Promise(function (resolve, reject) {
      resolve(isSuccess)
    })
  }
  /**
   * 获取音量,需要play调用成功后调用
   * @async
   * @function
   * @return {Promise<number>}	调用总是成功,正常返回音量值在0~100
  */
  getVolume () {
    return this.volume
  }
  /**
   * 设置进度,需要play调用成功后调用
   * @async
   * @function
   * @param {number}	ms - 代表跳到哪一毫秒,其值小于等于VideoInfo 中的duration
   * @return {Promise<boolen>}  正常返回true,错误返回false
   */
  seek (ms) {
    var isSuccess = ffplayer.Seek(ms)
    return new Promise(function (resolve, reject) {
      resolve(isSuccess)
    })
  }

  /**
   * 发送命令,需要play调用成功后调用
   * @async
   * @function
   * @param {number}	fileType - 0:视频 1:音频
   * @param {number}	filterName 过滤名
   * @param {string}	command  命令
   * @param {string}	arg 命令参数
   * @return {Promise<boolen>}  正常返回true,错误返回false
   */
  sendCommand (fileType, filterName, command, arg) {
    var isSuccess = ffplayer.SendCommand(fileType, filterName, command, arg)
    return new Promise(function (resolve, reject) {
      resolve(isSuccess)
    })
  }

}

/**
 * 发送实时yuv数据，默认支持yuv420p
 * @global
 * @type {object} 
 * @property {Array<number>} y - Y分量
 * @property {Array<number>} u - U分量
 * @property {Array<number>} v - V分量
 * @property {number} ystride  - Y分量步长
 * @property {number} uvstride - U/V分量步长
 * @property {number} width - 宽度,像素
 * @property {number} height - 高度,像素
 * @property {number} pts - 当前帧显示时戳信息,毫秒
 * @property {number} colorRange - 颜色范围
 * @property {number} colorSpace - 颜色空间
 * @property {number} sarNum
 * @property {number} sarDen
 */
YUVFrame = {
  y: new Uint8Array(),
  u: new Uint8Array(),
  v: new Uint8Array(),
  ystride: 0,
  uvstride: 0,
  width: 0,
  height: 0,
  pts: 0,
  colorRange: 0,
  colorSpace: 0,
  sarNum: 0,
  sarDen: 0
}
/**
 * @global
 * @type {Object}
 * @property {number} duration - 总时长，毫秒
 * @property {number} width - 画布宽,像素
 * @property {number} height - 画布高,像素
 */
VideoInfo = {
  duration: 0,
  width: 0,
  height: 0
}

module.exports = withIs(FFPlayer, {
  className: 'FFPlayer',
  symbolName: '@org/package-x/FFPlayer',
});
//module.exports = FFPlayer;

