DROP TABLE IF EXISTS `rtmp_live_info`;
CREATE TABLE `rtmp_live_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `created_date` datetime DEFAULT NULL,
  `publish_status` bit(1) DEFAULT NULL,
  `record_status` bit(1) DEFAULT NULL,
  `app_name` varchar(255) DEFAULT NULL,
  `record_enable` bit(1) DEFAULT NULL,
  `record_type` bit(1) DEFAULT NULL,
  `live_type` bit(1) DEFAULT NULL,
  `rtmp_url` varchar(255) DEFAULT NULL,
  `data_folder` varchar(255) DEFAULT NULL,
  `record_append` bit(1) DEFAULT NULL,
  PRIMARY KEY (`Id`)
)ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `hk_live_info`;
CREATE TABLE `hk_live_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `user_name` varchar(255) DEFAULT NULL,
  `pass_word` varchar(255) DEFAULT NULL,
  `ip` varchar(255) DEFAULT NULL,
  `port` int(11) DEFAULT NULL,
  `rtmp_url` varchar(255) DEFAULT NULL,
  `live_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`Id`)
)ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `general_device_info`;
CREATE TABLE `general_device_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `card_index` int(11) DEFAULT NULL,
  `width` int(11) DEFAULT NULL,
  `height` int(11) DEFAULT NULL,
  `remote_rtmp` bit(1) DEFAULT NULL,
  `rtmp_url` varchar(255) DEFAULT NULL,
  `rtmp_stream_name` varchar(255) DEFAULT NULL,
  `rtmp_local_app_name` varchar(255) DEFAULT NULL,
  `rtmp_local_stream_name` varchar(255) DEFAULT NULL,
  `bps` int(11) DEFAULT NULL,
  `frame_num` int(11) DEFAULT NULL,
  `use_audio` bit(1) DEFAULT NULL,
  `audio_device` varchar(255) DEFAULT NULL,
  `audio_line` varchar(255) DEFAULT NULL,
  `audio_volumn` int(11) DEFAULT NULL,
  `audio_sr` int(11) DEFAULT NULL,
  `audio_br` int(11) DEFAULT NULL,
  `audio_stereo` bit(1) DEFAULT NULL,
  PRIMARY KEY (`Id`)
)ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `live_record_info`;
CREATE TABLE `live_record_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `live_id` int(11) DEFAULT NULL,
  `start_time` varchar(255) DEFAULT NULL,
  `end_time` varchar(255) DEFAULT NULL,
  `days_of_week` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL, 
  PRIMARY KEY (`Id`)
)ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `tm_device_info`;
CREATE TABLE `tm_device_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `card_index` int(11) DEFAULT NULL,
  `width` int(11) DEFAULT NULL,
  `height` int(11) DEFAULT NULL,
  `fps` int(11) DEFAULT NULL,
  `remote_rtmp` bit(1) DEFAULT NULL,
  `rtmp_url` varchar(255) DEFAULT NULL,
  `rtmp_stream_name` varchar(255) DEFAULT NULL,
  `rtmp_local_app_name` varchar(255) DEFAULT NULL,
  `rtmp_local_stream_name` varchar(255) DEFAULT NULL,
  `bps` int(11) DEFAULT NULL,
  `frame_num` int(11) DEFAULT NULL, 
  PRIMARY KEY (`Id`)
)ENGINE=MyISAM DEFAULT CHARSET=utf8;