/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.DontCareFieldPosition;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.spi.NumberFormatProvider;
import java.util.Currency;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import sun.util.LocaleServiceProviderPool;
import sun.util.resources.LocaleData;

public abstract class NumberFormat
extends Format {
    public static final int INTEGER_FIELD = 0;
    public static final int FRACTION_FIELD = 1;
    private static final Hashtable cachedLocaleData = new Hashtable(3);
    private static final int NUMBERSTYLE = 0;
    private static final int CURRENCYSTYLE = 1;
    private static final int PERCENTSTYLE = 2;
    private static final int SCIENTIFICSTYLE = 3;
    private static final int INTEGERSTYLE = 4;
    private boolean groupingUsed = true;
    private byte maxIntegerDigits = (byte)40;
    private byte minIntegerDigits = 1;
    private byte maxFractionDigits = (byte)3;
    private byte minFractionDigits = 0;
    private boolean parseIntegerOnly = false;
    private int maximumIntegerDigits = 40;
    private int minimumIntegerDigits = 1;
    private int maximumFractionDigits = 3;
    private int minimumFractionDigits = 0;
    static final int currentSerialVersion = 1;
    private int serialVersionOnStream = 1;
    static final long serialVersionUID = -2308460125733713944L;

    protected NumberFormat() {
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (object instanceof Long || object instanceof Integer || object instanceof Short || object instanceof Byte || object instanceof AtomicInteger || object instanceof AtomicLong || object instanceof BigInteger && ((BigInteger)object).bitLength() < 64) {
            return this.format(((Number)object).longValue(), stringBuffer, fieldPosition);
        }
        if (object instanceof Number) {
            return this.format(((Number)object).doubleValue(), stringBuffer, fieldPosition);
        }
        throw new IllegalArgumentException("Cannot format given Object as a Number");
    }

    @Override
    public final Object parseObject(String string, ParsePosition parsePosition) {
        return this.parse(string, parsePosition);
    }

    public final String format(double d) {
        String string = this.fastFormat(d);
        if (string != null) {
            return string;
        }
        return this.format(d, new StringBuffer(), DontCareFieldPosition.INSTANCE).toString();
    }

    String fastFormat(double d) {
        return null;
    }

    public final String format(long l) {
        return this.format(l, new StringBuffer(), DontCareFieldPosition.INSTANCE).toString();
    }

    public abstract StringBuffer format(double var1, StringBuffer var3, FieldPosition var4);

    public abstract StringBuffer format(long var1, StringBuffer var3, FieldPosition var4);

    public abstract Number parse(String var1, ParsePosition var2);

    public Number parse(String string) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        Number number = this.parse(string, parsePosition);
        if (parsePosition.index == 0) {
            throw new ParseException("Unparseable number: \"" + string + "\"", parsePosition.errorIndex);
        }
        return number;
    }

    public boolean isParseIntegerOnly() {
        return this.parseIntegerOnly;
    }

    public void setParseIntegerOnly(boolean bl) {
        this.parseIntegerOnly = bl;
    }

    public static final NumberFormat getInstance() {
        return NumberFormat.getInstance(Locale.getDefault(Locale.Category.FORMAT), 0);
    }

    public static NumberFormat getInstance(Locale locale) {
        return NumberFormat.getInstance(locale, 0);
    }

    public static final NumberFormat getNumberInstance() {
        return NumberFormat.getInstance(Locale.getDefault(Locale.Category.FORMAT), 0);
    }

    public static NumberFormat getNumberInstance(Locale locale) {
        return NumberFormat.getInstance(locale, 0);
    }

    public static final NumberFormat getIntegerInstance() {
        return NumberFormat.getInstance(Locale.getDefault(Locale.Category.FORMAT), 4);
    }

    public static NumberFormat getIntegerInstance(Locale locale) {
        return NumberFormat.getInstance(locale, 4);
    }

    public static final NumberFormat getCurrencyInstance() {
        return NumberFormat.getInstance(Locale.getDefault(Locale.Category.FORMAT), 1);
    }

    public static NumberFormat getCurrencyInstance(Locale locale) {
        return NumberFormat.getInstance(locale, 1);
    }

    public static final NumberFormat getPercentInstance() {
        return NumberFormat.getInstance(Locale.getDefault(Locale.Category.FORMAT), 2);
    }

    public static NumberFormat getPercentInstance(Locale locale) {
        return NumberFormat.getInstance(locale, 2);
    }

    static final NumberFormat getScientificInstance() {
        return NumberFormat.getInstance(Locale.getDefault(Locale.Category.FORMAT), 3);
    }

    static NumberFormat getScientificInstance(Locale locale) {
        return NumberFormat.getInstance(locale, 3);
    }

    public static Locale[] getAvailableLocales() {
        LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(NumberFormatProvider.class);
        return localeServiceProviderPool.getAvailableLocales();
    }

    public int hashCode() {
        return this.maximumIntegerDigits * 37 + this.maxFractionDigits;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        NumberFormat numberFormat = (NumberFormat)object;
        return this.maximumIntegerDigits == numberFormat.maximumIntegerDigits && this.minimumIntegerDigits == numberFormat.minimumIntegerDigits && this.maximumFractionDigits == numberFormat.maximumFractionDigits && this.minimumFractionDigits == numberFormat.minimumFractionDigits && this.groupingUsed == numberFormat.groupingUsed && this.parseIntegerOnly == numberFormat.parseIntegerOnly;
    }

    @Override
    public Object clone() {
        NumberFormat numberFormat = (NumberFormat)super.clone();
        return numberFormat;
    }

    public boolean isGroupingUsed() {
        return this.groupingUsed;
    }

    public void setGroupingUsed(boolean bl) {
        this.groupingUsed = bl;
    }

    public int getMaximumIntegerDigits() {
        return this.maximumIntegerDigits;
    }

    public void setMaximumIntegerDigits(int n) {
        this.maximumIntegerDigits = Math.max(0, n);
        if (this.minimumIntegerDigits > this.maximumIntegerDigits) {
            this.minimumIntegerDigits = this.maximumIntegerDigits;
        }
    }

    public int getMinimumIntegerDigits() {
        return this.minimumIntegerDigits;
    }

    public void setMinimumIntegerDigits(int n) {
        this.minimumIntegerDigits = Math.max(0, n);
        if (this.minimumIntegerDigits > this.maximumIntegerDigits) {
            this.maximumIntegerDigits = this.minimumIntegerDigits;
        }
    }

    public int getMaximumFractionDigits() {
        return this.maximumFractionDigits;
    }

    public void setMaximumFractionDigits(int n) {
        this.maximumFractionDigits = Math.max(0, n);
        if (this.maximumFractionDigits < this.minimumFractionDigits) {
            this.minimumFractionDigits = this.maximumFractionDigits;
        }
    }

    public int getMinimumFractionDigits() {
        return this.minimumFractionDigits;
    }

    public void setMinimumFractionDigits(int n) {
        this.minimumFractionDigits = Math.max(0, n);
        if (this.maximumFractionDigits < this.minimumFractionDigits) {
            this.maximumFractionDigits = this.minimumFractionDigits;
        }
    }

    public Currency getCurrency() {
        throw new UnsupportedOperationException();
    }

    public void setCurrency(Currency currency) {
        throw new UnsupportedOperationException();
    }

    public RoundingMode getRoundingMode() {
        throw new UnsupportedOperationException();
    }

    public void setRoundingMode(RoundingMode roundingMode) {
        throw new UnsupportedOperationException();
    }

    private static NumberFormat getInstance(Locale locale, int n) {
        Object object;
        Object object2;
        LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(NumberFormatProvider.class);
        if (localeServiceProviderPool.hasProviders() && (object2 = (NumberFormat)localeServiceProviderPool.getLocalizedObject((LocaleServiceProviderPool.LocalizedObjectGetter)NumberFormatGetter.INSTANCE, locale, new Object[]{n})) != null) {
            return object2;
        }
        object2 = (String[])cachedLocaleData.get(locale);
        if (object2 == null) {
            object = LocaleData.getNumberFormatData(locale);
            object2 = ((ResourceBundle)object).getStringArray("NumberPatterns");
            cachedLocaleData.put(locale, object2);
        }
        object = DecimalFormatSymbols.getInstance(locale);
        int n2 = n == 4 ? 0 : n;
        DecimalFormat decimalFormat = new DecimalFormat(object2[n2], (DecimalFormatSymbols)object);
        if (n == 4) {
            decimalFormat.setMaximumFractionDigits(0);
            decimalFormat.setDecimalSeparatorAlwaysShown(false);
            decimalFormat.setParseIntegerOnly(true);
        } else if (n == 1) {
            decimalFormat.adjustForCurrencyDefaultFractionDigits();
        }
        return decimalFormat;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            this.maximumIntegerDigits = this.maxIntegerDigits;
            this.minimumIntegerDigits = this.minIntegerDigits;
            this.maximumFractionDigits = this.maxFractionDigits;
            this.minimumFractionDigits = this.minFractionDigits;
        }
        if (this.minimumIntegerDigits > this.maximumIntegerDigits || this.minimumFractionDigits > this.maximumFractionDigits || this.minimumIntegerDigits < 0 || this.minimumFractionDigits < 0) {
            throw new InvalidObjectException("Digit count range invalid");
        }
        this.serialVersionOnStream = 1;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.maxIntegerDigits = (byte)(this.maximumIntegerDigits > 127 ? 127 : (byte)this.maximumIntegerDigits);
        this.minIntegerDigits = (byte)(this.minimumIntegerDigits > 127 ? 127 : (byte)this.minimumIntegerDigits);
        this.maxFractionDigits = (byte)(this.maximumFractionDigits > 127 ? 127 : (byte)this.maximumFractionDigits);
        this.minFractionDigits = (byte)(this.minimumFractionDigits > 127 ? 127 : (byte)this.minimumFractionDigits);
        objectOutputStream.defaultWriteObject();
    }

    private static class NumberFormatGetter
    implements LocaleServiceProviderPool.LocalizedObjectGetter<NumberFormatProvider, NumberFormat> {
        private static final NumberFormatGetter INSTANCE = new NumberFormatGetter();

        private NumberFormatGetter() {
        }

        public NumberFormat getObject(NumberFormatProvider numberFormatProvider, Locale locale, String string, Object ... objectArray) {
            assert (objectArray.length == 1);
            int n = (Integer)objectArray[0];
            switch (n) {
                case 0: {
                    return numberFormatProvider.getNumberInstance(locale);
                }
                case 2: {
                    return numberFormatProvider.getPercentInstance(locale);
                }
                case 1: {
                    return numberFormatProvider.getCurrencyInstance(locale);
                }
                case 4: {
                    return numberFormatProvider.getIntegerInstance(locale);
                }
            }
            assert (false) : n;
            return null;
        }
    }

    public static class Field
    extends Format.Field {
        private static final long serialVersionUID = 7494728892700160890L;
        private static final Map instanceMap = new HashMap(11);
        public static final Field INTEGER = new Field("integer");
        public static final Field FRACTION = new Field("fraction");
        public static final Field EXPONENT = new Field("exponent");
        public static final Field DECIMAL_SEPARATOR = new Field("decimal separator");
        public static final Field SIGN = new Field("sign");
        public static final Field GROUPING_SEPARATOR = new Field("grouping separator");
        public static final Field EXPONENT_SYMBOL = new Field("exponent symbol");
        public static final Field PERCENT = new Field("percent");
        public static final Field PERMILLE = new Field("per mille");
        public static final Field CURRENCY = new Field("currency");
        public static final Field EXPONENT_SIGN = new Field("exponent sign");

        protected Field(String string) {
            super(string);
            if (this.getClass() == Field.class) {
                instanceMap.put(string, this);
            }
        }

        @Override
        protected Object readResolve() throws InvalidObjectException {
            if (this.getClass() != Field.class) {
                throw new InvalidObjectException("subclass didn't correctly implement readResolve");
            }
            Object v = instanceMap.get(this.getName());
            if (v != null) {
                return v;
            }
            throw new InvalidObjectException("unknown attribute name");
        }
    }
}

