/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.ts;

import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.expr.Constant;
import com.googlecode.dex2jar.ir.expr.Exprs;
import com.googlecode.dex2jar.ir.expr.Local;
import com.googlecode.dex2jar.ir.expr.PhiExpr;
import com.googlecode.dex2jar.ir.expr.Value;
import com.googlecode.dex2jar.ir.stmt.AssignStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.ts.Cfg;
import com.googlecode.dex2jar.ir.ts.Transformer;
import com.googlecode.dex2jar.ir.ts.UniqueQueue;
import java.util.HashSet;
import java.util.Set;

public class ConstTransformer
implements Transformer {
    @Override
    public void transform(IrMethod m) {
        this.init(m);
        this.collect(m);
        this.markConstant(m);
        this.markReplacable(m);
        this.replace(m);
        this.clean(m);
    }

    private void clean(IrMethod m) {
        for (Local local : m.locals) {
            local.tag = null;
        }
    }

    private void replace(IrMethod m) {
        Cfg.travelMod(m.stmts, new Cfg.TravelCallBack(){

            @Override
            public Value onUse(Local v) {
                ConstAnalyzeValue cav = (ConstAnalyzeValue)v.tag;
                if (cav.replacable) {
                    return Exprs.nConstant(cav.cst);
                }
                return v;
            }

            @Override
            public Value onAssign(Local v, AssignStmt as) {
                ConstAnalyzeValue cav = (ConstAnalyzeValue)v.tag;
                if (cav.replacable && as.op2.trim().vt != Value.VT.CONSTANT) {
                    as.op2 = Exprs.nConstant(cav.cst);
                }
                return v;
            }
        }, true);
    }

    private void markReplacable(IrMethod m) {
        for (Local local : m.locals) {
            ConstAnalyzeValue cav = (ConstAnalyzeValue)local.tag;
            if (!Boolean.TRUE.equals(cav.isConst)) continue;
            boolean allTosAreCst = true;
            for (ConstAnalyzeValue c : cav.assignTo) {
                if (Boolean.TRUE.equals(c.isConst)) continue;
                allTosAreCst = false;
                break;
            }
            if (!allTosAreCst) continue;
            cav.replacable = true;
        }
    }

    private void markConstant(IrMethod m) {
        UniqueQueue queue = new UniqueQueue();
        queue.addAll(m.locals);
        while (!queue.isEmpty()) {
            ConstAnalyzeValue cav = (ConstAnalyzeValue)((Local)queue.poll()).tag;
            Object cst = cav.cst;
            if (cav.isConst == null && cst != null) {
                boolean allCstEquals = true;
                for (ConstAnalyzeValue p0 : cav.assignFrom) {
                    if (cst.equals(p0.cst)) continue;
                    allCstEquals = false;
                    break;
                }
                if (allCstEquals) {
                    cav.isConst = true;
                }
            }
            if (cst != null || Boolean.TRUE.equals(cav.isConst)) {
                for (ConstAnalyzeValue p0 : cav.assignTo) {
                    if (p0.isConst != null) continue;
                    if (p0.cst == null) {
                        p0.cst = cst;
                    }
                    queue.add(p0.local);
                }
            }
            if (!Boolean.FALSE.equals(cav.isConst)) continue;
            cav.cst = null;
            for (ConstAnalyzeValue c : cav.assignTo) {
                if (Boolean.FALSE.equals(c.isConst)) continue;
                c.cst = null;
                c.isConst = false;
                queue.add(c.local);
            }
        }
    }

    private void collect(IrMethod m) {
        for (Stmt p = m.stmts.getFirst(); p != null; p = p.getNext()) {
            if (p.st != Stmt.ST.ASSIGN && p.st != Stmt.ST.IDENTITY) continue;
            Stmt.E2Stmt e2 = (Stmt.E2Stmt)p;
            Value op1 = e2.op1.trim();
            Value op2 = e2.op2.trim();
            if (op1.vt != Value.VT.LOCAL) continue;
            ConstAnalyzeValue cav = (ConstAnalyzeValue)((Local)op1).tag;
            if (op2.vt == Value.VT.CONSTANT) {
                Constant c = (Constant)op2;
                cav.isConst = true;
                cav.cst = c.value;
                continue;
            }
            if (op2.vt == Value.VT.LOCAL) {
                Local local2 = (Local)op2;
                ConstAnalyzeValue zaf2 = (ConstAnalyzeValue)local2.tag;
                cav.assignFrom.add(zaf2);
                zaf2.assignTo.add(cav);
                continue;
            }
            if (op2.vt == Value.VT.PHI) {
                PhiExpr pe = (PhiExpr)op2;
                for (Value v : pe.ops) {
                    ConstAnalyzeValue zaf2 = (ConstAnalyzeValue)((Local)v.trim()).tag;
                    cav.assignFrom.add(zaf2);
                    zaf2.assignTo.add(cav);
                }
                continue;
            }
            cav.isConst = Boolean.FALSE;
        }
    }

    private void init(IrMethod m) {
        for (Local local : m.locals) {
            local.tag = new ConstAnalyzeValue(local);
        }
    }

    static class ConstAnalyzeValue {
        private static final Integer ZERO = 0;
        public final Local local;
        public Boolean isConst = null;
        public boolean replacable = false;
        public Object cst;
        public Set<ConstAnalyzeValue> assignFrom = new HashSet<ConstAnalyzeValue>(3);
        public Set<ConstAnalyzeValue> assignTo = new HashSet<ConstAnalyzeValue>(3);

        public ConstAnalyzeValue(Local local) {
            this.local = local;
        }

        public boolean isZero() {
            if (this.isConst == null) {
                return false;
            }
            return this.isConst != false && ZERO.equals(this.cst);
        }
    }
}

