﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Net;
using ArcheBuddy.Bot.Classes;

namespace ArcheBuddy
{
    public partial class ControlForm : Form
    {
        Core core;
        Client client;
        double prevX = 0;
        double prevY = 0;

        double prevX2 = 0;
        double prevY2 = 0;


        public ControlForm(Core core)
        {
            this.core = core;

            InitializeComponent();
            client = new Client(IPAddress.Loopback, 5000);
            

        }

        private void ControlForm_Load(object sender, EventArgs e)
        {

        }

        private void cb_sendPosition_CheckedChanged(object sender, EventArgs e)
        {
            timer_sendPosition.Enabled = cb_sendPosition.Checked; 
        }

        private void timer_sendPosition_Tick(object sender, EventArgs e) 
        {
            if (prevX != core.me.X && prevY != core.me.Y)
            {
                sendSelfCoord(0, core.me.name);

                prevX = core.me.X;
                prevY = core.me.Y;
            }
        }

        private void bt_addPoint_Click(object sender, EventArgs e)
        {
            sendSelfCoord(1);
        }

        private void bt_addPath_Click(object sender, EventArgs e)
        {
            sendSelfCoord(2);
        }

        private void sendSelfCoord(int packet_type, string name = "")
        {
            if (!client.isConnected())
            {
                try
                {
                    client.Connect();
                    System.Threading.Thread.Sleep(500);
                }
                catch (Exception ex)
                {
                    core.Log(ex.Message);
                }
            }

            if (client.isConnected())
            {
                genericPacket packet = new genericPacket(packet_type, core.me.X, core.me.Y, core.me.Z, name);
                RawSerializer<genericPacket> serializer = new RawSerializer<genericPacket>();
                byte[] messageBuffer = serializer.RawSerialize(packet);
                client.Write(messageBuffer);
            }
        }

        private void autoSend_CheckedChanged(object sender, EventArgs e)
        {

            timerAutoSend.Enabled = autoSend.Checked; 
        }

        private void timerAutoSend_Tick(object sender, EventArgs e)
        {
            if (prevX2 != core.me.X && prevY2 != core.me.Y)
            {
                sendSelfCoord(2);
                core.Log("Sent");
                prevX2 = core.me.X;
                prevY2 = core.me.Y;
            }

        }
    }
}
