﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Scarecrow.Common
{
    public class Randomizer
    {
        /// <summary>
        ///     Sync object
        /// </summary>
        private static readonly object SyncObject = new object();

        /// <summary>
        ///     System randomizer
        /// </summary>
        private static readonly Random _random = new Random();

        /// <summary>
        ///     Obtaining random number
        /// </summary>
        /// <param name="min">From number</param>
        /// <param name="max">To number</param>
        /// <returns>Random number</returns>
        public static int GetRandom(int min, int max)
        {
            lock (SyncObject)
            {
                return _random.Next(min, max);
            }
        }

        public static double NextDouble()
        {
            lock (SyncObject)
            {
                return _random.NextDouble();
            }
        }

        public static Boolean GetBoolean(UInt16 probability = 50)
        {
            lock (SyncObject)
            {
                return _random.Next(1, 100) <= probability;
            }
        }
    }
}
