using System;
using System.Collections;

namespace Scarecrow.Coordinates
{
    [Serializable]
    public class Coords : IEqualityComparer, IEquatable<Coords>
    {
        /// <summary>
        ///     Initializes a new instance of the <see cref="Coords" /> class
        /// </summary>
        public Coords()
        {
        }

        /// <summary>
        ///     Initializes a new instance of the <see cref="Coords" /> class
        /// </summary>
        public Coords(double x, double y)
        {
            X = x;
            Y = y;
        }

        public double X { get; set; }

        public double Y { get; set; }

        public int Position { get; set; }

        public new bool Equals(object x, object y)
        {
            return ((Coords)x).Equals((Coords)y);
        }

        public int GetHashCode(object obj)
        {
            return (X + Y).GetHashCode();
        }

        private const double MovementDeltaMin = 0.2d;

        public bool Equals(Coords other)
        {
            return Math.Abs(X - other.X) < MovementDeltaMin && Math.Abs(Y - other.Y) < MovementDeltaMin;
        }
    }
}