﻿using System;

namespace Scarecrow.Coordinates
{
    public static class CoordsConverter
    {
        public static Coords FromLngLat(LngLatCoords lngLatCoords)
        {
            double lng = ((int)lngLatCoords.LngDirection)
                         * (lngLatCoords.LngDeg + (double)lngLatCoords.LngMin / 60 + (double)lngLatCoords.LngSec / 3600);

            double x = lng * 1024 + 21504;

            double lat = ((int)lngLatCoords.LatDirection)
                         * (lngLatCoords.LatDeg + (double)lngLatCoords.LatMin / 60 + (double)lngLatCoords.LatSec / 3600);

            double y = lat * 1024 + 28672;

            var result = new Coords { X = Math.Round(x * 100) / 100, Y = Math.Round(y * 100) / 100, };

            return result;
        }

        public static LngLatCoords FromAbs(Coords coords)
        {
            var result = new LngLatCoords();
            double lng = (coords.X - 21504) / 1024;
            double lat = (coords.Y - 28672) / 1024;
            result.LngDirection = lng < 0 ? LngDirections.W : LngDirections.E;
            lng = Math.Abs(lng);
            result.LatDirection = lat < 0 ? LatDirections.S : LatDirections.N;
            lat = Math.Abs(lat);
            int[] lngDeg = CoordsToDegree(lng);
            int[] latDeg = CoordsToDegree(lat);
            result.LngDeg = lngDeg[0];
            result.LngMin = lngDeg[1];
            result.LngSec = lngDeg[2];

            result.LatDeg = latDeg[0];
            result.LatMin = latDeg[1];
            result.LatSec = latDeg[2];

            return result;
        }

        private static int[] CoordsToDegree(double coord)
        {
            var result = new int[3];
            result[0] = (int)Math.Floor(coord);
            result[1] = (int)Math.Floor((coord - result[0]) * 60);
            //result[2] = (int)Math.Floor((coord - result[0] - result[1]) * 3600);
            result[2] = 0;
            return result;
        }
    }
}