﻿using System.Collections.Generic;
using System.Linq;
using ArcheBuddy.Bot.Classes;

namespace Scarecrow.Inventory
{
    public class ExtendedInventory
    {
        private static readonly object LockObject = new object();

        private readonly Core _core;

        private List<ItemWrapper> _realItems;

        /// <summary>
        ///     Initializes a new instance of the <see cref="ExtendedInventory" /> class
        /// </summary>
        public ExtendedInventory(Core core)
        {
            _core = core;
            _realItems = new List<ItemWrapper>();
            Init();
            core.onNewInvItem += OnNewInvItem;
            core.onInvItemRemoved += OnInvItemRemoved;
        }

        private void Init()
        {
            lock (LockObject)
            {
                _realItems =
                    _core.getAllInvItems().Select(x => new ItemWrapper { Item = x, TotalCount = x.count }).ToList();
                int len = _realItems.Count;
                for (int ii = 0; ii < len - 1; ii ++)
                {
                    if (1 == _realItems[ii].Item.maxStackSize)
                    {
                        continue;
                    }

                    for (int jj = ii + 1; jj < len; jj++)
                    {
                        if (_realItems[jj].Item.id == _realItems[ii].Item.id)
                        {
                            _realItems[jj].TotalCount += _realItems[ii].TotalCount;
                            _realItems.RemoveAt(ii);
                            len--;
                            ii--;
                            break;
                        }
                    }
                }
            }
        }

        private void OnInvItemRemoved(Item item, int count)
        {
            lock (LockObject)
            {
                int len = _realItems.Count;
                for (int ii = 0; ii < len; ii ++)
                {
                    if (_realItems[ii].Item.id == item.id)
                    {
                        // Avoid removing wrong items
                        if (1 == _realItems[ii].Item.maxStackSize && _realItems[ii].Item.cell != item.cell)
                        {
                            continue;
                        }

                        _realItems[ii].TotalCount -= count;

                        if (_realItems[ii].TotalCount <= 0)
                        {
                            _realItems.RemoveAt(ii);
                        }

                        return;
                    }
                }
            }
        }

        private void OnNewInvItem(Item item, int count)
        {
            lock (LockObject)
            {
                if (1 == item.maxStackSize)
                {
                    _realItems.Add(new ItemWrapper { Item = item, TotalCount = count });
                    return;
                }

                foreach (ItemWrapper itemWrapper in _realItems)
                {
                    if (1 == itemWrapper.Item.maxStackSize)
                    {
                        continue;
                    }

                    if (itemWrapper.Item.id == item.id)
                    {
                        itemWrapper.TotalCount += count;
                        return;
                    }
                }

                _realItems.Add(new ItemWrapper { Item = item, TotalCount = count });
            }
        }

        public List<ItemWrapper> GetAllItems()
        {
            return _realItems;
        }

        public List<ItemWrapper> GetInventoryItems(string partName)
        {
            partName = partName.ToLowerInvariant();
            lock (LockObject)
            {
                return _realItems.Where(x => x.Item.name.ToLowerInvariant().Contains(partName)).ToList();

            }
        }
    }
}