﻿namespace Scarecrow.Inventory
{
    public static class MoneyFormatter
    {
        public static string FormatMoney(this int price)
        {
            return FormatMoney((long)price);
        }

        public static string FormatMoney(this long price)
        {
            long gold = price / 10000;
            long silver = (price - gold * 10000) / 100;
            long bronze = price - gold * 10000 - silver * 100;
            return string.Format("{0}g {1:00}s {2:00}b", gold, silver, bronze);
        }
    }
}