﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Threading;
using System.Windows.Forms;
using ArcheBuddy.Bot.Classes;
using Scarecrow.Comparers;
using Scarecrow.UI;
using Scarecrow.Coordinates;
using Scarecrow.Inventory;
using Scarecrow.Common;

namespace Scarecrow
{
    public class Scarecrow : Core
    {
        private Thread mainThread;
        private List<FamilyMember> _familyMembers;

        private ExtendedInventory _inventory;

        private bool _isNeedToStop;

        public static string GetPluginAuthor()
        {
            return "";
        }

        public static string GetPluginVersion()
        {
            return "0.2";
        }

        public static string GetPluginDescription()
        {
            return "For the beginning you need to select seeds and scarecrows for processing, in the case of only gathering dont choose seeds" + Environment.NewLine +
                "Scarecrows are sorted by distance, family first. Format \"Scarecrow name (Owner) [id]\"" + Environment.NewLine +
                "After that scans selected scarecrows and builds a list of skills that can be used. Format \"Owner => skill.\"";
        }

        public void PluginRun()
        {
            _inventory = new ExtendedInventory(this);
            _familyMembers = me.family.getMembers();
            onCreatureDied += creature =>
                {
                    if (creature.uniqId == me.uniqId)

                    {
                        PlaySound("enemy.wav");
                        _isNeedToStop = true;
                    }
                };
            mainThread = new Thread(Start);
            mainThread.SetApartmentState(ApartmentState.STA);
            mainThread.Start();

            while (false == _isNeedToStop)
            {
                Thread.Sleep(100);
            }
        }

        public void PluginStop()
        {
            _isNeedToStop = true;
            if (mainThread.ThreadState == System.Threading.ThreadState.Running)
            {
                mainThread.Abort();
                mainThread.Join();
            }
        }

        private void Finish(bool final = false)
        {
            Log("Done");
            PlaySound("teleport.wav");
            if (!final)
                Start();
            else
                _isNeedToStop = true;
        }

        private void Start()
        {
            List<ItemWrapper> plants =
                _inventory.GetAllItems().Where(x => x.Item.type == BotTypes.Item).Distinct(new ItemComparer()).ToList();

            List<Creature> farms =
                getCreatures().Where(x => x.type == BotTypes.Housing).Distinct().OrderBy(x => x.distNoZ(me)).ToList();

            var selection = new PlantsSelection { TopMost = true };
            PlantSelectionResult results = selection.Show(plants, farms, IsCharacterInFamilyHandler);

            if (0 == results.Scarecrows.Count)
            {
                Finish(true);
                return;
            }

            List<PlantsWithSkills> allPlants;
            List<SinglePlantSkill> allSkills;
            PrepareToHarvest(results, out allPlants, out allSkills);

            foreach (Housing scarecrow in results.Scarecrows)
            {
                MoveToCorner(scarecrow);

                if (results.IsHarvestOnly)
                {
                    Harvest(scarecrow, allPlants, allSkills);
                }
                else
                {
                    Plant(results.PlantNames, scarecrow, results.Type, results.MotionType, allPlants, allSkills);
                }
            }

            Finish();
        }

        private void MoveToCorner(Housing scarecrow)
        {
            int radius = Randomizer.GetRandom(8, 12);

            var points = new List<Coords>
                             {
                                 new Coords(scarecrow.X - radius, scarecrow.Y - radius),
                                 new Coords(scarecrow.X - radius, scarecrow.Y + radius),
                                 new Coords(scarecrow.X + radius, scarecrow.Y - radius),
                                 new Coords(scarecrow.X + radius, scarecrow.Y + radius),
                             };

            double min = Double.MaxValue;
            Coords minPoint = points[0];
            foreach (Coords coords in points)
            {
                double dist = me.dist(coords.X, coords.Y);
                if (dist < min)
                {
                    min = dist;
                    minPoint = coords;
                }
            }
            
            MoveTo(minPoint.X, minPoint.Y, getZFromHeightMap(minPoint.X, minPoint.Y));
        }

        private void PrepareToHarvest(
            PlantSelectionResult result,
            out List<PlantsWithSkills> allPlants,
            out List<SinglePlantSkill> selectedSkills)
        {
            allPlants = new List<PlantsWithSkills>();
            selectedSkills = new List<SinglePlantSkill>();

            foreach (Housing scarecrow in result.Scarecrows)
            {
                allPlants.AddRange(
                    getDoodads()
                        .Where(x => x.plantZoneId == scarecrow.plantZoneId && x.type != BotTypes.Housing && x.dbAlmighty != null && x.dbAlmighty.growthTime != 0)
                        .Select(
                            x =>
                            new PlantsWithSkills
                                {
                                    Name = x.name,
                                    SkillName = x.getUseSkills().Select(y => y.desc).ToList(),
                                    OwnerName = scarecrow.ownerName,
                                    PlantZoneId = scarecrow.plantZoneId,
                                })
                        .ToList());
            }

            if (0 != allPlants.Count)
            {
                var selector = new PlantSkillSelection();
                selectedSkills = selector.Show(allPlants);
            }
        }

        private void Harvest(
            Housing farm,
            IEnumerable<PlantsWithSkills> allPlants,
            IEnumerable<SinglePlantSkill> selectedSkills)
        {
            List<PlantsWithSkills> plantsOnField = allPlants.Where(x => x.PlantZoneId == farm.plantZoneId).ToList();
            List<string> skills =
                selectedSkills.Where(x => x.PlantZoneId == farm.plantZoneId).Select(x => x.SkillName).ToList();

            if (0 != plantsOnField.Count)
            {
                PlaySound("harvest.wav");

                if (0 != skills.Count)
                {
                    foreach (PlantsWithSkills withSkills in plantsOnField)
                    {
                        string targetSkill = withSkills.SkillName.FirstOrDefault(skills.Contains);
                        if (null != targetSkill)
                        {
                            CollectItemsAtFarm(withSkills.Name, targetSkill, farm.uniqHousingId);

                            // HACK: to avoid situation when some of items weren't ready at the start of algorithm need to rety once again
                            CollectItemsAtFarm(withSkills.Name, targetSkill, farm.uniqHousingId);
                        }
                    }
                }
            }
        }

        private void Plant(
            IEnumerable<string> plantNames,
            Housing farm,
            PlantType type,
            MotionType motion,
            IEnumerable<PlantsWithSkills> allPlants,
            IEnumerable<SinglePlantSkill> selectedSkills)
        {
            Harvest(farm, allPlants, selectedSkills);

            SetPlantAlgoritm(type == PlantType.Random ? PlantAlgoritm.Randomized : PlantAlgoritm.MaxPerfomance);
            switch (motion)
            {
                case MotionType.Default:
                    {
                        SetPlantMotionType(PlantMotionType.Standart);
                    }
                    break;
                case MotionType.Optimized:
                    {
                        SetPlantMotionType(PlantMotionType.SecondStandart);
                    }
                    break;
                case MotionType.SnakeFromBorder:
                    {
                        SetPlantMotionType(PlantMotionType.SnakeFromBorder);
                    }
                    break;
                case MotionType.SnakeFromCenter:
                    {
                        SetPlantMotionType(PlantMotionType.SnakeFromCenter);
                    }
                    break;
            }

            foreach (string plantName in plantNames)
            {
                int totalCount = _inventory.GetInventoryItems(plantName).Sum(x => x.TotalCount);

                if (0 == totalCount)
                {
                    continue;
                }

                PlantItemsAtFarm(plantName, farm.uniqHousingId, (uint)totalCount);
            }

            Randomizer.GetRandom(5000, 8000);
        }

        private bool IsCharacterInFamilyHandler(string ownerName)
        {
            return _familyMembers.Any(x => x.name == ownerName);
        }
    }
}