﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Windows.Forms;
using Scarecrow.Comparers;

namespace Scarecrow.UI
{
    public partial class PlantSkillSelection : Form
    {
        public PlantSkillSelection()
        {
            InitializeComponent();
        }

        internal List<SinglePlantSkill> Show(List<PlantsWithSkills> plants)
        {
            checkedListBox.Items.Clear();
            var objects = new List<SinglePlantSkill>();
            foreach (PlantsWithSkills plantsWithSkillse in plants)
            {
                objects.AddRange(
                    plantsWithSkillse.SkillName.Select(
                        skill =>
                        new SinglePlantSkill
                            {
                                OwnerName = plantsWithSkillse.OwnerName,
                                Name = plantsWithSkillse.Name,
                                PlantZoneId = plantsWithSkillse.PlantZoneId,
                                SkillName = skill,
                            }));
            }

            List<SinglePlantSkill> skills = objects
                .Distinct(new PlantWithSkillsComparer())
                .ToList();

            foreach (SinglePlantSkill skill in skills)
            {
                checkedListBox.Items.Add(skill);
            }

            ShowDialog();
            List<SinglePlantSkill> result =
                (from object selectedItem in checkedListBox.CheckedItems select (SinglePlantSkill)selectedItem).ToList();
            return result;
        }

        private void ButtonOkClick(object sender, EventArgs e)
        {
            Close();
        }

    }
}