﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Windows.Forms;
using ArcheBuddy.Bot.Classes;
using Scarecrow.Inventory;

namespace Scarecrow.UI
{
    public partial class PlantsSelection : Form
    {
        private readonly List<uint> _categories = new List<uint> { 8, 51, 21 };

        private PlantSelectionResult _results;

        public PlantsSelection()
        {
            InitializeComponent();
        }

        private string FormatName(Housing obj)
        {
            return string.Format("{0} ({1}) [{2}]", obj.name, obj.ownerName, obj.uniqHousingId);
        }


        internal PlantSelectionResult Show(
            List<ItemWrapper> itemsToPlant,
            List<Creature> doodas,
            Func<String, Boolean> isCharacterInFamilyDelegateHandler)
        {
            checkedListBoxPlants.Items.Clear();
            checkedListBoxPlants.Items.AddRange(
                itemsToPlant.Where(x => _categories.Contains(x.Item.categoryId))
                    .Select(x => x.Item.name)
                    .OfType<object>()
                    .ToArray());
            
            checkedListBoxFarms.Items.Clear();

            int len = doodas.Count;

            for (int ii = 0; ii < len; ii ++)
            {
                if (isCharacterInFamilyDelegateHandler(((Housing)doodas[ii]).ownerName))
                {
                    var comboItem = new ComboItem
                                        {
                                            Name =
                                                string.Format(
                                                    "(C) {0}",
                                                    FormatName((Housing)doodas[ii])),
                                            Object = (Housing)doodas[ii],
                                        };

                    checkedListBoxFarms.Items.Add(comboItem);
                    doodas.RemoveAt(ii);
                    ii --;
                    len --;
                }
            }

            foreach (Creature creature in doodas)
            {
                var comboItem = new ComboItem { Name = FormatName((Housing)creature), Object = (Housing)creature, };
                checkedListBoxFarms.Items.Add(comboItem);
            }

            comboBoxType.SelectedIndex = 0;
            comboBoxMove.SelectedIndex = 0;

            ShowDialog();

            return _results;
        }

        private void ButtonOKClick(object sender, EventArgs e)
        {
            _results = MakeResults();
            Close();
        }

        private PlantSelectionResult MakeResults()
        {
            var result = new PlantSelectionResult
                             {
                                 Type = (PlantType)comboBoxType.SelectedIndex,
                                 MotionType = (MotionType)comboBoxMove.SelectedIndex,
                             };

            foreach (object checkedItem in checkedListBoxPlants.CheckedItems)
            {
                result.PlantNames.Add(checkedItem.ToString());
            }

            foreach (object checkedItem in checkedListBoxFarms.CheckedItems)
            {
                result.Scarecrows.Add(((ComboItem)checkedItem).Object);
            }

            return result;
        }

        private void ButtonCancelClick(object sender, EventArgs e)
        {
            _results = new PlantSelectionResult();
            Close();
        }

        private void ButtonHarvestClick(object sender, EventArgs e)
        {
            _results = MakeResults();
            _results.IsHarvestOnly = true;
            Close();
        }
    }
}