---
title: Contribute
date:  "2021-01-05T20:00:00+09:00"
draft: false
---

# Contribute

Asahi Linux is an open source project, and it would not be possible without the support of the community. We encourage contributors of all skill sets and backgrounds!

All contributors are expected to abide by our [Code of Conduct](/code-of-conduct) and our [Copyright and Reverse Engineering policy](/copyright).

## New to this kind of thing?

Are you interested in this kind of project, but you've never worked on something like this before? We were all like that at one point! The best way to learn how a low-level reverse engineering and development project like this works is to get involved. It might be intimidating at first, but don't worry. Join the [IRC channels](/community) and watch to see how things work. If you find an area which you find interesting, you can poke around yourself! If you feel like you can contribute to anything, just say so!

Here are some suggestions to get you started:

* Documentation: Reverse engineering often results in ugly brain-dump text files full of information, but we don't always have the time to clean things up into a nice wiki page. Helping out here is a good opportunity to get familiar with the subject, and you can ask questions to help shape the documentation and ensure it is accurate.
* Verification: Notes and documentation may have mistakes or be hastily written! It is always useful to have a second set of eyes go over the information, then try things out on the real hardware and see if it is correct. This is a good way to play around with the real hardware and understand how things work, and help find problems along the way!
* Testing: Does the code actually work? We need you to find out if it's broken in some way :-)
* Completeness: There are often gaps in what we find out - what does this bit do? What happens if you do more than one thing at once? You can look at cases we haven't tested yet and help complete the documentation and code.

## Already been here before?

Feel free to jump right and help us out - there is lots of work to do. A brief introduction would be helpful so that we can get to know you better. Let us know what you are experienced with and we can point you at specific areas you can help with.

## Prefer to help financially?

Head over to the [support](/support) page for more information. Every little bit counts!
