<?php



  //  AudioStreamer, www.audiostreamer.org

  //  Copyright (C) <2013>  <Lieven Rottiers>

  //

  //  This program is free software: you can redistribute it and/or modify

  //  it under the terms of the GNU General Public License as published by

  //  the Free Software Foundation, either version 3 of the License, or

  //  (at your option) any later version.

  //

  //  This program is distributed in the hope that it will be useful,

  //  but WITHOUT ANY WARRANTY; without even the implied warranty of

  //  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the

  //  GNU General Public License for more details.

  //

  //  You should have received a copy of the GNU General Public License

  //  along with this program.  If not, see <http://www.gnu.org/licenses/>.



function table_var_dump($variable, $wrap_in_td=false, $encoding='ISO-8859-1') {

  $returnstring = '';

  switch (gettype($variable)) {

    case 'array':

      $returnstring .= ($wrap_in_td ? '<td>' : '');

      $returnstring .= '<table class="dump" cellspacing="0" cellpadding="2">';

      foreach ($variable as $key => $value) {

        $returnstring .= '<tr><td valign="top"><b>'.str_replace("\x00", ' ', $key).'</b></td>';

        $returnstring .= '<td valign="top">'.gettype($value);

        if (is_array($value)) {

          $returnstring .= '&nbsp;('.count($value).')';

        } elseif (is_string($value)) {

          $returnstring .= '&nbsp;('.strlen($value).')';

        }

        //if (($key == 'data') && isset($variable['image_mime']) && isset($variable['dataoffset'])) {

        if (($key == 'data') && isset($variable['image_mime'])) {

          $imageinfo = array();

          $imagechunkcheck = getid3_lib::GetDataImageSize($value, $imageinfo);

          $returnstring .= '</td><td><img src="data:image/gif;base64,'.base64_encode($value).'" width="'.$imagechunkcheck[0].'" height="'.$imagechunkcheck[1].'"></td></tr>';

        } else {

          $returnstring .= '</td>'.table_var_dump($value, true, $encoding).'</tr>';

        }

      }

      $returnstring .= '</table>';

      $returnstring .= ($wrap_in_td ? '</td>' : '');

      break;



    case 'boolean':

      $returnstring .= ($wrap_in_td ? '<td class="dump_boolean">' : '').($variable ? 'TRUE' : 'FALSE').($wrap_in_td ? '</td>' : '');

      break;



    case 'integer':

      $returnstring .= ($wrap_in_td ? '<td class="dump_integer">' : '').$variable.($wrap_in_td ? '</td>' : '');

      break;



    case 'double':

    case 'float':

      $returnstring .= ($wrap_in_td ? '<td class="dump_double">' : '').$variable.($wrap_in_td ? '</td>' : '');

      break;



    case 'object':

    case 'null':

      $returnstring .= ($wrap_in_td ? '<td>' : '').string_var_dump($variable).($wrap_in_td ? '</td>' : '');

      break;



    case 'string':

      $variable = str_replace("\x00", ' ', $variable);

      $varlen = strlen($variable);

      for ($i = 0; $i < $varlen; $i++) {

        $returnstring .= htmlentities($variable{$i}, ENT_QUOTES, $encoding);

      }

      $returnstring = ($wrap_in_td ? '<td class="dump_string">' : '').nl2br($returnstring).($wrap_in_td ? '</td>' : '');

      break;



    default:

      $imageinfo = array();

      $imagechunkcheck = getid3_lib::GetDataImageSize($variable, $imageinfo);

      if (($imagechunkcheck[2] >= 1) && ($imagechunkcheck[2] <= 3)) {

        $returnstring .= ($wrap_in_td ? '<td>' : '');

        $returnstring .= '<table class="dump" cellspacing="0" cellpadding="2">';

        $returnstring .= '<tr><td><b>type</b></td><td>'.getid3_lib::ImageTypesLookup($imagechunkcheck[2]).'</td></tr>';

        $returnstring .= '<tr><td><b>width</b></td><td>'.number_format($imagechunkcheck[0]).' px</td></tr>';

        $returnstring .= '<tr><td><b>height</b></td><td>'.number_format($imagechunkcheck[1]).' px</td></tr>';

        $returnstring .= '<tr><td><b>size</b></td><td>'.number_format(strlen($variable)).' bytes</td></tr></table>';

        $returnstring .= ($wrap_in_td ? '</td>' : '');

      } else {

        $returnstring .= ($wrap_in_td ? '<td>' : '').nl2br(htmlspecialchars(str_replace("\x00", ' ', $variable))).($wrap_in_td ? '</td>' : '');

      }

      break;

  }

  return $returnstring;

}

  

  ?>



<?php

  // Initialize getID3 engine

  require_once('./getid3/getid3/getid3.php');    

  $PageEncoding = 'UTF-8';    

  $getID3 = new getID3;

  $getID3->setOption(array('encoding' => $PageEncoding));



  //

  include_once "./audiostreamerlib.php";

  $id = $_GET["id"];

  $output = '';

  $file = '';  



  try {

    global $sdb;

    $dbh = new PDO("sqlite:".$sdb);

    $dbh->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_WARNING);



    $sql = "select path from music where id = ".$id;

    foreach ($dbh->query($sql) as $row) {

      $file = utf8_encode($row['path']);

    }   

    

    //close connection

    $dbh = null;

  }

  catch(PDOException $e)

  {

    $output = $output.'<br/>'.$e->getMessage();

  }  



  if (file_exists($file)) {   

    $ThisFileInfo = $getID3->analyze($file);   

    getid3_lib::CopyTagsToComments($ThisFileInfo);

       

    $output = $output.'<br/>'. table_var_dump($ThisFileInfo, false, $PageEncoding);

  }

  else{

    $output = $output.'<br/>'. "File doesn't exist:<br/>".$file;

  }

  

  echo $output;

  //echo '<pre>';

  //print_r($ThisFileInfo);

  //echo '</pre>';

  

?>