local IsUsingDB = false
local dodgeReady = false
local PlayerManager
local dmgOwnerType
local curPlayerIndex
local masterPlayer
local masterPlayerIndex
local masterPlayerBase
local mPlObj
local mPlBHVT
local action_bank_id 
local action_id 
local frame_delay = 0
local wepType

local isAutoDemon = false
local isOpDemon = false

local isConfigLoaded = false
local userConfig = {
    isCDemon = false,
    isCOpDemon = false,
}

sdk.hook(sdk.find_type_definition("snow.player.PlayerMotionControl"):get_method("lateUpdate"),
function(args)
	local motionControl = sdk.to_managed_object(args[2])
	local refPlayerBase = motionControl:get_field("_RefPlayerBase")
	local curPlayerIndex = refPlayerBase:get_field("_PlayerIndex")
	
	if curPlayerIndex == masterPlayerIndex then
		action_id = motionControl:get_field("_OldMotionID")
		action_bank_id = motionControl:get_field("_OldBankID")
	end
	--- Normal State Check (OP) ----
	if isAutoDemon and isOpDemon then
		if (action_id >= 4 and action_id <= 9) or action_id == 118 then
		dodgeReady = false
		elseif (action_id >= 101 and action_id <= 110) or (action_id >= 208 and action_id <= 209) then
		dodgeReady = false
		elseif (action_id >= 179 and action_id <= 181) then
		dodgeReady = false
		elseif action_id == 115 or action_id == 177 or action_id == 154 then
		dodgeReady = false
		elseif action_id == 186 or action_id == 187 then
		dodgeReady = false
		end
	end
	
	--- Demon Mode Check ----
	if isAutoDemon then
		if (action_id >= 116 and action_id <= 122) or action_id == 303 then
		dodgeReady = false
		elseif (action_id >= 137 and action_id <= 146) or action_id == 151 then
		dodgeReady = false
		elseif (action_id >= 179 and action_id <= 181) or action_id == 159 then
		dodgeReady = false
		elseif (action_id >= 137 and action_id <= 146) or (action_id >= 208 and action_id <= 209) then
		dodgeReady = false
		elseif (action_id == 123 and action_id == 306) or (action_id == 204 and action_id == 300) then
		dodgeReady = false
		elseif (action_id == 188 and action_id == 148) then
		dodgeReady = false
		end
	end
	
	if action_id == 1 then
		dodgeReady = true
	end
end,
function(retval) end
)


re.on_frame(function()
	if not PlayerManager then
        PlayerManager = sdk.get_managed_singleton('snow.player.PlayerManager')
    end
	if not PlayerManager then return end
	masterPlayer = PlayerManager:call("findMasterPlayer")
	masterPlayerIndex = masterPlayer:get_field("_PlayerIndex")
	
	masterPlayerBase = PlayerManager:call("findMasterPlayer")
	if not masterPlayerBase then return end
	wepType = masterPlayerBase:get_field("_playerWeaponType")
	IsUsingDB = masterPlayerBase:get_field("_playerWeaponType") == 9
	mPlObj = masterPlayerBase:call("get_GameObject")
	mPlBHVT = mPlObj:call("getComponent(System.Type)",sdk.typeof("via.behaviortree.BehaviorTree"))

	if not isConfigLoaded then
        local config = json.load_file("autoDodgeConfig.json")
        if config == nil then
            print("File not Found")
            isConfigLoaded = true
            return
        else
            for i,v in pairs(config) do
                if i == "isCDemon" then
                    isAutoDemon = v
                elseif i == "isCOpDemon" then
                    isOpDemon = v
				end
            end
            isConfigLoaded = true
            return
        end
    end
	
end)

sdk.hook(sdk.find_type_definition("snow.player.PlayerQuestBase"):get_method("checkCalcDamage_DamageSide"),
	function(args)
		local manager = sdk.to_managed_object(args[2])	
		local argManager = sdk.to_managed_object(args[3])
		local damageData = argManager:call("get_AttackData")
		
		dmgOwnerType = damageData:call("get_OwnerType")
		curPlayerIndex = manager:get_field("_PlayerIndex")
		masterPlayerIndex = masterPlayerBase:get_field("_PlayerIndex")
	end,
    function(retval)
		local dmgFlowType = sdk.to_int64(retval)
		if IsUsingDB and curPlayerIndex == masterPlayerIndex and dmgOwnerType == 1 and dmgFlowType == 0 then
			if not dodgeReady then
				mPlBHVT:call("setCurrentNode(System.UInt64, System.UInt32, via.behaviortree.SetNodeInfo)",3862130673,nil,nil)
				return sdk.to_ptr(1)
			else
				return retval
			end
			return retval
		end	
		return retval
	end
)

-- draw ui
re.on_draw_ui(
function()
	if imgui.button("Save Input") then
        local _Config = {}
        for i,v in pairs(userConfig) do
            if i == "isCDemon" then
                _Config[i] = isAutoDemon
            elseif i == "isCOpDemon" then
                _Config[i] = isOpDemon
            end
        end
        local saveStatus = json.dump_file("autoDodgeConfig.json", _Config)
        print("Save Success : "..tostring(saveStatus))
    end

	if isAutoDemon then
		if imgui.button("Deactivate Counter Demon") then
			isAutoDemon = false
			isOpDemon = false
			dodgeReady = true
		end
		if isOpDemon then
			if imgui.button("Deactivate Op Counter Demon") then
				isOpDemon = false
			end
		else
			if imgui.button("Activate Op Counter Demon") then
				isOpDemon = true
			end
		end
	else
		if imgui.button("Activate Counter Demon") then
			isAutoDemon = true
		end
	end
	
end)
