#!C:/Adobe/DocumentServer/data/bin/perl.exe

#################################################################

require '../data/perl/config.pl';
require '../data/perl/pdfinfo.pl';

#################################################################

sub println
{
	print @_, "\n";
}

sub parseQueryString
{
	if (length ($ENV{'QUERY_STRING'}) > 0) {
		$buffer = $ENV{'QUERY_STRING'};
		@pairs = split(/&/, $buffer);
		foreach $pair (@pairs) {
			($name, $value) = split(/=/, $pair);
			$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
			$in{$name} = $value;
		}
	}
}

#################################################################

parseQueryString();

# Valid values for fmt are: gif, jpeg, g3_tiff
$fmt       = "gif";
$file_path = $in{"fileName"};
$file	   = $file_path;
$page      =  $in{"page"}  eq "" ? "1"   : $in{"page"};
$scale     =  $in{"scale"} eq "" ? "100" : $in{"scale"};
$img_req   = "image&page=" . $page . "&scale=" . $scale . "&mode=ic" . "&imgfmt=" . $fmt;

if ($file eq "") {
	print "Content-type: text/plain\n\n";
	println;
	println "Usage: http://.../csi.pl?fileName=<fullPathName>&page=<default_1>&scale=<default_100>";
	exit 100;
}

#################################################################
# Output the HTTP header, and the image contents
println "Content-type: image/$fmt";
println "Last-Modified: $file_headers{'Last-Modified'}" if defined($file_headers{'Last-Modified'});
# XXX println "Content-length: $size";

println;

binmode(STDOUT);

read_headers() if !defined(%file_headers);

process_pdf_info($img_req, sub { print $_; }, '', 1);
