
<p align="middle">
  <img src="https://i.imgur.com/6Zso95t.png"> 
</p>

#### Description
This mod is aimed at making changes to the overall user interface to improve usability as well as opening options to more potential mods.  

#### Player Features
- Prevents annoying story error message box appearing when using mods
<p float="left" align="middle">
  <img src="https://i.imgur.com/dm5CsPu.png">
</p>

- Removes annoying reset tutorial/enable tutorials message box when entering CC
<p float="left" align="middle">
  <img src="https://i.imgur.com/piE3sv3.jpg">
</p>

- Unlocks edit appearance option for all Origin characters in Character Creation.
- Character Creation Layout tweaks: Redesigned Origin layout (the first screen you see when entering CC).
- Magic Mirror tweaks: Allows all combinations to hit confirm. May need to hit randomise once before making changes.
- Hireling tweaks: Redesigned Hireling layout (makes better use of the dead space).
- <b>OPTIONAL FILE REQUIRED</b> Switches "Show all items" (highlighting all interactables, default left ALT key/right stick) from requiring a held input to an on/off switch. Works for both Keyboard and Controller - switching between the two input methods when enabled would cause an additional toggle to be required. Stays on UI change (such as game menu/dialogue) except when showing other tooltips. (Credit: Violet-Vibes)

<b>OPTIONAL FILE REQUIRED</b> Keyboard-only tweaks:
- Hides the bottom-left buttons when in dialogue with companions and NPCs where Attack/Trade are not relevant. Can still be accessed by placing your mouse in the bottom-left area. This cleans up the UI when experiencing intimate scenes. (Credit: Wesslan)
- Replaces existing Minimap with smaller version (75% zoom, takes up less space on screen) or no Minimap (leaving the relevant buttons).
<p float="left" align="middle">
  <img src="https://i.imgur.com/cMii97G.jpg"><img src="https://i.imgur.com/hElvnJR.jpg">
</p>

#### Modder Features
- Character Creation Layout tweaks: Removes head scroll limit (Credit: Alana)
- Character Creation Layout tweaks: Removes appearance tab restrictions allowing for modded slot use. (ex: Origin Hairstyles, Humans with tails)
- Character Creation Layout tweaks: Changes Dragonborn Sorcerer Draconic Ancestry to allow for additional scale types.
- Character Creation Layout tweaks: Allows for Feat selection once unlocked by another mod. Tip - "Allowimprovement" doesn't work on its own.
- CC/Level up Layout tweaks: Adds multiple scroll bars to Origins, Races, Subraces, Classes, Subclasses, Deity and Background selection for better support with modded options.
- CC/Level up Layout tweaks: Changes passive selection to turn into a scroll option when modded options are added - such as modded Eldritch Invocations. (Credit: Winterbrick)
- CC/Level up Layout tweaks: Changes Feat panel to have additional scroll options to support modded Feats with long descriptions and multiple options. (Credit: Lostsoul)
- Hireling tweaks: Adds multiple scroll bars to Hireling selection for better support with modded options.

#### <b>OPTIONAL FILE REQUIRED</b> Custom Asset Features 
- Supports modded class/subclass icons, with a generic icon given to mods without a provided icon.
- Dynamic support for class/subclass icons that have not been provided, the image name would need to match the class/subclass name in classdescriptions.lsx. (Credit: LaughingLeader)
- Supports modded race/subrace icons, including custom names for Subraces such as Dragonborn.
- Supports modded action resource icons for Keyboard - Hotbar, Tooltips and CC/Levelup.
- Supports modded action resource icons for Controller - Tooltips, Action Radial "Cost:", Action Radial bottom resource bar and CC/Levelup.
- Dynamic support for action resource icons that have not been provided and fallback support when no entries are provided for CC/Levelup and Action Radial bottom resource bar.
- Better handling of action resources without icons, with placeholder stars added to each section and counted on Keyboard Hotbar. (Credit: juumeijin)
- Supports modded background icons (instead of a square block). (Credit: NellsRelo)
- Supports modded deity icons (instead of a square block). (Credit: Lostsoul)

#### Showcase (version 3.2) - https://www.youtube.com/watch?v=livOpPUNIN0 - new video soon

#### Installing 
Place both ImprovedUI.pak and optional files under "%LocalAppData%\Larian Studios\Baldur's Gate 3\Mods" - no mod list entry required.

OR

If added via Candor/BG3 Mod Manager/manual install, ensure that the [Story Fix](https://www.nexusmods.com/baldursgate3/mods/141) (or a mod that includes it) is also added to work correctly.

#### Discord
Feel free to join the [Larian Discord](https://discord.com/invite/larianstudios) server and discuss in the BG3 Modding Channel  

#### Attribution
- [Baldur's Gate 3](https://store.steampowered.com/app/1086940/Baldurs_Gate_3/), a game by [Larian Studios](http://larian.com/)  
- Initial readme file generously donated by Zerd; check out their project here, [DnD Rebalancing](https://github.com/ZerdBG3/DnD-Rebalancing/)  

#### DISCLAIMER
- Since modding BG3 is not yet officially supported by Larian Studios, you might encounter unexpected problems that it's not in their current scope to fix. **PLEASE DISABLE AUTOMATIC TELEMETRY** and don't post bug reports on their official platforms, as you're playing with an unsupported mod.
- How to disable telemetry:  
<p float="left" align="middle">
  <img src="https://i.imgur.com/8BSSPiW.png" width="500">
  <img src="https://i.imgur.com/huTu79h.png" width="500">
</p>


#### Notes for Paking:
Use [LSLib](https://github.com/Norbyte/lslib); set Priority to 26
