<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output omit-xml-declaration="yes"/>
    <xsl:template match="@*|node()">
        <xsl:copy>
            <xsl:apply-templates select="@*|node()"/>
        </xsl:copy>

    </xsl:template>

	<!--mountain_bandits-->
    <xsl:template match='NPCCharacter[@id="mountain_bandits_chief"]/upgrade_targets'>
        <upgrade_targets>
			<upgrade_target id="NPCCharacter.vlandian_vanguard" />
        </upgrade_targets>
    </xsl:template>
	
	<!--sea_raiders-->
	<xsl:template match='NPCCharacter[@id="sea_raiders_raider"]/upgrade_targets'>
        <upgrade_targets>
			<upgrade_target id="NPCCharacter.sea_raiders_chief" />
			<upgrade_target id="NPCCharacter.sturgian_berzerker" />
        </upgrade_targets>
    </xsl:template>
	
	<xsl:template match='NPCCharacter[@id="sea_raiders_chief"]/upgrade_targets'>
        <upgrade_targets>
			<upgrade_target id="NPCCharacter.sturgian_veteran_warrior" />
        </upgrade_targets>
    </xsl:template>
	
	<!--desert_bandits-->
	<xsl:template match='NPCCharacter[@id="desert_bandits_chief"]/upgrade_targets'>
        <upgrade_targets>
			<upgrade_target id="NPCCharacter.aserai_mameluke_heavy_cavalry" />
        </upgrade_targets>
    </xsl:template>
	
	<!--steppe_bandits-->
	<xsl:template match='NPCCharacter[@id="steppe_bandits_bandit"]/upgrade_targets'>
        <upgrade_targets>
			<upgrade_target id="NPCCharacter.steppe_bandits_raider" />
			<upgrade_target id="NPCCharacter.khuzait_horseman" />
        </upgrade_targets>
    </xsl:template>
	
	<xsl:template match='NPCCharacter[@id="steppe_bandits_raider"]/upgrade_targets'>
        <upgrade_targets>
			<upgrade_target id="NPCCharacter.steppe_bandits_chief" />
			<upgrade_target id="NPCCharacter.khuzait_horse_archer" />
        </upgrade_targets>
    </xsl:template>
	
	<xsl:template match='NPCCharacter[@id="steppe_bandits_chief"]/upgrade_targets'>
        <upgrade_targets>
			<upgrade_target id="NPCCharacter.khuzait_heavy_horse_archer" />
        </upgrade_targets>
    </xsl:template>
	
	<!--forest_bandits - NEEDS NEW UNITS-->
	<xsl:template match='NPCCharacter[@id="forest_bandits_bandit"]/upgrade_targets'>
        <upgrade_targets>
			<upgrade_target id="NPCCharacter.forest_bandits_raider" />
			<upgrade_target id="NPCCharacter.bann_battanian_archer" />
        </upgrade_targets>
    </xsl:template>
	
	<xsl:template match='NPCCharacter[@id="forest_bandits_raider"]/upgrade_targets'>
        <upgrade_targets>
			<upgrade_target id="NPCCharacter.forest_bandits_chief" />
			<upgrade_target id="NPCCharacter.bann_battanian_longbow" />
        </upgrade_targets>
    </xsl:template>
	
	<xsl:template match='NPCCharacter[@id="forest_bandits_chief"]/upgrade_targets'>
        <upgrade_targets>
			<upgrade_target id="NPCCharacter.bann_battanian_veteran_longbow" />
        </upgrade_targets>
    </xsl:template>
	
</xsl:stylesheet>