/***** BEGIN LICENSE BLOCK *****

    FlashGot - a Firefox extension for external download managers integration
    Copyright (C) 2004-2008 Giorgio Maone - g.maone@informaction.com

***** END LICENSE BLOCK *****/

var gFlashGotDMDialog = null;

function FlashGotDMDialog() {
  gFlashGotDMDialog = this;

  this.url = dialog.mLauncher.source.spec;
  
  
  
  try {
    this.openerDocument = dialog.mContext.QueryInterface(Components.interfaces.nsIInterfaceRequestor)
      .getInterface(Components.interfaces.nsIDOMWindow).document;
  } catch(ex) {
    this.openerDocument = top.opener && top.opener.content && top.opener.content.document || null;
  }
  
  try {
      this.referrer = dialog.mContext.QueryInterface(
        Components.interfaces.nsIWebNavigation).currentURI.spec;
  } catch(ex) {
     this.referrer = this.openerDocument && this.openerDocument.URL || this.url;
  }
  
  
  this.dialog = dialog;
  

  this.fname = dialog.mLauncher.suggestedFileName;
  var ext=this.fname.split('.');
  this.ext = ext.length > 0 ? ext[ext.length-1] : "";
  this.extensionExists=gFlashGotService.extensionExists(this.ext);
  const itc = gFlashGotService.interceptor;
  
  if(itc.lastPost && itc.lastPost.URI.spec == this.url && itc.lastPost.isPending()) {
    this.postChannel = itc.lastPost;
  }
  
  if(gFlashGotService.DMS.found && (!itc.bypassAutoStart)
      && (itc.forceAutoStart
          || ( itc.autoStart
            && (itc.interceptAll
                || this.extensionExists)))) {
    this.download();
    return;
  }

  window.setTimeout(function() { gFlashGotDMDialog.init(); }, 0);
  
  if(typeof(ReGetDmDialog) == "object") {
    ReGetDmDialog.prototype.init = function() {};
    document.getElementById("regetRadio").style.display = "none";
    document.getElementById("regetBasic").style.display = "none";
  }
}

FlashGotDMDialog.prototype = {
  get choosen() {
    return gFlashGotService.getPref("dmchoice", false);
  }, 
  set choosen(v) {
    gFlashGotService.setPref("dmchoice", v);
    return v;
  },
  
 
  remember: null,
  choice: null,
  check: null,

  forceNormal: function(secondChance) {
    var basicBox = document.getElementById('basicBox');
    var normalBox = document.getElementById('normalBox');
    var self = this;
    if((normalBox && basicBox)) {
      if(normalBox.collapsed && basicBox.collapsed && !secondChance) {
        
        window.setTimeout(function() { self.forceNormal(true); }, 10);
        return;
      }
      if(normalBox.collapsed) {
        basicBox.collapsed = true;
        normalBox.collapsed = false;
        document.getElementById('open').parentNode.collapsed = true;
        var nodes = normalBox.getElementsByTagName('separator');
        for(var j = nodes.length; j-- > 0;) {
          nodes[j].collapsed = true;
        }
      }
    }
    window.setTimeout(self.sizeToContent, 0);
  },
  
  sizeToContent: function() {
    try {
      window.sizeToContent();
    } catch(e) { // bug 367184
      window.resizeTo(window.outerWidth, document.getElementById("container").boxObject.height + 80)
    }
  },
  
  init: function() {
    
    this.forceNormal();
  
    const dmsMenu = this.dmsMenu = document.getElementById("flashgot-dms");
      
    this.remember = document.getElementById("rememberChoice") || document.getElementById("alwaysHandle");
    if(this.remember) {
      this.remember.collapsed = false;
      if(this.remember.id == "rememberChoice" && 
        this.remember.parentNode.previousSibling &&
        this.remember.parentNode.previousSibling.nodeName == "separator") {
        this.remember.parentNode.previousSibling.collapsed = false;
      }
    }
   
    
    this.choice = document.getElementById("flashgot-dmradio");
    this.check = document.getElementById("flashgot-dmcheck");

    const dms = gFlashGotService.DMS;
    if(!dms.found) {
      this.choice.setAttribute("disabled", "true");
      if(this.check) this.check.setAttribute("disabled", "true");
      dmsMenu.setAttribute("collapsed", "true");
      return;
    }
    const defaultDM = gFlashGotService.defaultDM; 
    
    

    var menuItem;
    var enabledDMSs=0;
    dmsMenu.removeAllItems();
    var dm;
    for(var j=0, len = dms.length; j<len; j++) {
      dm=dms[j];
      if(dm.supported) {
        enabledDMSs++;
        menuItem=dmsMenu.appendItem(dm.name,dm.codeName);
        if(defaultDM==dm.name) {
          dmsMenu.selectedItem=menuItem;
        }
      }
    }
    
    const modeRadioGroup=document.getElementById("mode");
    
    if(enabledDMSs < 2) {
      dmsMenu.setAttribute("collapsed","true");
    } else {
      dmsMenu.addEventListener("popuphidden", function() {
        gFlashGotDMDialog.toggleChoice();
      }, true);
      
      const openRadio = document.getElementById("open");
      if(openRadio) {
        var maxWidth = Math.max(
          openRadio.boxObject.width, this.choice.boxObject.width
        );
        if(maxWidth > 0) openRadio.width = this.choice.width = maxWidth;
      }
    }
    
    if(this.choosen) {
      if(this.remember) this.remember.checked = this.extensionExists && gFlashGotService.interceptor.autoStart;
      document.getElementById("mode").selectedItem = this.choice;
      if(this.check) this.check.checked = true;
    }
    
    this.toggleChoice();
    modeRadioGroup.addEventListener(
      "select", function(event) {
        gFlashGotDMDialog.toggleChoice(event)
      },true);
    
    var d = document.documentElement;
    d.setAttribute('ondialogaccept',
      'if(gFlashGotDMDialog.dialogAccepted()) { '
      + document.documentElement.getAttribute('ondialogaccept')
      +'}');
      d.setAttribute("onblur", "if(dialog) {" + d.getAttribute("onblur") + " }");
  }
,
  toggleChoice: function() {
    var dmchoice = document.getElementById("mode").selectedItem == this.choice;
    
    this.choosen = dmchoice;
    var remember = this.remember;
    
    if(dmchoice) {
      this.dmsMenu.removeAttribute("disabled");
      window.setTimeout(
        function() { 
          document.documentElement.getButton('accept').disabled = false;
        }, 10);
      if(remember) {
        remember.disabled = false;
      }
    } else {
      this.dmsMenu.setAttribute("disabled", true);
    }
  }
,
   dialogAccepted: function() {
    if(this.choosen) {
      if(this.remember && this.remember.checked) {
        gFlashGotService.addExtension(this.ext);
        gFlashGotService.interceptor.autoStart = true;
      }
      if(this.dmsMenu.selectedItem) {
        gFlashGotService.defaultDM = this.dmsMenu.selectedItem.getAttribute("label");
      }
      this.download();
      return false;
    } else {
      return true;
    }
  }
,
  download: function() {
    var links=[ {
       href: this.url, 
       description: this.fname
    } ];
    links.referrer = this.referrer;
    links.document = this.openerDocument;
    links.browserWindow = top.opener;
    if(this.postChannel) {
      gFlashGotService.interceptor.extractPostData(this.postChannel, links);
    }
    gFlashGotService.download(links);
    with(document.documentElement) {
      removeAttribute('ondialogaccept');
      removeAttribute('onblur');
      removeAttribute('onfocus');
      cancelDialog();
    }
  }
}

window.addEventListener("load",  function(e) { new FlashGotDMDialog(); }, false);



