/***** BEGIN LICENSE BLOCK *****

    FlashGot - a Firefox extension for external download managers integration
    Copyright (C) 2004-2008 Giorgio Maone - g.maone@informaction.com

***** END LICENSE BLOCK *****/

const g_rxOpt=/^(inv|)opt-(.*)/;
var g_downloadManagers = null;
var g_opts = null;
var g_extList = null;
var g_extText = null;
var g_referrerRadio = null;
var g_referrerText = null;
var g_tmpDir = null;
var g_wellGetPath = null;

var g_cust = gFlashGotService && {
  dummy: gFlashGotService.createCustomDM(""),
  map: {},
  createEntry: function(obj, isNew) {
    if(!obj.custom) return null;
    const name=obj.name;
    const map=this.map;
    return map[name] ? map[name]
      : map[name]={
          _dirty: false,
          _deleted: false, 
          _new: isNew,
          supported: true,
          name: name,
          argsTemplate: obj.argsTemplate,
          exeFile: isNew?obj.locateExeFile(name):obj.exeFile
        };
  },
  get current() {
    if(!g_downloadManagers.selectedItem) return null;
    const dmName=g_downloadManagers.selectedItem.getAttribute("label");
    
    if( (!dmName) || dmName=="---") return null;
    var dm = gFlashGotService.DMS[dmName];
    if(dm) {
      return this.createEntry(dm,false);
    }
    this.dummy.name=dmName;
    return this.createEntry(this.dummy,true);
  },
  add: function() {
    const ps = Components.classes["@mozilla.org/embedcomp/prompt-service;1"
      ].getService(Components.interfaces.nsIPromptService);
    const ret={ value: "" };
    const title=gFlashGotService.getString("custom.new.title");
    var name;
    if(ps.prompt(window,
          title,
          gFlashGotService.getString("custom.new.text"),
          ret, null, {}) && 
       (name = ret.value) ) {
      if(/,|^(?:\d+|\s+|---)$/.test(name) ||
          gFlashGotService.DMS[name] || this.map[name]) {
        ps.alert(window,title,gFlashGotService.getString("custom.new.error"));
        return;
      }
      const dummy = this.dummy;
      dummy.name = name;
      this.createEntry(dummy, true);
      fgo_populateDMS(name);
    }
  },
  remove: function() {
    var dm=this.current;
    if(dm) {
      dm._deleted=true;
      fgo_populateDMS();
    }
  },
  locateExe: function() {
    const cur=this.current;
    if(cur) {
      var f=this.dummy.locateExeFile(this.current.name);
      if(f) {
        cur.exeFile=f;
        cur._dirty=true;
      }
      this.syncUI();
    }
  }
,
  argsChanged: function(txtArgs) {
    const cur=this.current;
    var val=txtArgs.value.replace(/['"`]/g,'');
    if(val!=txtArgs.value) {
      document.getElementById("quoteWarn").showPopup(txtArgs,-1, -1, "tooltip", "topleft", "bottomleft");
      selEnd=txtArgs.selectionEnd;
      txtArgs.value=val;
      try {
        txtArgs.selectionEnd=selEnd-1;
      } catch(ex) {}
    }
    if(cur && cur.argsTemplate!=val) {
      cur.argsTemplate=val;
      cur._dirty=true;
    }
  }
,
  syncUI: function() {
    var dm = this.current;
    document.getElementById("dmsdeck").setAttribute(
      "selectedIndex", dm ? "0" : "1");
    if(dm) {
      document.getElementById("customDM-exeFile").value = 
        dm.exeFile ? dm.exeFile.path : "";
      document.getElementById("customDM-args").value = dm.argsTemplate;
      var ph=document.getElementById("ph-");
      var popup=ph.parentNode;
      while(ph.nextSibling) {
        popup.removeChild(ph.nextSibling);
      }
      const PHS=this.dummy.PLACEHOLDERS;
      if(PHS) {
        var phName;
        for(var j=0, len=PHS.length; j<len; j++) {
          phName=PHS[j];
          ph=ph.cloneNode(true);
          ph.removeAttribute("hidden");
          ph.setAttribute("id","ph-"+phName);
          ph.setAttribute("label",gFlashGotService.getString("ph."+phName));
          popup.appendChild(ph);
        }
      }
    }
  }
,
 insertPH: function(id) {
   const phName="["+id.substring(3)+"]";
   const txtArgs=document.getElementById("customDM-args")
   var selStart=txtArgs.selectionStart;
   var selEnd=txtArgs.selectionEnd;
   txtArgs.value=txtArgs.value.substring(0,selStart)+phName+txtArgs.value.substring(selEnd);
   txtArgs.selectionStart=txtArgs.selectionEnd=selStart+phName.length;
 }
,
 save: function() {
   const map=this.map;
   var dm,target;
   for(var name in map) {
     dm=map[name];
     target=null;
     if(dm._deleted) {
       gFlashGotService.removeCustomDM(name);
     } else if(dm._new) {
       target = gFlashGotService.createCustomDM(name);
     } else if(dm._dirty) {
       target = gFlashGotService.DMS[name];
     }
     if(target) {
       target.argsTemplate=dm.argsTemplate;
       target.exeFile=dm.exeFile;
     }
   }
 }
};
function fgo_onload() {
  if(!gFlashGotService) {
    document.getElementById("mainTabbox").setAttribute("hidden","true");
    document.getElementById("badInstall").removeAttribute("hidden");
    document.getAnonymousElementByAttribute(document
            .getElementById("flashgotOptions"),"dlgtype","cancel")
            .setAttribute("hidden","true");
    return;
  }
  
  try {
      g_wellGetPath = gFlashGotService.prefs.getComplexValue("WellGet.path", Components.interfaces.nsILocalFile);
      document.getElementById("wellget-text").value = g_wellGetPath.path;
  } catch(ex) {}
   
  
  if(gFlashGotService.mailer) { 
    // Thunderbird will handle "simple" clicks through Firefox
    document.getElementById("tab-downloads").setAttribute("collapsed","true");
  }
  
  g_downloadManagers=document.getElementById("downloadManagers");
  g_opts=document.getElementsByTagName("checkbox");
  
  fgo_populateDMS();
  
  var j,len;
  
  g_extList = document.getElementById("ext-list");
  g_extText = document.getElementById("ext-text");
  g_extList.removeItemAt(0);
  var extensions=gFlashGotService.extensions;
  for(j=0, len=extensions.length; j<len; j++) {
    g_extList.appendItem(extensions[j],extensions[j]);
  }
  
  fgo_visitCheckboxes(
    function(prefName,inverse,checkbox) {
      var val=gFlashGotService.getPref(prefName);
      checkbox.checked=inverse?!val:val;
    }
  );
  
  g_referrerRadio=document.getElementById("referrer-radio");
  g_referrerText=document.getElementById("referrer-text");
  g_referrerRadio.selectedIndex=gFlashGotService.getPref("autoReferrer") ? 0 : 1;
  g_referrerText.value=gFlashGotService.getPref("fakeReferrer","");
  fgo_syncReferrer();
  g_referrerRadio.addEventListener("select", fgo_syncReferrer, true);
  
  
  g_downloadManagers.addEventListener("popuphidden", fgo_syncDMOptions, true);
  try {
    g_tmpDir = gFlashGotService.prefs.getComplexValue("tmpDir", Components.interfaces.nsILocalFile);
  } catch(ex) {
     g_tmpDir = gFlashGotService.tmpDir.parent;
  }
  if(g_tmpDir) {
    document.getElementById("tmpdir-text").value =g_tmpDir.path;
  }
  
  document.getElementById("interception-rg").selectedItem=
    document.getElementById("intercept"+
      (gFlashGotService.getPref("interceptAll")?"All":"Ext")+"-radio");
}

function fgo_populateDMS(name) {
  const defaultDM = gFlashGotService.defaultDM;
  const dms = gFlashGotService.DMS;
  const dmList = [].concat(gFlashGotService.DMS);

  const map = g_cust.map;
  var dm;
  for(p in map) {
    dm=map[p];
    if( ! (dm._deleted || p in dms) ) {
      dmList.push(map[p]);
    }
  }
  
  if(!name) name = defaultDM;
  
  var j, len, menuItem;
  
  g_downloadManagers.removeAllItems();
  g_downloadManagers.selectedItem=null;
  
  var custom;
  var found=false;
  for(j = 0, len=dmList.length; j<len; j++) {
    dm=dmList[j];
    if((custom=g_cust.createEntry(dm,false)) && custom._deleted) {
      continue;
    }
    
    menuItem = g_downloadManagers.appendItem(dm.name,dm.codeName);
    
    if(dm.supported) {
      if(!found) {
        found = (name == dm.name);
        if(found || !g_downloadManagers.selectedItem) {
          g_downloadManagers.selectedItem=menuItem;
        }
      }
    } else {
      if(!dm.shouldList()) menuItem.setAttribute("disabled", "true");
    }
  }
  
  
  if(g_downloadManagers.selectedItem) {
    document.getElementById("nodms").setAttribute("collapsed","true");
  } else {
    g_downloadManagers.selectedItem=g_downloadManagers.appendItem("---",null);
    document.getElementById("nodms").removeAttribute("collapsed");
  }
  
  fgo_syncDMOptions();
}

function fgo_interceptionSelected(rg) {
  document.getElementById('extensions-box').style.visibility=
    rg.selectedItem && rg.selectedItem.id=='interceptAll-radio' ? "hidden":"visible";
}

function fgo_syncDMOptions() {
  const dmrx = g_downloadManagers.value ?
    new RegExp("\\b" + g_downloadManagers.value + "\\b")
    :null;
  const dmopts = document.getElementsByAttribute("class", "dm-opt");
  var dmid, dmopt;
  for(var j = dmopts.length; j-->0;) {
    dmopt = dmopts[j];
    if(dmrx) {
      dmid = dmopt.id;
      if(dmid) {
        dmopt.setAttribute("hidden", dmid.match(dmrx) ? "false" : "true" );
      }
    } else {
      dmopt.setAttribute("hidden", "true" );
    }
  }
  var dmName = fgo_currentDmName();
  document.getElementById("shownInContextMenu").checked = dmName && ((dmName in shownInContextMenu) 
    ? shownInContextMenu[dmName] : gFlashGotService.DMS[dmName].shownInContextMenu);

  g_cust.syncUI();
}

function fgo_syncReferrer() {
  if(g_referrerRadio.selectedIndex == 1) {
    g_referrerText.removeAttribute("disabled");
  } else {
    g_referrerText.setAttribute("disabled","true");
  }
}
function fgo_enable(id,enabled) {
  var b=document.getElementById(id);
  if(enabled) {
    b.removeAttribute("disabled");
  } else {
     b.setAttribute("disabled","true");
  }
}

function fgo_extText_changed() {
  var enable;
  var value=g_extText.value;
  if((!g_extText.disabled) &&
    /^[\w\-]+$/.test(value)) {
      enable=true;
      for(var j=g_extList.getRowCount();
          j-- >0 && (enable=g_extList.getItemAtIndex(j).value!=value)
          ;);
  } else {
     enable=false;
  }
  fgo_enable("ext-add-button", enable);
}

function fgo_extList_changed() {
  fgo_enable("ext-remove-button",
    g_extList.selectedCount>0);
  fgo_extText_changed();
}

function fgo_ext_add() {
  g_extList.appendItem(g_extText.value,g_extText.value);
  fgo_extText_changed();
}

function fgo_ext_remove() {
  const selectedItems=g_extList.selectedItems;
  for(var j=selectedItems.length; j-->0;) {
    g_extList.removeItemAt(g_extList.getIndexOfItem(selectedItems[j]));
  }
}

function fgo_currentDmName() {
  var dmName;
  return g_downloadManagers.selectedItem && (dmName = g_downloadManagers.selectedItem.getAttribute("label"))
    && gFlashGotService.DMS[dmName] && gFlashGotService.DMS[dmName].supported && dmName || null;
 }

function fgo_save() {
  if(!gFlashGotService) return true;
  
  fgo_visitCheckboxes(
    function(prefName,inverse,checkbox) {
      gFlashGotService.setPref(prefName,inverse ?! checkbox.checked : checkbox.checked);
    }
  );
  
  g_cust.save();
  
  
  var dmName;
  for(dmName in shownInContextMenu) {
    gFlashGotService.DMS[dmName].shownInContextMenu = shownInContextMenu[dmName];
  }
  
  dmName = fgo_currentDmName();
  if(dmName) {
    gFlashGotService.defaultDM = dmName;
  }
  
  const extensions=[];
  var j;
  for(j = g_extList.getRowCount(); j-->0;) {
    extensions[extensions.length]=g_extList.getItemAtIndex(j).value;
  }
  gFlashGotService.extensions=extensions;
  gFlashGotService.setPref("autoReferrer",g_referrerRadio.value=="true");
  gFlashGotService.setPref("fakeReferrer",g_referrerText.value);
  if(g_tmpDir) gFlashGotService.prefs.setComplexValue("tmpDir", Components.interfaces.nsILocalFile, g_tmpDir);
  gFlashGotService.setPref("interceptAll",document.getElementById("interceptAll-radio").selected);
  try {
    if(g_wellGetPath) {
      gFlashGotService.prefs.setComplexValue("WellGet.path", Components.interfaces.nsILocalFile, g_wellGetPath); 
    } else {
      if(gFlashGotService.prefs.prefHasUserValue("WellGet.path")) gFlashGotService.prefs.clearUserPref("WellGet.path");
    }
  } catch(ex) {
    dump(ex);
  }
  gFlashGotService.savePrefs();
  return true;
  
}

function fgo_visitCheckboxes(callback) {
  var j,checkbox,match;
  for(j=g_opts.length; j-->0;) {
    checkbox=g_opts[j];
    if((match = checkbox.id.match(g_rxOpt))) {
      callback(match[2],match[1]=="inv",checkbox);
    }
  }
}


function fgo_showLog() {
  try {
    window.opener.open(Components.classes['@mozilla.org/network/io-service;1'
      ].getService(Components.interfaces.nsIIOService
      ).newFileURI(gFlashGotService.logFile).spec, "_blank",
      "scrollbars=yes,menubar=yes,titlebar=yes,resizable=yes");
  } catch(ex) { dump(ex.message); }
}


function fgo_clearLog() {
  gFlashGotService.clearLog();
}

function fgo_browseTmpDir() {
  const cc=Components.classes;
  const ci=Components.interfaces;
  const fp = cc["@mozilla.org/filepicker;1"].createInstance(ci.nsIFilePicker);
  const title="FlashGot - "+document.getElementById("tmpdir-label").value;
  fp.init(window, title, ci.nsIFilePicker.modeGetFolder);
  try {
    fp.displayDirectory = g_tmpDir == null ? gFlashGotService.tmpDir.parent : g_tmpDir;
  } catch (ex) { gFlashGotService.log(ex); }
  fp.appendFilters(ci.nsIFilePicker.filterAll);
  if (fp.show()==ci.nsIFilePicker.returnOK) {
    g_tmpDir = fp.file.QueryInterface(ci.nsILocalFile);
    document.getElementById("tmpdir-text").value = g_tmpDir.path;
    document.getElementById("tmpdir-warning").style.visibility="visible";
  }
}

function fgo_browseWellGet(reset) {
  if(reset) {
    g_wellGetPath = null;
    document.getElementById("wellget-text").value = "";
    return;
  }
  const cc=Components.classes;
  const ci=Components.interfaces;
  const fp = cc["@mozilla.org/filepicker;1"].createInstance(ci.nsIFilePicker);
  const title="FlashGot - "+document.getElementById("wellget-label").value;
  fp.init(window, title, ci.nsIFilePicker.modeOpen);
  fp.appendFilters(ci.nsIFilePicker.filterApps);
  if(!g_wellGetPath) {
    g_wellGetPath = gFlashGotService.profDir.clone();
    g_wellGetPath.QueryInterface(Components.interfaces.nsILocalFile)
                .initWithPath(g_wellGetPath.path.substring(0,3));
    g_wellGetPath.append("WellGet.exe");
  }
  try {
    fp.displayDirectory = g_wellGetPath.parent;
    fp.defaultString = g_wellGetPath.leafName;
  } catch (ex) { gFlashGotService.log(ex); }
 
  if (fp.show() == ci.nsIFilePicker.returnOK) {
    var f = fp.file.QueryInterface(ci.nsILocalFile);
    if(!(f.exists() && f.isExecutable() &&
        f.path.substring(0,1).toUpperCase() == 
        gFlashGotService.profDir.path.substring(0,1).toUpperCase())) {
      Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                .getService(Components.interfaces.nsIPromptService)
                .alert(window, "FlashGot / WellGet", 
                  gFlashGotService.getString("wellget.mustBeSameDrive", 
                            [gFlashGotService.profDir.path.substring(0,1)]));
      return;
    }
    g_wellGetPath = f;
    document.getElementById("wellget-text").value = f.path;
    gFlashGotService.DMS["WellGet"]._supported = null;
  }
}

var shownInContextMenu = {};
function fgo_shownInContextMenuClicked(cbx) {
  var dmName = fgo_currentDmName();
  if(dmName) shownInContextMenu[dmName] = cbx.checked;
}

function fgo_detectNow() {
  gFlashGotService.globals.DMS = gFlashGotService.checkDownloadManagers(true, true);
  fgo_populateDMS();
}


