/***** BEGIN LICENSE BLOCK *****
    FlashGot - a Firefox extension for external download managers integration
    Copyright (C) 2004-2008 Giorgio Maone - g.maone@informaction.com
***** END LICENSE BLOCK *****/

function FlashGotOverlay() {
  
  try {
    window.gFlashGot = this;
    
    if(!gFlashGotService) throw new Error("FlashGotService not registered!");
    
    // install listeners
    var target = window;
    target.addEventListener("mouseover", function(ev) {
      gFlashGot.hoverElement = ev.target;
    }, false);
    
    target.addEventListener("submit", function(ev) {
      var f = ev.originalTarget;
      if(/#FlashGot_form$/.test(f.action) || 
          f.ownerDocument.defaultView.location.hash == "#FlashGot_Form")
        gFlashGotService.interceptor.forceAutoStart = true;
    }, false);

    target.addEventListener("mouseup", function(ev) {
      gFlashGotService.interceptor.bypassAutoStart = false;
      gFlashGotService.interceptor.forceAutoStart = false;
      if(ev.altKey && !(ev.ctrlKey || ev.metaKey)) {
        function prevent() {
          ev.preventDefault();
          ev.stopPropagation();
          gFlashGot.lastClickCaptureTime = new Date().getTime();
        }
        var invert = gFlashGotService.getPref("invertAltShiftClick", false);
        if((ev.shiftKey && !invert) || (invert && !ev.shiftKey)) {
          gFlashGotService.interceptor.bypassAutoStart =
            gFlashGotService.getPref("bypassCombo",true);
        } else {
          if(gFlashGotService.getPref("altClick")) {
            try {
              if(gFlashGot.downloadSel() || gFlashGot.downloadLink()) {
                prevent();
                return;
              }
            } catch(ex) {}
            gFlashGotService.interceptor.forceAutoStart = true;
          } else {
            return;
          }
        }
        
        ev2 = ev.view.document.createEvent("MouseEvents");
        ev2.initMouseEvent("click",ev.canBubble, ev.cancelable, 
                           ev.view, ev.detail, ev.screenX, ev.screenY, 
                           ev.clientX, ev.clientY, 
                           //ev.ctrlKey, ev.altKey, ev.shiftKey, ev.metaKey,
                           false,false,false,false,
                           ev.button, ev.relatedTarget);
        prevent();
        gFlashGot.hoverElement.dispatchEvent(ev2);
      }
    }, true);
    
    target.addEventListener("click", function(ev) {
      if(ev.altKey && 
        typeof(gFlashGot.lastClickCaptureTime) == "number" && 
        new Date().getTime() - gFlashGot.lastClickCaptureTime < 100
      ) {
        ev.preventDefault();
        ev.stopPropagation();
      }
    }, true);
    
    
    this.contextMenu.addEventListener("popupshowing", function(ev) {
        if(this == ev.explicitOriginalTarget) {
          gFlashGot.prepareContextMenu(ev);
        }
      },false);
    this.contextMenu.addEventListener("popuphidden", function(ev) {
        if(this == ev.explicitOriginalTarget) {
          gFlashGot.disposeContextMenu(ev);
        }
    }, false);
    
    this.toggleMainMenuIcon();
    
    const prevVer = gFlashGotService.getPref("version", "");
    if(prevVer != gFlashGotService.VERSION) {
      gFlashGotService.setPref("version", gFlashGotService.VERSION);
      if(gFlashGotService.getPref("firstRunRedirection", true)) {
        window.setTimeout(function() {
          const url = "http://flashgot.net?ver=" + gFlashGotService.VERSION + "&prev=" + prevVer;
          const browser = getBrowser();
          browser.selectedTab = browser.addTab(url, null);
        }, 100);
      }
    }
    
    if(typeof(flashgot_doDirtyJobs) == "function") {
      window.setTimeout(flashgot_doDirtyJobs,0);
    }
    
    
  } catch(err) {
    dump("FlashGot init error: " + err.message);
    this.log("Unrecoverable init error: " + err.message);
  }
  
  
  
}


FlashGotOverlay.prototype = {
  hoverElement: null
, 
  log: function(msg) {
    gFlashGotService.log(msg);
  }
,
  _contextMenu: null,
  get contextMenu() {
    var cm=this._contextMenu;
    if(!cm) {
      this._contextMenu = cm = 
        document.getElementById("contentAreaContextMenu") || 
        document.getElementById("messagePaneContext")
    }
    return cm;
  }
,
  switchOption: function(opt) {
    gFlashGotService.setPref(opt, !gFlashGotService.getPref(opt));
  }
,
  openOptionsDialog: function() {
    window.open("chrome://flashgot/content/flashgotOptions.xul", "flashgotOptions",
      "chrome,dialog,centerscreen,alwaysRaised");
  }
,
  openAboutDialog: function() {
    window.open("chrome://flashgot/content/about.xul", "flashgotAbout",
      "chrome,dialog,centerscreen");
  }
,
  browse: function(url) {
    var browser =  window.getBrowser();
    browser.selectedTab = browser.addTab(url, null);
  }
,
  browseHomePage: function() {
    this.browse("http://flashgot.net");
  }
,
  get hideIcons() {
    return gFlashGotService.getPref("hide-icons", false);
  }
,
  toggleIcon: function(m, hide) {
    if(!m) return;
    const iconicClass = m.tagName + "-iconic";
    const rx=new RegExp("\\b"+iconicClass+"\\b");
    if(hide) {
      m.className=m.className.replace(rx,"").replace(/\bflashgot-icon-(\w+)\b/,'flashgot-noicon-$1');
    } else {
      const cl=m.className;
      if(!rx.test(cl)) {
        m.className=cl.replace(/\bflashgot-noicon-(\w+)\b/,'flashgot-icon-$1')+" "+iconicClass;
      }
    }
  }
,
  toggleMainMenuIcon: function() {
    this.toggleIcon(document.getElementById("flashgot-menu"),this.hideIcons);
  }
,
  prepareToolsMenu: function(ev) {
    
    function toggleMenu(id,disabled) {
      id="flashgot-main-menuitem-"+id;
      var m=document.getElementById(id);
      if(!m) return;
      m.setAttribute("disabled",disabled);
      gFlashGot.toggleIcon(m,hideIcons);
    }
    
    if(gFlashGotService && !(document.getElementById("flashgot-menu").hidden = gFlashGotService.getPref("hide-menu"))) {
      const dis = !gFlashGotService.DMS.found;
      const hideIcons = this.hideIcons;
      toggleMenu("tabs", dis || !this.isTabbed); 
      toggleMenu("all",dis);
      toggleMenu("sel", dis || this.isSelInvalid);
      toggleMenu("buildGallery",false);
      toggleMenu("opts",false);
      this.prepareOptsMenu(ev.target);
    }
  }
,
  
  prepareContextMenu: function(ev) {
    
    this.toggleMainMenuIcon();
    var menuCount = 0;
    
    function menuSwitch(name, disabled) {
      var menuItem = document.getElementById("flashgot-menuitem-" + name);
      
      if(menuItem && 
        ! ( menuItem.hidden = 
            ( hidden || gFlashGotService.getPref("hide-" + name) ) )
      ) {
       menuItem.setAttribute("disabled", disabled ? "true" : "false");
       if(! (menuItem.hidden=disabled && hideDisabled) ) {
         menuCount++;
       }
       gFlashGot.toggleIcon(menuItem, hideIcons);
      }
    }
    const defaultDM = gFlashGotService.defaultDM;  
    const dms = gFlashGotService.DMS;
    var dm = dms.found ? dms[defaultDM] : null;
    
    gFlashGotService.restoreNativeUIs(document);
    dm.hideNativeUI(document);
   
    const invalidLink = !this.popupLink;
   
    const invalidSel = this.isSelInvalid;
    
    const noLink = this.linksCount == 0;
    const hideDisabled = gFlashGotService.getPref("hideDisabledCmds");
   
    
    var hidden = !(dms.found && dm);
    const hideIcons = this.hideIcons;
    
    var hideLink = invalidLink || hidden || dm.disabledLink;
    var hideSel = invalidSel || hidden  || dm.disabledSel;
    this.prepareCommandsMenu(document.getElementById("flashgot-menuitem-it"), hideLink && hideSel);
    
    menuSwitch("it",  hideLink);
    menuSwitch("sel", hideSel);
    menuSwitch("all", noLink || hidden || dm.disabledAll);
    menuSwitch("tabs", (! (typeof(gBrowser)=="object" 
      && gBrowser.browsers && gBrowser.browsers.length>1) ) 
                           || hidden || dm.disabledAll);
    menuSwitch("autotest", hidden);
    hidden=false;
    menuSwitch("buildGallery", false);
    
    const optsMenu = document.getElementById("flashgot-menu-options");
    this.toggleIcon(optsMenu,hideIcons);
    if(!(optsMenu.hidden = gFlashGotService.getPref("hide-options"))) {
      menuCount++;
    }
    
    const submenu = document.getElementById("flashgot-submenu");
    this.toggleIcon(submenu, hideIcons);
    const subanchor = document.getElementById("flashgot-submenu-anchor");
    const subpop = subanchor.parentNode;
    const sep1 = document.getElementById("flashgot-context-separator");
    const sep2 = document.getElementById("flashgot-context-separator2");
    const menu = sep1.parentNode;
    var next=null;
    
    const nested = gFlashGotService.getPref("nested-menu") && (menuCount > 1);
    submenu.hidden = !nested;
    if(nested) {
      menuCount=0;
      if(!subanchor.nextSibling) {
        document.getElementById("flashgot-menuitem-tabs").setAttribute("accesskey", document.getElementById("flashgot-main-menuitem-tabs").getAttribute("acceskey"));
        for(menuItem = sep1.nextSibling;
            menuItem && (menuItem != sep2); 
            menuItem = next) {
          next=menuItem.nextSibling;
          subpop.appendChild(menuItem);
        }
      }
    } else {
      document.getElementById("flashgot-menuitem-tabs").removeAttribute("accesskey");
      for(var menuItem = subanchor.nextSibling; menuItem; menuItem = next) {
        next=menuItem.nextSibling;
        menu.insertBefore(menuItem, sep2);
      }
    }
    sep1.hidden = menuCount == 0;
  }
,
  disposeContextMenu: function(ev) {
    gFlashGotService.restoreNativeUIs(document);
  },
  prepareCommandsMenu: function(anchorNode, hideOnly) {
    var node, parentNode = anchorNode.parentNode;
    while((node = anchorNode.previousSibling) && /\bflashgot-command-menuitem\b/.test(node.className)) {
      parentNode.removeChild(node);
    }
    if(hideOnly) return;
    
    var mi, dm;
    const dms = gFlashGotService.DMS;
    for(var j = 0, len = dms.length; j < len; j++) {
      dm = dms[j];
      if(dm.supported && dm.shownInContextMenu) {
        mi = document.createElement("menuitem");
        mi.setAttribute("class", "menuitem-iconic flashgot-command-menuitem");
        mi.setAttribute("label", dm.name);
        mi.setAttribute("id", "flashgot-command-mi-" + dm.codeName);
        mi.setAttribute("oncommand", "gFlashGot.downloadSel(this.label) || gFlashGot.downloadPopupLink(this.label)");
        parentNode.insertBefore(mi, anchorNode);
        dm.hideNativeUI(document);
      }
    }
  },
  
  
  prepareOptsMenu: function(parentNode) {
   
    const opts = parentNode.getElementsByTagName("menuitem");
    
    this.toggleIcon(document.getElementById("flashgot-tbb-menuitem-opts"), this.hideIcons);
    
    var menuItem, id, match, lastMenu=null, isTBB=false;
    var j = opts.length;
    while(j-- > 0) {
      menuItem = opts[j];
      if((id=menuItem.id)) {
        if((match = id.match(/opt-(.*)/))) {
          menuItem.setAttribute("checked",
            gFlashGotService.getPref(match[1]) ? "true" : "false");
        } else if((match = id.match(/^flashgot-(\w+)-menuitem-nodms$/))) {
          lastMenu = menuItem;
          isTBB = match[1]=="tbb";
        }
      }
    }
    
    if(!lastMenu) return;
    
    const defaultDM = gFlashGotService.defaultDM;  
    const dms = gFlashGotService.DMS;
    var menuItemId;
    if(dms.found) {
      var idPrefix="flashgot-menuopt-dm-";
      var eventPostfix;
      if(isTBB) {
        idPrefix += "tbb-";
        eventPostfix = "gFlashGot.downloadSel() || gFlashGot.downloadAll()";
        var rsMenu = document.getElementById("flashgot-tbb-menuitem-rsPremium");
        if(gFlashGotService.getPref("rsPremium", false)) {
          rsMenu.removeAttribute("hidden");
        } else {
          rsMenu.setAttribute("hidden", "true");
        }
      } else {
        eventPostfix = "gFlashGot.downloadSel() || gFlashGot.downloadPopupLink()";
      }
      lastMenu.setAttribute("hidden", "true");
      parentNode = lastMenu.parentNode;
      var dm;
      const miclass = "flashgot-dms-entry";
      // add menu items
      for(j = dms.length; j-- >0;) {
        dm = dms[j];
        if(dm.supported) {
          menuItemId = idPrefix + dm.codeName;
          menuItem = document.getElementById(menuItemId);
          if(!menuItem) {
            menuItem = document.createElement("menuitem");
            menuItem.setAttribute("class", miclass);
            menuItem.setAttribute("id", menuItemId);
            menuItem.setAttribute("type", "radio");
            menuItem.setAttribute("autocheck", "true");
            menuItem.setAttribute("oncommand", 
                "gFlashGotService.defaultDM = this.label; window.setTimeout(function() { " + 
                  eventPostfix + " }, 0)");
            menuItem.setAttribute("label", dm.name);
            parentNode.insertBefore(menuItem, lastMenu);
          }
          menuItem.setAttribute("checked", (defaultDM == dm.name) ? "true" : "false");
          lastMenu = menuItem;
        }
      }
      // remove menu items
      var nodes=parentNode.getElementsByAttribute("class", miclass);
      for(j=nodes.length; j-->0;) {
        dm=dms[nodes[j].getAttribute("label")];
        if(!(dm && dm.supported)) {
          parentNode.removeChild(nodes[j],true);
        }
      }
    } else {
      lastMenu.removeAttribute("hidden");
    }
  }
,

  get srcWindow() {
    return document.commandDispatcher.focusedWindow;
  }
,
  get srcDocument() {
    return this.srcWindow.document;
  }
,

  get isTabbed() {
    var b = getBrowser();
    return b && b.browsers && b.browsers.length > 1;
  }
,
  get isSelInvalid() {
    return this.srcWindow.getSelection().isCollapsed && !this.grabSelectedTextFields(null, true);
  }
,
  get popupLink() { 
    return this.findLinkAsc(document.popupNode);
  }
,
  get linksCount() {
    const doc = this.srcDocument;
    if(!doc) return 0;
    
    var count = doc.links.length;
    
    if(gFlashGotService.getPref("includeImages")) 
       count += doc.images.length;
    count += doc.embeds.length;
    
    return count;
  }
,
  getLinks: function(filter, includeImages, doc) {
    if(typeof(doc) != "object") {
      doc = this.srcDocument;
    }
    if(doc == null) return [];
    const allLinks = [];
    const lm = gFlashGotService.lookupMethod;


    function wrapAndFilter(newL, l) {
      const href = l.src;
      if (!href) return null;
      
      if(href.lastIndexOf("://", 9) < 0) {
        try {
          newL.href = 
                (uriResolver || 
                 (uriResolver = 
                  Components.classes['@mozilla.org/network/io-service;1']
                            .getService(Components.interfaces.nsIIOService)
                            .newURI(doc.URL, null, null))).resolve(href);
        } catch(ex) {
          return false;
        }
      } else {
        newL.href =  href 
      }
      
      const ga = lm(l, "getAttribute");
      var des = ga("alt") || ga("title") || href.substring(href.lastIndexOf("/") + 1);
      var w, h;
      (w = ga("width")) && (h = ga("height")) && (des += " (" + w + "," + h + ")");

      newL.description = des;

      return filter(newL, l);
    }
    
    function filterLinks(elems, filter, tagName) {
      const wrap = tagName == "A";
      try {
        if(elems) {
          var l, newL;
          const e_item = lm(elems,"item");
          for(var j = 0, len = lm(elems,"length")(); j < len; j++) {
            l = e_item(j);
            newL = wrap ? gFlashGot._wrapAnchor(l, lm) : { tagName: tagName };
            if(newL && filter(newL, l)) {
              allLinks[allLinks.length] = newL;
            }
          }
        }
      } catch(ex) {}
    }
    
    
    
    filterLinks(doc.links, filter, "A"); 
    
    var uriResolver = null;
    
    if(includeImages) {
      filterLinks(doc.images, wrapAndFilter,"IMG");
    }
    
    filterLinks(doc.embeds,wrapAndFilter,"EMBED");

    return allLinks;
  }
,
  get referrer() {
    if(this._referrer) return this._referrer;
    var docURL = this.srcDocument.URL;
    var gb = docURL && docURL.substring(0,5) == "file:" && this.getBuildGalleryData();
    return gb ? gb.referrer : docURL;
  }
,  
  set referrer(r) {
    return this._referrer = r; 
  },
  
  getBuildGalleryData: function(doc) {
    doc = doc || window.content.document;
    const props = ['preview', 'content', 'referrer'];
    var gb = {};
    try {
      for each(var p in props) {
        gb[p] = doc.getElementById(p).firstChild.nodeValue;
      }
    } catch(e) {
      gb = null;
    }
    return gb;
  },
  
  grabSelectedTextFields: function(selection, justCheck) {
    const lm = gFlashGotService.lookupMethod;
    const doc = this.srcDocument;
    var ff, f, j;
    const vv = [];
    var selStart, selEnd;
    for each(var t in ["textarea", "input"]) {
      var ff = doc.getElementsByTagName(t);
      for(j = 0; (f = ff[j]); j++) {
        try {
          if(selection && selection.containsNode(f, true)) {
            if(justCheck) return true;
            vv.push(lm(f, "value")());
          }
          else {
            selStart = lm(f, "selectionStart")(), selEnd = lm(f, "selectionEnd")();
            if(selStart < selEnd) {
              if(justCheck) return true;
              vv.push(lm(f, "value")()).substring(selStart, selEnd);
            }
          }
        } catch(e) {}
      }
    }
    return justCheck ? false : vv;
  }
,
  getSelectionLinks: function(includeImages) {
    const selection = this.srcWindow.getSelection();
    
    // link nodes detection
    var links = this.getLinks(function(link, trueNode) {
      return link && gFlashGot.checkLink(link) && 
        selection.containsNode(trueNode ? trueNode : link, true); 
    }, includeImages); 
    
    var selString = selection.toString();
    
    // add textboxes
    
    selString += this.grabSelectedTextFields(selection).join("\n");
    
    var m;
    
    // password detection
    var pwd = gFlashGotService.getPref("selection.guessPassword", true) &&
        (m = selString.match(/\s(?:password|passw|pass|pwd|pw)\W+(.*)/i)) && m[1];

    // text links detection
    m = selString.match(
      /\b(h.{2}p:\/\/|ftp:\/\/|mms:\/\/|rtsp:\/\/|[a-z]+[a-z\d]+\.[a-z\d\-\.]+\/)[^\s]*/gi);
    delete selString;
    var j, k;
    if(m) {
      var descMap = null;
      var href, desc;
      var d, diff;
      
      linksLoop:
      for(j = 0, len = m.length; j < len; j++) {
        desc = m[j];
        href = desc.replace(/^h.{2}p/i, "http").replace(/^([a-z]+[a-z\d]+\.[a-z\d\.]+\/)/i, "http://$1");
        if(href) {
          if(!descMap) { // we use it to avoid textual "quasi-duplicates", as http://somepart...oftheurl
            descMap = {};
            for(k = links.length; k-- > 0;) {
              descMap[links[k].description] = true;
            }
          }
          if (descMap[href] || descMap[desc]) continue;
          if (!/^https?:/.test(desc)) {
            for (d in descMap) {
              diff = d.length - desc.length;
              if (diff >= 0 && d.indexOf(desc) == diff) continue linksLoop; 
            }
          }
          links[links.length] = {href: href, description: m[j]};
        }
      }
    }
    
    if(pwd) {
      var des;
      pwd = " pw: " + pwd;
      for(j = links.length; j-- > 0;) {
        des = links[j].description || "";
        links[j].description = des.substring(0, 4) == "http" ? pwd : des.concat(pwd);
      }
    }
    return links;
  }
,
  checkLink: function(link) {
    return link.href && /^[a-z]+:\/\/.*/i.test(link.href) && !/^(javascript|mailto|news|file|data):/i.test(link.href);
  }
,
  _wrapAnchor: function(node, lm) {
    var isAnchor = (node instanceof HTMLAnchorElement);
    if(isAnchor || node instanceof HTMLAreaElement) {
      var d;
      var href = lm(node, "href")();
      if(href) return { 
        href: href,
        tagName: "A",
        getElementsByTagName: lm(node, "getElementsByTagName"),
        description: isAnchor 
          ? (d = lm(node,"title")()) && d.replace(/\s+/g," ") || 
            (d = lm(node, "innerHTML")()) && d.replace(/\s+/g," ")
                                          .replace(/<.*?>/g, "") 
          : (d = (lm(node, "alt")() || lm(node, "title")())) &&
             d.replace(/\s+/g," ") 
        };
    }
    return null;
  }
,
  findLinkAsc: function(node) {
     const lm = gFlashGotService.lookupMethod;
     var anchor;
     while(node) {
      anchor = this._wrapAnchor(node, lm);
      if(anchor) return this.checkLink(anchor) ? anchor : null;
      node = node.parentNode;
    }
    return null;
  }
,
  delayCmd: function(cmd) {
    const pg = this.createProgress();
    pg.update(5);
    window.setTimeout(function() {
      try {
        pg.value = 100;
        gFlashGot["download"+cmd]();
        gFlashGot.showProgress();
      } catch(ex) {
        dump(ex);
      }
    },0);
  }
,
  downloadPopupLink: function(dmName) {
    const link = this.popupLink;
    return link && this.download([link], gFlashGotService.OP_ONE, dmName);
  }
,
  downloadLink: function(dmName) {
    const sel=this.srcWindow.getSelection();
    var link = this._wrapAnchor(sel.anchorNode, gFlashGotService.lookupMethod);
    if(!link) {
      link = this.findLinkAsc(this.hoverElement);
    }
    return link ? this.download([link], gFlashGotService.OP_ONE, dmName):false;
  }
,
  downloadSel: function(dmName) {
    if(this.isSelInvalid) return false;
    const startTime = new Date().getTime();
    const links = this.getSelectionLinks(gFlashGotService.getPref("includeImages"));
    if(!links.length) return false;
    links.startTime = startTime;
    return this.download(links, gFlashGotService.OP_SEL, dmName);
  }
,
 WrappedCollection: function(coll) {
  this.item = gFlashGotService.lookupMethod(coll, "item");
  this.length = gFlashGotService.lookupMethod(coll, "length")();
 }
,
  collectAllLinks: function(doc ,tagName) {
    var links=[];
    const includeImages=gFlashGotService.getPref("includeImages");
    if(tagName) {
      var frames=new this.WrappedCollection(doc.getElementsByTagName(tagName));
      const lm = gFlashGotService.lookupMethod;
      var contentDocument;
      for(var j=frames.length; j-->0;) {
        try {
          if((contentDocument = lm(frames.item(j), "contentDocument")())) {
            links=links.concat(
              this.collectAllLinks(contentDocument));
          }
        } catch(ex2) {
        }
      }
    } else {
      links = links.concat(this.getLinks(this.checkLink, includeImages, doc)
        ).concat(this.collectAllLinks(doc,"frame")
        ).concat(this.collectAllLinks(doc,"iframe"));
    }
    return links;
  }
,
  downloadAll: function(dmName) {
    const startTime = new Date().getTime();
    const links = this.collectAllLinks(content.document);
    links.startTime = startTime;
    return this.download(links, gFlashGotService.OP_ALL, dmName);
  }
,
  downloadTabs: function(dmName) {
    if(!this.isTabbed) return this.downloadAll(dmName);
    const bb = getBrowser().browsers;
    var doc;
    var links=[];
    for (var j = 0, len = bb.length; j<len; j++) 
      if ((doc = bb[j].contentDocument))
        links = links.concat(this.collectAllLinks(doc));

    return links.length &&
       this.download(links, gFlashGotService.OP_ALL, dmName);
  }
,
  autotest: function() {
   
    const ps = Components.classes["@mozilla.org/embedcomp/prompt-service;1"
      ].getService(Components.interfaces.nsIPromptService);


    var flags=ps.BUTTON_OK * ps.BUTTON_POS_0 +
          ps.BUTTON_TITLE_IS_STRING * ps.BUTTON_POS_1 +
          ps.BUTTON_TITLE_CANCEL  * ps.BUTTON_POS_2;

    const dms=gFlashGotService.DMS;
    const ops={
      Link: this.downloadLink, 
      Selection: this.downloadSel,
      All: this.downloadAll 
    };
    var dm,opName,res,opFunc;
    for(var j=dms.length; j-- >0;) {
      dm=dms[j];
      if(dm.supported) {
        for(opName in ops) {
          res=ps.confirmEx(window,"FlashGot Autotest",
                  "Performing FlashGot "+opName+" on "+dm.name,
                  flags, null, "Skip", null, null, {});
          if(res==0) {
            opFunc=ops[opName];
            try {
              opFunc.call(this,dm.name);
            } catch(ex) {
              alert("Error:\n"+ex.message);
              throw ex;
            }
          } else if(res==2) return;
        }
      }
    }
  }
,
  download: function(links, opType, dmName) {
    try {
      links.referrer = this.referrer;
      links.browserWindow = window;
      links.document = this.srcDocument;
    } catch(ex) {}
    
    links.progress = this.createProgress();
    const ret = gFlashGotService.download(links, opType, dmName);
    if(!ret) links.progress.update(100);
    return ret;
  }
,
  progressList: [],
  createProgress: function(v) {
    return new this.Progress(v);
  },
  Progress: function(v) {
    this.value = v || 0;
    this.showing = false;
    this.update = function(v) {
      if(!this.showing) {
        this.showing = true;
        gFlashGot.progressList.push(this);
      }
      if(typeof(v) == "number") this.value = v;
      gFlashGot.showProgress();
    }
  },
  
  showProgressValue: function(v) {
    document.getElementById("flashgot-progresspanel").setAttribute("collapsed",
        v < 100 ? "false" : "true");
    document.getElementById("flashgot-progressmeter").value = v;
    gFlashGotService.yield();
  },
  
  showProgress: function() {
    const pgl = this.progressList; 
    var len = pgl.length;
    var value;
    if(len > 0) {
      value = 0;
      for(var j = len; j-- > 0;) {
        var v = pgl[j].value;
        if(v < 100) {
          value += v;
        } else {
          pgl.splice(j, 1);
          len--;
        }
      }
      value = len > 0 ? Math.round(value / len) : 100;
    } else {
      value = 100;
    }
    this.showProgressValue(value);
  }
,
  buildGallery: function() {
    var previewURL = null, contentURL = null;
    var gb = this.getBuildGalleryData();
    if(gb) {
      dump("FGBG: reusing gallery data\n");
      previewURL = gb.preview;
      contentURL = gb.content;
    } else {
      var links=this.getSelectionLinks(true);
      if(!(links && links.length)) {
        dump("FGBG: no selection links, using "); 
        if(this.popupLink) {
         dump("popup link\n");
         links = [this.popupLink];
        } else {
         dump("all links\n");
         links=this.getLinks(this.checkLink, true);
        }
      }
      var len;
      if(links && (len=links.length)) {
        const previewRX = /\d+.*\.(jpg|jpeg|png|gif|bmp)(\?|$)/i;
        const contentRX = /\d+.*\.[a-z0-9]{2,4}(\?|$)/i;
        const lm = gFlashGotService.lookupMethod; 
        var l, tag, url, imgs, i, iLen, i_item, imgSrc;
        for(var j=0; j<len && ! (contentURL && previewURL); j++) {
          l=links[j];
          tag=l.tagName && l.tagName.toUpperCase();
          url=l.href;
          if(tag!="IMG" && contentRX.test(url)) {
            contentURL=url;
            if(tag=="A" && l.getElementsByTagName ) {
              imgs=l.getElementsByTagName("img");
              i_item=lm(imgs, "item");
              for(i = 0, iLen = lm(imgs,"length")(); i < iLen; i++) {
                imgSrc = lm(i_item(i),"src")();
                if(previewRX.test(imgSrc)) {
                  previewURL = imgSrc;
                  break;
                }
              }
            }
          }
        }
        if( (!previewURL) && (tag=="img" || previewRX.test(url)) ) {
          previewURL=url;
        } 
      }
      if(!previewURL) previewURL="";
      if(previewURL && !contentURL) contentURL=previewURL;
    }
    window.openDialog("chrome://flashgot/content/flashgotGalleryBuilder.xul","_blank",
      "chrome,dialog,centerscreen,resizable",
      { 
        previewURL: previewURL, 
        contentURL: contentURL, 
        referrerURL: this.referrer,
        originalWindow: window,
        tmpDir: gFlashGotService.tmpDir,
        prefs:  gFlashGotService.globals.prefs
      }
    );
  },
  
  rsPremiumHack: function() {
    const bb = getBrowser().browsers; 
    var w, d, f, fj, aa, k, files;
    var allFiles = []; 
    for(var j = 0; j < bb.length; j++) {
      d = (w = bb[j].contentWindow) && w.document;
      if(!d) continue;
      for(fj = d.forms.length; fj-- > 0;) {
        f = d.forms[fj];
        if(/rapidshare\.(?:com|de)/.test(f.action)) { 
          b = f.elements["dl.start"];
          if(b) {
            if(b.length == 2) {
              b = b[0];
            }
            b.type = "hidden";
            f.submit();
            break;
          }
        }
      }
      if(fj == -1 && /\brapid(share|safe)\.[\w]+$/.test(w.location.host)) {
        aa = d.getElementsByTagName("a");
        files = [];
        for(k = 0; k < aa.length; k++) {
          if(/^http:\/\/[^\/]*rapidshare\.(?:com|de)\/files\/\d+.*[^#]$/.test(aa[k].href)) {
            files.push({ href: aa[k].href, description: aa[k].innerHTML });
          }
        }
        if(files.length) {
          allFiles.push(files[Math.round(Math.random() * (files.length - 1))]);
          d.title = "***" + d.title;
        }
      }
    }
    if(allFiles.length) {
      this.download(allFiles);
    }
  }

}

window.addEventListener("load",  
  function(ev) {
    if(typeof(XPCNativeWrapper)!="function") {
       Components.classes["@mozilla.org/moz/jssubscript-loader;1"]
                 .getService(Components.interfaces.mozIJSSubScriptLoader)
                 .loadSubScript("chrome://global/content/XPCNativeWrapper.js", null);
    }
    new FlashGotOverlay();
  }, false);



