var gReferrerSpoofer = null;

function ReferrerSpoofer() {
  this.osrv = Components.classes["@mozilla.org/observer-service;1"]
                        .getService(Components.interfaces.nsIObserverService);
  this.osrv.addObserver(this, "http-on-modify-request", false);
  gReferrerSpoofer = this;
}

ReferrerSpoofer.prototype = {
  map: {},
  add: function(realURL, spoofedURL) {
    
    var obj = (realURL in this.map) ? this.map[realURL] : this.map[realURL]={ count: 0 };
    obj.referrer = spoofedURL;
    obj.count++;
  },
  remove: function(realURL) {
    if((realURL in this.map) && !(--(this.map[realURL].count)) ) delete this.map[realURL];
  },
  observe: function(channel, aTopic, aData) {
    channel.QueryInterface(Components.interfaces.nsIHttpChannel);
    if(channel.referrer && channel.referrer.spec in this.map) {
      channel.referrer.spec = this.map[channel.referrer.spec].referrer;
    }
  },
  dispose: function() {
    this.osrv.removeObserver(this, "http-on-modify-request");
  },
  QueryInterface: function(iid) {
    if (!iid.equals(Components.interfaces.nsISupports) &&
      !iid.equals(Components.interfaces.nsIObserver))
      throw Components.results.NS_ERROR_NO_INTERFACE;
    return this;
  },
  connect: function(browser) {
    if(!("gFlashGotReferrerSpoofer" in browser)) {
      browser.gFlashGotReferrerSpoofer = true;
      browser.addEventListener("load", this.onLoad, true);
      browser.addEventListener("unload", this.onUnload, true);
    }
  },
  getReferrer: function(doc) {
    return doc._flashgotGB && doc._flashgotGB.referrer;
  },
  onLoad: function(ev) {
    var ref = gReferrerSpoofer.getReferrer(ev.target);
    if(ref) gReferrerSpoofer.add(ev.target.URL, ref);
  },
  onUnload: function(ev) {
    var ref = gReferrerSpoofer.getReferrer(ev.target);
    if(ref) gReferrerSpoofer.remove(ev.URL);
  }
}
