//@line 36 "/e/fx19rel/WINNT_5.2_Depend/mozilla/browser/components/safebrowsing/content/sb-loader.js"

var safebrowsing = {
  appContext: null,

  startup: function() {
    setTimeout(safebrowsing.deferredStartup, 2000);
    window.removeEventListener("load", safebrowsing.startup, false);
  },

  deferredStartup: function() {
    this.appContext = Cc["@mozilla.org/safebrowsing/application;1"].
                      getService().wrappedJSObject;
    this.appContext.initialize();
  },

  setReportPhishingMenu: function() {
    var uri = getBrowser().currentURI;
    var broadcaster = document.getElementById("reportPhishingBroadcaster");
    if (uri && (uri.schemeIs("http") || uri.schemeIs("https")))
      broadcaster.removeAttribute("disabled");
    else
      broadcaster.disabled = true;
  },

  /**
   * Used to report a phishing page or a false positive
   * @param name String either "Phish" or "Error"
   * @return String the report phishing URL.
   */
  getReportURL: function(name) {
    var reportUrl = this.appContext.getReportURL(name);

    var pageUrl = getBrowser().currentURI.asciiSpec;
    reportUrl += "&url=" + encodeURIComponent(pageUrl);

    return reportUrl;
  }
}

window.addEventListener("load", safebrowsing.startup, false);
