
var FireGestures = {

	_gestureHandler: null,

	_gestureMappings: null,


	init: function()
	{
		if ("aioGestTable" in window || "mozgestInit" in window || "ucjsMouseGestures" in window)
			return alert("ERROR: Detected an extension or script which conflicts with FireGestures.");
		this._gestureHandler = Cc["@xuldev.org/firegestures/handler;1"].createInstance(Ci.xdIGestureHandler);
		this._gestureHandler.init(gBrowser.mPanelContainer, this);
		this._gestureMappings = Cc["@xuldev.org/firegestures/mappings;1"].getService(Ci.xdIGestureMappings);
		this._statusTextField = document.getElementById("statusbar-display");
	},

	uninit: function()
	{
		if (this._gestureHandler) {
			this._gestureHandler.destroy();
			delete this._gestureHandler;
		}
		if (this._clearStatusTimer)
			window.clearTimeout(this._clearStatusTimer);
		this._statusTextField = null;
	},


	onDirectionChanged: function(event, aDirection)
	{
		var command = this._gestureMappings.getCommandForDirection(aDirection);
		var name = command ? " (" + command.name + ")" : "";
		this.setStatusText(this.getLocaleString("GESTURE") + ": " + aDirection + name);
	},

	onMouseGesture: function(event, aDirection)
	{
		try {
			var command = this._gestureMappings.getCommandForDirection(aDirection);
			if (!command)
				throw null;
			if (command.type == this._gestureMappings.TYPE_SCRIPT)
				(new Function("event", command.value))(event);
			else
				this._performAction(event, command.value);
		}
		catch(ex) {
			this.setStatusText(
				ex ? 
				this.getLocaleString("GESTURE_FAILED")  + ": " + aDirection + " (" + ex + ")" :
				this.getLocaleString("GESTURE_UNKNOWN") + ": " + aDirection
			);
		}
		this.clearStatusText(3000);
	},

	onExtraGesture: function(event, aGesture)
	{
		this.setStatusText("");
		switch (aGesture) {
			case "wheel-up": 
			case "wheel-down": 
			case "rocker-left": 
			case "rocker-right": 
				this.onMouseGesture(event, aGesture);
				return;
			case "keypress-start": 
				this._linkURLs = [];
				this._linkElts = [];
				break;
			case "keypress-progress": 
				var linkURL = this.getLinkURL(event.target);
				if (!this._linkURLs)
					this._linkURLs = [];
				if (linkURL && this._linkURLs.indexOf(linkURL) < 0) {
					try {
						this.checkURL(linkURL, event.target.ownerDocument);
						this._linkURLs.push(linkURL);
						this._linkElts.push(event.target);
						event.target.style.MozOutline = "1px dashed darkorange";
					}
					catch(ex) {}
				}
				break;
			case "keypress-stop": 
				for (var i = 0; i < this._linkURLs.length; i++) {
					if (event.shiftKey)
						gBrowser.loadOneTab(this._linkURLs[i], null, null, null, true, false);
					else if (event.ctrlKey)
						window.setTimeout(
							'saveURL("' + this._linkURLs[i] + '", null, null, false, true, null);',
							i * 1000
						);
					this._linkElts[i].style.MozOutline = "";
					this._linkElts[i] = null;
				}
				this._linkURLs = null;
				this._linkElts = null;
				break;
			case "gesture-timeout": 
				this.setStatusText("");
				break;
		}
	},


	getLocaleString: function(aStringKey, aReplacements)
	{
		if (!this._stringBundle) {
			const kBundleURI = "chrome://firegestures/locale/firegestures.properties";
			var bundleSvc = Cc["@mozilla.org/intl/stringbundle;1"].getService(Ci.nsIStringBundleService);
			this._stringBundle = bundleSvc.createBundle(kBundleURI);
		}
		try {
			if (!aReplacements)
				return this._stringBundle.GetStringFromName(aStringKey);
			else
				return this._stringBundle.formatStringFromName(aStringKey, aReplacements, aReplacements.length);
		}
		catch(ex) {
			return aStringKey;
		}
	},

	_stringBundle: null,


	setStatusText: function(aText)
	{
		this._statusTextField.label = aText;
	},

	clearStatusText: function(aMillisec)
	{
		if (this._clearStatusTimer) {
			window.clearTimeout(this._clearStatusTimer);
			this._clearStatusTimer = null;
		}
		var text = this._statusTextField.label;
		var callback = function(self) {
			self._clearStatusTimer = null;
			if (self._statusTextField.label == text)
				self.setStatusText("");
		};
		this._clearStatusTimer = window.setTimeout(callback, aMillisec, this);
	},

	_statusTextField: null,

	_clearStatusTimer: null,



	_performAction: function(event, aCommand)
	{
		switch (aCommand) {
			case "FireGestures:GoUpperLevel": 
				this.goUpperLevel();
				break;
			case "FireGestures:IncrementURL": 
				this.goNumericURL(+1);
				break;
			case "FireGestures:DecrementURL": 
				this.goNumericURL(-1);
				break;
			case "FireGestures:MinimizeWindow" :
				window.minimize();
				break;
			case "FireGestures:MaximizeWindow": 
				window.windowState == window.STATE_MAXIMIZED ? window.restore() : window.maximize();
				break;
			case "cmd_close": 
				gBrowser.removeCurrentTab();
				break;
			case "FireGestures:UndoCloseTab": 
				try { undoCloseTab(); }
				catch(ex) {
					if ("undoRemoveTab" in gBrowser)
						gBrowser.undoRemoveTab();
					else
						throw "Session Restore feature is disabled.";
				}
				break;
			case "FireGestures:PreviousTab": 
				gBrowser.mTabContainer.advanceSelectedTab(-1, true);
				break;
			case "FireGestures:NextTab": 
				gBrowser.mTabContainer.advanceSelectedTab(+1, true);
				break;
			case "FireGestures:ReloadAllTabs": 
				gBrowser.reloadAllTabs(gBrowser.mCurrentTab);
				break;
			case "FireGestures:CloseOtherTabs": 
				gBrowser.removeAllTabsBut(gBrowser.mCurrentTab);
				break;
			case "FireGestures:CloseLeftTabs": 
				this.closeMultipleTabs("left");
				break;
			case "FireGestures:CloseRightTabs": 
				this.closeMultipleTabs("right");
				break;
			case "cmd_textZoomReduce": 
			case "cmd_textZoomEnlarge": 
			case "cmd_textZoomReset": 
				if ("FullZoom" in window) {
					var mdv = gBrowser.markupDocumentViewer;
					if (aCommand == "cmd_textZoomReset")
						mdv.textZoom = 1.0;
					else
						mdv.textZoom += (aCommand == "cmd_textZoomReduce") ? -0.2 : 0.2;
				}
				else
					document.getElementById(aCommand).doCommand();
				break;
			case "FireGestures:ScrollTop": 
				goDoCommand("cmd_scrollTop");
				break;
			case "FireGestures:ScrollBottom": 
				goDoCommand("cmd_scrollBottom");
				break;
			case "FireGestures:ScrollPageUp": 
				goDoCommand("cmd_scrollPageUp");
				break;
			case "FireGestures:ScrollPageDown": 
				goDoCommand("cmd_scrollPageDown");
				break;
			case "FireGestures:ShowOnlyThisFrame": 
				var docURL = this.sourceNode.ownerDocument.location.href;
				this.checkURL(docURL, gBrowser.contentDocument, Ci.nsIScriptSecurityManager.DISALLOW_SCRIPT);
				gBrowser.loadURI(docURL);
				break;
			case "FireGestures:OpenFrame": 
			case "FireGestures:OpenFrameInTab": 
			case "FireGestures:ReloadFrame": 
			case "FireGestures:AddBookmarkForFrame": 
			case "FireGestures:SaveFrame": 
			case "FireGestures:ViewFrameSource": 
			case "FireGestures:ViewFrameInfo": 
				var funcName = aCommand.substr("FireGestures:".length);
				funcName = funcName.charAt(0).toLowerCase() + funcName.substr(1);
				nsContextMenu.prototype.target = this.sourceNode;
				try { nsContextMenu.prototype[funcName](); }
				finally { nsContextMenu.prototype.target = null; }
				break;
			case "FireGestures:OpenLink": 
				var linkURL = this.getLinkURL();
				if (!linkURL)
					throw this.getLocaleString("ERROR_NOT_ON_LINK");
				if ("nodePrincipal" in this.sourceNode.ownerDocument)
					openNewWindowWith(linkURL, this.sourceNode.ownerDocument, null, false);
				else
					openNewWindowWith(linkURL, this.sourceNode.ownerDocument.location.href, null, false);
				break;
			case "FireGestures:OpenLinkInBgTab": 
			case "FireGestures:OpenLinkInFgTab": 
				var linkURL = this.getLinkURL();
				if (!linkURL)
					throw this.getLocaleString("ERROR_NOT_ON_LINK");
				var doc = this.sourceNode.ownerDocument;
				this.checkURL(linkURL, doc);
				var charset = window.content.document.characterSet;
				var referer = makeURI(doc.location.href);
				var background = aCommand == "FireGestures:OpenLinkInBgTab";
				gBrowser.loadOneTab(linkURL, referer, charset, null, background, false);
				break;
			case "FireGestures:AddBookmarkForLink": 
				var linkURL = this.getLinkURL();
				if (!linkURL)
					throw this.getLocaleString("ERROR_NOT_ON_LINK");
				if ("BookmarksUtils" in window)
					BookmarksUtils.addBookmark(linkURL, this.getLinkText());
				else
					PlacesCommandHook.bookmarkLink(PlacesUtils.bookmarksMenuFolderId, linkURL, this.getLinkText());
				break;
			case "FireGestures:SaveLink": 
				var linkURL = this.getLinkURL();
				if (!linkURL)
					throw this.getLocaleString("ERROR_NOT_ON_LINK");
				var doc = this.sourceNode.ownerDocument;
				this.checkURL(linkURL, doc);
				saveURL(linkURL, this.getLinkText(), null, true, false,
				        makeURI(doc.location.href, doc.characterSet));
				break;
			case "FireGestures:ViewImage": 
				var imageURL = this.getImageURL();
				if (!imageURL)
					throw this.getLocaleString("ERROR_NOT_ON_IMAGE");
				var onCanvas = this.sourceNode instanceof HTMLCanvasElement;
				if (onCanvas)
					this.checkURL(imageURL, gBrowser.contentDocument, Ci.nsIScriptSecurityManager.DISALLOW_SCRIPT);
				openUILink(imageURL, event);
				break;
			case "FireGestures:SaveImage": 
			case "FireGestures:SaveImageNow": 
				var imageURL = this.getImageURL();
				if (!imageURL)
					throw this.getLocaleString("ERROR_NOT_ON_IMAGE");
				var onCanvas = this.sourceNode instanceof HTMLCanvasElement;
				if (onCanvas)
					this.checkURL(imageURL, this.sourceNode.ownerDocument);
				var skipPrompt = aCommand == "FireGestures:SaveImageNow";
				saveURL(imageURL, onCanvas ? "canvas.png" : null, null, false, skipPrompt, null);
				break;
			case "FireGestures:WebSearch": 
				BrowserSearch.loadSearch(getBrowserSelection(), true);
				break;
			case "FireGestures:OpenLinksInSelection": 
				var linkURLs = this.gatherLinkURLsInSelection();
				if (!linkURLs || linkURLs.length == 0)
					throw "No valid links in selection";
				gBrowser.loadTabs(linkURLs, true, false);
				break;
			case "FireGestures:OpenURLsInSelection": 
				this.openURLsInSelection();
				break;
			case "FireGestures:ErrorConsole": 
				toJavaScriptConsole();
				break;
			case "FireGestures:BookmarksSidebar": 
				toggleSidebar("viewBookmarksSidebar");
				break;
			case "FireGestures:HistorySidebar": 
				toggleSidebar("viewHistorySidebar");
				break;
			case "FireGestures:FindBar": 
				if ("isFindBarVisible" in gFindBar)
					gFindBar.isFindBarVisible() ? gFindBar.closeFindBar() : gFindBar.onFindCmd();
				else
					gFindBar.hidden ? gFindBar.onFindCommand() : gFindBar.close();
				break;
			case "FireGestures:Preferences": 
				var win = Cc["@mozilla.org/appshell/window-mediator;1"].getService(Ci.nsIWindowMediator)
				          .getMostRecentWindow("FireGestures:Options");
				if (win)
					win.focus();
				else
					window.openDialog(
						"chrome://firegestures/content/prefs.xul", "FireGestures:Options",
						"chrome,titlebar,toolbar,centerscreen,resizable,dialog=no"
					);
				break;
			case "FireGestures:HybridSave": 
			case "FireGestures:HybridBookmark": 
				var onLink  = this.getLinkURL()  != null;
				var onImage = this.getImageURL() != null;
				var inFrame = this.sourceNode.ownerDocument != window.content.document;
				if (aCommand == "FireGestures:HybridSave") {
					if (onLink)       aCommand = "FireGestures:SaveLink";
					else if (onImage) aCommand = "FireGestures:SaveImage";
					else if (inFrame) aCommand = "FireGestures:SaveFrame";
					else              aCommand = "Browser:SavePage";
				}
				else {
					if (onLink)       aCommand = "FireGestures:AddBookmarkForLink";
					else if (inFrame) aCommand = "FireGestures:AddBookmarkForFrame";
					else              aCommand = "Browser:AddBookmarkAs";
				}
				this._performAction(event, aCommand);
				break;
			case "FireGestures:HybridViewSource": 
				var doc = this.sourceNode.ownerDocument;
				if ("getSelection" in doc && doc.getSelection())
					nsContextMenu.prototype.viewPartialSource("selection");
				else
					BrowserViewSourceOfDocument(doc);
				break;
			case "FireGestures:AllTabsPopup": 
			case "FireGestures:BFHistoryPopup": 
			case "FireGestures:ClosedTabsPopup": 
			case "FireGestures:WebSearchPopup": 
				this._buildPopup(aCommand, event.type == "DOMMouseScroll");
				break;
			default: 
				document.getElementById(aCommand).doCommand();
		}
	},



	get sourceNode()
	{
		return this._gestureHandler.sourceNode;
	},

	getLinkURL: function(aNode)
	{
		if (!aNode)
			aNode = this.sourceNode;
		while (aNode) {
			if ((aNode instanceof HTMLAnchorElement || aNode instanceof HTMLAreaElement) && aNode.href)
				return aNode.href;
			aNode = aNode.parentNode;
		}
		return null;
	},

	getLinkText: function(aNode)
	{
		if (!aNode)
			aNode = this.sourceNode;
		var text = gatherTextUnder(aNode);
		if (!text || !text.match(/\S/)) {
			text = aNode.getAttribute("title");
			if (!text || !text.match(/\S/)) {
				text = aNode.getAttribute("alt");
				if (!text || !text.match(/\S/)) {
					text = this.getLinkURL(aNode);
				}
			}
		}
		return text;
	},

	getImageURL: function(aNode)
	{
		if (!aNode)
			aNode = this.sourceNode;
		if (aNode instanceof HTMLImageElement && aNode.src)
			return aNode.src;
		else if (aNode instanceof HTMLCanvasElement)
			return aNode.toDataURL();
		return null;
	},

	getSelectedText: function()
	{
		var doc = this.sourceNode.ownerDocument;
		return doc.getSelection().toString();
	},

	gatherLinkURLsInSelection: function()
	{
		var win = document.commandDispatcher.focusedWindow;
		if (!win || win == window || win instanceof Ci.nsIDOMChromeWindow)
			win = window.content;
		var sel = win.getSelection();
		if (!sel || sel.rangeCount <= 0)
			return null;
		var doc = win.document;
		var ret = [];
		for (var i = 0; i < sel.rangeCount; i++) {
			var range = sel.getRangeAt(i);
			var fragment = range.cloneContents();
			var treeWalker = fragment.ownerDocument.createTreeWalker(fragment, NodeFilter.SHOW_ELEMENT, null, true);
			while (treeWalker.nextNode()) {
				var node = treeWalker.currentNode;
				if ((node instanceof HTMLAnchorElement || node instanceof HTMLAreaElement) && node.href) {
					try {
						this.checkURL(node.href, doc, Ci.nsIScriptSecurityManager.DISALLOW_SCRIPT);
						ret.push(node.href);
					}
					catch(ex) {
					}
				}
			}
		}
		return ret;
	},

	checkURL: function(aURL, aDoc, aFlags)
	{
		urlSecurityCheck(aURL, aDoc.nodePrincipal || aDoc.location.href, aFlags);
	},


	goUpperLevel: function()
	{
		var uri = gBrowser.currentURI;
		if (uri.path == "/")
			return;
		var pathList = uri.path.split("/");
		if (!pathList.pop())
			pathList.pop();
		loadURI(uri.prePath + pathList.join("/") + "/");
	},

	goNumericURL: function(aIncrement)
	{
		var url = gBrowser.currentURI.spec;
		if (!url.match(/(\d+)(\D*)$/))
			throw "No numeric value in URL";
		var num = RegExp.$1;
		var digit = (num.charAt(0) == "0") ? num.length : null;
		num = parseInt(num, 10) + aIncrement;
		if (num < 0)
			throw "Cannot decrement number in URL anymore";
		num = num.toString();
		digit = digit - num.length;
		for (var i = 0; i < digit; i++)
			num = "0" + num;
		loadURI(RegExp.leftContext + num + RegExp.$2);
	},

	openURLsInSelection: function()
	{
		var sel = this.getSelectedText();
		if (!sel)
			throw "No selection";
		var flag = 0;
		sel = sel.split("\n");
		sel.forEach(function(str) {
			str = str.match(/([\w\+\-\=\$;:\?\.%,!#~\*\/@&]{8,})/);
			if (!str || str[1].indexOf(".") < 0)
				return;
			if (str[1].split("/").length < 3 && str[1].split(".").length < 3)
				return;
			str = str[1];
			if (str.indexOf("ttp://") == 0 || str.indexOf("ttps://") == 0)
				str = "h" + str;
			var tab = gBrowser.loadOneTab(str, null, null, null, true, false);
			gBrowser.moveTabTo(tab, gBrowser.mCurrentTab._tPos + ++flag);
		});
		if (!flag)
			BrowserSearch.loadSearch(sel, true);
	},

	closeMultipleTabs: function(aLeftRight)
	{
		if ("warnAboutClosingTabs2" in gBrowser == false)
			window.eval(
				"gBrowser.warnAboutClosingTabs2 = " + 
				gBrowser.warnAboutClosingTabs.toString()
				.replace("(aAll)", "(aAll, aTabsToClose)")
				.replace("--tabsToClose;", "tabsToClose = aTabsToClose;")
			);
		var pos = gBrowser.mCurrentTab._tPos;
		var start = (aLeftRight == "left") ? pos - 1 : gBrowser.mTabs.length - 1;
		var stop  = (aLeftRight == "left") ? 0 : pos + 1;
		var tabsToClose = start - stop + 1;
		if (tabsToClose < 1 || !gBrowser.warnAboutClosingTabs2(false, tabsToClose))
			return;
		for (var i = start; i >= stop; i--)
			gBrowser.removeTab(gBrowser.mTabs[i]);
	},


	_popupActiveItem: null,
	_popupUsingPanel: false,

	_buildPopup: function(aCommand, aWheelGesture)
	{
		const POPUP_ID = "fireGesturesPopup";
		var popup = document.getElementById(POPUP_ID);
		if (!popup) {
			this._popupUsingPanel = "PlacesCommandHook" in window && 
			                        navigator.platform.indexOf("Mac") >= 0;
			if (this._popupUsingPanel) {
				popup = document.createElement("panel");
				popup.setAttribute("noautohide", "true");
			}
			else
				popup = document.createElement("popup");
			popup.id = POPUP_ID;
			document.documentElement.appendChild(popup);
		}
		popup.setAttribute("_moz-gesturecommand", aCommand);
		var activeItem = null;
		switch (aCommand) {
			case "FireGestures:AllTabsPopup": 
				var tabs = gBrowser.mTabs;
				if (tabs.length < 1)
					return;
				for (var i = 0; i < tabs.length; i++) {
					var menuitem = popup.appendChild(document.createElement("menuitem"));
					var tab = tabs[i];
					menuitem.setAttribute("class", "menuitem-iconic bookmark-item");
					menuitem.setAttribute("label", tab.label);
					menuitem.setAttribute("crop", tab.getAttribute("crop"));
					menuitem.setAttribute("image", tab.getAttribute("image"));
					menuitem.index = i;
					if (tab.selected)
						activeItem = menuitem;
				}
				break;
			case "FireGestures:BFHistoryPopup": 
				var sessionHistory = gBrowser.webNavigation.sessionHistory;
				if (sessionHistory.count < 1)
					throw "No back/forward history for this tab.";
				var curIdx = sessionHistory.index;
				for (var i = 0; i < sessionHistory.count; i++) {
					var entry = sessionHistory.getEntryAtIndex(i, false);
					if (!entry)
						continue;
					var menuitem = popup.appendChild(document.createElement("menuitem"));
					menuitem.setAttribute("label", entry.title);
					menuitem.index = i;
					if (i == curIdx)
						activeItem = menuitem;
				}
				break;
			case "FireGestures:ClosedTabsPopup": 
				if (!gPrefService.getBoolPref("browser.sessionstore.enabled"))
					throw "Session Restore feature is disabled.";
				var ss = Cc["@mozilla.org/browser/sessionstore;1"].getService(Ci.nsISessionStore);
				if (ss.getClosedTabCount(window) == 0)
					throw "No restorable tabs in this window.";
				var undoItems = eval("(" + ss.getClosedTabData(window) + ")");
				for (var i = 0; i < undoItems.length; i++) {
					var menuitem = popup.appendChild(document.createElement("menuitem"));
					menuitem.setAttribute("label", undoItems[i].title);
					menuitem.index = i;
				}
				break;
			case "FireGestures:WebSearchPopup": 
				var searchSvc = Cc["@mozilla.org/browser/search-service;1"].getService(Ci.nsIBrowserSearchService);
				var engines = searchSvc.getVisibleEngines({});
				if (engines.length < 1)
					throw "No search engines installed.";
				for (var i = engines.length - 1; i >= 0; --i) {
					var menuitem = document.createElement("menuitem");
					menuitem.setAttribute("label", engines[i].name);
					menuitem.setAttribute("class", "menuitem-iconic");
					if (engines[i].iconURI)
						menuitem.setAttribute("src", engines[i].iconURI.spec);
					popup.insertBefore(menuitem, popup.firstChild);
					menuitem.engine = engines[i];
				}
				popup.setAttribute("_moz-selectedtext", getBrowserSelection());
				break;
		}
		if (activeItem)
			activeItem.setAttribute("default", "true");
		else
			activeItem = popup.firstChild;
		if (aWheelGesture) {
			this._popupActiveItem = activeItem;
			this._activateMenuItem(true);
		}
		document.popupNode = null;
		document.tooltipNode = null;
		var popupType = navigator.platform.indexOf("Win") == 0 ? "popup" : "tooltip";
		popup.addEventListener("popupshowing", this, true);
		popup.addEventListener("popuphiding", this, true);
		this._gestureHandler.openPopupAtPointer(popup, popupType);
		document.documentElement.addEventListener("mouseup", this, true);
		if (aWheelGesture)
			document.documentElement.addEventListener("DOMMouseScroll", this, true);
	},

	handleEvent: function(event)
	{
		var popup = document.getElementById("fireGesturesPopup");
		if (event.type == "DOMMouseScroll") {
			event.preventDefault();
			event.stopPropagation();
			this._activateMenuItem(false);
			var activeItem = this._popupActiveItem;
			activeItem = event.detail > 0 ? activeItem.nextSibling : activeItem.previousSibling;
			if (!activeItem)
				activeItem = event.detail > 0 ? popup.firstChild : popup.lastChild;
			this._popupActiveItem = activeItem;
			this._activateMenuItem(true);
			var scrollbox = document.getAnonymousNodes(popup)[0];
			scrollbox.ensureElementIsVisible(activeItem);
		}
		else if (event.type == "mouseup") {
			var activeItem = this._popupActiveItem || event.target;
			if (activeItem.localName == "menuitem" && !activeItem.hasAttribute("default")) {
				switch (popup.getAttribute("_moz-gesturecommand")) {
					case "FireGestures:AllTabsPopup": 
						gBrowser.selectedTab = gBrowser.mTabs[activeItem.index];
						break;
					case "FireGestures:BFHistoryPopup": 
						gBrowser.webNavigation.gotoIndex(activeItem.index);
						break;
					case "FireGestures:ClosedTabsPopup": 
						undoCloseTab(activeItem.index);
						break;
					case "FireGestures:WebSearchPopup": 
						var selText = popup.getAttribute("_moz-selectedtext");
						var engine = activeItem.engine;
						if (!engine)
							break;
						var submission = engine.getSubmission(selText, null);
						if (!submission)
							break;
						gBrowser.loadOneTab(submission.uri.spec, null, null, submission.postData, null, false);
						break;
				}
			}
			popup.hidePopup();
		}
		else if (event.type == "popupshowing") {
			var boxObj = popup.popupBoxObject;
			if ("setConsumeRollupEvent" in boxObj) {
				boxObj.setConsumeRollupEvent(boxObj.ROLLUP_NO_CONSUME);
			}
		}
		else if (event.type == "popuphiding") {
			this._popupActiveItem = null;
			popup.removeEventListener("popupshowing", this, true);
			popup.removeEventListener("popuphiding", this, true);
			document.documentElement.removeEventListener("mouseup", this, true);
			document.documentElement.removeEventListener("DOMMouseScroll", this, true);
			while (popup.hasChildNodes())
				popup.removeChild(popup.lastChild);
		}
	},

	_activateMenuItem: function(aActive)
	{
		if (aActive)
			this._popupActiveItem.setAttribute("_moz-menuactive", "true");
		else
			this._popupActiveItem.removeAttribute("_moz-menuactive");
		if (this._popupUsingPanel) {
			if (aActive) {
				var cssText = "background-color: -moz-menuhover; color: -moz-menuhovertext;";
				this._popupActiveItem.setAttribute("style", cssText);
			}
			else
				this._popupActiveItem.removeAttribute("style");
		}
	},

	QueryInterface: function(aIID)
	{
		if (!aIID.equals(Ci.nsISupports) && 
		    !aIID.equals(Ci.nsIDOMEventListener) &&
		    !aIID.equals(Ci.xdIGestureObserver)) {
			throw Cr.NS_ERROR_NO_INTERFACE;
		}
		return this;
	}

};



