
const Cc = Components.classes;
const Ci = Components.interfaces;
const Cr = Components.results;

const TYPE_CATEGORY = Ci.xdIGestureMappings.TYPE_CATEGORY;
const TYPE_NORMAL   = Ci.xdIGestureMappings.TYPE_NORMAL;
const TYPE_SCRIPT   = Ci.xdIGestureMappings.TYPE_SCRIPT;

const kTypeCol      = 0;
const kNameCol      = 1;
const kCommandCol   = 2;
const kDirectionCol = 3;

const kExtraIDs  = ["wheelGestureU", "wheelGestureD", "rockerGestureL", "rockerGestureR"];
const kExtraDirs = ["wheel-up", "wheel-down", "rocker-left", "rocker-right"];

const PREFS_DOMAIN = "extensions.firegestures.";
const DRAGDROP_FLAVOR = "text/x-moz-tree-index";

var gMappingsService = null;
var gMappingsArray = [];
var gMappingsView = null;
var gShouldCommit = false;


var gIsMac = navigator.platform.indexOf("Mac") == 0;
var gIsFx3 = Cc["@mozilla.org/xre/app-info;1"].getService(Ci.nsIXULAppInfo)
             .version.substr(0, 1) == "3";

if (gIsMac && gIsFx3)
	document.documentElement.style.paddingBottom = "3em";


var FireGesturesPrefs = {

	init: function()
	{
		var mappingsTree = document.getElementById("mappingsTree");
		this.updateGroupedUI("mouseTrail");
		this.updateGroupedUI("wheelGesture");
		this.updateGroupedUI("rockerGesture");
		this.updateGroupedUI("keypressGesture");
		this.updateGroupedUI("tabwheelGesture");
		this.updateMouseTrailSample();
		gMappingsService = Cc["@xuldev.org/firegestures/mappings;1"]
		                   .getService(Ci.xdIGestureMappings);
		gMappingsArray = gMappingsService.getMappingsArray();
		gMappingsView = new CustomTreeView();
		mappingsTree.view = gMappingsView;
		if (navigator.platform.indexOf("Win") == 0) {
			mappingsTree.lastChild.style.height = "";
			mappingsTree.lastChild.style.minHeight = "";
		}
		this.updateCommands();
		for (var i = 0; i < kExtraIDs.length; i++) {
			var command = gMappingsService.getCommandForDirection(kExtraDirs[i]);
			if (!command)
				command = { name: "...", value: "" };
			var menulist = document.getElementById(kExtraIDs[i]);
			menulist.removeAllItems();
			menulist.appendItem(command.name, command.value);
			menulist.selectedIndex = 0;
			if (gIsFx3)
				menulist.setAttribute("sizetopopup", "always");
		}
		if (gIsMac && !gIsFx3)
			document.documentElement.style.paddingBottom = "3em";
	},

	done: function()
	{
//		var selIdx = gMappingsView.getSelectedIndexes();
//		if (selIdx.length > 0)
//			document.getElementById("mappingsTree").setAttribute("lastSelectedIndex", selIdx[0]);
		if (!gShouldCommit)
			return;
		gMappingsArray = gMappingsArray.filter(function(item) {
			if (item[kTypeCol] == TYPE_CATEGORY)
				return false;
			if (item[kTypeCol] == TYPE_NORMAL && !item[kDirectionCol])
				return false;
			return true;
		});
		for (var i = 0; i < kExtraIDs.length; i++) {
			gMappingsArray.push([
				TYPE_NORMAL, "", document.getElementById(kExtraIDs[i]).value, kExtraDirs[i]
			]);
		}
		try {
			gMappingsService.saveUserMappings(gMappingsArray);
		}
		catch(ex) {
			alert("FireGestures ERROR: Failed to access database.\n" + ex);
		}
	},

	updateGroupedUI: function(aGroupName)
	{
		var enable = document.getElementById(aGroupName).checked;
		var elts = document.getElementsByAttribute("group", aGroupName);
		Array.forEach(elts, function(elt) {
			elt.disabled = !enable;
			if (elt.localName == "colorpicker")
				elt.style.MozOpacity = enable ? "1" : "0.5";
		});
	},

	updateMouseTrailSample: function()
	{
		var elt = document.getElementById("mouseTrailSample");
		var size = document.getElementById(PREFS_DOMAIN + "mousetrail.size").value;
		elt.style.borderWidth = size.toString() + "px";
		elt.style.borderColor = document.getElementById(PREFS_DOMAIN + "mousetrail.color").value;
		if (document.getElementById("mouseTrail").checked)
			elt.previousSibling.disabled = (size == 1);
	},

	changeMouseTrailSize: function(aIncrement)
	{
		var pref = document.getElementById(PREFS_DOMAIN + "mousetrail.size");
		pref.value = pref.value + aIncrement > 0 ? pref.value + aIncrement : 1;
		this.updateMouseTrailSample();
	},

	handleTreeEvent: function(event)
	{
		if (event.type == "dblclick") {
			if (event.target.localName == "treechildren")
			this.doCommand("cmd_edit_gesture");
		}
		else if (event.type == "keypress") {
			switch (event.keyCode) {
				case event.DOM_VK_RETURN: 
					this.doCommand("cmd_edit_gesture");
					break;
				case event.DOM_VK_DELETE: 
					this.doCommand("cmd_clear_gesture");
					break;
				default: return;
			}
			event.preventDefault();
		}
	},

	updateCommands: function()
	{
		var idxs = gMappingsView.getSelectedIndexes();
		var canEdit = idxs.length > 0;
		var canDelete = false, canClear = false;
		idxs.forEach(function(idx) {
			if (gMappingsArray[idx][kTypeCol] == TYPE_SCRIPT)
				canDelete = true;
			if (gMappingsArray[idx][kDirectionCol])
				canClear = true;
		});
		var setElementDisabledByID = function(aID, aDisable) {
			if (aDisable)
				document.getElementById(aID).removeAttribute("disabled");
			else
				document.getElementById(aID).setAttribute("disabled", "true");
		};
		setElementDisabledByID("cmd_edit_gesture",  canEdit);
		setElementDisabledByID("cmd_clear_gesture", canClear);
		setElementDisabledByID("cmd_delete_script", canDelete);
	},

	doCommand: function(aCommand)
	{
		switch (aCommand) {
			case "cmd_add_script": 
				var name = document.getElementById("fireGesturesStrings").getString("NEW_SCRIPT");
				var newIdx = gMappingsView.appendItem([TYPE_SCRIPT, name, "", ""]);
				this.editGesture(newIdx, true);
				break;
			case "cmd_edit_gesture" : 
				var idxs = gMappingsView.getSelectedIndexes();
				idxs.forEach(function(idx) { this.editGesture(idx, false); }, this);
				break;
			case "cmd_clear_gesture": 
				var idxs = gMappingsView.getSelectedIndexes();
				idxs.forEach(function(idx) { gMappingsArray[idx][kDirectionCol] = ""; });
				gMappingsView.update();
				break;
			case "cmd_delete_script": 
				var idxs = gMappingsView.getSelectedIndexes();
				for (var i = idxs.length - 1; i >= 0; i--) {
					if (gMappingsArray[idxs[i]][kTypeCol] == TYPE_SCRIPT)
						gMappingsView.removeItemAt(idxs[i]);
				}
				break;
		}
		this.updateCommands();
		gShouldCommit = true;
	},

	editGesture: function(aIdx, aIsNewScript)
	{
		var oldCommand   = gMappingsArray[aIdx][kCommandCol];
		var oldDirection = gMappingsArray[aIdx][kDirectionCol];
		var ret = {
			type     : gMappingsArray[aIdx][kTypeCol],
			name     : gMappingsArray[aIdx][kNameCol],
			command  : oldCommand,
			direction: oldDirection,
			accepted : false
		};
		var features = "chrome,modal" + (ret.type == TYPE_SCRIPT ? ",all,resizable" : "");
		document.documentElement.openSubDialog("chrome://firegestures/content/edit.xul", features, ret);
		if (!document)
			throw new Error("FireGestures: Unexpected error occurred.");
		if (aIsNewScript && !ret.accepted) {
			gMappingsView.removeItemAt(aIdx);
			return;
		}
		if (this.checkConflict(ret.direction, aIdx)) {
			if (aIsNewScript)
				ret.direction = "";
			else if (oldCommand != ret.command)
				ret.direction = oldDirection;
			else
				return;
		}
		gMappingsArray[aIdx][kDirectionCol] = ret.direction;
		if (ret.type == TYPE_SCRIPT) {
			gMappingsArray[aIdx][kNameCol]    = ret.name;
			gMappingsArray[aIdx][kCommandCol] = ret.command;
		}
		gMappingsView.update();
	},

	checkConflict: function(aDirection, aIdx)
	{
		if (!aDirection)
			return false;
		for (var i = 0; i < gMappingsArray.length; i++) {
			var item = gMappingsArray[i];
			if (i != aIdx && item[kDirectionCol] == aDirection) {
				var msg = document.getElementById("fireGesturesStrings").getFormattedString(
					"CONFIRM_CONFLICT",
					[aDirection, item[kNameCol], item[kNameCol]]
				);
				var ps = Cc["@mozilla.org/embedcomp/prompt-service;1"]
				         .getService(Ci.nsIPromptService);
				var ret = ps.confirmEx(window, "FireGestures", msg, ps.STD_YES_NO_BUTTONS,
				                       null, null, null, null, {});
				if (ret == 1)
					return true;
				item[kDirectionCol] = "";
				return false;
			}
		}
		return false;
	},

	generateMenu: function(aMenuList)
	{
		if (aMenuList.hasAttribute("_generated"))
			return;
		aMenuList.removeItemAt(0);
		var selItem;
		gMappingsArray.forEach(function(item) {
			if (item[kTypeCol] == TYPE_CATEGORY) {
				var newItem = document.getElementById("separatorTemplate").cloneNode(true);
				newItem.firstChild.setAttribute("value", item[kNameCol]);
				aMenuList.menupopup.appendChild(newItem);
			}
			else {
				var newItem = aMenuList.appendItem(item[kNameCol], item[kCommandCol]);
				if (item[kCommandCol] == aMenuList.value)
					selItem = newItem;
				if (item[kTypeCol] == TYPE_SCRIPT)
					newItem.setAttribute("disabled", "true");
			}
		});
		if (selItem)
			aMenuList.selectedItem = selItem;
		aMenuList.setAttribute("_generated", "true");
	},

	openURL: function(aURL)
	{
		var win = Cc["@mozilla.org/appshell/window-mediator;1"]
		          .getService(Ci.nsIWindowMediator)
		          .getMostRecentWindow("navigator:browser");
		if (win)
			win.gBrowser.loadOneTab(aURL, null, null, null, false, false);
		else
			window.open(aURL);
	}

};



var gDragDropObserver = {


	onDragStart: function(event, aXferData, aDragAction)
	{
		var selIdxs = gMappingsView.getSelectedIndexes();
		if (selIdxs.length != 1)
			return;
		var sourceIndex = selIdxs[0];
		if (gMappingsArray[sourceIndex][kTypeCol] != TYPE_SCRIPT)
			return;
		aXferData.data = new TransferData();
		aXferData.data.addDataForFlavour(DRAGDROP_FLAVOR, sourceIndex);
		aDragAction.action = Ci.nsIDragService.DRAGDROP_ACTION_MOVE;
	},


	_flavourSet: null,

	getSupportedFlavours: function()
	{
		if (!this._flavourSet) {
			this._flavourSet = new FlavourSet();
			this._flavourSet.appendFlavour("text/x-moz-url");
		}
		return this._flavourSet;
	},
	canDrop: function(event, aDragSession) { return true; },
	onDragEnter: function(event, aDragSession) {},
	onDragOver: function(event, aFlavour, aDragSession) {},
	onDragExit: function(event, aDragSession) {},
	onDrop: function(event, aXferData, aDragSession)
	{
		const URL_PREFIX = "data:text/javascript,";
		var lines = aXferData.data.toString().split("\n");
		if (lines.length != 2 || lines[0].indexOf(URL_PREFIX) != 0)
			return;
		lines[0] = decodeURIComponent(lines[0].substr(URL_PREFIX.length));
		gMappingsView.appendItem([TYPE_SCRIPT, lines[1], lines[0], ""]);
	},

};



function CustomTreeView() {}

CustomTreeView.prototype = {


	get ATOM_SVC()
	{
		if (!this._atomSvc)
			this._atomSvc = Cc["@mozilla.org/atom-service;1"].getService(Ci.nsIAtomService);
		return this._atomSvc;
	},
	_atomSvc: null,

	_treeBoxObject: null,


	appendItem: function(aItem)
	{
		gMappingsArray.push(aItem);
		var newIdx = this.rowCount - 1;
		this._treeBoxObject.rowCountChanged(newIdx, 1);
		this.selection.select(newIdx);
		this._treeBoxObject.ensureRowIsVisible(newIdx);
		this._treeBoxObject.treeBody.focus();
		return newIdx;
	},

	removeItemAt: function(aIndex)
	{
		gMappingsArray.splice(aIndex, 1);
		this._treeBoxObject.rowCountChanged(aIndex, -1);
	},

	moveItem: function(aSourceIndex, aTargetIndex)
	{
		var removedItems = gMappingsArray.splice(aSourceIndex, 1);
		gMappingsArray.splice(aTargetIndex, 0, removedItems[0]);
	},

	update: function()
	{
		this._treeBoxObject.invalidate();
	},

	getSelectedIndexes: function()
	{
		var ret = [];
		var sel = this.selection;
		for (var rc = 0; rc < sel.getRangeCount(); rc++) {
			var start = {}, end = {};
			sel.getRangeAt(rc, start, end);
			for (var idx = start.value; idx <= end.value; idx++) {
				if (!this.isSeparator(idx))
					ret.push(idx);
			}
		}
		return ret;
	},

	getSourceIndexFromDrag: function()
	{
		var dragService = Cc["@mozilla.org/widget/dragservice;1"].getService(Ci.nsIDragService);
		var dragSession = dragService.getCurrentSession();
		var xferData = Cc["@mozilla.org/widget/transferable;1"].createInstance(Ci.nsITransferable);
		xferData.addDataFlavor(DRAGDROP_FLAVOR);
		dragSession.getData(xferData, 0);
		var obj = {}, len = {};
		var sourceIndex = -1;
		try {
			xferData.getAnyTransferData({}, obj, len);
		}
		catch (ex) {}
		if (obj.value) {
			sourceIndex = obj.value.QueryInterface(Ci.nsISupportsString).data;
			sourceIndex = parseInt(sourceIndex.substring(0, len.value), 10);
		}
		return sourceIndex;
	},


	get rowCount()
	{
		return gMappingsArray.length;
	},
	selection: null,
	getRowProperties: function(index, properties) {},
	getCellProperties: function(row, col, properties)
	{
		if (col.index == 0 && this.isSeparator(row))
			properties.AppendElement(this.ATOM_SVC.getAtom("category"));
	},
	getColumnProperties: function(col, properties) {},
	isContainer: function(index) { return false; },
	isContainerOpen: function(index) { return false; },
	isContainerEmpty: function(index) { return false; },
	isSeparator: function(index)
	{
		return gMappingsArray[index][kTypeCol] == TYPE_CATEGORY;
	},
	isSorted: function() { return false; },
	canDrop: function(targetIndex, orientation)
	{
		var sourceIndex = this.getSourceIndexFromDrag();
		return (
			gMappingsArray[targetIndex][kTypeCol] == TYPE_SCRIPT && 
			sourceIndex != -1 && 
			sourceIndex != targetIndex && 
			sourceIndex != (targetIndex + orientation)
		);
	},
	drop: function(targetIndex, orientation)
	{
		var sourceIndex = this.getSourceIndexFromDrag();
		if (sourceIndex == -1)
			return;
		if (sourceIndex < targetIndex) {
			if (orientation == Ci.nsITreeView.DROP_BEFORE)
				targetIndex--;
		}
		else {
			if (orientation == Ci.nsITreeView.DROP_AFTER)
				targetIndex++;
		}
		this.moveItem(sourceIndex, targetIndex);
		this.update();
		this.selection.clearSelection();
		this.selection.select(targetIndex);
	},
	getParentIndex: function(rowIndex) { return -1; },
	hasNextSibling: function(rowIndex, afterIndex) { return false; },
	getLevel: function(index) { return 0; },
	getImageSrc: function(row, col) {},
	getProgressMode: function(row, col) {},
	getCellValue: function(row, col) {},
	getCellText: function(row, col)
	{
		switch (col.index) {
			case 0: return gMappingsArray[row][kNameCol];
			case 1: return gMappingsArray[row][kCommandCol].replace(/\r|\n|\t/g, " ");
			case 2: return gMappingsArray[row][kDirectionCol];
		}
	},
	setTree: function(tree)
	{
		this._treeBoxObject = tree;
	},
	toggleOpenState: function(index) {},
	cycleHeader: function(col) {},
	selectionChanged: function() {},
	cycleCell: function(row, col) {},
	isEditable: function(row, col) { return false; },
	isSelectable: function(row, col) {},
	setCellValue: function(row, col, value) {},
	setCellText: function(row, col, value)
	{
		if (col.index == 0)
			gMappingsArray[row][kNameCol] = value;
		else if (col.index == 1)
			gMappingsArray[row][kCommandCol] = value;
		else if (col.index == 2)
			gMappingsArray[row][kDirectionCol] = value;
	},
	performAction: function(action) {},
	performActionOnRow: function(action, row) {},
	performActionOnCell: function(action, row, col) {},

};


