var gDefaultColor = "#B6BDD2";
var gURLBar_value = "http://www.example.net/";
var gAnimation;

function initDialog()
{
	gAnimation = setInterval(function(aProgressBar) {
		aProgressBar.value = 33 + (parseInt(aProgressBar.value) - 29) % 67;
	}, 500, _("statusbar-icon"));
}

function uninitDialog()
{
	clearInterval(gAnimation);
}

function writeColor()
{
	var image = _("color-image").value.replace(/^\s+|\s+$/g, "");
	var color = _("color-plain").color;
	
	return (image || color != gDefaultColor) ? (image ? "url(" + image + ") " : "") + color : "";
}

function readColorPlain()
{
	document.getAnonymousElementByAttribute(_("statusbar-icon"), "class", "progress-bar").style.background = _("extensions.fission.color").value.replace(/^(url\(.+\)) #[0-9A-F]{6}$/, "$1 transparent");
	
	return /(#[0-9A-F]{6})$/i.test(_("extensions.fission.color").value) ? RegExp.$1 : gDefaultColor;
}

function readColorImage()
{
	return /^url\((.+)\)/.test(_("extensions.fission.color").value) ? RegExp.$1 : "";
}

function readIconize()
{
	var iconize = _("extensions.fission.iconize").value;
	
	var urlbar = _("urlbar");
	urlbar.setAttribute("fission", iconize ? "icon" : "fusion");
	urlbar.flex = iconize ? 0 : 1000;
	urlbar.value = iconize ? "" : gURLBar_value;
	
	return iconize;
}

function onFindImage()
{
	var nsIFilePicker = Components.interfaces.nsIFilePicker;
	var filePicker = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);
	
	filePicker.init(window, null, nsIFilePicker.modeOpen);
	filePicker.appendFilters(nsIFilePicker.filterImages);
	
	try
	{
		var uri = Components.classes["@mozilla.org/network/io-service;1"].getService(Components.interfaces.nsIIOService).newURI(_("color-image").value, null, null);
		if (uri instanceof Components.interfaces.nsIFileURL && uri.file instanceof Components.interfaces.nsILocalFile)
		{
			filePicker.displayDirectory = uri.file.parent;
		}
	}
	catch (ex) { }
	
	if (filePicker.show() == nsIFilePicker.returnOK)
	{
		_("color-image").value = filePicker.fileURL.spec;
		_("FissionOptionsPane").userChangedValue(_("color-image"));
	}
}

function onResetColor()
{
	_("extensions.fission.color").value = "";
}

function _(aId)
{
	return document.getElementById(aId);
}
