/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeStateListener;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.lafwidget.animation.effects.GhostPaintingUtils;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.RenderingUtils;
import org.jvnet.substance.SubstanceButtonBorder;
import org.jvnet.substance.button.SubstanceButtonShaper;
import org.jvnet.substance.combo.SubstanceComboBoxButton;
import org.jvnet.substance.scroll.SubstanceScrollBarButton;
import org.jvnet.substance.utils.ButtonBackgroundDelegate;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.PulseTracker;
import org.jvnet.substance.utils.RolloverButtonListener;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.icon.GlowingIcon;

public class SubstanceButtonUI
extends BasicButtonUI {
    protected boolean iconGhostingMarker;
    protected Set lafWidgets;
    public static final String BORDER_COMPUTED = "substancelaf.buttonbordercomputed";
    public static final String BORDER_COMPUTING = "substancelaf.buttonbordercomputing";
    public static final String BORDER_ORIGINAL = "substancelaf.buttonborderoriginal";
    public static final String ICON_ORIGINAL = "substancelaf.buttoniconoriginal";
    public static final String OPACITY_ORIGINAL = "substancelaf.buttonopacityoriginal";
    public static final String LOCK_OPACITY = "substancelaf.lockopacity";
    public static final String IS_TITLE_CLOSE_BUTTON = "substancelaf.internal.isTitleCloseButton";
    private ButtonBackgroundDelegate delegate = new ButtonBackgroundDelegate();
    private RolloverButtonListener substanceButtonListener;
    protected GlowingIcon glowingIcon;
    protected PropertyChangeListener substancePropertyListener;
    protected FadeStateListener substanceFadeStateListener;

    protected void paintIcon(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        jComponent.putClientProperty("icon.bounds", new Rectangle(rectangle));
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        GhostPaintingUtils.paintGhostIcon(graphics2D, (AbstractButton)jComponent, rectangle);
        graphics2D.dispose();
        this.__org__jvnet__substance__SubstanceButtonUI__icon__paintIcon(graphics, jComponent, rectangle);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        float f = 1.0f;
        if (composite instanceof AlphaComposite && ((AlphaComposite)(object = (AlphaComposite)composite)).getRule() == 3) {
            f = ((AlphaComposite)object).getAlpha();
        }
        graphics2D.setComposite(TransitionLayout.getAlphaComposite((Component)jComponent, f));
        object = RenderingUtils.installDesktopHints(graphics2D);
        this.__org__jvnet__substance__SubstanceButtonUI__update(graphics2D, jComponent);
        graphics2D.setComposite(composite);
        if (object != null) {
            graphics2D.addRenderingHints((Map<?, ?>)object);
        }
    }

    public void __org__jvnet__substance__SubstanceButtonUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__jvnet__substance__SubstanceButtonUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void __org__jvnet__substance__SubstanceButtonUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        this.__org__jvnet__substance__SubstanceButtonUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    public void installListeners(AbstractButton abstractButton) {
        this.__org__jvnet__substance__SubstanceButtonUI__installListeners(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    public void installDefaults(AbstractButton abstractButton) {
        this.__org__jvnet__substance__SubstanceButtonUI__installDefaults(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    public void uninstallListeners(AbstractButton abstractButton) {
        this.__org__jvnet__substance__SubstanceButtonUI__uninstallListeners(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    public void uninstallDefaults(AbstractButton abstractButton) {
        this.__org__jvnet__substance__SubstanceButtonUI__uninstallDefaults(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public static ComponentUI createUI(JComponent b) {
        AbstractButton button = (AbstractButton)b;
        button.setRolloverEnabled(true);
        button.setOpaque(false);
        return new SubstanceButtonUI();
    }

    public void __org__jvnet__substance__SubstanceButtonUI__installDefaults(AbstractButton b) {
        super.installDefaults(b);
        if (b.getClientProperty(BORDER_ORIGINAL) == null) {
            b.putClientProperty(BORDER_ORIGINAL, b.getBorder());
        }
        this.trackGlowingIcon(b);
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(b);
        if (b.getClientProperty(BORDER_COMPUTED) == null) {
            b.setBorder(shaper.getButtonBorder(b));
        } else {
            Border currBorder = b.getBorder();
            if (!(currBorder instanceof SubstanceButtonBorder)) {
                b.setBorder(shaper.getButtonBorder(b));
            } else {
                SubstanceButtonBorder sbCurrBorder = (SubstanceButtonBorder)currBorder;
                if (shaper.getClass() != sbCurrBorder.getButtonShaperClass()) {
                    b.setBorder(shaper.getButtonBorder(b));
                }
            }
        }
        b.putClientProperty(OPACITY_ORIGINAL, b.isOpaque());
        if (b instanceof SubstanceComboBoxButton) {
            b.setBorder(new BorderUIResource.CompoundBorderUIResource(new EmptyBorder(1, 1, 1, 1), b.getBorder()));
        }
    }

    public void __org__jvnet__substance__SubstanceButtonUI__uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        b.setBorder((Border)b.getClientProperty(BORDER_ORIGINAL));
        b.setOpaque((Boolean)b.getClientProperty(OPACITY_ORIGINAL));
        Icon origIcon = (Icon)b.getClientProperty(ICON_ORIGINAL);
        if (origIcon != null) {
            b.setIcon(origIcon);
        }
        b.putClientProperty(OPACITY_ORIGINAL, null);
    }

    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return null;
    }

    protected void __org__jvnet__substance__SubstanceButtonUI__installListeners(final AbstractButton b) {
        super.installListeners(b);
        this.substanceButtonListener = new RolloverButtonListener(b);
        b.addMouseListener(this.substanceButtonListener);
        b.addMouseMotionListener(this.substanceButtonListener);
        b.addFocusListener(this.substanceButtonListener);
        b.addPropertyChangeListener(this.substanceButtonListener);
        b.addChangeListener(this.substanceButtonListener);
        this.substancePropertyListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("substancelaf.buttonShaper".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SwingUtilities.updateComponentTreeUI(b);
                        }
                    });
                }
                if ("model".equals(evt.getPropertyName())) {
                    if (SubstanceButtonUI.this.substanceFadeStateListener != null) {
                        SubstanceButtonUI.this.substanceFadeStateListener.unregisterListeners();
                    }
                    SubstanceButtonUI.this.substanceFadeStateListener = new FadeStateListener(b, b.getModel(), SubstanceCoreUtilities.getFadeCallback(b));
                    SubstanceButtonUI.this.substanceFadeStateListener.registerListeners(b instanceof SubstanceScrollBarButton);
                }
                if ("icon".equals(evt.getPropertyName())) {
                    SubstanceButtonUI.this.trackGlowingIcon(b);
                }
            }
        };
        b.addPropertyChangeListener(this.substancePropertyListener);
        this.substanceFadeStateListener = new FadeStateListener(b, b.getModel(), SubstanceCoreUtilities.getFadeCallback(b));
        this.substanceFadeStateListener.registerListeners(b instanceof SubstanceScrollBarButton);
    }

    protected void __org__jvnet__substance__SubstanceButtonUI__uninstallListeners(AbstractButton b) {
        b.removeMouseListener(this.substanceButtonListener);
        b.removeMouseMotionListener(this.substanceButtonListener);
        b.removeFocusListener(this.substanceButtonListener);
        b.removePropertyChangeListener(this.substanceButtonListener);
        b.removeChangeListener(this.substanceButtonListener);
        this.substanceButtonListener = null;
        b.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        this.substanceFadeStateListener.unregisterListeners();
        this.substanceFadeStateListener = null;
        super.uninstallListeners(b);
    }

    public void __org__jvnet__substance__SubstanceButtonUI__update(Graphics g, JComponent c) {
        JButton jb;
        AbstractButton button = (AbstractButton)c;
        if (button instanceof JButton && PulseTracker.isPulsating(jb = (JButton)button)) {
            PulseTracker.update(jb);
        }
        this.delegate.updateBackground(g, button);
        this.paint(g, c);
        AbstractButton b = (AbstractButton)c;
        FontMetrics fm = c.getFontMetrics(c.getFont());
        Insets i = c.getInsets();
        Rectangle viewRect = new Rectangle();
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        viewRect.x = i.left;
        viewRect.y = i.top;
        viewRect.width = b.getWidth() - (i.right + viewRect.x);
        viewRect.height = b.getHeight() - (i.bottom + viewRect.y);
        textRect.height = 0;
        textRect.width = 0;
        textRect.y = 0;
        textRect.x = 0;
        iconRect.height = 0;
        iconRect.width = 0;
        iconRect.y = 0;
        iconRect.x = 0;
        Font f = c.getFont();
        g.setFont(f);
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
        if (!(b.hasFocus() && b.isFocusPainted() || !FadeTracker.getInstance().isTracked(c, FadeKind.FOCUS))) {
            this.paintFocus(g, b, viewRect, textRect, iconRect);
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        AbstractButton button = (AbstractButton)c;
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(button);
        return shaper.getPreferredSize(button, super.getPreferredSize(button));
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        if (!b.isFocusPainted()) {
            return;
        }
        SubstanceCoreUtilities.paintFocus(g, b, b, null, textRect, 1.0f, 2 + SubstanceSizeUtils.getExtraPadding());
    }

    protected void paintButtonPressed(Graphics g, AbstractButton b) {
    }

    public boolean contains(JComponent c, int x, int y) {
        return ButtonBackgroundDelegate.contains((JButton)c, x, y);
    }

    protected void __org__jvnet__substance__SubstanceButtonUI__icon__paintIcon(Graphics g, JComponent c, Rectangle iconRect) {
        Graphics2D graphics = (Graphics2D)g.create();
        FadeTracker fadeTracker = FadeTracker.getInstance();
        AbstractButton b = (AbstractButton)c;
        Icon icon = SubstanceCoreUtilities.getIcon(b, this.glowingIcon, false);
        graphics.setComposite(TransitionLayout.getAlphaComposite((Component)b, g));
        if (fadeTracker.isTracked(b, FadeKind.ROLLOVER)) {
            ComponentState state = ComponentState.getState(b.getModel(), b);
            if (state.isKindActive(FadeKind.ROLLOVER)) {
                SubstanceCoreUtilities.getIcon(b, this.glowingIcon, true).paintIcon(b, graphics, iconRect.x, iconRect.y);
                graphics.setComposite(TransitionLayout.getAlphaComposite(b, fadeTracker.getFade10(b, FadeKind.ROLLOVER) / 10.0f, g));
                icon.paintIcon(b, graphics, iconRect.x, iconRect.y);
            } else {
                icon.paintIcon(b, graphics, iconRect.x, iconRect.y);
                graphics.setComposite(TransitionLayout.getAlphaComposite(b, fadeTracker.getFade10(b, FadeKind.ROLLOVER) / 10.0f, g));
                b.getIcon().paintIcon(b, graphics, iconRect.x, iconRect.y);
            }
        } else {
            icon.paintIcon(b, graphics, iconRect.x, iconRect.y);
        }
        graphics.dispose();
    }

    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        SubstanceCoreUtilities.paintText(g, (AbstractButton)c, textRect, text, this.getTextShiftOffset(), this.getPropertyPrefix());
    }

    protected void trackGlowingIcon(AbstractButton b) {
        Icon currIcon = b.getIcon();
        if (currIcon instanceof GlowingIcon) {
            return;
        }
        if (currIcon == null) {
            return;
        }
        this.glowingIcon = new GlowingIcon(currIcon, b);
    }
}

