/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Color;
import java.awt.Component;
import javax.swing.border.EtchedBorder;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstanceEtchedBorder
extends EtchedBorder {
    public Color getHighlightColor() {
        return this.getHighlightColor(null);
    }

    public Color getHighlightColor(Component c) {
        SubstanceTheme theme = SubstanceCoreUtilities.getTheme(c, true);
        boolean isDark = SubstanceCoreUtilities.isThemeDark(theme.getActiveTheme());
        ColorScheme colorScheme = isDark ? theme.getActiveTheme().getColorScheme() : theme.getDefaultTheme().getColorScheme();
        Color foreDark = isDark ? colorScheme.getExtraLightColor() : SubstanceColorUtilities.getInterpolatedColor(colorScheme.getMidColor(), colorScheme.getDarkColor(), 0.4);
        return SubstanceColorUtilities.getAlphaColor(foreDark, 196);
    }

    public Color getShadowColor() {
        return this.getShadowColor(null);
    }

    public Color getShadowColor(Component c) {
        SubstanceTheme theme = SubstanceCoreUtilities.getTheme(c, true);
        boolean isDark = SubstanceCoreUtilities.isThemeDark(theme.getActiveTheme());
        ColorScheme colorScheme = isDark ? theme.getActiveTheme().getColorScheme() : theme.getDefaultTheme().getColorScheme();
        Color back = isDark ? colorScheme.getDarkColor() : colorScheme.getUltraLightColor();
        return SubstanceColorUtilities.getAlphaColor(back, 196);
    }

    public boolean isBorderOpaque() {
        return false;
    }
}

