/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Area;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.ScrollPaneLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicScrollPaneUI;
import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.LafWidgetUtilities;
import org.jvnet.lafwidget.animation.FadeConfigurationManager;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeStep;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.lafwidget.animation.FadeTrackerAdapter;
import org.jvnet.lafwidget.layout.TransitionBorder;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.LafConstants;
import org.jvnet.lafwidget.utils.RenderingUtils;
import org.jvnet.substance.SubstanceFillBackgroundDelegate;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.SubstanceScrollBarUI;
import org.jvnet.substance.SubstanceTreeUI;
import org.jvnet.substance.scroll.SubstanceScrollPaneBorder;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstanceScrollPaneUI
extends BasicScrollPaneUI {
    protected Set lafWidgets;
    protected PropertyChangeListener substancePropertyChangeListener;
    protected ChangeListener substanceVerticalScrollbarChangeListener;
    protected long horScrollId;
    protected static SubstanceFillBackgroundDelegate bgDelegate = new SubstanceFillBackgroundDelegate();

    public void update(Graphics graphics, JComponent jComponent) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        float f = 1.0f;
        if (composite instanceof AlphaComposite && ((AlphaComposite)(object = (AlphaComposite)composite)).getRule() == 3) {
            f = ((AlphaComposite)object).getAlpha();
        }
        graphics2D.setComposite(TransitionLayout.getAlphaComposite((Component)jComponent, f));
        object = RenderingUtils.installDesktopHints(graphics2D);
        this.__org__jvnet__substance__SubstanceScrollPaneUI__update(graphics2D, jComponent);
        graphics2D.setComposite(composite);
        if (object != null) {
            graphics2D.addRenderingHints((Map<?, ?>)object);
        }
    }

    public void __org__jvnet__substance__SubstanceScrollPaneUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__jvnet__substance__SubstanceScrollPaneUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void __org__jvnet__substance__SubstanceScrollPaneUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        this.__org__jvnet__substance__SubstanceScrollPaneUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    public void installListeners(JScrollPane jScrollPane) {
        this.__org__jvnet__substance__SubstanceScrollPaneUI__installListeners(jScrollPane);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    public void installDefaults(JScrollPane jScrollPane) {
        this.__org__jvnet__substance__SubstanceScrollPaneUI__installDefaults(jScrollPane);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    public void uninstallListeners(JComponent jComponent) {
        this.__org__jvnet__substance__SubstanceScrollPaneUI__uninstallListeners(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    public void uninstallDefaults(JScrollPane jScrollPane) {
        this.__org__jvnet__substance__SubstanceScrollPaneUI__uninstallDefaults(jScrollPane);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public static ComponentUI createUI(JComponent c) {
        return new SubstanceScrollPaneUI();
    }

    protected void __org__jvnet__substance__SubstanceScrollPaneUI__installDefaults(JScrollPane scrollpane) {
        super.installDefaults(scrollpane);
        if (SubstanceCoreUtilities.toBleedWatermark(this.scrollpane)) {
            this.scrollpane.setOpaque(false);
            this.scrollpane.getViewport().setOpaque(false);
        }
        scrollpane.setLayout(new AdjustedLayout((ScrollPaneLayout)scrollpane.getLayout()));
    }

    protected void __org__jvnet__substance__SubstanceScrollPaneUI__uninstallDefaults(JScrollPane c) {
        LayoutManager lm = this.scrollpane.getLayout();
        if (lm instanceof AdjustedLayout) {
            c.setLayout(((AdjustedLayout)lm).delegate);
        }
        super.uninstallDefaults(c);
    }

    protected void __org__jvnet__substance__SubstanceScrollPaneUI__installListeners(final JScrollPane c) {
        super.installListeners(c);
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                ScrollPaneLayout currLayout;
                if ("substancelaf.scrollPaneButtonsPolicy".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            c.getHorizontalScrollBar().doLayout();
                            c.getVerticalScrollBar().doLayout();
                        }
                    });
                }
                if ("substancelaf.watermark.tobleed".equals(evt.getPropertyName())) {
                    boolean toBleed = SubstanceCoreUtilities.toBleedWatermark(c);
                    c.setOpaque(!toBleed);
                    c.getViewport().setOpaque(!toBleed);
                    Component view = c.getViewport().getView();
                    if (view instanceof JComponent) {
                        ((JComponent)view).setOpaque(!toBleed);
                    }
                }
                if ("layoutManager".equals(evt.getPropertyName()) && ((Boolean)evt.getNewValue()).booleanValue() && !((currLayout = (ScrollPaneLayout)c.getLayout()) instanceof AdjustedLayout)) {
                    c.setLayout(new AdjustedLayout((ScrollPaneLayout)c.getLayout()));
                }
            }
        };
        c.addPropertyChangeListener(this.substancePropertyChangeListener);
        this.substanceVerticalScrollbarChangeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (c.getViewport().getView() instanceof JTree) {
                    JTree tree = (JTree)c.getViewport().getView();
                    if (FadeConfigurationManager.getInstance().fadeAllowed(SubstanceLookAndFeel.TREE_SMART_SCROLL_ANIMATION_KIND, tree)) {
                        int finalDelta;
                        int currMidX;
                        Rectangle viewportRect;
                        SubstanceTreeUI treeUI = (SubstanceTreeUI)tree.getUI();
                        int medianX = treeUI.getMedianRendererX(viewportRect = c.getViewport().getViewRect());
                        int delta = medianX - (currMidX = viewportRect.x + viewportRect.width / 2);
                        int finalX = viewportRect.x + delta;
                        if (finalX < 0) {
                            delta -= finalX;
                        }
                        if (Math.abs(finalDelta = delta) > viewportRect.width / 6) {
                            FadeTrackerAdapter callback = new FadeTrackerAdapter(){

                                public void fadeEnded(FadeKind fadeKind) {
                                }

                                public void fadePerformed(FadeKind fadeKind, float fadeCycle10) {
                                    if ((double)fadeCycle10 >= 5.0) {
                                        int nudge = (int)((double)finalDelta * ((double)fadeCycle10 - 5.0) / 5.0);
                                        c.getViewport().setViewPosition(new Point(viewportRect.x + nudge, viewportRect.y));
                                    }
                                }
                            };
                            if (SubstanceScrollPaneUI.this.horScrollId >= 0L) {
                                FadeTracker.getInstance().cancelFadeInstance(SubstanceScrollPaneUI.this.horScrollId);
                            }
                            final FadeStep delegate = LafWidgetUtilities.getAnimationKind(tree).getStep();
                            SubstanceScrollPaneUI.this.horScrollId = FadeTracker.getInstance().trackFadeIn(SubstanceLookAndFeel.TREE_SMART_SCROLL_ANIMATION_KIND, tree, null, false, callback, new LafConstants.AnimationKind(new FadeStep(){

                                public float getNextStep(FadeKind fadeKind, float currFadePosition, boolean isFadeIn, boolean isLooping) {
                                    if ((double)currFadePosition < 0.5) {
                                        return delegate.getNextStep(fadeKind, currFadePosition, isFadeIn, isLooping) / 3.0f;
                                    }
                                    return delegate.getNextStep(fadeKind, currFadePosition, isFadeIn, isLooping) / 1.5f;
                                }
                            }, "substancelaf.treeSmartScrollFadeStep"));
                        }
                    }
                }
            }
        };
        c.getVerticalScrollBar().getModel().addChangeListener(this.substanceVerticalScrollbarChangeListener);
    }

    protected void __org__jvnet__substance__SubstanceScrollPaneUI__uninstallListeners(JComponent c) {
        c.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        JScrollPane jsp = (JScrollPane)c;
        jsp.getVerticalScrollBar().getModel().removeChangeListener(this.substanceVerticalScrollbarChangeListener);
        this.substanceVerticalScrollbarChangeListener = null;
        super.uninstallListeners(c);
    }

    protected MouseWheelListener createMouseWheelListener() {
        return new MouseWheelHandler();
    }

    public void __org__jvnet__substance__SubstanceScrollPaneUI__update(Graphics g, JComponent c) {
        LayoutManager origLm;
        bgDelegate.updateIfOpaque(g, c);
        JScrollPane jsp = (JScrollPane)c;
        if (SubstanceCoreUtilities.hasOverlayProperty(jsp)) {
            JViewport viewport = jsp.getViewport();
            int dx = -viewport.getX() + viewport.getViewRect().x;
            int dy = viewport.getY() - viewport.getViewRect().y;
            Graphics2D graphics = (Graphics2D)g.create();
            Area clip = new Area();
            if (jsp.getVerticalScrollBar() != null && jsp.getVerticalScrollBar().isVisible()) {
                clip.add(new Area(jsp.getVerticalScrollBar().getBounds()));
            }
            if (jsp.getHorizontalScrollBar() != null && jsp.getHorizontalScrollBar().isVisible()) {
                clip.add(new Area(jsp.getHorizontalScrollBar().getBounds()));
            }
            graphics.setClip(clip);
            graphics.translate(-dx, dy);
            JComponent view = (JComponent)viewport.getView();
            HashMap<Component, Boolean> dbSnapshot = new HashMap<Component, Boolean>();
            SubstanceCoreUtilities.makeNonDoubleBuffered(view, dbSnapshot);
            view.paint(graphics);
            SubstanceCoreUtilities.restoreDoubleBuffered(view, dbSnapshot);
            graphics.translate(dx, -dy);
            graphics.dispose();
        }
        LayoutManager lm = jsp.getLayout();
        ScrollPaneLayout scrollLm = null;
        if (lm instanceof ScrollPaneLayout) {
            scrollLm = (ScrollPaneLayout)lm;
        } else if (lm instanceof TransitionLayout && (origLm = ((TransitionLayout)lm).getDelegate()) instanceof ScrollPaneLayout) {
            scrollLm = (ScrollPaneLayout)origLm;
        }
        if (scrollLm != null) {
            HashSet<Component> corners = new HashSet<Component>();
            if (scrollLm.getCorner("LOWER_LEFT_CORNER") != null) {
                corners.add(scrollLm.getCorner("LOWER_LEFT_CORNER"));
            }
            if (scrollLm.getCorner("LOWER_RIGHT_CORNER") != null) {
                corners.add(scrollLm.getCorner("LOWER_RIGHT_CORNER"));
            }
            if (scrollLm.getCorner("UPPER_LEFT_CORNER") != null) {
                corners.add(scrollLm.getCorner("UPPER_LEFT_CORNER"));
            }
            if (scrollLm.getCorner("UPPER_RIGHT_CORNER") != null) {
                corners.add(scrollLm.getCorner("UPPER_RIGHT_CORNER"));
            }
            if (TransitionLayout.isOpaque(c)) {
                for (Component corner : corners) {
                    bgDelegate.update(g, c, corner.getBounds());
                }
            }
        }
        super.paint(g, c);
    }

    protected static class AdjustedLayout
    extends ScrollPaneLayout
    implements UIResource {
        protected ScrollPaneLayout delegate;

        public AdjustedLayout(ScrollPaneLayout delegate) {
            this.delegate = delegate;
        }

        public void addLayoutComponent(String s, Component c) {
            this.delegate.addLayoutComponent(s, c);
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        public JViewport getColumnHeader() {
            return this.delegate.getColumnHeader();
        }

        public Component getCorner(String key) {
            return this.delegate.getCorner(key);
        }

        public JScrollBar getHorizontalScrollBar() {
            return this.delegate.getHorizontalScrollBar();
        }

        public int getHorizontalScrollBarPolicy() {
            return this.delegate.getHorizontalScrollBarPolicy();
        }

        public JViewport getRowHeader() {
            return this.delegate.getRowHeader();
        }

        public JScrollBar getVerticalScrollBar() {
            return this.delegate.getVerticalScrollBar();
        }

        public int getVerticalScrollBarPolicy() {
            return this.delegate.getVerticalScrollBarPolicy();
        }

        public JViewport getViewport() {
            return this.delegate.getViewport();
        }

        public Rectangle getViewportBorderBounds(JScrollPane scrollpane) {
            return this.delegate.getViewportBorderBounds(scrollpane);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.delegate.minimumLayoutSize(parent);
        }

        public Dimension preferredLayoutSize(Container parent) {
            return this.delegate.preferredLayoutSize(parent);
        }

        public void removeLayoutComponent(Component c) {
            this.delegate.removeLayoutComponent(c);
        }

        public void setHorizontalScrollBarPolicy(int x) {
            this.delegate.setHorizontalScrollBarPolicy(x);
        }

        public void setVerticalScrollBarPolicy(int x) {
            this.delegate.setVerticalScrollBarPolicy(x);
        }

        public void syncWithScrollPane(JScrollPane sp) {
            this.delegate.syncWithScrollPane(sp);
        }

        public String toString() {
            return this.delegate.toString();
        }

        public void layoutContainer(Container parent) {
            this.delegate.layoutContainer(parent);
            JScrollPane scrollPane = (JScrollPane)parent;
            Border border = scrollPane.getBorder();
            boolean toAdjust = border instanceof SubstanceScrollPaneBorder;
            if (border instanceof TransitionBorder) {
                toAdjust = ((TransitionBorder)border).getDelegate() instanceof SubstanceScrollPaneBorder;
            }
            if (toAdjust) {
                Rectangle hBounds;
                Rectangle vBounds;
                JScrollBar vertical = scrollPane.getVerticalScrollBar();
                JScrollBar horizontal = scrollPane.getHorizontalScrollBar();
                int dx = 0;
                int dy = 0;
                int dw = 0;
                int dh = 0;
                if (scrollPane.getComponentOrientation().isLeftToRight()) {
                    if (vertical.isVisible()) {
                        vBounds = vertical.getBounds();
                        ++dw;
                        vertical.setBounds(vBounds.x + 1, vBounds.y - 1, vBounds.width, vBounds.height + 2);
                    }
                    if (horizontal.isVisible()) {
                        ++dh;
                        hBounds = horizontal.getBounds();
                        horizontal.setBounds(hBounds.x - 1, hBounds.y + 1, hBounds.width + 2, hBounds.height);
                    }
                    if (this.delegate.getCorner("LOWER_RIGHT_CORNER") != null) {
                        Rectangle lrBounds = this.delegate.getCorner("LOWER_RIGHT_CORNER").getBounds();
                        this.delegate.getCorner("LOWER_RIGHT_CORNER").setBounds(lrBounds.x + 1, lrBounds.y + 1, lrBounds.width, lrBounds.height);
                    }
                } else {
                    if (vertical.isVisible()) {
                        --dx;
                        ++dw;
                        vBounds = vertical.getBounds();
                        vertical.setBounds(vBounds.x - 1, vBounds.y - 1, vBounds.width, vBounds.height + 2);
                    }
                    if (horizontal.isVisible()) {
                        ++dh;
                        hBounds = horizontal.getBounds();
                        horizontal.setBounds(hBounds.x - 1, hBounds.y + 1, hBounds.width + 2, hBounds.height);
                    }
                    if (this.delegate.getCorner("LOWER_LEFT_CORNER") != null) {
                        Rectangle llBounds = this.delegate.getCorner("LOWER_LEFT_CORNER").getBounds();
                        this.delegate.getCorner("LOWER_LEFT_CORNER").setBounds(llBounds.x - 1, llBounds.y - 1, llBounds.width, llBounds.height);
                    }
                }
                if (this.delegate.getViewport() != null) {
                    Rectangle vpBounds = this.delegate.getViewport().getBounds();
                    this.delegate.getViewport().setBounds(new Rectangle(vpBounds.x + dx, vpBounds.y + dy, vpBounds.width + dw, vpBounds.height + dh));
                }
            }
        }
    }

    protected class MouseWheelHandler
    implements MouseWheelListener {
        protected MouseWheelHandler() {
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
            if (SubstanceScrollPaneUI.this.scrollpane.isWheelScrollingEnabled() && e.getScrollAmount() != 0) {
                JScrollBar toScroll = SubstanceScrollPaneUI.this.scrollpane.getVerticalScrollBar();
                int direction = 0;
                if (!(toScroll != null && toScroll.isVisible() && e.getModifiers() != 8 || (toScroll = SubstanceScrollPaneUI.this.scrollpane.getHorizontalScrollBar()) != null && toScroll.isVisible())) {
                    return;
                }
                direction = e.getWheelRotation() < 0 ? -1 : 1;
                SubstanceScrollBarUI ui = (SubstanceScrollBarUI)toScroll.getUI();
                if (e.getScrollType() == 0) {
                    ui.scrollByUnits(direction, 2 * e.getScrollAmount());
                } else if (e.getScrollType() == 1) {
                    ui.scrollByBlock(direction);
                }
            }
        }
    }
}

