/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultButtonModel;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.LafWidgetUtilities;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeState;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.lafwidget.animation.FadeTrackerAdapter;
import org.jvnet.lafwidget.animation.FadeTrackerCallback;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.RenderingUtils;
import org.jvnet.substance.SubstanceDefaultTableCellRenderer;
import org.jvnet.substance.SubstanceDefaultTableHeaderCellRenderer;
import org.jvnet.substance.SubstanceGradientBackgroundDelegate;
import org.jvnet.substance.SubstanceTableUI;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceFadeUtilities;

public class SubstanceTableHeaderUI
extends BasicTableHeaderUI {
    protected Set lafWidgets;
    private static SubstanceGradientBackgroundDelegate backgroundDelegate = new SubstanceGradientBackgroundDelegate();
    protected TableHeaderListener substanceHeaderListener;
    protected TableCellRenderer defaultHeaderRenderer;
    protected Map<Integer, Object> selectedIndices;
    protected ListSelectionListener substanceFadeSelectionListener;
    private Map<Integer, ComponentState> prevStateMap = new HashMap<Integer, ComponentState>();
    private Map<Integer, ComponentState> nextStateMap = new HashMap<Integer, ComponentState>();

    public void update(Graphics graphics, JComponent jComponent) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        float f = 1.0f;
        if (composite instanceof AlphaComposite && ((AlphaComposite)(object = (AlphaComposite)composite)).getRule() == 3) {
            f = ((AlphaComposite)object).getAlpha();
        }
        graphics2D.setComposite(TransitionLayout.getAlphaComposite((Component)jComponent, f));
        object = RenderingUtils.installDesktopHints(graphics2D);
        this.__org__jvnet__substance__SubstanceTableHeaderUI__update(graphics2D, jComponent);
        graphics2D.setComposite(composite);
        if (object != null) {
            graphics2D.addRenderingHints((Map<?, ?>)object);
        }
    }

    public void __org__jvnet__substance__SubstanceTableHeaderUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__jvnet__substance__SubstanceTableHeaderUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void uninstallUI(JComponent jComponent) {
        this.__org__jvnet__substance__SubstanceTableHeaderUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    public void installListeners() {
        this.__org__jvnet__substance__SubstanceTableHeaderUI__installListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    public void installDefaults() {
        this.__org__jvnet__substance__SubstanceTableHeaderUI__installDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    public void uninstallListeners() {
        this.__org__jvnet__substance__SubstanceTableHeaderUI__uninstallListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    public void uninstallDefaults() {
        this.__org__jvnet__substance__SubstanceTableHeaderUI__uninstallDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public static ComponentUI createUI(JComponent h) {
        SubstanceTableHeaderUI result = new SubstanceTableHeaderUI();
        return result;
    }

    public SubstanceTableHeaderUI() {
        this.selectedIndices = new HashMap<Integer, Object>();
    }

    protected void __org__jvnet__substance__SubstanceTableHeaderUI__installListeners() {
        ListSelectionModel lsm;
        super.installListeners();
        TableColumnModel columnModel = this.header.getColumnModel();
        if (columnModel != null && (lsm = columnModel.getSelectionModel()) != null) {
            this.substanceHeaderListener = new TableHeaderListener(this);
            lsm.addListSelectionListener(this.substanceHeaderListener);
        }
        this.substanceFadeSelectionListener = new ListSelectionListener(){

            protected void cancelFades(Set<Long> initiatedFadeSequences) {
                FadeTracker fadeTrackerInstance = FadeTracker.getInstance();
                for (long fadeId : initiatedFadeSequences) {
                    fadeTrackerInstance.cancelFadeInstance(fadeId);
                }
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SubstanceTableHeaderUI.this.header == null) {
                    return;
                }
                if (LafWidgetUtilities.hasNoFades(SubstanceTableHeaderUI.this.header.getTable(), FadeKind.SELECTION)) {
                    return;
                }
                HashSet<Long> initiatedFadeSequences = new HashSet<Long>();
                boolean fadeCanceled = false;
                FadeTracker fadeTrackerInstance = FadeTracker.getInstance();
                TableColumnModel columnModel = SubstanceTableHeaderUI.this.header.getColumnModel();
                int size = columnModel.getColumnCount();
                ListSelectionModel lsm = columnModel.getSelectionModel();
                for (int i = e.getFirstIndex(); i <= e.getLastIndex(); ++i) {
                    long fadeId;
                    if (i >= size) continue;
                    if (lsm.isSelectedIndex(i)) {
                        if (SubstanceTableHeaderUI.this.selectedIndices.containsKey(i)) continue;
                        if (!fadeCanceled) {
                            fadeId = fadeTrackerInstance.trackFadeIn(FadeKind.SELECTION, (Component)SubstanceTableHeaderUI.this.header, i, false, (FadeTrackerCallback)new ColumnHeaderRepaintCallback(SubstanceTableHeaderUI.this.header, i));
                            initiatedFadeSequences.add(fadeId);
                            if (initiatedFadeSequences.size() > 25) {
                                this.cancelFades(initiatedFadeSequences);
                                initiatedFadeSequences.clear();
                                fadeCanceled = true;
                            }
                        }
                        SubstanceTableHeaderUI.this.selectedIndices.put(i, columnModel.getColumn(i));
                        continue;
                    }
                    if (!SubstanceTableHeaderUI.this.selectedIndices.containsKey(i)) continue;
                    if (SubstanceTableHeaderUI.this.selectedIndices.get(i) == columnModel.getColumn(i) && !fadeCanceled) {
                        fadeId = fadeTrackerInstance.trackFadeOut(FadeKind.SELECTION, (Component)SubstanceTableHeaderUI.this.header, i, false, (FadeTrackerCallback)new ColumnHeaderRepaintCallback(SubstanceTableHeaderUI.this.header, i));
                        initiatedFadeSequences.add(fadeId);
                        if (initiatedFadeSequences.size() > 25) {
                            this.cancelFades(initiatedFadeSequences);
                            initiatedFadeSequences.clear();
                            fadeCanceled = true;
                        }
                    }
                    SubstanceTableHeaderUI.this.selectedIndices.remove(i);
                }
            }
        };
        if (columnModel != null && (lsm = columnModel.getSelectionModel()) != null) {
            lsm.addListSelectionListener(this.substanceFadeSelectionListener);
        }
    }

    protected void __org__jvnet__substance__SubstanceTableHeaderUI__installDefaults() {
        super.installDefaults();
        this.defaultHeaderRenderer = this.header.getDefaultRenderer();
        if (this.defaultHeaderRenderer instanceof UIResource) {
            this.header.setDefaultRenderer(new SubstanceDefaultTableHeaderCellRenderer());
        }
        for (int i = 0; i < this.header.getColumnModel().getColumnCount(); ++i) {
            if (!this.header.getColumnModel().getSelectionModel().isSelectedIndex(i)) continue;
            this.selectedIndices.put(i, this.header.getColumnModel().getColumn(i));
            this.prevStateMap.put(i, ComponentState.SELECTED);
        }
    }

    protected void __org__jvnet__substance__SubstanceTableHeaderUI__uninstallListeners() {
        ListSelectionModel lsm;
        TableColumnModel columnModel = this.header.getColumnModel();
        if (columnModel != null && (lsm = columnModel.getSelectionModel()) != null) {
            lsm.removeListSelectionListener(this.substanceHeaderListener);
            this.substanceHeaderListener = null;
        }
        super.uninstallListeners();
    }

    protected void __org__jvnet__substance__SubstanceTableHeaderUI__uninstallDefaults() {
        super.uninstallDefaults();
        this.selectedIndices.clear();
        if (this.header.getDefaultRenderer() instanceof SubstanceDefaultTableCellRenderer) {
            this.header.setDefaultRenderer(this.defaultHeaderRenderer);
            if (this.defaultHeaderRenderer instanceof Component) {
                SwingUtilities.updateComponentTreeUI((Component)((Object)this.defaultHeaderRenderer));
            }
        }
    }

    public void paint(Graphics g, JComponent c) {
        int columnWidth;
        int column;
        if (this.header.getColumnModel().getColumnCount() <= 0) {
            return;
        }
        boolean ltr = this.header.getComponentOrientation().isLeftToRight();
        Rectangle clip = g.getClipBounds();
        Point left = clip.getLocation();
        Point right = new Point(clip.x + clip.width - 1, clip.y);
        TableColumnModel cm = this.header.getColumnModel();
        int[] selectedColumns = cm.getSelectedColumns();
        HashSet<Integer> selected = new HashSet<Integer>();
        for (int sel : selectedColumns) {
            selected.add(sel);
        }
        int cMin = this.header.columnAtPoint(ltr ? left : right);
        int cMax = this.header.columnAtPoint(ltr ? right : left);
        if (cMin == -1) {
            cMin = 0;
        }
        if (cMax == -1) {
            cMax = cm.getColumnCount() - 1;
        }
        TableColumn draggedColumn = this.header.getDraggedColumn();
        Rectangle cellRect = this.header.getHeaderRect(ltr ? cMin : cMax);
        if (ltr) {
            for (column = cMin; column <= cMax; ++column) {
                TableColumn aColumn = cm.getColumn(column);
                cellRect.width = columnWidth = aColumn.getWidth();
                if (aColumn != draggedColumn) {
                    this.paintCell(g, cellRect, column, selected.contains(column));
                }
                cellRect.x += columnWidth;
            }
        } else {
            for (column = cMax; column >= cMin; --column) {
                TableColumn aColumn = cm.getColumn(column);
                cellRect.width = columnWidth = aColumn.getWidth();
                if (aColumn != draggedColumn) {
                    this.paintCell(g, cellRect, column, selected.contains(column));
                }
                cellRect.x += columnWidth;
            }
        }
        if (draggedColumn != null) {
            int draggedColumnIndex = this.viewIndexForColumn(draggedColumn);
            Rectangle draggedCellRect = this.header.getHeaderRect(draggedColumnIndex);
            g.setColor(this.header.getParent().getBackground());
            g.fillRect(draggedCellRect.x, draggedCellRect.y, draggedCellRect.width, draggedCellRect.height);
            draggedCellRect.x += this.header.getDraggedDistance();
            g.setColor(this.header.getBackground());
            g.fillRect(draggedCellRect.x, draggedCellRect.y, draggedCellRect.width, draggedCellRect.height);
            this.paintCell(g, draggedCellRect, draggedColumnIndex, selected.contains(draggedColumnIndex));
        }
        this.rendererPane.removeAll();
    }

    private Component getHeaderRenderer(int columnIndex) {
        TableColumn aColumn = this.header.getColumnModel().getColumn(columnIndex);
        TableCellRenderer renderer = aColumn.getHeaderRenderer();
        if (renderer == null) {
            renderer = this.header.getDefaultRenderer();
        }
        return renderer.getTableCellRendererComponent(this.header.getTable(), aColumn.getHeaderValue(), false, false, -1, columnIndex);
    }

    private void paintCell(Graphics g, Rectangle cellRect, int columnIndex, boolean isSelected) {
        float endAlpha;
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setComposite(TransitionLayout.getAlphaComposite((Component)this.header, g));
        Component component = this.getHeaderRenderer(columnIndex);
        backgroundDelegate.update(g, component, cellRect, SubstanceCoreUtilities.getDefaultTheme(this.header, true), true);
        ComponentState prevState = this.getPrevColumnState(columnIndex);
        ComponentState currState = this.getColumnState(columnIndex);
        float alphaForPrevBackground = 0.0f;
        float startAlpha = SubstanceCoreUtilities.getHighlightAlpha(this.header, prevState, true);
        float alphaForCurrBackground = endAlpha = SubstanceCoreUtilities.getHighlightAlpha(this.header, currState, true);
        FadeState state = SubstanceFadeUtilities.getFadeState((Component)this.header, Integer.valueOf(columnIndex), FadeKind.SELECTION, FadeKind.ROLLOVER);
        if (state != null) {
            float fadeCoef = state.getFadePosition();
            float totalAlpha = 0.0f;
            totalAlpha = state.isFadingIn() ? startAlpha + (endAlpha - startAlpha) * fadeCoef / 10.0f : startAlpha + (endAlpha - startAlpha) * (10.0f - fadeCoef) / 10.0f;
            if (state.isFadingIn()) {
                fadeCoef = 10.0f - fadeCoef;
            }
            alphaForPrevBackground = totalAlpha * fadeCoef / 10.0f;
            alphaForCurrBackground = totalAlpha * (10.0f - fadeCoef) / 10.0f;
        }
        SubstanceTheme prevTheme = SubstanceCoreUtilities.getHighlightTheme((Component)this.header, prevState, true, false);
        SubstanceTheme currTheme = SubstanceCoreUtilities.getHighlightTheme((Component)this.header, currState, true, false);
        if (alphaForPrevBackground > 0.0f) {
            g2d.setComposite(TransitionLayout.getAlphaComposite(this.header, alphaForPrevBackground, g));
            backgroundDelegate.update(g2d, component, cellRect, prevTheme, true);
            g2d.setComposite(TransitionLayout.getAlphaComposite((Component)this.header, g));
        }
        if (alphaForCurrBackground > 0.0f) {
            g2d.setComposite(TransitionLayout.getAlphaComposite(this.header, alphaForCurrBackground, g));
            backgroundDelegate.update(g2d, component, cellRect, currTheme, true);
            g2d.setComposite(TransitionLayout.getAlphaComposite((Component)this.header, g));
        }
        this.rendererPane.paintComponent(g2d, component, this.header, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
        g2d.dispose();
    }

    private int viewIndexForColumn(TableColumn aColumn) {
        TableColumnModel cm = this.header.getColumnModel();
        for (int column = 0; column < cm.getColumnCount(); ++column) {
            if (cm.getColumn(column) != aColumn) continue;
            return column;
        }
        return -1;
    }

    public void __org__jvnet__substance__SubstanceTableHeaderUI__update(Graphics g, JComponent c) {
        SubstanceTheme theme = SubstanceCoreUtilities.getDefaultTheme(this.header, true);
        backgroundDelegate.update(g, c, c.getBounds(), theme, true);
        this.paint(g, c);
    }

    public void __org__jvnet__substance__SubstanceTableHeaderUI__uninstallUI(JComponent c) {
        for (int i = 0; i < this.header.getColumnModel().getColumnCount(); ++i) {
            TableColumn aColumn = this.header.getColumnModel().getColumn(i);
            TableCellRenderer renderer = aColumn.getHeaderRenderer();
            if (renderer == null) {
                renderer = this.header.getDefaultRenderer();
            }
            Component rendComp = renderer.getTableCellRendererComponent(this.header.getTable(), aColumn.getHeaderValue(), false, false, -1, i);
            SwingUtilities.updateComponentTreeUI(rendComp);
        }
        super.uninstallUI(c);
    }

    public ComponentState getPrevColumnState(int columnIndex) {
        if (this.prevStateMap.containsKey(columnIndex)) {
            return this.prevStateMap.get(columnIndex);
        }
        return ComponentState.DEFAULT;
    }

    public ComponentState getColumnState(int columnIndex) {
        TableUI ui;
        DefaultButtonModel synthModel = new DefaultButtonModel();
        synthModel.setEnabled(this.header.isEnabled());
        JTable table = this.header.getTable();
        if (table != null && (ui = table.getUI()) instanceof SubstanceTableUI) {
            SubstanceTableUI tableUI = (SubstanceTableUI)table.getUI();
            int rolledOverIndex = tableUI.getRolloverColumnIndex();
            synthModel.setRollover(rolledOverIndex >= 0 && rolledOverIndex == columnIndex);
        }
        synthModel.setSelected(this.header.getColumnModel().getSelectionModel().isSelectedIndex(columnIndex));
        return ComponentState.getState(synthModel, null);
    }

    public FadeTrackerCallback getCallback(int columnIndex) {
        return new ColumnHeaderRepaintCallback(this.header, columnIndex);
    }

    protected class ColumnHeaderRepaintCallback
    extends FadeTrackerAdapter {
        protected JTableHeader header;
        protected int columnIndex;

        public ColumnHeaderRepaintCallback(JTableHeader header, int columnIndex) {
            this.header = header;
            this.columnIndex = columnIndex;
        }

        public void fadeEnded(FadeKind fadeKind) {
            if (SubstanceTableHeaderUI.this.header == this.header && this.columnIndex < this.header.getColumnModel().getColumnCount()) {
                ComponentState currState = SubstanceTableHeaderUI.this.getColumnState(this.columnIndex);
                if (currState == ComponentState.DEFAULT) {
                    SubstanceTableHeaderUI.this.prevStateMap.remove(this.columnIndex);
                    SubstanceTableHeaderUI.this.nextStateMap.remove(this.columnIndex);
                } else {
                    SubstanceTableHeaderUI.this.prevStateMap.put(this.columnIndex, currState);
                    SubstanceTableHeaderUI.this.nextStateMap.put(this.columnIndex, currState);
                }
            }
            this.repaintColumnHeader();
        }

        public void fadeReversed(FadeKind fadeKind, boolean isFadingIn, float fadeCycle10) {
            if (SubstanceTableHeaderUI.this.header == this.header && this.columnIndex < this.header.getColumnModel().getColumnCount()) {
                ComponentState nextState = (ComponentState)((Object)SubstanceTableHeaderUI.this.nextStateMap.get(this.columnIndex));
                if (nextState == null) {
                    SubstanceTableHeaderUI.this.prevStateMap.remove(this.columnIndex);
                } else {
                    SubstanceTableHeaderUI.this.prevStateMap.put(this.columnIndex, nextState);
                }
            }
            this.repaintColumnHeader();
        }

        public void fadePerformed(FadeKind fadeKind, float fade10) {
            if (SubstanceTableHeaderUI.this.header == this.header && this.columnIndex < this.header.getColumnModel().getColumnCount()) {
                SubstanceTableHeaderUI.this.nextStateMap.put(this.columnIndex, SubstanceTableHeaderUI.this.getColumnState(this.columnIndex));
            }
            this.repaintColumnHeader();
        }

        private void repaintColumnHeader() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (ColumnHeaderRepaintCallback.this.header == null) {
                        return;
                    }
                    try {
                        int cellCount = ColumnHeaderRepaintCallback.this.header.getColumnModel().getColumnCount();
                        if (cellCount > 0 && ColumnHeaderRepaintCallback.this.columnIndex < cellCount) {
                            Rectangle rect = ColumnHeaderRepaintCallback.this.header.getHeaderRect(ColumnHeaderRepaintCallback.this.columnIndex);
                            ColumnHeaderRepaintCallback.this.header.repaint(rect);
                        }
                    }
                    catch (RuntimeException re) {
                        return;
                    }
                }
            });
        }
    }

    private static class TableHeaderListener
    implements ListSelectionListener {
        private SubstanceTableHeaderUI ui;

        public TableHeaderListener(SubstanceTableHeaderUI ui) {
            this.ui = ui;
        }

        public void valueChanged(ListSelectionEvent e) {
            if (this.ui.header == null) {
                return;
            }
            if (this.ui.header.isValid()) {
                this.ui.header.repaint();
            }
        }
    }
}

