/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.border;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import org.jvnet.substance.border.SubstanceBorderPainter;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.utils.SubstanceColorUtilities;

public class StandardBorderPainter
implements SubstanceBorderPainter {
    public String getDisplayName() {
        return "Standard";
    }

    public void paintBorder(Graphics g, int width, int height, Shape contour, ColorScheme colorScheme1, ColorScheme colorScheme2, float cyclePos, boolean useCyclePosAsInterpolation) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ColorScheme interpolationScheme1 = colorScheme1;
        ColorScheme interpolationScheme2 = useCyclePosAsInterpolation ? colorScheme2 : colorScheme1;
        double cycleCoef = 1.0 - (double)cyclePos / 10.0;
        Color topBorderColor = this.getTopBorderColor(interpolationScheme1, interpolationScheme2, cycleCoef, useCyclePosAsInterpolation);
        Color midBorderColor = this.getMidBorderColor(interpolationScheme1, interpolationScheme2, cycleCoef, useCyclePosAsInterpolation);
        Color bottomBorderColor = this.getBottomBorderColor(interpolationScheme1, interpolationScheme2, cycleCoef, useCyclePosAsInterpolation);
        if (topBorderColor != null && midBorderColor != null) {
            GradientPaint gradientBorderTop = new GradientPaint(0.0f, 0.0f, topBorderColor, 0.0f, height / 2, midBorderColor);
            Graphics2D topGr = (Graphics2D)graphics.create();
            topGr.setPaint(gradientBorderTop);
            topGr.clip(new Rectangle(0, 0, width, height / 2));
            topGr.draw(contour);
            topGr.dispose();
        }
        if (bottomBorderColor != null && midBorderColor != null) {
            Graphics2D bottomGr = (Graphics2D)graphics.create();
            GradientPaint gradientBorderBottom = new GradientPaint(0.0f, height / 2, midBorderColor, 0.0f, height, bottomBorderColor);
            bottomGr.setPaint(gradientBorderBottom);
            bottomGr.clip(new Rectangle(0, height / 2, width, 1 + height / 2));
            bottomGr.draw(contour);
            bottomGr.dispose();
        }
        graphics.dispose();
    }

    public Color getTopBorderColor(ColorScheme interpolationScheme1, ColorScheme interpolationScheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
        return SubstanceColorUtilities.getTopBorderColor(interpolationScheme1, interpolationScheme2, cycleCoef);
    }

    public Color getMidBorderColor(ColorScheme interpolationScheme1, ColorScheme interpolationScheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
        return SubstanceColorUtilities.getMidBorderColor(interpolationScheme1, interpolationScheme2, cycleCoef);
    }

    public Color getBottomBorderColor(ColorScheme interpolationScheme1, ColorScheme interpolationScheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
        return SubstanceColorUtilities.getBottomBorderColor(interpolationScheme1, interpolationScheme2, cycleCoef);
    }
}

