/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.skin;

import java.awt.Color;
import org.jvnet.substance.button.ClassicButtonShaper;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.color.EbonyColorScheme;
import org.jvnet.substance.color.ShadeColorScheme;
import org.jvnet.substance.color.TintColorScheme;
import org.jvnet.substance.painter.AlphaControlBackgroundComposite;
import org.jvnet.substance.painter.SimplisticSoftBorderReverseGradientPainter;
import org.jvnet.substance.skin.SubstanceAbstractSkin;
import org.jvnet.substance.theme.SubstanceComplexTheme;
import org.jvnet.substance.theme.SubstanceEbonyTheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.title.FlatTitlePainter;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.watermark.SubstanceCrosshatchWatermark;

public class RavenGraphiteSkin
extends SubstanceAbstractSkin {
    public static String NAME = "Raven Graphite";

    public RavenGraphiteSkin() {
        TintColorScheme activeScheme = new TintColorScheme(new EbonyColorScheme(), 0.2){
            Color foreColor;
            {
                this.foreColor = new Color(200, 200, 200);
            }

            public Color getForegroundColor() {
                return this.foreColor;
            }
        };
        ShadeColorScheme disabledScheme = new ShadeColorScheme(activeScheme, 0.3){
            Color foreColor;
            {
                this.foreColor = new Color(110, 110, 110);
            }

            public Color getForegroundColor() {
                return this.foreColor;
            }
        };
        SubstanceTheme activeTheme = new SubstanceTheme(activeScheme, "Tinted Ebony 20%", SubstanceTheme.ThemeKind.DARK);
        SubstanceTheme defaultTheme = activeTheme.shade(0.2);
        SubstanceTheme disabledTheme = new SubstanceTheme(disabledScheme, "Disabled Raven Graphite", SubstanceTheme.ThemeKind.DARK);
        SubstanceTheme activeTitleTheme = defaultTheme;
        SubstanceComplexTheme theme = new SubstanceComplexTheme(NAME, SubstanceTheme.ThemeKind.DARK, activeTheme, defaultTheme, disabledTheme, activeTitleTheme);
        theme.setNonActivePainter(new SimplisticSoftBorderReverseGradientPainter());
        theme.setSelectedTabFadeStart(0.3);
        theme.setSelectedTabFadeEnd(0.6);
        theme.registerComponentHighlightStateTheme((SubstanceTheme)new SubstanceEbonyTheme(), new ComponentState[0]);
        this.theme = theme;
        this.shaper = new ClassicButtonShaper();
        this.watermark = new SubstanceCrosshatchWatermark();
        this.gradientPainter = new SimplisticSoftBorderReverseGradientPainter(){

            public Color getBottomFillColor(ColorScheme interpolationScheme1, ColorScheme interpolationScheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
                return this.getMidFillColorBottom(interpolationScheme1, interpolationScheme2, cycleCoef, useCyclePosAsInterpolation);
            }
        };
        this.titlePainter = new FlatTitlePainter();
        this.tabBackgroundComposite = new AlphaControlBackgroundComposite(0.5f);
    }

    public String getDisplayName() {
        return NAME;
    }
}

