/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.title;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Map;
import org.jvnet.substance.painter.ClassicGradientPainter;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.title.SubstanceTitlePainter;
import org.jvnet.substance.utils.SoftHashMap;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class ClassicTitlePainter
implements SubstanceTitlePainter {
    public static final String DISPLAY_NAME = "Classic";
    protected static Map<String, BufferedImage> smallImageCache = new SoftHashMap<String, BufferedImage>();
    protected ClassicGradientPainter painter = new ClassicGradientPainter();

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintTitleBackground(Graphics2D graphics, Component comp, int width, int height, int leftTitleX, int rightTitleX, SubstanceTheme theme, boolean hasDarkBorder) {
        int size = Math.max(width, height);
        if (size < 150) {
            ClassicTitlePainter classicTitlePainter = this;
            synchronized (classicTitlePainter) {
                String key = width + "*" + height + "*" + leftTitleX + "*" + rightTitleX + "*" + theme.getDisplayName() + "*" + hasDarkBorder;
                BufferedImage result = smallImageCache.get(key);
                if (result == null) {
                    result = SubstanceCoreUtilities.getBlankImage(width, height);
                    this.internalPaint((Graphics2D)result.getGraphics(), width, height, leftTitleX, rightTitleX, theme, hasDarkBorder);
                    smallImageCache.put(key, result);
                }
                graphics.drawImage((Image)result, 0, 0, null);
                return;
            }
        }
        this.internalPaint(graphics, width, height, leftTitleX, rightTitleX, theme, hasDarkBorder);
    }

    protected void internalPaint(Graphics2D graphics, int width, int height, int leftTitleX, int rightTitleX, SubstanceTheme theme, boolean hasDarkBorder) {
        graphics.setColor(theme.getActiveTitlePaneTheme().getColorScheme().getMidColor());
        graphics.drawImage((Image)this.painter.getContourBackground(width + 6, height + 6, new Rectangle(width + 6, height + 6), false, theme.getActiveTitlePaneTheme().getColorScheme(), theme.getActiveTitlePaneTheme().getColorScheme(), 0.0f, false, false), -3, -3, null);
        if (hasDarkBorder) {
            graphics.setColor(theme.getActiveTitlePaneTheme().getColorScheme().getMidColor());
            graphics.drawLine(0, 0, width - 1, 0);
            graphics.drawLine(0, 0, 0, height - 1);
            graphics.drawLine(0, height - 1, width - 1, height - 1);
            graphics.drawLine(width - 1, 0, width - 1, height - 1);
        }
    }

    public static synchronized void reset() {
        smallImageCache.clear();
    }
}

