/*
 * Decompiled with CFR 0.152.
 */
package com.exidex.stg;

import com.exidex.stg.STGConfig;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public final class LeftClickEventHandler {
    public static final List<Function<EntityLivingBase, Boolean>> PREDICATES = Lists.newArrayList();

    private LeftClickEventHandler() {
    }

    @SubscribeEvent
    public static void onLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        IBlockState state = event.getWorld().func_180495_p(event.getPos()).func_185899_b((IBlockAccess)event.getWorld(), event.getPos());
        if (state.func_185890_d((IBlockAccess)event.getWorld(), event.getPos()) != Block.field_185506_k) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        if (player == null) {
            return;
        }
        float blockReachDistance = 4.5f;
        Vec3d from = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        Vec3d vec3d = player.func_70676_i(1.0f);
        Vec3d to = from.func_72441_c(vec3d.field_72450_a * (double)blockReachDistance, vec3d.field_72448_b * (double)blockReachDistance, vec3d.field_72449_c * (double)blockReachDistance);
        EntityLivingBase targetEntity = LeftClickEventHandler.getEntityClosestToStartPos(player, event.getWorld(), from, to);
        if (targetEntity != null) {
            if (!event.getWorld().field_72995_K) {
                player.func_71059_n((Entity)targetEntity);
                player.func_184821_cY();
            }
            event.setCanceled(STGConfig.cancelClickEventPropagation);
        }
    }

    private static EntityLivingBase getEntityClosestToStartPos(EntityPlayer player, World world, Vec3d startPos, Vec3d endPos) {
        EntityLivingBase entityLiving = null;
        List list = world.func_175674_a((Entity)player, new AxisAlignedBB(startPos.field_72450_a, startPos.field_72448_b, startPos.field_72449_c, endPos.field_72450_a, endPos.field_72448_b, endPos.field_72449_c), Predicates.and((Predicate)EntitySelectors.field_188444_d, e -> {
            boolean filter;
            boolean bl = filter = e != null && e.func_70067_L() && e instanceof EntityLivingBase && !(e instanceof FakePlayer);
            if (filter) {
                for (Function<EntityLivingBase, Boolean> predicate : PREDICATES) {
                    filter &= predicate.apply((EntityLivingBase)e).booleanValue();
                }
            }
            return filter;
        }));
        double d0 = 0.0;
        for (Entity entity : list) {
            double d1;
            AxisAlignedBB axisAlignedBB = entity.func_174813_aQ().func_72321_a(0.3, 0.3, 0.3);
            RayTraceResult raytraceResult = axisAlignedBB.func_72327_a(startPos, endPos);
            if (raytraceResult == null || !((d1 = startPos.func_72436_e(raytraceResult.field_72307_f)) < d0) && d0 != 0.0) continue;
            entityLiving = (EntityLivingBase)entity;
            d0 = d1;
        }
        return entityLiving;
    }
}

